/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.tax.AccumulateItem;
import com.kingdee.shr.compensation.app.tax.Annu;
import com.kingdee.shr.compensation.app.tax.CalSchemeAnnu;
import com.kingdee.shr.compensation.app.tax.TaxUnitCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxYearCollection;
import com.kingdee.shr.compensation.app.tax.TaxYearFactory;
import com.kingdee.shr.compensation.app.tax.TaxYearInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CalFunctionTaxService {
    private static final String PRESET_TAXTABLE_ID = "viEAAAPGSyALldNo";
    private static final String FTaxValley = "FTaxValley";
    private static final String FTaxPeak = "FTaxPeak";
    private static final String FRate = "FRate";
    private static final String FDeduction = "FDeduction";
    private static final String FNoTaxPeak = "FNoTaxPeak";
    private static final String FNoTaxValley = "FNoTaxValley";
    private static final String FID = "FID";
    private static final String FPersonID = "FPersonID";
    private static final String FTaxUnitID = "FTaxUnitID";
    private static final String FTaxPart = "FTaxPart";
    private static final String beginDate = "beginDate";
    private static final String endDate = "endDate";
    private static final String FCalSchemeID = "FCalSchemeID";
    private static final String FperiodYear = "FperiodYear";
    private static final String FperiodMonth = "FperiodMonth";
    private static final String FCalTime = "FcalTime";
    private static final String split = "_";
    private static final Object objValue = new Object();

    public double getDataFromTaxUnit(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, String type, String offset, String mainTableRowFilter) {
        Map<String, Double> map = new HashMap();
        Context ctx = Tools.getInstance().getCtx();
        String calSchemeId = calSchemeInfo.getId().toString();
        int year = calSchemeInfo.getPeriodYear();
        int month = calSchemeInfo.getPeriodMonth();
        int time = calSchemeInfo.getCalTime();
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1, 0, 0, 0);
        int offsetInt = Integer.valueOf(offset);
        int taxYear = year;
        int taxMonth = month + offsetInt;
        if (taxMonth > 12) {
            ++taxYear;
            taxMonth -= 12;
        } else if (taxMonth <= 0) {
            --taxYear;
            taxMonth = 12 + taxMonth;
        }
        calendar.add(2, offsetInt);
        String key = "getDataFromTaxUnit_" + calSchemeId + split + year + split + month + split + time + split + offsetInt + split + type;
        if (null == tempMap.get(key)) {
            StringBuilder str = new StringBuilder();
            str.append(" select tt.FEducation, tt.FHousing, tt.FRent, tt.FSupport, tt.FAdult, tt.FThreshold, tt.FMoney,tt.FInfant, tt.FPersonalPension, tt.FPersonID ");
            str.append(" from T_HR_STaxSumCumulation tt ");
            str.append(" inner join T_HR_SCmpCalTable cal on tt.FPersonId = cal.FPersonId and tt.FTaxUnitID = cal.FTaxUnitID ");
            str.append(" where tt.FPeriodYear = ").append(taxYear);
            str.append(" and tt.FPeriodMonth = ").append(taxMonth);
            str.append(" and cal.FCalSchemeId = '").append(calSchemeId).append("' and cal.FPeriodYear = ").append(year).append(" and cal.FPeriodMonth = ").append(month);
            str.append(" and cal.FCalTime = ").append(time);
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String personSql = "select fpersonId from t_hr_scmpcaltable where " + mainTableRowFilter;
                str.append(" AND cal.FPERSONID in (").append(personSql).append(")");
            }
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    map.put(rowSet.getString(FPersonID) + split + 10, rowSet.getDouble("FHousing"));
                    map.put(rowSet.getString(FPersonID) + split + 20, rowSet.getDouble("FRent"));
                    map.put(rowSet.getString(FPersonID) + split + 30, rowSet.getDouble("FEducation"));
                    map.put(rowSet.getString(FPersonID) + split + 40, rowSet.getDouble("FAdult"));
                    map.put(rowSet.getString(FPersonID) + split + 50, rowSet.getDouble("FSupport"));
                    map.put(rowSet.getString(FPersonID) + split + 55, rowSet.getDouble("FInfant"));
                    map.put(rowSet.getString(FPersonID) + split + 56, rowSet.getDouble("FPersonalPension"));
                    map.put(rowSet.getString(FPersonID) + split + 60, rowSet.getDouble("FMoney"));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            tempMap.put(key, map);
        } else {
            map = (Map)tempMap.get(key);
        }
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        int taxType = Integer.parseInt(type);
        String personKey = personid + split + taxType;
        return map.containsKey(personKey) ? (Double)map.get(personKey) : 0.0;
    }

    public double getTaxDeductMoney(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, String type) {
        Map<String, Double> map = new HashMap();
        Context ctx = Tools.getInstance().getCtx();
        int taxType = Integer.valueOf(type);
        String calSchemeId = calSchemeInfo.getId().toString();
        int year = calSchemeInfo.getPeriodYear();
        int month = calSchemeInfo.getPeriodMonth();
        int time = calSchemeInfo.getCalTime();
        String key = "getTaxDeductMoney_" + calSchemeId + split + year + split + month + split + time;
        if (null == tempMap.get(key)) {
            StringBuilder str = new StringBuilder();
            str.append(" select taxBase.FTotal money, taxBase.FPersonId personId, taxBase.FType ");
            str.append(" from T_HR_STaxBase taxBase ");
            str.append(" where FDataState = 1 and FState in (30, 40) ");
            str.append(" and (FEffdtYear = ").append(year).append(" and FEffdtMonth <= ").append(month);
            str.append(" or FEffdtYear < ").append(year).append(") ");
            str.append(" and (FLeffdtYear = ").append(year).append(" and FLeffdtMonth >= ").append(month);
            str.append(" or FLeffdtYear > ").append(year).append(") ");
            str.append(" and exists (select 1 from T_HR_SCmpCalTable caltable where caltable.FPersonId = taxBase.FPersonId ");
            str.append(" and caltable.FCalSchemeId = '" + calSchemeId + "' and caltable.FPeriodYear = ").append(year).append(" and caltable.FPeriodMonth = ").append(month);
            str.append(" and caltable.FCalTime = ").append(time).append(") ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    map.put(rowSet.getString("personId") + split + rowSet.getObject("FType"), rowSet.getDouble("money"));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            tempMap.put(key, map);
        } else {
            map = (Map)tempMap.get(key);
        }
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        String personKey = personid + split + taxType;
        return map.containsKey(personKey) ? (Double)map.get(personKey) : 0.0;
    }

    public double getTaxUnitMonth(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, double type, String mainTableRowFilter) {
        List date;
        Map<String, List> pTaxUnitMap;
        Map<String, java.util.Date> yearRange;
        double month = 0.0;
        Context ctx = Tools.getInstance().getCtx();
        String calSchemeId = calScheme.getId().toString();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        String yearKey = "getTaxYearRange_" + calSchemeId + split + periodYear + split + periodMonth + split + calTime;
        if (tempMap.get(yearKey) == null) {
            yearRange = this.getTaxYearRange(ctx, calScheme, periodYear, periodMonth);
            if (yearRange == null || yearRange.get(beginDate) == null || yearRange.get(endDate) == null) {
                return month;
            }
            tempMap.put(yearKey, yearRange);
        }
        yearRange = (Map<String, java.util.Date>)tempMap.get(yearKey);
        String dataKey = "getTaxUnitMonth_" + calSchemeId + split + periodYear + split + periodMonth + split + calTime;
        if (tempMap.get(dataKey) == null) {
            pTaxUnitMap = this.getPersonTaxUnit(ctx, calSchemeId, periodYear, periodMonth, calTime, yearRange, mainTableRowFilter);
            tempMap.put(dataKey, pTaxUnitMap);
        }
        if ((date = (pTaxUnitMap = (Map<String, List>)tempMap.get(dataKey)).get(paramMap.get("T_HR_SCMPCALTABLE_FPERSONID").toString())) == null || date.size() == 0) {
            return month;
        }
        if (type == 0.0) {
            java.util.Date tempEffdt = null;
            java.util.Date tempLeffdt = null;
            int size = date.size();
            for (int i = 0; i < size; ++i) {
                String[] dateStr = date.get(i).toString().split(split);
                java.util.Date effdt = new java.util.Date(Long.parseLong(dateStr[0]));
                java.util.Date leffdt = new java.util.Date(Long.parseLong(dateStr[1]));
                if (effdt.after(yearRange.get(endDate))) continue;
                if (leffdt.before(yearRange.get(beginDate))) break;
                if (null == tempEffdt) {
                    tempEffdt = effdt.before(yearRange.get(beginDate)) ? yearRange.get(beginDate) : effdt;
                    java.util.Date date2 = tempLeffdt = leffdt.after(yearRange.get(endDate)) ? yearRange.get(endDate) : leffdt;
                }
                if (i + 1 >= size) continue;
                String[] nextdateStr = date.get(i + 1).toString().split(split);
                java.util.Date nextEffdt = new java.util.Date(Long.parseLong(nextdateStr[0]));
                java.util.Date nextLeffdt = new java.util.Date(Long.parseLong(nextdateStr[1]));
                if (nextLeffdt.before(yearRange.get(beginDate))) break;
                int dvalue = effdt.getMonth() - nextLeffdt.getMonth();
                int n = dvalue = dvalue < 0 ? dvalue + 12 : dvalue;
                if (dvalue != 1) continue;
                if (nextEffdt.before(yearRange.get(beginDate))) {
                    tempEffdt = yearRange.get(beginDate);
                    break;
                }
                tempEffdt = nextEffdt;
            }
            if (null != tempEffdt && null != tempLeffdt) {
                month += (double)this.getMonth(tempEffdt, tempLeffdt);
            }
        } else {
            for (int i = 0; i < date.size(); ++i) {
                String[] dateStr = date.get(i).toString().split(split);
                java.util.Date effdt = new java.util.Date(Long.parseLong(dateStr[0]));
                java.util.Date leffdt = new java.util.Date(Long.parseLong(dateStr[1]));
                if (leffdt.after(yearRange.get(endDate))) {
                    leffdt = yearRange.get(endDate);
                }
                if (effdt.before(yearRange.get(beginDate))) {
                    effdt = yearRange.get(beginDate);
                }
                month += (double)this.getMonth(effdt, leffdt);
            }
        }
        return month;
    }

    private int getMonth(java.util.Date effdt, java.util.Date leffdt) {
        Calendar bef = Calendar.getInstance();
        bef.setTime(effdt);
        Calendar aft = Calendar.getInstance();
        aft.setTime(leffdt);
        int result = (aft.get(1) - bef.get(1)) * 12;
        int month = aft.get(2) - bef.get(2) + 1;
        return Math.abs(result + month);
    }

    private Map<String, List> getPersonTaxUnit(Context ctx, String cmpSchemeId, int periodYear, int periodMonth, int calTime, Map<String, java.util.Date> yearRange, String mainTableRowFilter) {
        HashMap<String, List> personTaxUnit = new HashMap<String, List>();
        String beginDateStr = CmpDateUtil.toKSqlDate(yearRange.get(beginDate));
        String endDateStr = CmpDateUtil.toKSqlDate(yearRange.get(endDate));
        StringBuffer sql = new StringBuffer();
        sql.append("select caltable.FPersonId,taxUnit.FEFFDT,taxUnit.FLEFFDT from T_HR_SCmpCalTable caltable left join T_HR_SPersonTaxUnit taxUnit ");
        sql.append("on caltable.FPersonId=taxUnit.FPersonId and caltable.FTaxUnitId=taxUnit.FTaxUnitId where caltable.FCalSchemeId='");
        sql.append(cmpSchemeId).append("' and caltable.FPeriodYear=").append(periodYear).append(" and caltable.FPeriodMonth=");
        sql.append(periodMonth).append(" and caltable.FCalTime=").append(calTime).append(" and taxUnit.FEFFDT <=").append(endDateStr);
        sql.append(" and taxUnit.FLEFFDT >=").append(beginDateStr);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            String replace = mainTableRowFilter.replace("t_hr_scmpcaltable.fid", "caltable.fid").replace("t_hr_scmpcaltable.FCalState", "caltable.FCalState");
            sql.append(" and ").append(replace);
        }
        sql.append(" order by caltable.FPersonId, taxUnit.FEFFDT desc");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            List date = null;
            Date effdt = null;
            Date leffdt = null;
            while (rowset.next()) {
                String personId = rowset.getString(FPersonID);
                effdt = rowset.getDate("FEFFDT");
                leffdt = rowset.getDate("FLEFFDT");
                if (effdt == null || leffdt == null) continue;
                date = personTaxUnit.containsKey(personId) ? (List)personTaxUnit.get(personId) : new ArrayList();
                date.add(effdt.getTime() + split + leffdt.getTime());
                personTaxUnit.put(personId, date);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personTaxUnit;
    }

    public double getTaxThreshold(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap) throws SQLException {
        block5: {
            Context ctx = Tools.getInstance().getCtx();
            try {
                String key = "T_HR_STaxThreshold_" + calSchemeInfo.getId().toString() + calSchemeInfo.getEndDate().getTime();
                String endDateStr = CmpDateUtil.toKSqlDate(calSchemeInfo.getEndDate());
                if (null == tempMap.get(key)) {
                    String exec_sql = "SELECT FTHRESHOLD, FCURRENCYID FROM T_HR_STaxRateTable where FEFFDT <=" + endDateStr + " and fid = 'viEAAAPGSyALldNo' ";
                    IRowSet set = DbUtil.executeQuery((Context)ctx, (String)exec_sql);
                    if (set.next()) {
                        String currencyId = set.getString("FCURRENCYID");
                        BigDecimal currencyRate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                        double threshold = set.getDouble(1) * currencyRate.doubleValue();
                        tempMap.put(key, threshold);
                        return threshold;
                    }
                    break block5;
                }
                return Double.parseDouble(tempMap.get(key).toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0.0;
    }

    private LinkedHashMap<String, Map<String, BigDecimal>> getTaxRateTable(CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap) {
        Context ctx = Tools.getInstance().getCtx();
        String endDateStr = CmpDateUtil.toKSqlDate(calSchemeInfo.getEndDate());
        StringBuilder str = new StringBuilder();
        str.append(" SELECT ENTRY.FID,ENTRY.FTAXVALLEY,ENTRY.FTAXPEAK, ");
        str.append(" ENTRY.FNOTAXVALLEY,ENTRY.FNOTAXPEAK,ENTRY.FRATE,ENTRY.FDEDUCTION,TAXTABLE.FCURRENCYID ");
        str.append(" FROM T_HR_STAXRATETABLEENTRY ENTRY ");
        str.append(" INNER JOIN T_HR_STAXRATETABLE TAXTABLE ON TAXTABLE.FID=ENTRY.FTAXTABLEID and TAXTABLE.FEFFDT <= ").append(endDateStr);
        str.append(" and TAXTABLE.FID = 'viEAAAPGSyALldNo' ");
        str.append(" ORDER BY ENTRY.FTAXPEAK ASC ");
        LinkedHashMap<String, Map<String, BigDecimal>> taxTable = new LinkedHashMap<String, Map<String, BigDecimal>>();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            BigDecimal taxPeak = null;
            BigDecimal noTaxPeak = null;
            BigDecimal rate = null;
            BigDecimal deduction = null;
            HashMap<String, BigDecimal> entryMap = null;
            while (rowset.next()) {
                String currencyId = rowset.getString("FCURRENCYID");
                BigDecimal currencyRate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                taxPeak = rowset.getBigDecimal(FTaxPeak);
                rate = rowset.getBigDecimal(FRate);
                deduction = rowset.getBigDecimal(FDeduction);
                noTaxPeak = rowset.getBigDecimal(FNoTaxPeak);
                entryMap = new HashMap<String, BigDecimal>();
                entryMap.put(FTaxPeak, taxPeak.multiply(currencyRate));
                entryMap.put(FRate, rate);
                entryMap.put(FDeduction, deduction.multiply(currencyRate));
                entryMap.put(FNoTaxPeak, noTaxPeak.multiply(currencyRate));
                taxTable.put(rowset.getString(FID), entryMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return taxTable;
    }

    public double getCumulativePreTax(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap, double val, double type) {
        String key = "T_HR_STaxRateTable_" + calSchemeInfo.getId().toString() + calSchemeInfo.getEndDate().getTime();
        LinkedHashMap taxTable = null;
        if (null == tempMap.get(key)) {
            taxTable = this.getTaxRateTable(calSchemeInfo, currencyMap);
            tempMap.put(key, taxTable);
        } else {
            taxTable = (LinkedHashMap)tempMap.get(key);
        }
        BigDecimal rate = new BigDecimal(0);
        BigDecimal deduction = new BigDecimal(0);
        BigDecimal valBig = new BigDecimal(String.valueOf(val));
        if (valBig.compareTo(BigDecimal.ZERO) <= 0) {
            return 0.0;
        }
        Iterator keyIt = taxTable.keySet().iterator();
        String mapKay = null;
        Map entryMap = null;
        while (keyIt.hasNext()) {
            mapKay = (String)keyIt.next();
            entryMap = (Map)taxTable.get(mapKay);
            if (valBig.compareTo((BigDecimal)entryMap.get(FTaxPeak)) > 0) continue;
            rate = (BigDecimal)entryMap.get(FRate);
            deduction = (BigDecimal)entryMap.get(FDeduction);
            break;
        }
        double value = 0.0;
        if (type == 2.0) {
            value = rate.doubleValue();
        } else if (type == 3.0) {
            value = deduction.doubleValue();
        } else {
            BigDecimal b4 = valBig.multiply(rate);
            value = b4.subtract(deduction).doubleValue();
        }
        return value;
    }

    public double getCumulativePreTaxMoney(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap, double v1, double v2, double type) {
        String key = "T_HR_STaxRateTable_" + calSchemeInfo.getId().toString() + calSchemeInfo.getEndDate().getTime();
        LinkedHashMap taxTable = null;
        if (null == tempMap.get(key)) {
            taxTable = this.getTaxRateTable(calSchemeInfo, currencyMap);
            tempMap.put(key, taxTable);
        } else {
            taxTable = (LinkedHashMap)tempMap.get(key);
        }
        BigDecimal rate = new BigDecimal(0);
        BigDecimal deduction = new BigDecimal(0);
        BigDecimal tax = new BigDecimal(0);
        BigDecimal val1 = new BigDecimal(String.valueOf(v1));
        BigDecimal val2 = new BigDecimal(String.valueOf(v2));
        BigDecimal valBig = val1.subtract(val2);
        Iterator keyIt = taxTable.keySet().iterator();
        String mapKay = null;
        Map entryMap = null;
        while (keyIt.hasNext()) {
            mapKay = (String)keyIt.next();
            entryMap = (Map)taxTable.get(mapKay);
            if (valBig.compareTo((BigDecimal)entryMap.get(FNoTaxPeak)) > 0) continue;
            rate = (BigDecimal)entryMap.get(FRate);
            deduction = (BigDecimal)entryMap.get(FDeduction);
            break;
        }
        double value = 0.0;
        if (type == 3.0) {
            value = rate.doubleValue();
        } else if (type == 4.0) {
            value = deduction.doubleValue();
        } else {
            BigDecimal b5 = val1.subtract(deduction).subtract(val2.multiply(rate));
            BigDecimal b6 = new BigDecimal(1).subtract(rate);
            double b7 = b5.divide(b6, 10, 4).doubleValue();
            value = type == 2.0 ? b7 - v1 : b7;
        }
        return value;
    }

    public Map<String, java.util.Date> getTaxYearRange(Context ctx, CalSchemeInfo calSchemeInfo, int periodYear, int periodMonth) {
        HashMap<String, java.util.Date> rangeMap = null;
        int taxYear = -1;
        try {
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getBeginMonth() <= 12) {
                taxYear = periodYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && periodMonth > calSchemeInfo.getEndMonth()) {
                    ++taxYear;
                }
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && periodMonth < calSchemeInfo.getBeginMonth()) {
                    --taxYear;
                }
                rangeMap = new HashMap<String, java.util.Date>();
                Calendar pal = Calendar.getInstance();
                int beginYear = taxYear;
                int endYear = taxYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && calSchemeInfo.getBeginMonth() > 1) {
                    beginYear = taxYear - 1;
                } else if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && calSchemeInfo.getBeginMonth() > 1) {
                    endYear = taxYear + 1;
                }
                pal.set(1, beginYear);
                pal.set(2, calSchemeInfo.getBeginMonth() - 1);
                pal.set(5, 1);
                pal.set(10, 0);
                pal.set(12, 0);
                pal.set(13, 0);
                rangeMap.put(beginDate, pal.getTime());
                pal.set(1, periodYear);
                pal.set(2, periodMonth - 1);
                pal.set(5, pal.getActualMaximum(5));
                rangeMap.put(endDate, pal.getTime());
                return rangeMap;
            }
            TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
            if (taxYearCol != null && taxYearCol.size() > 0) {
                TaxYearInfo taxYearInf = taxYearCol.get(0);
                taxYear = periodYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && periodMonth > taxYearInf.getEndMonth()) {
                    ++taxYear;
                }
                if (taxYearInf.getAnnu() == Annu.thatyear && periodMonth < taxYearInf.getBeginMonth()) {
                    --taxYear;
                }
                rangeMap = new HashMap();
                Calendar pal = Calendar.getInstance();
                int beginYear = taxYear;
                int endYear = taxYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && taxYearInf.getBeginMonth() > 1) {
                    beginYear = taxYear - 1;
                } else if (taxYearInf.getAnnu() == Annu.thatyear && taxYearInf.getBeginMonth() > 1) {
                    endYear = taxYear + 1;
                }
                pal.set(1, beginYear);
                pal.set(2, taxYearInf.getBeginMonth() - 1);
                pal.set(5, 1);
                pal.set(10, 0);
                pal.set(12, 0);
                pal.set(13, 0);
                rangeMap.put(beginDate, pal.getTime());
                pal.set(1, periodYear);
                pal.set(2, periodMonth - 1);
                pal.set(5, pal.getActualMaximum(5));
                rangeMap.put(endDate, pal.getTime());
                return rangeMap;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rangeMap;
    }

    private int getTaxYear(Context ctx, CalSchemeInfo calSchemeInfo, int periodYear, int periodMonth) {
        int taxYear = -1;
        try {
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not & calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getBeginMonth() <= 12) {
                taxYear = periodYear;
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear && periodMonth > calSchemeInfo.getEndMonth()) {
                    ++taxYear;
                }
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.thatyear && periodMonth < calSchemeInfo.getBeginMonth()) {
                    --taxYear;
                }
                return taxYear;
            }
            TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
            if (taxYearCol != null && taxYearCol.size() > 0) {
                TaxYearInfo taxYearInf = taxYearCol.get(0);
                taxYear = periodYear;
                if (taxYearInf.getAnnu() == Annu.lastyear && periodMonth > taxYearInf.getEndMonth()) {
                    ++taxYear;
                }
                if (taxYearInf.getAnnu() == Annu.thatyear && periodMonth < taxYearInf.getBeginMonth()) {
                    --taxYear;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return taxYear;
    }

    private Map<String, String> getAllItemMap() {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        String accuItem2 = null;
        for (String accuItem2 : AccumulateItem.getEnumMap().keySet()) {
            if (accuItem2.equals("none")) continue;
            if (!accuItem2.startsWith("f") && !accuItem2.startsWith("F")) {
                accuItem2 = "F" + accuItem2;
            }
            itemMap.put(accuItem2, accuItem2);
        }
        return itemMap;
    }

    private Map<String, Map> getAccumulateItemMap(Context ctx) {
        HashMap<String, Map> result = new HashMap<String, Map>();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        HashMap<String, String> accuItemMap = new HashMap<String, String>();
        HashMap<String, Number> deDuctOnceMap = new HashMap<String, Number>();
        try {
            CmpItemCollection itemColl = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection("select * where AccumulateItem is not null");
            if (itemColl != null && itemColl.size() > 0) {
                int size = itemColl.size();
                String fieldSn = null;
                String accuItem = null;
                for (int i = 0; i < size; ++i) {
                    CmpItemInfo item = itemColl.get(i);
                    fieldSn = "s" + item.getFieldSn();
                    accuItem = item.getAccumulateItem().getValue();
                    if (!accuItem.startsWith("f") && !accuItem.startsWith("F")) {
                        accuItem = "F" + accuItem;
                    }
                    itemMap.put(fieldSn, accuItem);
                    if ("Fnone".equals(accuItem)) continue;
                    accuItemMap.put(fieldSn, accuItem);
                    boolean isDeductOnce = item.isIsDeductOnce();
                    if (!isDeductOnce) continue;
                    deDuctOnceMap.put(fieldSn + "_times", 0);
                    deDuctOnceMap.put(fieldSn + "_value", BigDecimal.ZERO);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        result.put("itemMap", itemMap);
        result.put("accuItemMap", accuItemMap);
        result.put("deDuctOnceMap", deDuctOnceMap);
        return result;
    }

    private Map<String, Object> getEmptyMap(Map<String, String> allItemMap, int nYear, int nMonth) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Iterator<String> itemIt = allItemMap.keySet().iterator();
        while (itemIt.hasNext()) {
            dataMap.put(itemIt.next(), BigDecimal.ZERO);
        }
        dataMap.put(FperiodYear, nYear);
        dataMap.put(FperiodMonth, nMonth);
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, Map> getCalSumDataMap(Context ctx, CalSchemeInfo calSchemeInfo, int taxYear, int periodYear, int periodMonth, int calTime, boolean isSeriesTaxAcc, String mainTableRowFilter) {
        HashMap<String, Map<String, Object>> otherUnitDataMap;
        HashMap<String, Map<String, Object>> curUnitDataMap;
        HashMap<String, Map> resultMap;
        block33: {
            String cmpSchemeId = calSchemeInfo.getId().toString();
            resultMap = new HashMap<String, Map>();
            curUnitDataMap = null;
            otherUnitDataMap = new HashMap<String, Map<String, Object>>();
            int beginYear = taxYear;
            int beginMonth = periodMonth;
            long startTime = System.currentTimeMillis();
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getEndMonth() <= 12) {
                beginMonth = calSchemeInfo.getBeginMonth();
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear) {
                    --beginYear;
                }
            } else {
                try {
                    TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
                    if (taxYearCol != null && taxYearCol.size() > 0) {
                        TaxYearInfo taxYearInf = taxYearCol.get(0);
                        beginMonth = taxYearInf.getBeginMonth();
                        if (taxYearInf.getAnnu() == Annu.lastyear) {
                            --beginYear;
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Integer> taxUnitMap = new HashMap<String, Integer>();
            try {
                TaxUnitCollection taxUnitColl = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitCollection("select id where state=1 and isAllowedQuoted=1");
                if (taxUnitColl != null && taxUnitColl.size() > 0) {
                    for (int i = 0; i < taxUnitColl.size(); ++i) {
                        taxUnitMap.put(taxUnitColl.get(i).getId().toString(), i);
                    }
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            System.out.println("------------begin\uff1a" + (endTime - startTime));
            startTime = System.currentTimeMillis();
            Map<String, String> allItemMap = this.getAllItemMap();
            Map<String, Map> result = this.getAccumulateItemMap(ctx);
            Map itemMap = result.get("itemMap");
            Map accuItemMap = result.get("accuItemMap");
            Iterator it = itemMap.keySet().iterator();
            StringBuffer selectCtbSn = new StringBuffer();
            while (it.hasNext()) {
                selectCtbSn.append(",ctb.").append((String)it.next());
            }
            StringBuffer preSql = new StringBuffer();
            preSql.append("select ctb.FPersonId,ctb.FCalSchemeID,ctb.FperiodYear,ctb.FperiodMonth,ctb.FcalTime,ctb.FTaxUnitId,ctb.FID,");
            preSql.append("cur.FTaxUnitId curTaxUnitId,record.FItemMap").append(selectCtbSn).append("  from T_HR_SCmpCalTable ctb ");
            preSql.append("inner join (select FID, FPersonId,FTaxUnitId from T_HR_SCmpCalTable ").append(" where FCalSchemeID = '");
            preSql.append(cmpSchemeId).append("'  and FperiodYear=").append(periodYear).append(" and FperiodMonth= ").append(periodMonth);
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                preSql.append(" and ").append(mainTableRowFilter);
            }
            preSql.append(" and FcalTime=").append(calTime).append(") cur on ctb.FPersonId=cur.FPersonId ");
            preSql.append("left join T_HR_SSumItemMapRecord record on record.FCalSchemeId=ctb.FCalSchemeId and record.FperiodYear=ctb.FperiodYear ");
            preSql.append("and record.FperiodMonth=ctb.FperiodMonth and record.FcalTime=ctb.FcalTime");
            preSql.append(" where (").append(this.getPeriodFilter(beginYear, beginMonth, periodYear, periodMonth, "ctb.FperiodYear", "ctb.FperiodMonth")).append(") ");
            preSql.append(" and ctb.FCalState in (12,20) order by ctb.FperiodYear asc,ctb.FperiodMonth asc,ctb.FcalTime asc");
            endTime = System.currentTimeMillis();
            System.out.println("------------Select time consuming\uff1a" + (endTime - startTime));
            Connection conn = null;
            Statement statement = null;
            ResultSet rowset = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                statement = conn.createStatement();
                startTime = System.currentTimeMillis();
                rowset = statement.executeQuery(preSql.toString());
                endTime = System.currentTimeMillis();
                System.out.println("------------execute time consuming\uff1a" + (endTime - startTime));
                System.out.println("------------select result \uff1a" + rowset.getFetchSize() + "------------select sql\uff1a" + preSql.toString());
                String personID = null;
                String taxUnitId = null;
                String calSchemeId = null;
                String curTaxUnitId = null;
                Map curItemMap = null;
                Map dataMap = null;
                String FItemMap = null;
                String ctbFID = null;
                curUnitDataMap = new HashMap<String, Map<String, Object>>();
                HashMap<String, Object> recordMap = new HashMap<String, Object>();
                HashMap<String, Map> ItemMapRecord = new HashMap<String, Map>();
                String itemMapKey = null;
                startTime = System.currentTimeMillis();
                while (rowset.next()) {
                    String accumulateItem;
                    BigDecimal value;
                    personID = rowset.getString(FPersonID);
                    taxUnitId = rowset.getString(FTaxUnitID);
                    calSchemeId = rowset.getString(FCalSchemeID);
                    int nYear = rowset.getInt(FperiodYear);
                    int nMonth = rowset.getInt(FperiodMonth);
                    int nCalTime = rowset.getInt(FCalTime);
                    ctbFID = rowset.getString(FID);
                    curTaxUnitId = rowset.getString("curTaxUnitId");
                    FItemMap = rowset.getString("FItemMap");
                    if (recordMap.containsKey(ctbFID) || cmpSchemeId.equals(calSchemeId) && periodYear == nYear && periodMonth == nMonth && nCalTime > calTime) continue;
                    recordMap.put(ctbFID, objValue);
                    itemMapKey = calSchemeId + split + nYear + split + nMonth + split + nCalTime;
                    if (StringUtils.isEmpty((String)FItemMap)) {
                        curItemMap = accuItemMap;
                    } else if (ItemMapRecord.containsKey(itemMapKey)) {
                        curItemMap = (Map)ItemMapRecord.get(itemMapKey);
                    } else {
                        curItemMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)FItemMap, Map.class);
                        ItemMapRecord.put(itemMapKey, curItemMap);
                    }
                    if (StringUtils.isEmpty((String)curTaxUnitId)) continue;
                    if (curTaxUnitId.equals(taxUnitId)) {
                        dataMap = (Map)curUnitDataMap.get(personID);
                        if (dataMap == null) {
                            dataMap = this.getEmptyMap(allItemMap, nYear, nMonth);
                        } else if (!isSeriesTaxAcc) {
                            int month = nMonth - Integer.parseInt(dataMap.get(FperiodMonth).toString());
                            int n = month = month < 0 ? month + 12 : month;
                            if (month > 1) {
                                dataMap = this.getEmptyMap(allItemMap, nYear, nMonth);
                            }
                        }
                        for (String keySn : curItemMap.keySet()) {
                            value = rowset.getBigDecimal(keySn);
                            value = value == null ? BigDecimal.ZERO : value;
                            accumulateItem = (String)curItemMap.get(keySn);
                            dataMap.put((String)accumulateItem, (Object)((BigDecimal)dataMap.get(accumulateItem)).add(value));
                        }
                        dataMap.put((String)FperiodYear, nYear);
                        dataMap.put((String)FperiodMonth, nMonth);
                        curUnitDataMap.put(personID, dataMap);
                        continue;
                    }
                    if (!taxUnitMap.containsKey(taxUnitId)) continue;
                    dataMap = (Map)otherUnitDataMap.get(personID);
                    if (dataMap == null) {
                        dataMap = this.getEmptyMap(allItemMap, nYear, nMonth);
                    }
                    for (String keySn : curItemMap.keySet()) {
                        value = rowset.getBigDecimal(keySn);
                        value = value == null ? BigDecimal.ZERO : value;
                        accumulateItem = (String)curItemMap.get(keySn);
                        dataMap.put((String)accumulateItem, (Object)((BigDecimal)dataMap.get(accumulateItem)).add(value));
                    }
                    otherUnitDataMap.put(personID, dataMap);
                }
                endTime = System.currentTimeMillis();
                System.out.println("------------time consuming\uff1a" + (endTime - startTime));
                SQLUtils.cleanup((ResultSet)rowset, (Statement)statement, (Connection)conn);
            }
            catch (SQLException e) {
                SQLUtils.cleanup((Connection)conn);
                e.printStackTrace();
            }
            catch (Exception ex) {
                SQLUtils.cleanup((Connection)conn);
                ex.printStackTrace();
                break block33;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(rowset, (Statement)statement, (Connection)conn);
            }
        }
        resultMap.put("CurrentUnitData", curUnitDataMap);
        resultMap.put("OtherUnitData", otherUnitDataMap);
        return resultMap;
    }

    private String getPeriodFilter(int beginYear, int beginMonth, int endYear, int endMonth, String year, String month) {
        StringBuilder res = new StringBuilder();
        if (beginYear == endYear) {
            res.append(year + " = " + beginYear + " and " + month + ">=" + beginMonth + " and " + month + "<=" + endMonth);
        } else if (endYear > beginYear) {
            res.append("(" + year + " = " + beginYear + " and " + month + ">=" + beginMonth + ")");
            res.append("or (" + year + " = " + endYear + " and " + month + "<=" + endMonth + ")");
        } else {
            res.append("(" + year + " = " + beginYear + " and " + month + ">=" + beginMonth + " and " + month + "<=" + endMonth + " and " + year + " = " + endYear + ")");
            res.append("or(" + year + " = " + beginYear + " and " + month + ">=" + beginMonth + " and " + year + " < " + endYear + ")");
            res.append("or(" + year + " > " + beginYear + " and " + year + "<" + endYear + ")");
            res.append("or(" + year + " = " + endYear + " and " + month + "<=" + endMonth + " and " + year + " > " + beginYear + ")");
        }
        return res.toString();
    }

    private String switchItemNum(String itemNum) {
        String colName = "";
        int intNum = Integer.parseInt(itemNum);
        switch (intNum) {
            case 10: {
                colName = "FtaxIncome";
                break;
            }
            case 20: {
                colName = "FtotalIncome";
                break;
            }
            case 21: {
                colName = "FnetIncome";
                break;
            }
            case 30: {
                colName = "FtaxFreeIncome";
                break;
            }
            case 40: {
                colName = "FbasicDeduction";
                break;
            }
            case 50: {
                colName = "FsocDeduction";
                break;
            }
            case 51: {
                colName = "FagedDeduction";
                break;
            }
            case 52: {
                colName = "FmedicalDeduction";
                break;
            }
            case 53: {
                colName = "FunemployDeduction";
                break;
            }
            case 60: {
                colName = "fundDeduction";
                break;
            }
            case 61: {
                colName = "fundPayment";
                break;
            }
            case 70: {
                colName = "FspeDeduction";
                break;
            }
            case 71: {
                colName = "FhouseLoanDeduction";
                break;
            }
            case 72: {
                colName = "FrentalDeduction";
                break;
            }
            case 73: {
                colName = "FchildEduDeduction";
                break;
            }
            case 74: {
                colName = "furtherEduDeduction";
                break;
            }
            case 75: {
                colName = "FsupportDeduction";
                break;
            }
            case 76: {
                colName = "FinFantCare";
                break;
            }
            case 80: {
                colName = "FotherDeduction";
                break;
            }
            case 81: {
                colName = "Fannuity";
                break;
            }
            case 82: {
                colName = "FreserveOne";
                break;
            }
            case 83: {
                colName = "FreserveTwo";
                break;
            }
            case 84: {
                colName = "FreserveThree";
                break;
            }
            case 90: {
                colName = "FwithholdTax";
            }
        }
        return colName;
    }

    private BigDecimal getItemValue(Map<String, Map> personDataMap, String personId, String colName, boolean sameUnit, int periodMonth, boolean isSeriesTaxAcc) {
        BigDecimal value = BigDecimal.ZERO;
        if (personDataMap.size() > 0 && personDataMap.get(personId) != null) {
            int month = periodMonth - Integer.parseInt(personDataMap.get(personId).get(FperiodMonth).toString());
            int n = month = month < 0 ? month + 12 : month;
            if (sameUnit && !isSeriesTaxAcc && month > 1) {
                return value;
            }
            Object objValue = personDataMap.get(personId).get(colName);
            if (objValue == null) {
                System.out.println("getAccumulateValue\uff1aget null");
            } else {
                value = (BigDecimal)objValue;
            }
        }
        return value;
    }

    public double getAccumulateValue(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String itemNum, double type) {
        double value = 0.0;
        Context ctx = Tools.getInstance().getCtx();
        String cmpSchemeId = calScheme.getId().toString();
        String taxUnitId = calScheme.getTaxUnit() == null ? "" : calScheme.getTaxUnit().getId().toString();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        boolean isSeriesTaxAcc = calScheme.isIsSeriesTaxAcc();
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)personId)) {
            System.out.println("getAccumulateValue\uff1aselect null ");
            return value;
        }
        String key = cmpSchemeId + split + taxUnitId + split + periodYear + split + periodMonth + split + calTime + split + isSeriesTaxAcc;
        if (tempMap.get(key) == null) {
            int taxYear = this.getTaxYear(ctx, calScheme, periodYear, periodMonth);
            if (taxYear < 0) {
                HashMap notDateMap = new HashMap();
                tempMap.put(key, notDateMap);
                return value;
            }
            Map<String, Map> personDataMap = this.getCalSumDataMap(ctx, calScheme, taxYear, periodYear, periodMonth, calTime, isSeriesTaxAcc, mainTableRowFilter);
            tempMap.put(key, personDataMap);
        }
        String colName = this.switchItemNum(itemNum);
        Map dataMap = (Map)tempMap.get(key);
        if (dataMap.size() < 1) {
            return value;
        }
        if (type == 3.0) {
            BigDecimal curValue = this.getItemValue((Map)dataMap.get("CurrentUnitData"), personId, colName, true, periodMonth, isSeriesTaxAcc);
            BigDecimal otherValue = this.getItemValue((Map)dataMap.get("OtherUnitData"), personId, colName, false, periodMonth, isSeriesTaxAcc);
            value = curValue.add(otherValue).doubleValue();
        } else {
            value = type == 1.0 ? this.getItemValue((Map)dataMap.get("OtherUnitData"), personId, colName, false, periodMonth, isSeriesTaxAcc).doubleValue() : this.getItemValue((Map)dataMap.get("CurrentUnitData"), personId, colName, true, periodMonth, isSeriesTaxAcc).doubleValue();
        }
        return value;
    }

    public double getTaxTbThreshold(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap, String taxTbName) throws SQLException {
        block5: {
            Context ctx = Tools.getInstance().getCtx();
            String lanIndex = calSchemeInfo.getLanType().getValue();
            try {
                String key = "getTaxTbThreshold_" + calSchemeInfo.getId().toString() + calSchemeInfo.getEndDate().getTime() + taxTbName;
                String endDateStr = CmpDateUtil.toKSqlDate(calSchemeInfo.getEndDate());
                if (null == tempMap.get(key)) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(" SELECT FTHRESHOLD, FCURRENCYID FROM T_HR_STaxRateTable where Fname_");
                    buffer.append(lanIndex);
                    buffer.append("='");
                    buffer.append(taxTbName);
                    buffer.append("'");
                    buffer.append(" and FState=1");
                    buffer.append(" and FLEFFDT <=");
                    buffer.append(endDateStr);
                    buffer.append(" order by FLEFFDT desc");
                    IRowSet set = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
                    if (set.next()) {
                        String currencyId = set.getString(2);
                        BigDecimal rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                        double threshold = set.getDouble(1) * rate.doubleValue();
                        tempMap.put(key, threshold);
                        return threshold;
                    }
                    break block5;
                }
                return Double.parseDouble(tempMap.get(key).toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0.0;
    }

    public double getTaxTabWithholdingTax(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap, String taxTbName, double val, double type) {
        double value = 0.0;
        String key = "T_HR_STaxRateTable_" + calSchemeInfo.getId().toString() + calSchemeInfo.getEndDate().getTime() + taxTbName;
        LinkedHashMap<String, Map<String, BigDecimal>> taxTable = null;
        if (null == tempMap.get(key)) {
            boolean isValid = this.isValidTaxTable(calSchemeInfo, taxTbName);
            if (!isValid) {
                tempMap.put(key, new LinkedHashMap());
                return value;
            }
            taxTable = this.getTaxRateTable(calSchemeInfo, taxTbName, currencyMap);
            tempMap.put(key, taxTable);
        } else {
            taxTable = (LinkedHashMap<String, Map<String, BigDecimal>>)tempMap.get(key);
        }
        BigDecimal rate = new BigDecimal(0);
        BigDecimal deduction = new BigDecimal(0);
        BigDecimal valBig = new BigDecimal(String.valueOf(val));
        if (valBig.compareTo(BigDecimal.ZERO) <= 0) {
            return 0.0;
        }
        Iterator<String> keyIt = taxTable.keySet().iterator();
        String mapKay = null;
        Map<String, BigDecimal> entryMap = null;
        while (keyIt.hasNext()) {
            mapKay = keyIt.next();
            entryMap = taxTable.get(mapKay);
            if (valBig.compareTo(entryMap.get(FTaxPeak)) > 0) continue;
            rate = entryMap.get(FRate);
            deduction = entryMap.get(FDeduction);
            break;
        }
        if (type == 2.0) {
            value = rate.doubleValue();
        } else if (type == 3.0) {
            value = deduction.doubleValue();
        } else {
            BigDecimal rateVal = valBig.multiply(rate);
            value = rateVal.subtract(deduction).doubleValue();
        }
        return value;
    }

    private LinkedHashMap<String, Map<String, BigDecimal>> getTaxRateTable(CalSchemeInfo calSchemeInfo, String taxTbName, Map<String, BigDecimal> currencyMap) {
        Context ctx = Tools.getInstance().getCtx();
        String endDateStr = CmpDateUtil.toKSqlDate(calSchemeInfo.getEndDate());
        String lanIndex = calSchemeInfo.getLanType().getValue();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT ENTRY.FID,ENTRY.FTAXVALLEY,ENTRY.FTAXPEAK, ");
        buffer.append(" ENTRY.FNOTAXVALLEY,ENTRY.FNOTAXPEAK,ENTRY.FRATE,ENTRY.FDEDUCTION,TAXTABLE.FCURRENCYID ");
        buffer.append(" FROM T_HR_STAXRATETABLEENTRY ENTRY ");
        buffer.append(" INNER JOIN T_HR_STAXRATETABLE TAXTABLE ON TAXTABLE.FID=ENTRY.FTAXTABLEID ");
        buffer.append(" WHERE FEFFDT <= ");
        buffer.append(endDateStr);
        buffer.append(" AND FNAME_").append(lanIndex).append(" = '").append(taxTbName).append("'");
        buffer.append(" AND FSTATE =1 ");
        buffer.append(" ORDER BY ENTRY.FTAXPEAK ASC ");
        LinkedHashMap<String, Map<String, BigDecimal>> taxTable = new LinkedHashMap<String, Map<String, BigDecimal>>();
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            BigDecimal taxValley = null;
            BigDecimal taxPeak = null;
            BigDecimal noTaxValley = null;
            BigDecimal noTaxPeak = null;
            BigDecimal rate = null;
            BigDecimal deduction = null;
            HashMap<String, BigDecimal> entryMap = null;
            while (rowset.next()) {
                String currencyId = rowset.getString("FCURRENCYID");
                BigDecimal currencyRate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                taxValley = rowset.getBigDecimal(FTaxValley) == null ? new BigDecimal(0) : rowset.getBigDecimal(FTaxValley);
                taxPeak = rowset.getBigDecimal(FTaxPeak) == null ? new BigDecimal(0) : rowset.getBigDecimal(FTaxPeak);
                rate = rowset.getBigDecimal(FRate) == null ? new BigDecimal(0) : rowset.getBigDecimal(FRate);
                deduction = rowset.getBigDecimal(FDeduction) == null ? new BigDecimal(0) : rowset.getBigDecimal(FDeduction);
                noTaxPeak = rowset.getBigDecimal(FNoTaxPeak) == null ? new BigDecimal(0) : rowset.getBigDecimal(FNoTaxPeak);
                noTaxValley = rowset.getBigDecimal(FNoTaxValley) == null ? new BigDecimal(0) : rowset.getBigDecimal(FNoTaxValley);
                entryMap = new HashMap<String, BigDecimal>();
                entryMap.put(FTaxValley, taxValley.multiply(currencyRate));
                entryMap.put(FTaxPeak, taxPeak.multiply(currencyRate));
                entryMap.put(FRate, rate);
                entryMap.put(FDeduction, deduction.multiply(currencyRate));
                entryMap.put(FNoTaxValley, noTaxValley.multiply(currencyRate));
                entryMap.put(FNoTaxPeak, noTaxPeak.multiply(currencyRate));
                taxTable.put(rowset.getString(FID), entryMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return taxTable;
    }

    private boolean isValidTaxTable(CalSchemeInfo calSchemeInfo, String taxTbName) {
        Context ctx = Tools.getInstance().getCtx();
        String endDateStr = CmpDateUtil.toKSqlDate(calSchemeInfo.getEndDate());
        String lanIndex = calSchemeInfo.getLanType().getValue();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT Fid FROM T_HR_STaxRateTable where FEFFDT <= ");
        buffer.append(endDateStr);
        buffer.append(" and Fname_");
        buffer.append(lanIndex);
        buffer.append(" = '");
        buffer.append(taxTbName);
        buffer.append("'");
        buffer.append(" and FSTATE =1 ");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            if (rowset.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public double getTaxTabPreTax(Map paramMap, HashMap tempMap, CalSchemeInfo calSchemeInfo, Map<String, BigDecimal> currencyMap, String taxTbName, double v1, double v2, double type) {
        double value = 0.0;
        String key = "T_HR_STaxRateTable_" + calSchemeInfo.getId().toString() + calSchemeInfo.getEndDate().getTime() + taxTbName;
        LinkedHashMap<String, Map<String, BigDecimal>> taxTable = null;
        if (null == tempMap.get(key)) {
            boolean isValid = this.isValidTaxTable(calSchemeInfo, taxTbName);
            if (!isValid) {
                tempMap.put(key, new LinkedHashMap());
                return value;
            }
            taxTable = this.getTaxRateTable(calSchemeInfo, taxTbName, currencyMap);
            tempMap.put(key, taxTable);
        } else {
            taxTable = (LinkedHashMap<String, Map<String, BigDecimal>>)tempMap.get(key);
        }
        BigDecimal rate = new BigDecimal(0);
        BigDecimal deduction = new BigDecimal(0);
        BigDecimal val1 = new BigDecimal(Double.toString(v1));
        BigDecimal val2 = new BigDecimal(Double.toString(v2));
        BigDecimal valBig = val1.subtract(val2);
        Iterator<String> keyIt = taxTable.keySet().iterator();
        String mapKay = null;
        Map<String, BigDecimal> entryMap = null;
        while (keyIt.hasNext()) {
            mapKay = keyIt.next();
            entryMap = taxTable.get(mapKay);
            if (valBig.compareTo(entryMap.get(FNoTaxPeak)) > 0) continue;
            rate = entryMap.get(FRate);
            deduction = entryMap.get(FDeduction);
            break;
        }
        if (type == 3.0) {
            value = rate.doubleValue();
        } else if (type == 4.0) {
            value = deduction.doubleValue();
        } else {
            BigDecimal b5 = val1.subtract(deduction).subtract(val2.multiply(rate));
            BigDecimal b6 = new BigDecimal(1).subtract(rate);
            double b7 = b5.divide(b6, 10, 4).doubleValue();
            value = type == 2.0 ? b7 - v1 : b7;
        }
        return value;
    }

    public double getExchangeRateValue(HashMap tempMap, String sourceCurrency, String targetCurrency, String exchangeTable, String leffdt) {
        String key = "getExchangeRateValue_" + sourceCurrency + split + targetCurrency + split + exchangeTable + split + leffdt;
        Context ctx = Tools.getInstance().getCtx();
        if (null == leffdt || "".equals(leffdt.trim())) {
            return 0.0;
        }
        if (!tempMap.containsKey(key)) {
            String oqlLeffdt = CmpDateUtil.toKSqlDate(CmpDateUtil.toDate(leffdt));
            StringBuilder str = new StringBuilder();
            str.append("SELECT RATE.FCONVERTRATE, AUX.FPRECISION ");
            str.append(" FROM T_BD_EXCHANGEAUX AUX ");
            str.append(" INNER JOIN T_BD_EXCHANGERATE RATE ON RATE.FEXCHANGEAUXID = AUX.FID ");
            str.append(" INNER JOIN T_BD_EXCHANGETABLE TAB ON AUX.FEXCHANGETABLEID = TAB.FID ");
            str.append(" INNER JOIN T_BD_CURRENCY SOURCE ON AUX.FSOURCECURRENCYID = SOURCE.FID ");
            str.append(" INNER JOIN T_BD_CURRENCY TARGET ON AUX.FTARGETCURRENCYID = TARGET.FID ");
            str.append(" WHERE SOURCE.FNUMBER = '").append(sourceCurrency).append("' ");
            str.append(" AND TARGET.FNUMBER = '").append(targetCurrency).append("' ");
            str.append(" AND TAB.FNUMBER = '").append(exchangeTable).append("' ");
            str.append(" AND RATE.FAVAILTIME <=").append(oqlLeffdt);
            str.append(" AND RATE.FINVALIDTIME >= ").append(oqlLeffdt);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                if (rowSet.next()) {
                    BigDecimal convertRate = rowSet.getBigDecimal(1);
                    int precision = rowSet.getInt(2);
                    convertRate = convertRate.setScale(precision);
                    tempMap.put(key, convertRate);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tempMap.containsKey(key) ? ((BigDecimal)tempMap.get(key)).doubleValue() : 0.0;
    }

    public double getAccumulateValueNew(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String itemNum, double type) {
        double value = 0.0;
        Context ctx = Tools.getInstance().getCtx();
        String cmpSchemeId = calScheme.getId().toString();
        String taxUnitId = calScheme.getTaxUnit() == null ? "" : calScheme.getTaxUnit().getId().toString();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        boolean isSeriesTaxAcc = calScheme.isIsSeriesTaxAcc();
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)personId)) {
            System.out.println("getAccumulateValue\uff1a\u67e5\u8be2\u4e0d\u5230\u5458\u5de5");
            return value;
        }
        String key = "getAccumulateValueNew_" + cmpSchemeId + split + taxUnitId + split + periodYear + split + periodMonth + split + calTime + split + isSeriesTaxAcc;
        if (tempMap.get(key) == null) {
            int taxYear = this.getTaxYear(ctx, calScheme, periodYear, periodMonth);
            if (taxYear < 0) {
                System.out.println("getAccumulateValue\uff1a\u672a\u7ef4\u62a4\u7eb3\u7a0e\u5e74\u5ea6");
                return value;
            }
            Map<String, Map> personDataMap = this.getCalSumDataMapNew(ctx, calScheme, taxYear, periodYear, periodMonth, calTime, isSeriesTaxAcc, mainTableRowFilter);
            tempMap.put(key, personDataMap);
        }
        String colName = this.switchItemNum(itemNum);
        Map dataMap = (Map)tempMap.get(key);
        if (type == 3.0) {
            BigDecimal curValue = this.getItemValue((Map)dataMap.get("CurrentUnitData"), personId, colName, true, periodMonth, isSeriesTaxAcc);
            BigDecimal otherValue = this.getItemValue((Map)dataMap.get("OtherUnitData"), personId, colName, false, periodMonth, isSeriesTaxAcc);
            value = curValue.add(otherValue).doubleValue();
        } else {
            value = type == 1.0 ? this.getItemValue((Map)dataMap.get("OtherUnitData"), personId, colName, false, periodMonth, isSeriesTaxAcc).doubleValue() : this.getItemValue((Map)dataMap.get("CurrentUnitData"), personId, colName, true, periodMonth, isSeriesTaxAcc).doubleValue();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, Map> getCalSumDataMapNew(Context ctx, CalSchemeInfo calSchemeInfo, int taxYear, int periodYear, int periodMonth, int calTime, boolean isSeriesTaxAcc, String mainTableRowFilter) {
        HashMap<String, Map<String, Object>> otherUnitDataMap;
        HashMap<String, Map<String, Object>> curUnitDataMap;
        HashMap<String, Map> resultMap;
        block43: {
            String cmpSchemeId = calSchemeInfo.getId().toString();
            resultMap = new HashMap<String, Map>();
            curUnitDataMap = null;
            otherUnitDataMap = new HashMap<String, Map<String, Object>>();
            int beginYear = taxYear;
            int beginMonth = periodMonth;
            long startTime = System.currentTimeMillis();
            if (calSchemeInfo.getAnnu() != CalSchemeAnnu.not && calSchemeInfo.getBeginMonth() >= 1 && calSchemeInfo.getEndMonth() <= 12) {
                beginMonth = calSchemeInfo.getBeginMonth();
                if (calSchemeInfo.getAnnu() == CalSchemeAnnu.lastyear) {
                    --beginYear;
                }
            } else {
                try {
                    TaxYearCollection taxYearCol = TaxYearFactory.getLocalInstance(ctx).getTaxYearCollection();
                    if (taxYearCol != null && taxYearCol.size() > 0) {
                        TaxYearInfo taxYearInf = taxYearCol.get(0);
                        beginMonth = taxYearInf.getBeginMonth();
                        if (taxYearInf.getAnnu() == Annu.lastyear) {
                            --beginYear;
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Integer> taxUnitMap = new HashMap<String, Integer>();
            try {
                TaxUnitCollection taxUnitColl = TaxUnitFactory.getLocalInstance(ctx).getTaxUnitCollection("select id where state=1 and isAllowedQuoted=1");
                if (taxUnitColl != null && taxUnitColl.size() > 0) {
                    for (int i = 0; i < taxUnitColl.size(); ++i) {
                        taxUnitMap.put(taxUnitColl.get(i).getId().toString(), i);
                    }
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            System.out.println("------------\u8ba1\u7b97\u7eb3\u7a0e\u5e74\u5ea6\u8d77\u59cb\u5e74\u6708\u65f6\u95f4\uff1a" + (endTime - startTime));
            startTime = System.currentTimeMillis();
            Map<String, String> allItemMap = this.getAllItemMap();
            Map<String, Map> result = this.getAccumulateItemMap(ctx);
            Map itemMap = result.get("itemMap");
            Map accuItemMap = result.get("accuItemMap");
            Map deDuctOnceMap = result.get("deDuctOnceMap");
            Iterator it = itemMap.keySet().iterator();
            StringBuffer selectCtbSn = new StringBuffer();
            while (it.hasNext()) {
                selectCtbSn.append(",ctb.").append((String)it.next());
            }
            StringBuffer preSql = new StringBuffer();
            preSql.append("select ctb.FPersonId,ctb.FCalSchemeID,ctb.FperiodYear,ctb.FperiodMonth,ctb.FcalTime,ctb.FTaxUnitId,ctb.FID,");
            preSql.append("cur.FTaxUnitId curTaxUnitId,record.FItemMap,ctb.FCalState").append(selectCtbSn).append("  from T_HR_SCmpCalTable ctb ");
            preSql.append("inner join (select FID, FPersonId,FTaxUnitId from T_HR_SCmpCalTable ").append(" where FCalSchemeID = '");
            preSql.append(cmpSchemeId).append("'  and FperiodYear=").append(periodYear).append(" and FperiodMonth= ").append(periodMonth);
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                preSql.append(" and ").append(mainTableRowFilter);
            }
            preSql.append(" and FcalTime=").append(calTime).append(") cur on ctb.FPersonId=cur.FPersonId ");
            preSql.append("left join T_HR_SSumItemMapRecord record on record.FCalSchemeId=ctb.FCalSchemeId and record.FperiodYear=ctb.FperiodYear ");
            preSql.append("and record.FperiodMonth=ctb.FperiodMonth and record.FcalTime=ctb.FcalTime");
            preSql.append(" where (").append(this.getPeriodFilter(beginYear, beginMonth, periodYear, periodMonth, "ctb.FperiodYear", "ctb.FperiodMonth")).append(") ");
            preSql.append(" and ctb.FCalState>=12 order by ctb.FperiodYear asc,ctb.FperiodMonth asc,ctb.FcalTime asc");
            endTime = System.currentTimeMillis();
            System.out.println("------------\u51c6\u5907\u67e5\u8be2\u6761\u4ef6\u548c\u6570\u636e\u7684\u65f6\u95f4\uff1a" + (endTime - startTime));
            Connection conn = null;
            Statement statement = null;
            ResultSet rowset = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                statement = conn.createStatement();
                startTime = System.currentTimeMillis();
                rowset = statement.executeQuery(preSql.toString());
                endTime = System.currentTimeMillis();
                System.out.println("------------\u6267\u884c\u67e5\u8be2\u7684\u65f6\u95f4\uff1a" + (endTime - startTime));
                System.out.println("------------\u67e5\u8be2\u7ed3\u679c\u6570\uff1a" + rowset.getFetchSize() + "------------\u67e5\u8be2sql\uff1a" + preSql.toString());
                String personID = null;
                String taxUnitId = null;
                String calSchemeId = null;
                String curTaxUnitId = null;
                Map curItemMap = null;
                Map dataMap = null;
                String FItemMap = null;
                String ctbFID = null;
                curUnitDataMap = new HashMap<String, Map<String, Object>>();
                HashMap<String, Object> recordMap = new HashMap<String, Object>();
                HashMap<String, Map> ItemMapRecord = new HashMap<String, Map>();
                String itemMapKey = null;
                startTime = System.currentTimeMillis();
                while (rowset.next()) {
                    BigDecimal tempValue;
                    int times;
                    String accumulateItem;
                    BigDecimal value;
                    String keySn;
                    BigDecimal calValue;
                    Iterator keyIt;
                    HashMap<String, Number> deDuctOnceMapPer;
                    personID = rowset.getString(FPersonID);
                    taxUnitId = rowset.getString(FTaxUnitID);
                    calSchemeId = rowset.getString(FCalSchemeID);
                    int nYear = rowset.getInt(FperiodYear);
                    int nMonth = rowset.getInt(FperiodMonth);
                    int nCalTime = rowset.getInt(FCalTime);
                    ctbFID = rowset.getString(FID);
                    curTaxUnitId = rowset.getString("curTaxUnitId");
                    FItemMap = rowset.getString("FItemMap");
                    int nCalState = rowset.getInt("FCalState");
                    if (recordMap.containsKey(ctbFID) || cmpSchemeId.equals(calSchemeId) && periodYear == nYear && periodMonth == nMonth && nCalTime > calTime) continue;
                    recordMap.put(ctbFID, objValue);
                    itemMapKey = calSchemeId + split + nYear + split + nMonth + split + nCalTime;
                    if (StringUtils.isEmpty((String)FItemMap)) {
                        curItemMap = accuItemMap;
                    } else if (ItemMapRecord.containsKey(itemMapKey)) {
                        curItemMap = (Map)ItemMapRecord.get(itemMapKey);
                    } else {
                        curItemMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)FItemMap, Map.class);
                        ItemMapRecord.put(itemMapKey, curItemMap);
                    }
                    if (StringUtils.isEmpty((String)curTaxUnitId)) continue;
                    if (curTaxUnitId.equals(taxUnitId)) {
                        dataMap = (Map)curUnitDataMap.get(personID);
                        if (dataMap == null) {
                            dataMap = this.getEmptyMap(allItemMap, nYear, nMonth);
                        } else if (!isSeriesTaxAcc) {
                            int month = nMonth - Integer.parseInt(dataMap.get(FperiodMonth).toString());
                            int n = month = month < 0 ? month + 12 : month;
                            if (month > 1) {
                                dataMap = this.getEmptyMap(allItemMap, nYear, nMonth);
                            }
                        }
                        deDuctOnceMapPer = (HashMap<String, Number>)dataMap.get("deDuctOnceMapPer_" + personID + split + nYear + split + nMonth);
                        if (null == deDuctOnceMapPer) {
                            deDuctOnceMapPer = new HashMap<String, Number>();
                            deDuctOnceMapPer.putAll(deDuctOnceMap);
                            dataMap.put((String)("deDuctOnceMapPer_" + personID + split + nYear + split + nMonth), deDuctOnceMapPer);
                        }
                        keyIt = curItemMap.keySet().iterator();
                        calValue = BigDecimal.ZERO;
                        while (keyIt.hasNext()) {
                            keySn = (String)keyIt.next();
                            value = rowset.getBigDecimal(keySn);
                            value = value == null ? BigDecimal.ZERO : value;
                            accumulateItem = (String)curItemMap.get(keySn);
                            if (deDuctOnceMapPer.containsKey(keySn + "_times")) {
                                times = Integer.parseInt(deDuctOnceMapPer.get(keySn + "_times").toString());
                                if (periodYear == nYear && periodMonth == nMonth && nCalState < 20) continue;
                                if (times > 0) {
                                    tempValue = (BigDecimal)deDuctOnceMapPer.get(keySn + "_value");
                                    calValue = tempValue.compareTo(value) == -1 ? value : tempValue;
                                    deDuctOnceMapPer.put(keySn + "_value", calValue);
                                    calValue = ((BigDecimal)dataMap.get(accumulateItem)).subtract(tempValue).add(calValue);
                                } else {
                                    calValue = ((BigDecimal)dataMap.get(accumulateItem)).add(value);
                                    deDuctOnceMapPer.put(keySn + "_times", 1);
                                    deDuctOnceMapPer.put(keySn + "_value", value);
                                }
                            } else {
                                calValue = ((BigDecimal)dataMap.get(accumulateItem)).add(value);
                            }
                            dataMap.put((String)accumulateItem, (Object)calValue);
                        }
                        dataMap.put((String)FperiodYear, nYear);
                        dataMap.put((String)FperiodMonth, nMonth);
                        curUnitDataMap.put(personID, dataMap);
                        continue;
                    }
                    if (!taxUnitMap.containsKey(taxUnitId)) continue;
                    dataMap = (Map)otherUnitDataMap.get(personID);
                    if (dataMap == null) {
                        dataMap = this.getEmptyMap(allItemMap, nYear, nMonth);
                    }
                    if (null == (deDuctOnceMapPer = (Map)dataMap.get("deDuctOnceMapPer_" + personID + split + nYear + split + nMonth))) {
                        deDuctOnceMapPer = new HashMap();
                        deDuctOnceMapPer.putAll(deDuctOnceMap);
                        dataMap.put((String)("deDuctOnceMapPer_" + personID + split + nYear + split + nMonth), deDuctOnceMapPer);
                    }
                    keyIt = curItemMap.keySet().iterator();
                    calValue = BigDecimal.ZERO;
                    while (keyIt.hasNext()) {
                        keySn = (String)keyIt.next();
                        value = rowset.getBigDecimal(keySn);
                        value = value == null ? BigDecimal.ZERO : value;
                        accumulateItem = (String)curItemMap.get(keySn);
                        if (deDuctOnceMapPer.containsKey(keySn)) {
                            times = Integer.parseInt(deDuctOnceMapPer.get(keySn + "_times").toString());
                            if (periodYear == nYear && periodMonth == nMonth && nCalState < 20) continue;
                            if (times > 0) {
                                tempValue = (BigDecimal)deDuctOnceMapPer.get(keySn + "_value");
                                calValue = tempValue.compareTo(value) == -1 ? value : tempValue;
                                deDuctOnceMapPer.put(keySn + "_value", calValue);
                                calValue = ((BigDecimal)dataMap.get(accumulateItem)).subtract(tempValue).add(calValue);
                            } else {
                                calValue = ((BigDecimal)dataMap.get(accumulateItem)).add(value);
                                deDuctOnceMapPer.put(keySn + "_times", 1);
                                deDuctOnceMapPer.put(keySn + "_value", value);
                            }
                        } else {
                            calValue = ((BigDecimal)dataMap.get(accumulateItem)).add(value);
                        }
                        dataMap.put((String)accumulateItem, (Object)calValue);
                    }
                    otherUnitDataMap.put(personID, dataMap);
                }
                endTime = System.currentTimeMillis();
                System.out.println("------------\u7ec4\u88c5\u7ed3\u679c\u6570\u636e\u7684\u65f6\u95f4\uff1a" + (endTime - startTime));
                SQLUtils.cleanup((ResultSet)rowset, (Statement)statement, (Connection)conn);
            }
            catch (SQLException e) {
                SQLUtils.cleanup((Connection)conn);
                e.printStackTrace();
            }
            catch (Exception ex) {
                SQLUtils.cleanup((Connection)conn);
                ex.printStackTrace();
                break block43;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(rowset, (Statement)statement, (Connection)conn);
            }
        }
        resultMap.put("CurrentUnitData", curUnitDataMap);
        resultMap.put("OtherUnitData", otherUnitDataMap);
        return resultMap;
    }
}

