/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.BasicItemInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalSubmitSchemeFunctionService
extends SalaryCalFunction2 {
    private static final Logger logger = LoggerFactory.getLogger(CalSubmitSchemeFunctionService.class);
    private final SimpleDateFormat sdf_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    private static final String EARLIEST_EFFDT = "1900-01-01";
    private static final String MAX_ENDDATE = "2199-12-31";

    public String getCurMonthPeriodEndDate(Context ctx, String mainTableName, Map paramMap, HashMap tempMap, BasicItemInfo calScheme, String mainTableRowFilter, double nullDefaultVal) {
        HashMap result;
        String entryId = (String)paramMap.get(mainTableName.toUpperCase(Locale.ENGLISH) + "_FID");
        String tempMapKey = "CalSubmitSchemeFunctionService_getCurMonthPeriodEndDate";
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initPeriodRecord(ctx, mainTableName, mainTableRowFilter, null, new java.util.Date()));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((result = (HashMap)tempMap.get(tempMapKey)).containsKey(entryId)) {
            return (String)result.get(entryId);
        }
        return 0.0 == nullDefaultVal ? EARLIEST_EFFDT : MAX_ENDDATE;
    }

    public String getCurMonEndDateForSubElement(Context ctx, String mainTableName, Map paramMap, HashMap tempMap, BasicItemInfo calScheme, String mainTableRowFilter, String submitElement, double nullDefaultVal) {
        HashMap result;
        if (StringUtils.isEmpty((CharSequence)submitElement)) {
            return 0.0 == nullDefaultVal ? EARLIEST_EFFDT : MAX_ENDDATE;
        }
        String entryId = (String)paramMap.get(mainTableName.toUpperCase(Locale.ENGLISH) + "_FID");
        String tempMapKey = "CalSubmitSchemeFunctionService_getCurMonEndDateForSubElement_" + submitElement;
        if (tempMap.get(tempMapKey) == null) {
            try {
                tempMap.put(tempMapKey, this.initPeriodRecord(ctx, mainTableName, mainTableRowFilter, submitElement, new java.util.Date()));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                tempMap.put(tempMapKey, new HashMap());
            }
        }
        if ((result = (HashMap)tempMap.get(tempMapKey)).containsKey(entryId)) {
            return (String)result.get(entryId);
        }
        return 0.0 == nullDefaultVal ? EARLIEST_EFFDT : MAX_ENDDATE;
    }

    private Map<String, String> initPeriodRecord(Context ctx, String mainTableName, String mainTableRowFilter, String submitElement, java.util.Date effectDate) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder osql = new StringBuilder();
        osql.append("select entry.fid entryId, entry.fpersonId personId, subPeriod.fsubmitschemeid submitScheme,periodDetail.FendDate endDate from ").append(mainTableName).append(" entry ").append(" left join T_HR_SBatchSubmitShemeBill bill on bill.fid = entry.fbillId ").append(" left join T_HR_SCalSubmitPeriod subPeriod on subPeriod.fsubmitSchemeId=bill.fsubmitSchemeId ").append(" left join T_HR_SubmitPeriod period on period.fid=subPeriod.fsubmitperiodid ").append(" left join T_HR_SubmitPeriodDetail periodDetail on periodDetail.fbillId = period.fid ").append(" where subPeriod.fstate = ").append(1).append(" and periodDetail.fstate=").append(1);
        if (StringUtils.isNotEmpty((CharSequence)mainTableRowFilter)) {
            osql.append(" and entry.fid in (").append(mainTableRowFilter).append(") ");
        }
        if (StringUtils.isNotEmpty((CharSequence)submitElement)) {
            osql.append(" and subPeriod.fsubmitElementId in (select fid from T_HR_SSubmitElement where fnumber ='").append(submitElement).append("') ");
            osql.append(" and entry.fsubmitElementId in (select fid from T_HR_SSubmitElement where fnumber ='").append(submitElement).append("') ");
        }
        osql.append(" and periodDetail.FstartDate <= {ts '").append(this.sdf_yyyy_MM_dd.format(effectDate)).append("'} and periodDetail.FendDate >= {ts '").append(this.sdf_yyyy_MM_dd.format(effectDate)).append("'}").append(" order by periodDetail.FendDate desc ");
        IRowSet peroidRowSet = DbUtil.executeQuery((Context)ctx, (String)osql.toString());
        while (peroidRowSet.next()) {
            result.put(peroidRowSet.getString("entryId"), this.sdf_yyyy_MM_dd.format(peroidRowSet.getDate("endDate")));
        }
        return result;
    }

    public double getAtsDataWithSubOrg(Context ctx, Map<String, Object> paramMap, HashMap<String, Object> tempMap, String mainTableName, String mainTableRowFilter, String project, double isVac, String company, double needSubOrg, double relativePeriod) {
        boolean haveSubOrg = 1.0 == needSubOrg;
        boolean vacProject = 1.0 == isVac;
        String key = "AtsResult:" + project + "-" + company + "-" + needSubOrg + "-" + isVac + "-" + relativePeriod;
        HashMap mapData = null;
        ArrayList listData = null;
        if (tempMap.get(key) == null) {
            Map<String, Map<String, String>> dataMap = this.getSubDataGroupByEffectDate(ctx, mainTableName, mainTableRowFilter, relativePeriod);
            if (dataMap.isEmpty() || dataMap.get("sqlMap").isEmpty()) {
                return 0.0;
            }
            Map<String, String> sqlMap = dataMap.get("sqlMap");
            Map<String, String> dateMap = dataMap.get("effectDateMap");
            Iterator<String> iterator = sqlMap.keySet().iterator();
            HashMap<String, Object> param = new HashMap<String, Object>();
            while (iterator.hasNext()) {
                String dateKey = iterator.next();
                String rangeSql = sqlMap.get(dateKey);
                String[] yearAndMonth = dateKey.split("~");
                param.put("year", yearAndMonth[0]);
                param.put("month", yearAndMonth[1]);
                String l = ctx.getLocale().getLanguage();
                String companyLongNumber = " select fLongNumber from T_ORG_ADMIN where fid in   (select FADMINORGID  from T_ORG_ADMINORGtreehis where fDisplayName_" + l + " = '" + company + "') ";
                param.put("companyLongNumber", Base64Utils.encodeWithSalt(companyLongNumber));
                param.put("personIds", Base64Utils.encodeWithSalt(rangeSql));
                param.put("haveSubOrg", haveSubOrg);
                param.put("attendProject", project);
                List tempListData = !vacProject ? (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getAttendSumByHrOrg") : (List)OSFExecutor.executeOSF((Context)ctx, param, (String)"getHolidayProjectSummary");
                if (tempListData == null) continue;
                if (mapData == null) {
                    mapData = new HashMap();
                }
                if ((listData = (ArrayList)mapData.get(dateKey)) == null) {
                    listData = new ArrayList();
                    mapData.put(dateKey, listData);
                }
                listData.addAll(tempListData);
            }
            tempMap.put(key, mapData);
            tempMap.put(key + "-effectDate", dateMap);
        }
        String personId = (String)paramMap.get(mainTableName.toUpperCase() + "_FPERSONID");
        String id = (String)paramMap.get(mainTableName.toUpperCase() + "_FID");
        Map effectDateMap = (Map)tempMap.get(key + "-effectDate");
        String dateKey = (String)effectDateMap.get(id);
        Map resultData = (Map)tempMap.get(key);
        String evalPersonId = "";
        HashMap atsResultMap = null;
        if (null != resultData && null != resultData.get(dateKey) && !((List)resultData.get(dateKey)).isEmpty()) {
            List atsResultData = (List)resultData.get(dateKey);
            for (HashMap map : atsResultData) {
                evalPersonId = map.containsKey("personId") ? map.get("personId").toString() : "";
                if (!evalPersonId.equals(personId)) continue;
                atsResultMap = map;
                break;
            }
        }
        if (null != atsResultMap) {
            double res = 0.0;
            if (null != atsResultMap.get(project) && !"".equals(atsResultMap.get(project))) {
                res = Double.parseDouble(atsResultMap.get(project).toString());
            }
            return res;
        }
        return 0.0;
    }

    public Map<String, Map<String, String>> getSubDataGroupByEffectDate(Context ctx, String mainTableName, String mainTableRowFilter, double relativePeriod) {
        String sql = "select FID, FEffectDate, FPersonID from " + mainTableName + " where FID in (" + mainTableRowFilter + ")";
        HashMap<String, ArrayList<String>> effectDateMap = new HashMap<String, ArrayList<String>>();
        HashMap sqlMap = new HashMap();
        HashMap<String, String> dateMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> dataMap = new HashMap<String, Map<String, String>>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (null != executeQuery) {
                while (executeQuery.next()) {
                    Date effectDate = executeQuery.getDate("FEffectDate");
                    String personId = executeQuery.getString("FPersonID");
                    String id = executeQuery.getString("FID");
                    if (effectDate == null) continue;
                    Calendar c = Calendar.getInstance();
                    c.setTime(effectDate);
                    c.add(2, (int)relativePeriod);
                    int year = c.get(1);
                    int month = c.get(2) + 1;
                    dateMap.put(id, year + "~" + month);
                    ArrayList<String> list = (ArrayList<String>)effectDateMap.get(year + "~" + month);
                    if (list == null) {
                        list = new ArrayList<String>();
                        effectDateMap.put(year + "~" + month, list);
                    }
                    list.add(personId);
                }
            }
            if (effectDateMap.isEmpty()) {
                return dataMap;
            }
            CmpInSql instance = CmpInSqlFactory.getInstance();
            for (Map.Entry entry : effectDateMap.entrySet()) {
                List personList = (List)entry.getValue();
                sqlMap.put(entry.getKey(), instance.createInSqlBaseOnFId(ctx, personList).replace("(", "").replace(")", ""));
            }
            dataMap.put("sqlMap", sqlMap);
            dataMap.put("effectDateMap", dateMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }
}

