/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CreateTableWithPartitionService {
    private static final Logger LOG = Logger.getLogger(CreateTableWithPartitionService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createExpenseDetailsSubmitBill(Context ctx) {
        String selectSQL = "select 1 from KSQL_UserTables where KSQL_TabName = 'T_HR_SExpenseDetailsSubmitBill' ";
        Connection conn = null;
        Statement statement = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.size() > 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            DatabaseMetaData metaData = conn.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            String createSQL = "Create Table T_HR_SExpenseDetailsSubmitBill (FBaseId VARCHAR(44),FSubmitBillId VARCHAR(44),FSubmitBillEntryId VARCHAR(44),FSubmitCurrencyId VARCHAR(44),FBudgetYear INT,FID VARCHAR(44) DEFAULT '' NOT NULL ,CONSTRAINT PK_ExpenseDetailsS PRIMARY KEY (FID))";
            String tableName = "T_HR_SExpenseDetailsSubmitBill";
            boolean oracleFlag = true;
            if ("oracle".equalsIgnoreCase(dbName)) {
                try {
                    StringBuilder oracleSql = new StringBuilder(createSQL);
                    CreateTableWithPartitionService.appendOraclePartition(oracleSql, tableName);
                    statement.execute(oracleSql.toString());
                    oracleFlag = false;
                }
                catch (Exception e) {
                    LOG.error((Object)"create oracle table T_HR_SExpenseDetailsSubmitBill error: ", (Throwable)e);
                }
            } else if ("postgresql".equalsIgnoreCase(dbName)) {
                createSQL = createSQL.replace("PRIMARY KEY (FID)", "PRIMARY KEY (FID, FBudgetYear)");
                createSQL = "/*dialect*/ " + createSQL;
                createSQL = CreateTableWithPartitionService.appendPGPartition(createSQL, tableName);
            } else if ("dm".equalsIgnoreCase(dbName)) {
                createSQL = CreateTableWithPartitionService.appendDMPartition(createSQL, tableName);
            }
            if (oracleFlag) {
                statement.execute(createSQL);
            }
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDSMT_SMT on T_HR_SExpenseDetailsSubmitBill(FSubmitBillId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDSMT_BS on T_HR_SExpenseDetailsSubmitBill(FBaseId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDSMT_CRC on T_HR_SExpenseDetailsSubmitBill(FSubmitCurrencyId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDSMT_SMTE on T_HR_SExpenseDetailsSubmitBill(FSubmitBillEntryId)");
            CreateTableWithPartitionService.createExpenseDetailsSubmitBase(ctx);
        }
        catch (BOSException | SQLException e) {
            LOG.error((Object)"createTable error: ", e);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createExpenseDetailsCmp(Context ctx) {
        String selectSQL = "select 1 from KSQL_UserTables where KSQL_TabName = 'T_HR_SExpenseDetailsCmp' ";
        Connection conn = null;
        Statement statement = null;
        try {
            CreateTableWithPartitionService.createExpenseDetailsSubmitBase(ctx);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.size() > 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            DatabaseMetaData metaData = conn.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            String createSQL = "Create Table T_HR_SExpenseDetailsCmp ( FBaseID VARCHAR(44),FCmpCalTableID VARCHAR(44),FCalCurrencyID VARCHAR(44),FBudgetYear INT,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FID VARCHAR(44) DEFAULT '' NOT NULL ,CONSTRAINT PK_ExpenseDetailsC PRIMARY KEY (FID))";
            String tableName = "T_HR_SExpenseDetailsCmp";
            boolean oracleFlag = true;
            if ("oracle".equalsIgnoreCase(dbName)) {
                try {
                    StringBuilder oracleSql = new StringBuilder(createSQL);
                    CreateTableWithPartitionService.appendOraclePartition(oracleSql, tableName);
                    statement.execute(oracleSql.toString());
                    oracleFlag = false;
                }
                catch (Exception exception) {}
            } else if ("postgresql".equalsIgnoreCase(dbName)) {
                createSQL = createSQL.replace("PRIMARY KEY (FID)", "PRIMARY KEY (FID, FBudgetYear)").replace(" DateTime,", " timestamp,");
                createSQL = "/*dialect*/ " + createSQL;
                createSQL = CreateTableWithPartitionService.appendPGPartition(createSQL, tableName);
            } else if ("dm".equalsIgnoreCase(dbName)) {
                createSQL = CreateTableWithPartitionService.appendDMPartition(createSQL, tableName);
            }
            if (oracleFlag) {
                statement.execute(createSQL);
            }
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_BUDTEXP_Cal on T_HR_SExpenseDetailsCmp(FCmpCalTableID)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_BUDTEXP_BS on T_HR_SExpenseDetailsCmp(FBaseId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_BUDTEXP_Cur on T_HR_SExpenseDetailsCmp(FCalCurrencyID)");
        }
        catch (BOSException | SQLException e) {
            LOG.error((Object)"createTable error: ", e);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createExpenseDetailsSubmitBase(Context ctx) {
        String selectSQL = "select 1 from KSQL_UserTables where KSQL_TabName = 'T_HR_SExpenseDetailsBase' ";
        Connection conn = null;
        Statement statement = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.size() > 0) {
                return;
            }
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            DatabaseMetaData metaData = conn.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            String createSQL = "Create Table T_HR_SExpenseDetailsBase (FCmpEmpORelationId VARCHAR(44),FAdjustEmpRelationId VARCHAR(44),FBudgetTemplateId VARCHAR(44),FBudgetSchemeId VARCHAR(44),FBudgetManageId VARCHAR(44),FSubBudgetQueryId VARCHAR(44),FCostTypeId VARCHAR(44),FCostBearOrgId VARCHAR(44),FBudgetYear INT DEFAULT 0 NOT NULL ,FRate NUMERIC(28,10),FCurrencyId VARCHAR(44),FStandingBookId VARCHAR(44),FPersonID VARCHAR(44),FSubStandingBookId VARCHAR(44),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FID VARCHAR(44) DEFAULT '' NOT NULL ,CONSTRAINT PK_Cmp_ExpDetailsB PRIMARY KEY (FID))";
            String tableName = "T_HR_SExpenseDetailsBase";
            boolean oracleFlag = true;
            if ("oracle".equalsIgnoreCase(dbName)) {
                try {
                    StringBuilder oracleSql = new StringBuilder(createSQL);
                    CreateTableWithPartitionService.appendOraclePartition(oracleSql, tableName);
                    statement.execute(oracleSql.toString());
                    oracleFlag = false;
                }
                catch (Exception exception) {}
            } else if ("postgresql".equalsIgnoreCase(dbName)) {
                createSQL = createSQL.replace("PRIMARY KEY (FID)", "PRIMARY KEY (FID, FBudgetYear)").replace(" DateTime,", " timestamp,");
                createSQL = "/*dialect*/ " + createSQL;
                createSQL = CreateTableWithPartitionService.appendPGPartition(createSQL, tableName);
            } else if ("dm".equalsIgnoreCase(dbName)) {
                createSQL = CreateTableWithPartitionService.appendDMPartition(createSQL, tableName);
            }
            if (oracleFlag) {
                statement.execute(createSQL);
            }
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_AER on T_HR_SExpenseDetailsBase(FAdjustEmpRelationId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_CEOR on T_HR_SExpenseDetailsBase(FCmpEmpORelationId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_TEMP on T_HR_SExpenseDetailsBase(FBudgetTemplateId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_BDSCHEME on T_HR_SExpenseDetailsBase(FBudgetSchemeId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_BM on T_HR_SExpenseDetailsBase(FBudgetManageId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_SBQ on T_HR_SExpenseDetailsBase(FSubBudgetQueryId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_CBO on T_HR_SExpenseDetailsBase(FCostBearOrgId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_STDB on T_HR_SExpenseDetailsBase(FStandingBookId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_SUSTDB on T_HR_SExpenseDetailsBase(FSubStandingBookId)");
            DbUtil.execute((Context)ctx, (String)"create index IX_HR_EXPDBASE_PER on T_HR_SExpenseDetailsBase(FPersonID)");
            CreateTableWithPartitionService.addBudgetTempLateSystemBookItem(ctx);
        }
        catch (BOSException | SQLException e) {
            LOG.error((Object)"createTable error: ", e);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"createTable error: ", (Throwable)e);
                }
            }
        }
    }

    private static void addBudgetTempLateSystemBookItem(Context ctx) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='S5' and KSQL_COL_TABNAME='T_HR_SExpenseDetailsBase') ALTER TABLE T_HR_SExpenseDetailsBase ADD S5 NUMERIC(28,10)");
    }

    private static String appendDMPartition(String createSQL, String tableName) {
        return createSQL + " partition by RANGE(FBudgetYear) (partition " + tableName + "2023 values EQU OR LESS THAN ('2023'),partition " + tableName + "2024 values EQU OR LESS THAN ('2024'),partition " + tableName + "2025 values EQU OR LESS THAN ('2025'),partition " + tableName + "2026 values EQU OR LESS THAN ('2026'),partition " + tableName + "2027 values EQU OR LESS THAN ('2027'),partition " + tableName + "2028 values EQU OR LESS THAN ('2028'),partition " + tableName + "2029 values EQU OR LESS THAN ('2029'),partition " + tableName + "2030 values EQU OR LESS THAN ('2030'),partition " + tableName + "2031 values EQU OR LESS THAN ('2031'),partition " + tableName + "2032 values EQU OR LESS THAN ('2032'),partition " + tableName + "2033 values EQU OR LESS THAN ('2033'))";
    }

    private static String appendPGPartition(String createSQL, String tableName) {
        return createSQL + " partition by range(FBudgetYear);CREATE TABLE " + tableName + "2023 PARTITION OF " + tableName + " for values from (2023) to (2024);CREATE TABLE " + tableName + "2024 PARTITION OF " + tableName + " for values from (2024) to (2025);CREATE TABLE " + tableName + "2025 PARTITION OF " + tableName + " for values from (2025) to (2026);CREATE TABLE " + tableName + "2026 PARTITION OF " + tableName + " for values from (2026) to (2027);CREATE TABLE " + tableName + "2027 PARTITION OF " + tableName + " for values from (2027) to (2028);CREATE TABLE " + tableName + "2028 PARTITION OF " + tableName + " for values from (2028) to (2029);CREATE TABLE " + tableName + "2029 PARTITION OF " + tableName + " for values from (2029) to (2030);CREATE TABLE " + tableName + "2030 PARTITION OF " + tableName + " for values from (2030) to (2031);CREATE TABLE " + tableName + "2031 PARTITION OF " + tableName + " for values from (2031) to (2032);CREATE TABLE " + tableName + "2032 PARTITION OF " + tableName + " for values from (2032) to (2033);CREATE TABLE " + tableName + "2033 PARTITION OF " + tableName + " for values from (2033) to (2034);";
    }

    private static void appendOraclePartition(StringBuilder createSQL, String tableName) {
        createSQL.append(" partition by list(FBudgetYear) (");
        createSQL.append("partition ").append(tableName).append("2023 values (2023),");
        createSQL.append("partition ").append(tableName).append("2024 values (2024),");
        createSQL.append("partition ").append(tableName).append("2025 values (2025),");
        createSQL.append("partition ").append(tableName).append("2026 values (2026),");
        createSQL.append("partition ").append(tableName).append("2027 values (2027),");
        createSQL.append("partition ").append(tableName).append("2028 values (2028),");
        createSQL.append("partition ").append(tableName).append("2029 values (2029),");
        createSQL.append("partition ").append(tableName).append("2030 values (2030),");
        createSQL.append("partition ").append(tableName).append("2031 values (2031),");
        createSQL.append("partition ").append(tableName).append("2032 values (2032),");
        createSQL.append("partition ").append(tableName).append("2033 values (2033)");
        createSQL.append(")");
    }
}

