/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.timepiece;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.service.timepiece.ItemInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalFunGetDimensionDataService
extends SalaryCalFunction2 {
    private static final Logger logger = Logger.getLogger(CalFunGetDimensionDataService.class);

    public double getDimensionSubmitItemData(Context ctx, String schemeId, String mainTableName, String mainTableRowFilter, Map<String, Object> paramMap, HashMap<String, Object> tempMap, String specifyDimension, double specifyType, String cmpItem, double dataType) {
        Map<String, BigDecimal> result;
        Map cmpItemmap;
        String entryId = (String)paramMap.get(mainTableName.toUpperCase(Locale.ENGLISH) + "_FID");
        if (!StringUtils.isEmpty((String)specifyDimension) && (specifyDimension.contains("[") || specifyDimension.contains("]"))) {
            specifyDimension = specifyDimension.replace("[", "").replace("]", "");
        }
        String dataKey = "specifyDimension_" + schemeId + "_" + specifyDimension + "_" + specifyType + "_" + cmpItem + "_" + dataType;
        String itemkey = "CalFunGetDimensionDataService_ITEM" + schemeId;
        if (tempMap.get(itemkey) == null) {
            tempMap.put(itemkey, this.getSumbitSchemeItemName(ctx, schemeId));
        }
        if ((cmpItemmap = (Map)tempMap.get(itemkey)) == null || !cmpItemmap.containsKey(cmpItem)) {
            return 0.0;
        }
        ItemInfo info = (ItemInfo)cmpItemmap.get(cmpItem);
        if (!"0".equals(info.getDataType())) {
            return 0.0;
        }
        String cmpItemSn = "S" + info.getFieldSn();
        if (StringUtils.isEmpty((String)specifyDimension) && !tempMap.containsKey(dataKey)) {
            result = this.getAndCalDataByItemDimensionSn(ctx, mainTableRowFilter, cmpItemSn, null, String.valueOf((int)dataType));
            tempMap.put(dataKey, result);
        }
        if (specifyType < 1.0) {
            if (!cmpItemmap.containsKey(specifyDimension)) {
                return 0.0;
            }
            String specifyDimensionSn = "S" + ((ItemInfo)cmpItemmap.get(specifyDimension)).getFieldSn();
            if (!tempMap.containsKey(dataKey)) {
                Map<String, BigDecimal> result2 = this.getAndCalDataByItemDimensionSn(ctx, mainTableRowFilter, cmpItemSn, specifyDimensionSn, String.valueOf((int)dataType));
                tempMap.put(dataKey, result2);
            }
        } else if (!tempMap.containsKey(dataKey)) {
            String specifyDimensionClientNumAndColNum = this.getClientNumberAndColNumber(ctx, specifyDimension, "012");
            if (StringUtils.isEmpty((String)specifyDimensionClientNumAndColNum)) {
                tempMap.put(dataKey, new HashMap());
                return 0.0;
            }
            Map<String, BigDecimal> result3 = this.getAndCalDataByIfonDimensionSn(ctx, mainTableRowFilter, cmpItemSn, specifyDimensionClientNumAndColNum, String.valueOf((int)dataType));
            tempMap.put(dataKey, result3);
        }
        result = (Map<String, BigDecimal>)tempMap.get(dataKey);
        if (!result.containsKey(entryId) || result.get(entryId) == null) {
            return 0.0;
        }
        return result.get(entryId).doubleValue();
    }

    protected Map<String, BigDecimal> getAndCalDataByIfonDimensionSn(Context ctx, String mainTableRowFilter, String cmpItemSn, String specifyDimensionClientNumAndColNum, String dataType) {
        HashMap<String, String> entryIdAnddimensionSn = new HashMap<String, String>();
        HashMap<String, BigDecimal> dimensionSnValue = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> dimensionCount = new HashMap<String, Integer>();
        Map<String, List> map = this.getBillIdsWhereSqlAndCalEntryIds(ctx, mainTableRowFilter);
        String billIdsWhereSql = "";
        List idList = new ArrayList();
        for (Map.Entry<String, List> entry : map.entrySet()) {
            billIdsWhereSql = entry.getKey();
            idList = entry.getValue();
        }
        String sql = this.buildDataSetSql(ctx, mainTableRowFilter, specifyDimensionClientNumAndColNum, cmpItemSn, billIdsWhereSql);
        sql = sql.replace("T_HR_SCHEMEBILLENTRY", "T_HR_TimepieceBillEntry");
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                BigDecimal bigDecimal;
                String entryId = executeQuery.getString("fid");
                String dimension = executeQuery.getString("FBillID");
                Object dimensionSn = executeQuery.getObject("clientNumAndColNum");
                if (entryIdAnddimensionSn.containsKey(entryId)) {
                    System.out.println("getAndCalDataByIfonDimensionSn--sql\uff1a " + sql);
                    System.out.println("getAndCalDataByIfonDimensionSn--entryId\uff1a " + entryId + "," + (String)entryIdAnddimensionSn.get(entryId) + "," + dimensionSn);
                    continue;
                }
                String dimensionSnStr = dimensionSn == null ? "" : dimensionSn.toString();
                dimension = dimension + dimensionSnStr;
                if (idList.contains(entryId)) {
                    entryIdAnddimensionSn.put(entryId, dimension);
                }
                Integer count = dimensionCount.getOrDefault(dimension, 0);
                dimensionCount.put(dimension, count + 1);
                BigDecimal value = executeQuery.getBigDecimal(cmpItemSn);
                value = value == null ? new BigDecimal("0.0") : value;
                BigDecimal dimensionResult = dimensionSnValue.getOrDefault(dimension, new BigDecimal("0.00"));
                if ("2".equals(dataType)) {
                    dimensionResult = dimensionSnValue.getOrDefault(dimension, value);
                    bigDecimal = dimensionResult.compareTo(value) < 0 ? dimensionResult : value;
                    dimensionSnValue.put(dimension, bigDecimal);
                    continue;
                }
                if ("3".equals(dataType)) {
                    bigDecimal = dimensionResult.compareTo(value) > 0 ? dimensionResult : value;
                    dimensionSnValue.put(dimension, bigDecimal);
                    continue;
                }
                BigDecimal add = value.add(dimensionResult);
                dimensionSnValue.put(dimension, add);
            }
            if ("1".equals(dataType)) {
                this.calAverage(dimensionSnValue, dimensionCount);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return this.calResult(dimensionSnValue, entryIdAnddimensionSn);
    }

    protected String buildDataSetSql(Context ctx, String mainTableRowFilter, String specifyDimensionClientNumAndColNum, String cmpItemSn, String billIdsWhereSql) {
        String sql = "";
        try {
            FilterInfo filter = new FilterInfo("CMP_SMT001.id in " + billIdsWhereSql);
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("CMP_SMT002.id", "fid");
            selectMapping.put("CMP_SMT001.id", "FBillID");
            selectMapping.put("CMP_SMT002." + cmpItemSn, cmpItemSn);
            selectMapping.put(specifyDimensionClientNumAndColNum, "clientNumAndColNum");
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(filter);
            sqlParam.setScheme("012");
            sqlParam.setHistoryMode(true);
            sqlParam.setNeedDistinct(true);
            sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        }
        catch (BOSException | ParserException | EASBizException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return sql;
    }

    protected Map<String, BigDecimal> getAndCalDataByItemDimensionSn(Context ctx, String mainTableRowFilter, String cmpItemSn, String specifyDimensionSn, String dataType) {
        Map<String, List> map = this.getBillIdsWhereSqlAndCalEntryIds(ctx, mainTableRowFilter);
        String billIdsWhereSql = "";
        List idList = new ArrayList();
        for (Map.Entry<String, List> entry : map.entrySet()) {
            billIdsWhereSql = entry.getKey();
            idList = entry.getValue();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fid , FBillID, ");
        sb.append(cmpItemSn);
        if (specifyDimensionSn != null) {
            sb.append(",").append(specifyDimensionSn);
        }
        sb.append(" from T_HR_TimepieceBillEntry where FBillID in ");
        sb.append(billIdsWhereSql);
        HashMap<String, String> entryIdAnddimensionSn = new HashMap<String, String>();
        HashMap<String, BigDecimal> dimensionSnValue = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> dimensionCount = new HashMap<String, Integer>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (executeQuery.next()) {
                BigDecimal bigDecimal;
                String entryId = executeQuery.getString("fid");
                String dimension = executeQuery.getString("FBillID");
                if (specifyDimensionSn != null) {
                    Object dimensionSn = executeQuery.getObject(specifyDimensionSn);
                    String dimensionSnStr = dimensionSn == null ? "" : dimensionSn.toString();
                    dimension = dimension + dimensionSnStr;
                }
                if (idList.contains(entryId)) {
                    entryIdAnddimensionSn.put(entryId, dimension);
                }
                Integer count = dimensionCount.getOrDefault(dimension, 0);
                dimensionCount.put(dimension, count + 1);
                BigDecimal value = executeQuery.getBigDecimal(cmpItemSn);
                value = value == null ? new BigDecimal("0.0") : value;
                BigDecimal dimensionResult = dimensionSnValue.getOrDefault(dimension, new BigDecimal("0.0"));
                if ("2".equals(dataType)) {
                    dimensionResult = dimensionSnValue.getOrDefault(dimension, value);
                    bigDecimal = dimensionResult.compareTo(value) < 0 ? dimensionResult : value;
                    dimensionSnValue.put(dimension, bigDecimal);
                    continue;
                }
                if ("3".equals(dataType)) {
                    bigDecimal = dimensionResult.compareTo(value) > 0 ? dimensionResult : value;
                    dimensionSnValue.put(dimension, bigDecimal);
                    continue;
                }
                BigDecimal add = value.add(dimensionResult);
                dimensionSnValue.put(dimension, add);
            }
            if ("1".equals(dataType)) {
                this.calAverage(dimensionSnValue, dimensionCount);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return this.calResult(dimensionSnValue, entryIdAnddimensionSn);
    }

    private Map<String, BigDecimal> calResult(Map<String, BigDecimal> dimensionSnValue, Map<String, String> entryIdAnddimensionSn) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, String> entry : entryIdAnddimensionSn.entrySet()) {
            String entryId = entry.getKey();
            String dimension = entry.getValue();
            result.put(entryId, dimensionSnValue.get(dimension));
        }
        return result;
    }

    private void calAverage(Map<String, BigDecimal> dimensionSnValue, Map<String, Integer> dimensionCount) {
        for (Map.Entry<String, BigDecimal> entry : dimensionSnValue.entrySet()) {
            String dimension = entry.getKey();
            BigDecimal value = entry.getValue();
            Integer count = dimensionCount.get(dimension);
            BigDecimal divide = value.divide(new BigDecimal(count), 10, RoundingMode.HALF_UP);
            entry.setValue(divide);
        }
    }

    protected String getClientNumberAndColNumber(Context ctx, String specifyDimension, String structSchemeNumber) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT sconfig.FClientNumber clientNumber , columns.FNumber colNumber ");
        builder.append(" FROM T_HR_QueryConfigField field ");
        builder.append(" left join T_HR_StructureConfigColumns columns on field.FFactFieldID = columns.Fid ");
        builder.append(" left join T_HR_StructureConfig sconfig on sconfig.Fid = columns.FStructureConfigID ");
        builder.append(" left join T_HR_StructureConfigScheme cscheme on cscheme.Fid = sconfig.FSchemeID ");
        builder.append(" where field.FAlias_").append(ctx.getLocale().getLanguage()).append(" = ? and cscheme.FNumber = ? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{specifyDimension, structSchemeNumber});
            if (rowSet.next()) {
                String clientNumber = rowSet.getString("clientNumber");
                String colNumber = rowSet.getString("colNumber");
                return clientNumber + "." + colNumber;
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return "";
    }

    protected Map<String, List> getBillIdsWhereSqlAndCalEntryIds(Context ctx, String mainTableRowFilter) {
        String sql = "select   FBillID ,fid from T_HR_TimepieceBillEntry where fid in ( " + mainTableRowFilter + " )";
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> idList = new ArrayList<String>();
        HashMap<String, List> map = new HashMap<String, List>();
        String billIdsWhereSql = "";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String billID = executeQuery.getString("FBillID");
                set.add(billID);
                idList.add(executeQuery.getString("fid"));
            }
            CmpInSql inSql = CmpInSqlFactory.getInstance();
            billIdsWhereSql = inSql.createInSql(ctx, set.toArray(), "'", "T_HR_SBatchSubmitShemeBill", "fid");
            map.put(billIdsWhereSql, idList);
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return map;
    }

    public Map<String, ItemInfo> getSumbitSchemeItemName(Context ctx, String schemeId) {
        String l = ctx.getLocale().getLanguage();
        String sql = "Select \u3000m.FDataType , m.fieldSn,m.fdataType,m.fname_" + l + " MNAME\u3000 from  T_HR_SCalSubmitScheme e  inner join  T_HR_SCalSubmitSchemeItem t on t.FCalSubmitSchemeID = e.fid  inner join T_HR_SCalSubmitItem m on  m.fid = t.FCalSubmitItemID  where  e.fid = ? ";
        HashMap<String, ItemInfo> resultMap = new HashMap<String, ItemInfo>();
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
            while (executeQuery.next()) {
                String resultKey = executeQuery.getString("MNAME");
                ItemInfo info = new ItemInfo();
                info.setFieldSn(executeQuery.getString("FIELDSN"));
                info.setDataType(executeQuery.getString("FDataType"));
                resultMap.put(resultKey, info);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return resultMap;
    }
}

