/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.sql.wizard;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalState;
import com.kingdee.shr.compensation.CalTableDesTypeEnum;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.filter.CmpPermFilter;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class CmpSchemePersonSQL {
    public static String getDeleteCalSqlIds(Map<String, Object> param, String calSchemeId, int periodYear, int periodMonth, int calTime) {
        String permItemId = (String)param.get("permItemId");
        Context ctx = (Context)param.get("context");
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        String otherFilter = CmpSchemePersonSQL.getCtbFilterStr(calSchemeId, periodYear, periodMonth, calTime);
        String permSql = CmpPermFilter.getPermSQLByHRO(ctx, "002", calSchemeInfo.getHrOrgUnit().getId().toString(), otherFilter, true);
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select fid from T_HR_SCmpCalTable ");
        sqlStr.append("where FCalSchemeID = '" + calSchemeId + "' ");
        sqlStr.append("and FPeriodYear = " + periodYear + " ");
        sqlStr.append("and FPeriodMonth = " + periodMonth + " ");
        sqlStr.append("and FCalTime = " + calTime + " ");
        sqlStr.append("and FHROrgUnitID in (" + hrRange + ") ");
        sqlStr.append("and ((FAdminOrgUnitID in (" + adminRange + ") ");
        sqlStr.append("or FCmpCalOrgID in (" + adminRange + ")) ");
        sqlStr.append("or FUSEDEFAULT=0 ) ");
        sqlStr.append("and FIsLockOtherSysData = 0 ");
        if (!CmpStrUtil.isEmpty(permSql)) {
            sqlStr.append("and FPersonID in (" + permSql + ")");
        }
        return sqlStr.toString();
    }

    public static String[] getDeleteCalSchemeSqls(Map<String, Object> param, String calSchemeId, int periodYear, int periodMonth, int calTime) {
        String[] sqls = new String[3];
        String permItemId = (String)param.get("permItemId");
        Context ctx = (Context)param.get("context");
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        String otherFilter = CmpSchemePersonSQL.getCtbFilterStr(calSchemeId, periodYear, periodMonth, calTime);
        String permSql = CmpPermFilter.getPermSQLByHRO(ctx, "002", calSchemeInfo.getHrOrgUnit().getId().toString(), otherFilter, true);
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("update T_HR_SCmpStopCal stopCal set FGrantSchemeID = null, FGrantPeriodYear = null, FGrantPeriodMonth = null, ");
        sqlStr.append("FGrantCalTime = null, FGrantState = 0, FIsRefer = 0, FcalTableId = null ");
        sqlStr.append("where exists (");
        sqlStr.append("select fid from T_HR_SCmpCalTable calTable ");
        sqlStr.append("where stopCal.FGrantSchemeID = calTable.FCALSCHEMEID and stopCal.FGrantPeriodYear = calTable.FPERIODYEAR ");
        sqlStr.append("and stopCal.FGrantPeriodMonth = calTable.FPERIODMONTH and stopCal.FGrantCalTime = calTable.FCALTIME and stopCal.FPERSONID = calTable.FPERSONID ");
        sqlStr.append(" and calTable.FCalSchemeID = '" + calSchemeId + "' ");
        sqlStr.append(" and calTable.FPeriodYear = " + periodYear + " ");
        sqlStr.append(" and calTable.FPeriodMonth = " + periodMonth + " ");
        sqlStr.append(" and calTable.FCalTime = " + calTime + " ");
        sqlStr.append(" and calTable.FHROrgUnitID in (" + hrRange + ") ");
        sqlStr.append(" and ((calTable.FAdminOrgUnitID in (" + adminRange + ") ");
        sqlStr.append(" or calTable.FCmpCalOrgID in (" + adminRange + ")) ");
        sqlStr.append(" or calTable.FUSEDEFAULT=0 ) ");
        if (!CmpStrUtil.isEmpty(permSql)) {
            sqlStr.append("and calTable.FPersonID in (" + permSql + ") ");
        }
        sqlStr.append(" and (calTable.FIsLockOtherSysData is null or calTable.FIsLockOtherSysData = 0) and stopCal.FGrantState = 1");
        sqlStr.append(")");
        sqls[0] = sqlStr.toString();
        sqlStr.setLength(0);
        sqlStr.append("DELETE FROM T_HR_SSUBMITRELYCALTABLE WHERE FCalTableID in (");
        sqlStr.append("select fid from T_HR_SCmpCalTable ");
        sqlStr.append("where FCalSchemeID = '" + calSchemeId + "' ");
        sqlStr.append("and FPeriodYear = " + periodYear + " ");
        sqlStr.append("and FPeriodMonth = " + periodMonth + " ");
        sqlStr.append("and FCalTime = " + calTime + " ");
        sqlStr.append("and FHROrgUnitID in (" + hrRange + ") ");
        sqlStr.append("and ((FAdminOrgUnitID in (" + adminRange + ") ");
        sqlStr.append("or FCmpCalOrgID in (" + adminRange + ")) ");
        sqlStr.append("or FUSEDEFAULT=0 ) ");
        sqlStr.append("and FIsLockOtherSysData = 0 ");
        if (!CmpStrUtil.isEmpty(permSql)) {
            sqlStr.append("and FPersonID in (" + permSql + ")");
        }
        sqlStr.append(")");
        sqls[1] = sqlStr.toString();
        sqlStr.setLength(0);
        sqlStr.append("delete from T_HR_SCmpCalTable ");
        sqlStr.append("where FCalSchemeID = '" + calSchemeId + "' ");
        sqlStr.append("and FPeriodYear = " + periodYear + " ");
        sqlStr.append("and FPeriodMonth = " + periodMonth + " ");
        sqlStr.append("and FCalTime = " + calTime + " ");
        sqlStr.append("and FHROrgUnitID in (" + hrRange + ") ");
        sqlStr.append("and ((FAdminOrgUnitID in (" + adminRange + ") ");
        sqlStr.append("or FCmpCalOrgID in (" + adminRange + ")) ");
        sqlStr.append("or FUSEDEFAULT=0 ) ");
        sqlStr.append("and FIsLockOtherSysData = 0 ");
        if (!CmpStrUtil.isEmpty(permSql)) {
            sqlStr.append("and FPersonID in (" + permSql + ") ");
        }
        sqls[2] = sqlStr.toString();
        return sqls;
    }

    public static String getDeleteCalSchemeSql(Map<String, Object> param, String calSchemeId, int periodYear, int periodMonth, int calTime) {
        String permItemId = (String)param.get("permItemId");
        Context ctx = (Context)param.get("context");
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        StringBuilder deleteSb = new StringBuilder();
        deleteSb.append("delete from T_HR_SCmpCalTable ");
        deleteSb.append("where FCalSchemeID = '" + calSchemeId + "' ");
        deleteSb.append("and FPeriodYear = " + periodYear + " ");
        deleteSb.append("and FPeriodMonth = " + periodMonth + " ");
        deleteSb.append("and FCalTime = " + calTime + " ");
        deleteSb.append("and FHROrgUnitID in (" + hrRange + ") ");
        deleteSb.append("and ((FAdminOrgUnitID in (" + adminRange + ") ");
        deleteSb.append("or FCmpCalOrgID in (" + adminRange + ")) ");
        deleteSb.append("or FUSEDEFAULT=0 ) ");
        deleteSb.append("and FIsLockOtherSysData = 0 ");
        String otherFilter = CmpSchemePersonSQL.getCtbFilterStr(calSchemeId, periodYear, periodMonth, calTime);
        String permSql = CmpPermFilter.getPermSQLByHRO(ctx, "002", calSchemeInfo.getHrOrgUnit().getId().toString(), otherFilter, true);
        if (!CmpStrUtil.isEmpty(permSql)) {
            deleteSb.append("and FPersonID in (" + permSql + ") ");
        }
        return deleteSb.toString();
    }

    private static String getCtbFilterStr(String calSchemeId, int periodYear, int periodMonth, int calTime) {
        StringBuilder filterSb = new StringBuilder();
        filterSb.append("cal_calScheme.id ='" + calSchemeId + "'");
        filterSb.append(" and cmp_CTB.periodYear =" + periodYear + "");
        filterSb.append(" and cmp_CTB.periodMonth =" + periodMonth + "");
        filterSb.append(" and cmp_CTB.calTime =" + calTime + "");
        return filterSb.toString();
    }

    public static String getUpdateSqlByCalSchemeSql(String calSchemeId, Map<String, Object> param, int periodYear, int periodMonth, int calTime, String userId) {
        String sqlDate = CmpDateUtil.toKSqlDate(new Date());
        String permItemId = (String)param.get("permItemId");
        Context ctx = (Context)param.get("context");
        Boolean isUseForTaxCal = (Boolean)param.get("isUseForTaxCal");
        Boolean mergeSchemeIsUseForTaxCal = (Boolean)param.get("mergeSchemeIsUseForTaxCal");
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        String currencyId = null == calSchemeInfo.getCurrency() ? null : "'" + calSchemeInfo.getCurrency().getId().toString() + "'";
        String exchangeTableId = null == calSchemeInfo.getExchangeTable() ? null : "'" + calSchemeInfo.getExchangeTable().getId().toString() + "'";
        int exchangeRule = null == calSchemeInfo.getExchangeRule() ? null : Integer.valueOf(calSchemeInfo.getExchangeRule().getValue());
        String taxUnitId = null == calSchemeInfo.getTaxUnit() ? null : calSchemeInfo.getTaxUnit().getId().toString();
        String mergecalSchemeId = param.get("mergeSchemeId").toString();
        int mergeYear = (Integer)param.get("mergedYear");
        int mergeMonth = (Integer)param.get("mergedMonth");
        int mergeCalTime = (Integer)param.get("mergedCalTime");
        StringBuilder updateSb = new StringBuilder();
        updateSb.append("update T_HR_SCmpCalTable as CMP set ");
        updateSb.append("(FAdminOrgUnitID, ");
        updateSb.append("FLongNumber, ");
        updateSb.append("FCostBearOrgID, ");
        updateSb.append("FCmpCalOrgID, ");
        updateSb.append("FPositionID, ");
        updateSb.append("FJobID, ");
        updateSb.append("FEmpPosOrgRelationID, ");
        updateSb.append("FTaxUnitID, ");
        updateSb.append("FEmployeeTypeID, ");
        updateSb.append("FLastUpdateUserID, ");
        updateSb.append("FLastUpdateTime,");
        updateSb.append("FCmpEmpORelationID,FHrOrgUnitID,FRealEndDate,FIsCostBear,FSocPersonRecordID,FUseDefault,FCurrencyID,FExchangeTableID,FExchangeRule) ");
        updateSb.append("= ");
        updateSb.append("(select distinct CMP_TEMP.FAdminOrgUnitID, CMP_TEMP.FLongNumber, CMP_TEMP.FCostBearOrgID, CMP_TEMP.FCmpCalOrgID, CMP_TEMP.FPositionID, CMP_TEMP.FJobID,");
        updateSb.append("CMP_TEMP.FEmpPosOrgRelationID, ");
        if (isUseForTaxCal.booleanValue() && !mergeSchemeIsUseForTaxCal.booleanValue()) {
            updateSb.append("'" + taxUnitId + "', ");
        } else if (!isUseForTaxCal.booleanValue() && mergeSchemeIsUseForTaxCal.booleanValue()) {
            updateSb.append(" null, ");
        } else if (isUseForTaxCal.booleanValue() && mergeSchemeIsUseForTaxCal.booleanValue()) {
            updateSb.append(" CMP_TEMP.FTaxUnitID, ");
        } else if (!isUseForTaxCal.booleanValue() && !mergeSchemeIsUseForTaxCal.booleanValue()) {
            updateSb.append(" null, ");
        }
        updateSb.append(" CMP_TEMP.FEmployeeTypeID, '" + userId + "', " + sqlDate + ", ");
        updateSb.append("CMP_TEMP.FCmpEmpORelationID,CMP_TEMP.FHrOrgUnitID,CMP_TEMP.FRealEndDate,CMP_TEMP.FIsCostBear,CMP_TEMP.FSocPersonRecordID,CMP_TEMP.FUseDefault, ");
        updateSb.append(currencyId).append(", ");
        updateSb.append(exchangeTableId).append(", ");
        updateSb.append(exchangeRule);
        updateSb.append(" from T_HR_SCmpCalTable AS CMP_TEMP ");
        updateSb.append(" LEFT JOIN T_HR_SPersonCmp AS PersonCmp ON CMP_TEMP.FPersonID = PersonCmp.FPersonId ");
        updateSb.append(" and (YEAR(PersonCmp.FLeffectDate) > " + periodYear + " or (YEAR(PersonCmp.FLeffectDate) = " + periodYear + " and MONTH(PersonCmp.FLeffectDate) >= " + periodMonth + ")) ");
        updateSb.append(" where PersonCmp.FPersonID = CMP_TEMP.FPersonID and PersonCmp.FIsSendSalary = 1 ");
        updateSb.append(" and CMP_TEMP.FCalSchemeID = '" + mergecalSchemeId + "' ");
        updateSb.append(" and CMP_TEMP.FPeriodYear = " + mergeYear + " ");
        updateSb.append(" and CMP_TEMP.FPeriodMonth = " + mergeMonth + " ");
        updateSb.append(" and CMP_TEMP.FCalTime = " + mergeCalTime + " ");
        updateSb.append(" and CMP_TEMP.FPersonID=CMP.fpersonid ");
        updateSb.append(" and CMP_TEMP.FHROrgUnitID in (" + hrRange + ") ");
        updateSb.append(" and ((CMP_TEMP.FAdminOrgUnitID in (" + adminRange + ") ");
        updateSb.append(" or CMP_TEMP.FCmpCalOrgID in (" + adminRange + ")) ");
        updateSb.append(" or CMP_TEMP.FUSEDEFAULT=0 ) ");
        String otherFilter = CmpSchemePersonSQL.getCtbFilterStr(mergecalSchemeId, mergeYear, mergeMonth, mergeCalTime);
        String permSql = CmpPermFilter.getPermSQLByHRO(ctx, "002", calSchemeInfo.getHrOrgUnit().getId().toString(), otherFilter, true);
        if (!CmpStrUtil.isEmpty(permSql)) {
            updateSb.append("and CMP_TEMP.FPersonID in (" + permSql + ") ");
        }
        updateSb.append(" ) ");
        updateSb.append("where CMP.FID in ");
        updateSb.append("(select CMP_CAL.FID from ");
        updateSb.append("(select Fid, FPersonID ");
        updateSb.append("from T_HR_SCmpCalTable ");
        updateSb.append("where FCalSchemeID = '" + calSchemeId + "' ");
        updateSb.append("and FPeriodYear = " + periodYear + " ");
        updateSb.append("and FPeriodMonth = " + periodMonth + " ");
        updateSb.append("and FCalTime = " + calTime + " ");
        updateSb.append(") CMP_CAL inner join ");
        updateSb.append("(select Fid, FPersonID ");
        updateSb.append("from T_HR_SCmpCalTable ");
        updateSb.append("where FCalSchemeID = '" + mergecalSchemeId + "' ");
        updateSb.append("and FPeriodYear = " + mergeYear + " ");
        updateSb.append("and FPeriodMonth = " + mergeMonth + " ");
        updateSb.append("and FCalTime = " + mergeCalTime + " ");
        updateSb.append(") MER_CMP_CAL ");
        updateSb.append("on CMP_CAL.FPersonID = MER_CMP_CAL.FPersonID) ");
        return updateSb.toString();
    }

    public static String getInsertByCalSchemeSql(CalSchemeInfo calSchemeInfo, Map<String, Object> param, String userId) {
        StringBuilder insertSb = new StringBuilder();
        String sqlDate = CmpDateUtil.toKSqlDate(new Date());
        Boolean isUseForTaxCal = (Boolean)param.get("isUseForTaxCal");
        Boolean mergeSchemeIsUseForTaxCal = (Boolean)param.get("mergeSchemeIsUseForTaxCal");
        String taxUnitId = null == calSchemeInfo.getTaxUnit() ? null : calSchemeInfo.getTaxUnit().getId().toString();
        String calSchemeId = calSchemeInfo.getId().toString();
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        int cmpPeriodTypeValue = calSchemeInfo.getCmpPeriodType().getValue();
        String sqlBeginDate = CmpDateUtil.toKSqlDate(calSchemeInfo.getBeginDate());
        String sqlEndDate = CmpDateUtil.toKSqlDate(calSchemeInfo.getEndDate());
        String permItemId = (String)param.get("permItemId");
        Context ctx = (Context)param.get("context");
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        String currencyId = null == calSchemeInfo.getCurrency() ? null : "'" + calSchemeInfo.getCurrency().getId().toString() + "'";
        String exchangeTableId = null == calSchemeInfo.getExchangeTable() ? null : "'" + calSchemeInfo.getExchangeTable().getId().toString() + "'";
        int exchangeRule = null == calSchemeInfo.getExchangeRule() ? null : Integer.valueOf(calSchemeInfo.getExchangeRule().getValue());
        String l = LocaleUtils.getShortCode((Context)ctx);
        String mergecalSchemeId = param.get("mergeSchemeId").toString();
        int mergeYear = (Integer)param.get("mergedYear");
        int mergeMonth = (Integer)param.get("mergedMonth");
        int mergeCalTime = (Integer)param.get("mergedCalTime");
        insertSb.append(" Insert into T_HR_SCmpCalTable(");
        insertSb.append(" FID, FPersonID, FCalSchemeID, FCmpPeriodType, FTaxUnitID,");
        insertSb.append(" FPeriodYear, FPeriodMonth, FCalTime, FBeginDate, FEndDate, FCalState, FIsLockOtherSysData, FCalUpdateType,");
        insertSb.append(" FAdminOrgUnitID, FLongNumber, FCostBearOrgID, FCmpCalOrgID, FPositionID, FJobID,");
        insertSb.append(" FEmpPosOrgRelationID, FEmployeeTypeID,");
        insertSb.append(" FName_" + l + ", FNumber, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime,");
        insertSb.append(" FCmpEmpORelationID,FHrOrgUnitID,FRealEndDate,FIsCostBear,FDescription_l1,FDescription_l2,FDescription_l3,FUseDefault,FCurrencyID,FExchangeTableID,FExchangeRule )");
        insertSb.append(" select ");
        insertSb.append("newbosid('269E3024'), ");
        insertSb.append("FPersonID,");
        insertSb.append("'" + calSchemeId + "',");
        insertSb.append("'" + cmpPeriodTypeValue + "',");
        if (isUseForTaxCal.booleanValue() && !mergeSchemeIsUseForTaxCal.booleanValue()) {
            insertSb.append(" '" + taxUnitId + "',");
        } else if (!isUseForTaxCal.booleanValue() && mergeSchemeIsUseForTaxCal.booleanValue()) {
            insertSb.append(" null,");
        } else if (isUseForTaxCal.booleanValue() && mergeSchemeIsUseForTaxCal.booleanValue()) {
            insertSb.append(" FTaxUnitID,");
        } else {
            insertSb.append(" null,");
        }
        insertSb.append("" + periodYear + ",");
        insertSb.append("" + periodMonth + ",");
        insertSb.append("" + calTime + ",");
        insertSb.append("" + sqlBeginDate + ",");
        insertSb.append("" + sqlEndDate + ",");
        insertSb.append("1, ");
        insertSb.append("0, ");
        insertSb.append("FCalUpdateType,FAdminOrgUnitID, FLongNumber, FCostBearOrgID, FCmpCalOrgID, FPositionID, FJobID,");
        insertSb.append("FEmpPosOrgRelationID, FEmployeeTypeID,");
        insertSb.append("FName_" + l + ", FNumber, ");
        insertSb.append("'" + userId + "', ");
        insertSb.append("" + sqlDate + ", ");
        insertSb.append("'" + userId + "', ");
        insertSb.append("" + sqlDate + " ");
        insertSb.append(",FCmpEmpORelationID, FHrOrgUnitID, FRealEndDate, 0, ");
        insertSb.append("N'" + CalTableDesTypeEnum.PERSONWEB.getAlias(LocaleUtils.locale_en_US) + "',");
        insertSb.append("N'" + CalTableDesTypeEnum.PERSONWEB.getAlias(LocaleUtils.locale_zh_CN) + "',");
        insertSb.append("N'" + CalTableDesTypeEnum.PERSONWEB.getAlias(LocaleUtils.locale_zh_TW) + "',");
        insertSb.append("FUseDefault,");
        insertSb.append(currencyId).append(", ");
        insertSb.append(exchangeTableId).append(", ");
        insertSb.append(exchangeRule);
        insertSb.append(" from (select ");
        insertSb.append(" distinct CmpCal.FID, CmpCal.FPersonID, CmpCal.FCalSchemeID, CmpCal.FCmpPeriodType, CmpCal.FTaxUnitID,");
        insertSb.append(" CmpCal.FPeriodYear, CmpCal.FPeriodMonth, CmpCal.FCalTime, CmpCal.FBeginDate, CmpCal.FEndDate, CmpCal.FCalState, CmpCal.FIsLockOtherSysData, CmpCal.FCalUpdateType,");
        insertSb.append(" CmpCal.FAdminOrgUnitID, CmpCal.FLongNumber, CmpCal.FCostBearOrgID, CmpCal.FCmpCalOrgID, CmpCal.FPositionID, CmpCal.FJobID,");
        insertSb.append(" CmpCal.FEmpPosOrgRelationID, CmpCal.FEmployeeTypeID,");
        insertSb.append(" CmpCal.FName_" + l + ", CmpCal.FNumber, CmpCal.FCreatorID, CmpCal.FCreateTime, CmpCal.FLastUpdateUserID, CmpCal.FLastUpdateTime, ");
        insertSb.append(" CmpCal.FCmpEmpORelationID,CmpCal.FHrOrgUnitID, CmpCal.FRealEndDate,CmpCal.FUseDefault from T_HR_SCmpCalTable ");
        insertSb.append(" AS CmpCal LEFT JOIN T_HR_SPersonCmp PersonCmp on CmpCal.FPersonID = PersonCmp.FPersonId ");
        insertSb.append(" and CmpCal.FHRORGUNITID = PersonCmp.FHRORGUNITID ");
        insertSb.append(" and (YEAR(PersonCmp.FLeffectDate) > " + periodYear + " or (YEAR(PersonCmp.FLeffectDate) = " + periodYear + " and MONTH(PersonCmp.FLeffectDate) >= " + periodMonth + ")) ");
        insertSb.append(" where PersonCmp.FIsSendSalary = 1  and CmpCal.FCalSchemeID = '" + mergecalSchemeId + "' ");
        insertSb.append(" and CmpCal.FPeriodYear = " + mergeYear + " ");
        insertSb.append(" and CmpCal.FPeriodMonth = " + mergeMonth + " ");
        insertSb.append(" and CmpCal.FCalTime = " + mergeCalTime + " ");
        insertSb.append(" and CmpCal.FHROrgUnitID in (" + hrRange + ") ");
        insertSb.append(" and ((CmpCal.FAdminOrgUnitID in (" + adminRange + ") ");
        insertSb.append(" or CmpCal.FCmpCalOrgID in (" + adminRange + ")) ");
        insertSb.append(" or CmpCal.FUSEDEFAULT=0 ) ");
        String otherFilter = CmpSchemePersonSQL.getCtbFilterStr(mergecalSchemeId, mergeYear, mergeMonth, mergeCalTime);
        String permSql = CmpPermFilter.getPermSQLByHRO(ctx, "002", calSchemeInfo.getHrOrgUnit().getId().toString(), otherFilter, true);
        if (!CmpStrUtil.isEmpty(permSql)) {
            insertSb.append("and CmpCal.FPersonID in (" + permSql + ") ");
        }
        insertSb.append(") MER_CMP_CAL ");
        insertSb.append("where MER_CMP_CAL.FPersonID not in ( select FPersonID from T_HR_SCmpCalTable ");
        insertSb.append("where FCalSchemeID = '" + calSchemeId + "' ");
        insertSb.append("and FPeriodYear = " + periodYear + " ");
        insertSb.append("and FPeriodMonth = " + periodMonth + " ");
        insertSb.append("and FCalTime = " + calTime + ") ");
        return insertSb.toString();
    }

    public static List<Map<String, String>> getAfterApprFilter(String calSchemeId, String permItemId, Map<String, Object> param, int periodYear, int periodMonth, int calTime) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Context ctx = (Context)param.get("context");
        String language = ctx.getLocale().getLanguage();
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL(ctx, permItemId);
        String adminRange = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select p.FNumber as number, p.FName_").append(language).append(" as name, admin.FName_").append(language).append(" as adminOrg, pos.FName_").append(language).append(" as position, e.FName_").append(language).append(" as employeeType, aff.FName_").append(language).append(" as affairar, ");
        sBuilder.append("cal.FCalState as calState, cal.FIsLockOtherSysData as isLock ");
        sBuilder.append("from T_HR_SCmpCalTable cal ");
        sBuilder.append("left join T_BD_Person p on cal.FPersonID = p.FID ");
        sBuilder.append("left join T_ORG_Position pos on cal.FPOSITIONID = pos.FID ");
        sBuilder.append("left join T_ORG_ADMIN admin on cal.FADMINORGUNITID = admin.FID ");
        sBuilder.append("left join T_HR_BDEMPLOYEETYPE e on cal.FEMPLOYEETYPEID = e.FID ");
        sBuilder.append("left join T_HR_EMPORGRELATION rel on cal.FEMPPOSORGRELATIONID = rel.FID ");
        sBuilder.append("left join T_HR_AFFAIRACTIONREASON aff on aff.FID = rel.FACTIONTYPEID ");
        sBuilder.append("where cal.FCalSchemeID = '" + calSchemeId + "' ");
        sBuilder.append("and cal.FPeriodYear = " + periodYear + " ");
        sBuilder.append("and cal.FPeriodMonth = " + periodMonth + " ");
        sBuilder.append("and cal.FCalTime = " + calTime + " ");
        sBuilder.append("and cal.FHROrgUnitID in (" + hrRange + ") ");
        sBuilder.append("and ((cal.FAdminOrgUnitID in (" + adminRange + ") ");
        sBuilder.append("or cal.FCmpCalOrgID in (" + adminRange + ")) ");
        sBuilder.append("or cal.FUSEDEFAULT=0 ) ");
        sBuilder.append("and cal.FIsLockOtherSysData = 1 ");
        String otherFilter = CmpSchemePersonSQL.getCtbFilterStr(calSchemeId, periodYear, periodMonth, calTime);
        String permSql = CmpPermFilter.getPermSQLByHRO(ctx, "002", calSchemeInfo.getHrOrgUnit().getId().toString(), otherFilter, true);
        if (!CmpStrUtil.isEmpty(permSql)) {
            sBuilder.append("and cal.FPersonID in (" + permSql + ") ");
        }
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sBuilder.toString());
            while (rs.next()) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                result.put("number", rs.getString("number"));
                result.put("name", rs.getString("name"));
                result.put("adminOrg", rs.getString("adminOrg"));
                result.put("position", rs.getString("position"));
                String calStateName = rs.getObject("calState") == null ? "" : CalState.getEnum(rs.getInt("calState")).getAlias();
                result.put("calState", calStateName);
                String isLockName = rs.getObject("isLock") == null ? "" : (rs.getInt("isLock") == 0 ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label211", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label210", (Locale)ctx.getLocale()));
                result.put("isLock", isLockName);
                result.put("employeeType", rs.getString("employeeType"));
                result.put("affairar", rs.getString("affairar"));
                list.add(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

