/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.CancelDeclareResponseData;
import com.kingdee.shr.compensation.app.taxCal.vo.CancelDeclareResponseVO;
import com.kingdee.shr.compensation.app.taxCal.vo.CancelDeclareResult;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.tax.task.impl.TaxDeclareUpdateService;
import com.kingdee.shr.compensation.taxCal.util.TaxCalcFileUtils;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CancelTaxDeclareService
extends TaxDeclareUpdateService {
    private static final Logger logger = Logger.getLogger(CancelTaxDeclareService.class);
    private static final int CANCELLING = 2;
    private static final int CANCEL_FAILED = 0;
    private static final int CANCEL_SUCCESS = 1;
    private static final int CANCEL_SUCCESS1 = -2;

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        CancelDeclareResponseVO responseVO = (CancelDeclareResponseVO)JSON.parseObject((String)response, CancelDeclareResponseVO.class);
        String taskId = taskInfo.getId().toString();
        String sql = "select d.fid, d.fTbType, d.fBatchNo from t_hr_sIncomeTaxDeclar d, t_hr_sTaskIncomeTaxRelation r, t_hr_sTaxCalTask t where d.fid = r.fBizId and r.fTaskId = t.fid and t.fid = '" + taskId + "' and t.fCatalog='" + 140 + "'";
        try {
            CancelDeclareResponseData data;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                throw new BOSException("taskId[" + taskId + "]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7533\u62a5\u6570\u636e");
            }
            String id = null;
            String tbType = null;
            String batchNo = null;
            while (rowSet.next()) {
                id = rowSet.getString(1);
                tbType = rowSet.getString(2);
                batchNo = rowSet.getString(3);
            }
            if (null == batchNo) {
                batchNo = TaxCalcFileUtils.getUUID();
            }
            if (null == (data = responseVO.getData())) {
                logger.error((Object)("afterCancelDeclare error: CancelDeclareResponseData is null for taskId: " + taskId));
                return;
            }
            CancelDeclareResult result = "1".equals(tbType) ? data.getYkyjsbjg() : ("2".equals(tbType) ? data.getFlsdsbjg() : data.getFjmsbjg());
            if (null == result) {
                logger.error((Object)("afterCancelDeclare error: CancelDeclareResult is null for taskId: " + taskId));
                return;
            }
            Integer zfbz = result.getZfbz();
            if (zfbz == 2) {
                return;
            }
            TaxCalTaskStateEnum taskState = TaxCalTaskStateEnum.RUNNING;
            String msg = result.getErrorinfo();
            String declareSQL = "update t_hr_sIncomeTaxDeclar set FIsCancelled = ?, fBatchNo = ? ";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            String newBatchNo = TaxCalcFileUtils.getUUID();
            if (zfbz == 1 || zfbz == -2) {
                taskState = TaxCalTaskStateEnum.FINISHED;
                declareSQL = declareSQL + ", FDeclareStatus = ?";
                Object[] param = new Object[]{1, newBatchNo, "0", id};
                params.add(param);
                List<String> configDetailIds = this.copyData(ctx, id, 1, batchNo, newBatchNo);
                this.updateBatchNo4ConfigData(ctx, configDetailIds, newBatchNo);
            } else if (zfbz == 0) {
                taskState = TaxCalTaskStateEnum.FAIDED;
                Object[] param = new Object[]{0, id};
                params.add(param);
            }
            declareSQL = declareSQL + " where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)declareSQL, params);
            TaxCalTaskFactory.getLocalInstance(ctx).updateStateMsgById(taskId, taskState, msg);
            taskInfo.setState(taskState);
            this.sendMsg2Commander(ctx, taskInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_afterCancelDeclare error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((CharSequence)errMsg) ? "\u4f5c\u5e9f\u7533\u62a5\u5931\u8d25" : errMsg, taskInfo.getId().toString()};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        this.sendMsg2Commander(ctx, taskInfo);
    }

    @Override
    public void sendMsg2Commander(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String msgTemplate;
            String title;
            String declareSQL = "select d.fTbType from t_hr_sIncomeTaxDeclar d, t_hr_sTaskIncomeTaxRelation r, t_hr_sTaxCalTask t where d.fid = r.fBizId and r.fTaskId = t.fid and t.fid = '" + taxCalTaskInfo.getId().toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)declareSQL);
            String tbType = "1";
            while (rowSet.next()) {
                tbType = rowSet.getString(1);
            }
            String tbTypeStr = CmpConstants.getTbTypeDesc(tbType);
            String number = taxCalTaskInfo.getNumber();
            TaxCalTaskStateEnum state = taxCalTaskInfo.getState();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            if (TaxCalTaskStateEnum.FINISHED.equals((Object)state)) {
                title = "\u4f5c\u5e9f\u7533\u62a5\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u4f5c\u5e9f\u6210\u529f\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}][{2}]\u4f5c\u5e9f\u7533\u62a5\u5b8c\u6210\uff0c\u8bf7\u8fdb\u5165[\u4e2a\u7a0e\u670d\u52a1-\u4e2a\u7a0e\u7533\u62a5-\u66f4\u6b63\u5904\u7406]\u64cd\u4f5c";
            } else {
                title = "\u4f5c\u5e9f\u7533\u62a5\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u4f5c\u5e9f\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}][{2}]\u4f5c\u5e9f\u5931\u8d25";
            }
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period, tbTypeStr);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)"FailureHandler130 error: ", (Throwable)e);
        }
    }
}

