/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemCollection;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemFactory;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemFactory;
import com.kingdee.shr.compensation.app.budget.StandingBookItemCollection;
import com.kingdee.shr.compensation.app.budget.StandingBookItemFactory;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.exception.BaseUtilsBizException;
import com.kingdee.shr.compensation.util.CmpCacheUtil;
import com.kingdee.shr.compensation.util.CmpCommonUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CmpPopulateUtil {
    private static final Logger logger = Logger.getLogger(CmpPopulateUtil.class);

    public List pupolate(Context ctx, String scheme, String sql, IRowSet rowSet) throws BOSException, EASBizException {
        try {
            if (CmpCommonUtil.isNullOrEmpty(sql, rowSet)) {
                throw new BaseUtilsBizException(BaseUtilsBizException.SQL_ROWSET_EMPTY);
            }
            Map<String, Set<String>> tableCloumnSetMap = this.getTableCloumnSetMap(ctx, sql, rowSet);
            Set<String> numberSet = tableCloumnSetMap.get("numberSet");
            Set<String> intSet = tableCloumnSetMap.get("intSet");
            Set<String> dateSet = tableCloumnSetMap.get("dateSet");
            Set<String> strSet = tableCloumnSetMap.get("strSet");
            Set<String> nclobSet = tableCloumnSetMap.get("nclobSet");
            Set<String> uidSet = tableCloumnSetMap.get("uidSet");
            ArrayList dataList = new ArrayList();
            Map<String, Integer> numberTypeCmpItemMapping = null;
            if ("012".equals(scheme)) {
                numberTypeCmpItemMapping = this.getNumberTypeSubmitItemMapping(ctx, numberSet);
            } else if ("006_CMP_ADJ".equals(scheme)) {
                numberTypeCmpItemMapping = this.getNumberTypeAdjustSalaryItemMapping(ctx, numberSet);
            } else if ("002_STOP_CAL".equals(scheme)) {
                scheme = "002";
                numberTypeCmpItemMapping = this.getNumberTypeStopCalItemMapping(ctx, numberSet);
            } else {
                numberTypeCmpItemMapping = "budget".equals(scheme) || "subBudgetAssign".equals(scheme) || "expense".equals(scheme) ? this.getNumberTypeBudgetItemMapping(ctx, numberSet) : this.getNumberTypeCmpItemMapping(ctx, numberSet);
            }
            String regex = "\\w+\\.\\w+\\.(S|s)\\d+";
            String budgetRegex = "\\w+\\.\\w+\\.(T|t)\\d+";
            HashMap<String, String> typeMap = new HashMap<String, String>();
            while (rowSet.next()) {
                Map<String, Map<String, Object>> resultMap;
                Object objectValue;
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                for (String field : intSet) {
                    try {
                        String str = rowSet.getString(field);
                        objectValue = StringUtils.isEmpty((String)str) ? null : Integer.valueOf(rowSet.getInt(field));
                    }
                    catch (Exception e) {
                        objectValue = 0;
                    }
                    if (StringUtils.isEmpty((String)((String)typeMap.get(field)))) {
                        resultMap = this.getStructColumnsPupolateValue(ctx, scheme, field, objectValue);
                        objectValue = resultMap.get(field).get("value");
                        typeMap.put(field, resultMap.get(field).get("type") + "");
                    } else {
                        objectValue = this.getStructColumnsPupolateValueByType(scheme, field, objectValue, (String)typeMap.get(field) + "");
                    }
                    dataMap.put(field.toLowerCase(Locale.ENGLISH), objectValue);
                }
                for (String field : numberSet) {
                    String matchField = field.matches(regex) || field.matches(budgetRegex) ? field.substring(field.indexOf(".") + 1) : field;
                    Integer numberPer = numberTypeCmpItemMapping.get(matchField);
                    int per = numberPer == null ? 2 : numberPer;
                    try {
                        objectValue = rowSet.getBigDecimal(field);
                        objectValue = CmpCommonUtil.toBigDecimal(CmpCommonUtil.toDoubleString(objectValue));
                        if (null != objectValue) {
                            objectValue = BigDecimal.ZERO.equals(objectValue) ? FunctionTools.getRound(per, ((BigDecimal)objectValue).doubleValue()) : new BigDecimal(String.valueOf(objectValue)).setScale(per, RoundingMode.HALF_UP);
                        }
                    }
                    catch (Exception e) {
                        objectValue = null;
                    }
                    dataMap.put(field.toLowerCase(Locale.ENGLISH), null == objectValue ? objectValue : new BigDecimal(String.valueOf(objectValue)).toPlainString());
                }
                for (String field : dateSet) {
                    try {
                        objectValue = new Date(rowSet.getTimestamp(field).getTime());
                    }
                    catch (Exception e) {
                        objectValue = null;
                    }
                    dataMap.put(field.toLowerCase(Locale.ENGLISH), objectValue);
                }
                for (String field : strSet) {
                    try {
                        objectValue = rowSet.getString(field);
                    }
                    catch (Exception e) {
                        objectValue = null;
                    }
                    if (StringUtils.isEmpty((String)((String)typeMap.get(field)))) {
                        resultMap = this.getStructColumnsPupolateValue(ctx, scheme, field, objectValue);
                        objectValue = resultMap.get(field).get("value");
                        typeMap.put(field, resultMap.get(field).get("type") + "");
                    } else {
                        objectValue = this.getStructColumnsPupolateValueByType(scheme, field, objectValue, (String)typeMap.get(field) + "");
                    }
                    if (null != objectValue && "0E-10".equalsIgnoreCase(objectValue.toString()) && field.contains("cmp_ctb")) {
                        objectValue = null;
                    }
                    dataMap.put(field.toLowerCase(Locale.ENGLISH), objectValue);
                }
                for (String field : nclobSet) {
                    try {
                        objectValue = rowSet.getString(field);
                    }
                    catch (Exception e) {
                        objectValue = null;
                    }
                    if (StringUtils.isEmpty((String)((String)typeMap.get(field)))) {
                        resultMap = this.getStructColumnsPupolateValue(ctx, scheme, field, objectValue);
                        objectValue = resultMap.get(field).get("value");
                        typeMap.put(field, resultMap.get(field).get("type") + "");
                    } else {
                        objectValue = this.getStructColumnsPupolateValueByType(scheme, field, objectValue, (String)typeMap.get(field) + "");
                    }
                    dataMap.put(field.toLowerCase(Locale.ENGLISH), objectValue);
                }
                for (String field : uidSet) {
                    try {
                        objectValue = rowSet.getString(field);
                    }
                    catch (Exception e) {
                        objectValue = null;
                    }
                    if (StringUtils.isEmpty((String)((String)typeMap.get(field)))) {
                        resultMap = this.getStructColumnsPupolateValue(ctx, scheme, field, objectValue);
                        objectValue = resultMap.get(field).get("value");
                        typeMap.put(field, resultMap.get(field).get("type") + "");
                    } else {
                        objectValue = this.getStructColumnsPupolateValueByType(scheme, field, objectValue, (String)typeMap.get(field) + "");
                    }
                    dataMap.put(field.toLowerCase(Locale.ENGLISH), objectValue);
                }
                dataList.add(dataMap);
            }
            return dataList;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public Map<String, Set<String>> getTableCloumnSetMap(Context ctx, String tableName, IRowSet rowSet) throws BOSException, EASBizException {
        try {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            HashSet<String> numberSet = new HashSet<String>();
            HashSet<String> intSet = new HashSet<String>();
            HashSet<String> dateSet = new HashSet<String>();
            HashSet<String> strSet = new HashSet<String>();
            HashSet<String> nclobSet = new HashSet<String>();
            HashSet<String> uidSet = new HashSet<String>();
            int columnCount = rowSet.getMetaData().getColumnCount();
            ResultSetMetaData metaData = rowSet.getMetaData();
            for (int i = 1; i <= columnCount; ++i) {
                String columnTypeName = metaData.getColumnTypeName(i);
                int scale = metaData.getScale(i);
                int precision = metaData.getPrecision(i);
                String columnName = metaData.getColumnName(i);
                if (columnName.equals("RN")) continue;
                if ("PERSONCOUNTS".equalsIgnoreCase(columnName) || "PERSONCMP.ISSENDSALARY".equalsIgnoreCase(columnName)) {
                    intSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if (("number".equalsIgnoreCase(columnTypeName) || "decimal".equalsIgnoreCase(columnTypeName) || "numeric".equalsIgnoreCase(columnTypeName)) && (scale >= 2 || precision == 0)) {
                    numberSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("float".equalsIgnoreCase(columnTypeName)) {
                    numberSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("DEC".equalsIgnoreCase(columnTypeName)) {
                    if (scale == 0 && precision == 10) {
                        intSet.add(columnName.toLowerCase(Locale.ENGLISH));
                        continue;
                    }
                    if (scale == 0 && precision == 0) {
                        numberSet.add(columnName.toLowerCase(Locale.ENGLISH));
                        continue;
                    }
                    numberSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("number".equalsIgnoreCase(columnTypeName) || "decimal".equalsIgnoreCase(columnTypeName) || "numeric".equalsIgnoreCase(columnTypeName)) {
                    intSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("int".equalsIgnoreCase(columnTypeName) || "int4".equalsIgnoreCase(columnTypeName)) {
                    intSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("datetime".equalsIgnoreCase(columnTypeName) || "timestamp".equalsIgnoreCase(columnTypeName) || "date".equalsIgnoreCase(columnTypeName)) {
                    dateSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("clob".equalsIgnoreCase(columnTypeName) || "nclob".equalsIgnoreCase(columnTypeName)) {
                    nclobSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                if ("varchar".equalsIgnoreCase(columnTypeName) && precision == 44) {
                    uidSet.add(columnName.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                strSet.add(columnName.toLowerCase(Locale.ENGLISH));
            }
            map.put("numberSet", numberSet);
            map.put("intSet", intSet);
            map.put("dateSet", dateSet);
            map.put("strSet", strSet);
            map.put("nclobSet", nclobSet);
            map.put("uidSet", uidSet);
            return map;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public Map<String, Integer> getNumberTypeSubmitItemMapping(Context ctx, Set<String> numberSet) throws BOSException {
        HashSet<Integer> fieldSnSet = new HashSet<Integer>();
        for (String numKey : numberSet) {
            Integer fieldSn = null;
            try {
                String sn = numKey.split("\\.")[1];
                fieldSn = Integer.parseInt(sn.substring(1));
            }
            catch (Exception sn) {
                // empty catch block
            }
            if (null == fieldSn) continue;
            fieldSnSet.add(fieldSn);
        }
        HashMap<String, Integer> dataLengthMap = new HashMap<String, Integer>();
        if (fieldSnSet.isEmpty()) {
            return dataLengthMap;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("dataDot"));
        sic.add(new SelectorItemInfo("dataLength"));
        sic.add(new SelectorItemInfo("fieldSn"));
        entityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fieldSn", fieldSnSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        CalSubmitItemCollection itemCollcection = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemCollection(entityViewInfo);
        CalSubmitItemInfo itemInfo = new CalSubmitItemInfo();
        int size = itemCollcection.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = itemCollcection.get(i);
            dataLengthMap.put("cmp_smt002.s" + itemInfo.getFieldSn(), itemInfo.getDataDot().getValue());
        }
        return dataLengthMap;
    }

    public Map<String, Integer> getNumberTypeAdjustSalaryItemMapping(Context ctx, Set<String> numberSet) throws BOSException {
        HashSet<Integer> fieldSnSet = new HashSet<Integer>();
        for (String numKey : numberSet) {
            Integer fieldSn = null;
            try {
                String sn = numKey.split("\\.")[1];
                fieldSn = Integer.parseInt(sn.substring(1));
            }
            catch (Exception sn) {
                // empty catch block
            }
            if (null == fieldSn) continue;
            fieldSnSet.add(fieldSn);
        }
        HashMap<String, Integer> dataLengthMap = new HashMap<String, Integer>();
        if (fieldSnSet.isEmpty()) {
            return dataLengthMap;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("dataDot"));
        sic.add(new SelectorItemInfo("dataLength"));
        sic.add(new SelectorItemInfo("fieldSn"));
        entityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fieldSn", fieldSnSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        AdjustSalaryItemCollection itemCollcection = AdjustSalaryItemFactory.getLocalInstance((Context)ctx).getAdjustSalaryItemCollection(entityViewInfo);
        AdjustSalaryItemInfo itemInfo = new AdjustSalaryItemInfo();
        int size = itemCollcection.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = itemCollcection.get(i);
            dataLengthMap.put("cmp_smt001.s" + itemInfo.getFieldSn(), itemInfo.getDataDot().getValue());
        }
        return dataLengthMap;
    }

    public Map<String, Integer> getNumberTypeStopCalItemMapping(Context ctx, Set<String> numberSet) throws BOSException {
        HashSet<Integer> fieldSnSet = new HashSet<Integer>();
        for (String numKey : numberSet) {
            Integer fieldSn = null;
            try {
                String sn = numKey.split("\\.")[1];
                fieldSn = Integer.parseInt(sn.substring(1));
            }
            catch (Exception sn) {
                // empty catch block
            }
            if (null == fieldSn) continue;
            fieldSnSet.add(fieldSn);
        }
        HashMap<String, Integer> dataLengthMap = new HashMap<String, Integer>();
        if (fieldSnSet.isEmpty()) {
            return dataLengthMap;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("dataDot"));
        sic.add(new SelectorItemInfo("dataLength"));
        sic.add(new SelectorItemInfo("fieldSn"));
        entityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fieldSn", fieldSnSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        CmpItemCollection itemCollcection = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(entityViewInfo);
        CmpItemInfo cmpItemInfo = new CmpItemInfo();
        int size = itemCollcection.size();
        for (int i = 0; i < size; ++i) {
            cmpItemInfo = itemCollcection.get(i);
            dataLengthMap.put("cmp_stop.s" + cmpItemInfo.getFieldSn(), cmpItemInfo.getDataDot().getValue());
            for (int k = 1; k <= 7; ++k) {
                dataLengthMap.put("cost0" + k + ".s" + cmpItemInfo.getFieldSn() + "c", cmpItemInfo.getDataDot().getValue());
            }
        }
        return dataLengthMap;
    }

    public Map<String, Integer> getNumberTypeBudgetItemMapping(Context ctx, Set<String> numberSet) throws BOSException {
        StandingBookItemCollection stbItemCollection;
        int fieldSn;
        IntEnum dataDot;
        SHRBaseItemInfo itemInfo;
        int i;
        int size;
        CmpBudgetItemCollection itemCollection;
        HashMap itemDataDotMap = Maps.newHashMap();
        HashSet budgetItemFieldSet = Sets.newHashSet();
        String[] budgetItemColumnPrefix = new String[]{""};
        HashSet stbItemFieldSet = Sets.newHashSet();
        String[] stbItemColumnPrefix = new String[]{""};
        numberSet.forEach(field -> {
            String fieldSnStr = Pattern.compile("[^0-9]").matcher((CharSequence)field).replaceAll("").trim();
            if (StringUtils.isEmpty((String)fieldSnStr)) {
                return;
            }
            int fieldSn = Integer.parseInt(fieldSnStr);
            if (field.toLowerCase(Locale.ENGLISH).startsWith("manage.t") || field.toLowerCase(Locale.ENGLISH).startsWith("subbudgetquery.t")) {
                budgetItemFieldSet.add(fieldSn);
                budgetItemColumnPrefix[0] = Pattern.compile("[0-9]").matcher((CharSequence)field).replaceAll("").trim().toLowerCase(Locale.ENGLISH);
            } else {
                stbItemFieldSet.add(fieldSn);
                stbItemColumnPrefix[0] = Pattern.compile("[0-9]").matcher((CharSequence)field).replaceAll("").trim().toLowerCase(Locale.ENGLISH);
            }
        });
        if (!budgetItemFieldSet.isEmpty() && null != (itemCollection = CmpBudgetItemFactory.getLocalInstance(ctx).getCmpBudgetItemCollection("select fieldSn,dataType,dataDot where fieldSn in (" + ((Object)budgetItemFieldSet).toString().replace("[", "").replace("]", "") + ") and dataType = " + 0)) && itemCollection.size() > 0) {
            size = itemCollection.size();
            for (i = 0; i < size; ++i) {
                itemInfo = itemCollection.get(i);
                dataDot = itemInfo.getDataDot();
                fieldSn = itemInfo.getFieldSn();
                itemDataDotMap.put(budgetItemColumnPrefix[0] + fieldSn, dataDot.getValue());
            }
        }
        if (!stbItemFieldSet.isEmpty() && null != (stbItemCollection = StandingBookItemFactory.getLocalInstance(ctx).getStandingBookItemCollection("select fieldSn,dataType,dataDot where fieldSn in (" + ((Object)stbItemFieldSet).toString().replace("[", "").replace("]", "") + ") and dataType = " + 0)) && stbItemCollection.size() > 0) {
            size = stbItemCollection.size();
            for (i = 0; i < size; ++i) {
                itemInfo = stbItemCollection.get(i);
                dataDot = itemInfo.getDataDot();
                fieldSn = itemInfo.getFieldSn();
                itemDataDotMap.put(stbItemColumnPrefix[0] + fieldSn, dataDot.getValue());
            }
        }
        return itemDataDotMap;
    }

    public Map<String, Integer> getNumberTypeCmpItemMapping(Context ctx, Set<String> numberSet) throws BOSException {
        HashSet<Integer> fieldSnSet = new HashSet<Integer>();
        for (String numKey : numberSet) {
            Integer fieldSn = null;
            try {
                String sn = numKey.split("\\.")[1];
                fieldSn = Integer.parseInt(sn.substring(1));
            }
            catch (Exception sn) {
                // empty catch block
            }
            if (null == fieldSn) continue;
            fieldSnSet.add(fieldSn);
        }
        HashMap<String, Integer> dataLengthMap = new HashMap<String, Integer>();
        if (fieldSnSet.isEmpty()) {
            return dataLengthMap;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("dataDot"));
        sic.add(new SelectorItemInfo("dataLength"));
        sic.add(new SelectorItemInfo("fieldSn"));
        entityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fieldSn", fieldSnSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        CmpItemCollection itemCollcection = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(entityViewInfo);
        CmpItemInfo cmpItemInfo = new CmpItemInfo();
        int size = itemCollcection.size();
        for (int i = 0; i < size; ++i) {
            cmpItemInfo = itemCollcection.get(i);
            dataLengthMap.put("cmp_ctb.s" + cmpItemInfo.getFieldSn(), cmpItemInfo.getDataDot().getValue());
            for (int k = 1; k <= 7; ++k) {
                dataLengthMap.put("cost0" + k + ".s" + cmpItemInfo.getFieldSn() + "c", cmpItemInfo.getDataDot().getValue());
            }
        }
        return dataLengthMap;
    }

    public Map<String, Map<String, Object>> getStructColumnsPupolateValue(Context ctx, String scheme, String field, Object objectValue) throws BOSException, EASBizException {
        String column;
        String clientNumber;
        StructureConfigColumnsInfo structureConfigColumns;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (CmpCommonUtil.isNullOrEmpty(scheme, field)) {
            valueMap.put("value", objectValue);
            valueMap.put("type", "");
            resultMap.put(field, valueMap);
            return resultMap;
        }
        String[] split = field.split("\\.");
        if (split.length > 1 && !CmpCommonUtil.isNullOrEmpty(structureConfigColumns = this.getStructureConfigColumns(ctx, scheme, clientNumber = split[0], column = split[1]))) {
            String dataType = structureConfigColumns.getDataType();
            valueMap.put("type", dataType);
            if (!StringUtils.isEmpty((String)structureConfigColumns.getEnumSource())) {
                String enumSource;
                block18: {
                    enumSource = structureConfigColumns.getEnumSource();
                    try {
                        Class<?> clazz = Class.forName(enumSource);
                        if (objectValue != null && !(objectValue instanceof Enum)) {
                            objectValue = objectValue instanceof Integer ? EnumUtils.getEnum(clazz, (int)((Integer)objectValue)) : (objectValue instanceof BigDecimal ? EnumUtils.getEnum(clazz, (int)((BigDecimal)objectValue).intValue()) : (objectValue instanceof Double ? EnumUtils.getEnum(clazz, (int)((Double)objectValue).intValue()) : EnumUtils.getEnumByValue(clazz, (String)((String)objectValue))));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (objectValue == null) break block18;
                        objectValue = CmpCommonUtil.getEnumItem(enumSource, objectValue.toString());
                    }
                }
                valueMap.put("type", "enum_" + enumSource);
            } else if ("Boolean".equalsIgnoreCase(dataType)) {
                objectValue = CmpCommonUtil.toInt(objectValue) == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                valueMap.put("type", "Boolean");
            } else if ("Integer".equalsIgnoreCase(dataType)) {
                objectValue = CmpCommonUtil.isNullOrEmpty(scheme, field) || objectValue == null ? null : CmpCommonUtil.toInt(objectValue);
                valueMap.put("type", "Integer");
            } else if ("Date".equalsIgnoreCase(dataType)) {
                objectValue = CmpDateUtil.toDate(objectValue);
                valueMap.put("type", "Date");
            } else if ("TimeStamp".equalsIgnoreCase(dataType)) {
                objectValue = CmpCommonUtil.toTimestamp(objectValue);
                valueMap.put("type", "TimeStamp");
            } else if ("BigDecimal".equalsIgnoreCase(dataType)) {
                objectValue = CmpCommonUtil.toBigDecimal(CmpCommonUtil.toDoubleString(objectValue));
                valueMap.put("type", "BigDecimal");
            } else if ("Float".equalsIgnoreCase(dataType)) {
                objectValue = CmpCommonUtil.toBigDecimal(objectValue);
                valueMap.put("type", "Float");
            }
        }
        valueMap.put("value", objectValue);
        resultMap.put(field, valueMap);
        return resultMap;
    }

    public Object getStructColumnsPupolateValueByType(String scheme, String field, Object objectValue, String type) throws EASBizException {
        block19: {
            if (CmpCommonUtil.isNullOrEmpty(scheme, field)) {
                return objectValue;
            }
            String[] split = type.split("_");
            if (split.length > 1) {
                String enumSource = split[1];
                try {
                    Class<?> clazz = Class.forName(enumSource);
                    if (objectValue == null || objectValue instanceof Enum) break block19;
                    if (objectValue instanceof Integer) {
                        objectValue = EnumUtils.getEnum(clazz, (int)((Integer)objectValue));
                        break block19;
                    }
                    if (objectValue instanceof BigDecimal) {
                        objectValue = EnumUtils.getEnum(clazz, (int)((BigDecimal)objectValue).intValue());
                        break block19;
                    }
                    if (objectValue instanceof Double) {
                        objectValue = EnumUtils.getEnum(clazz, (int)((Double)objectValue).intValue());
                        break block19;
                    }
                    objectValue = EnumUtils.getEnumByValue(clazz, (String)((String)objectValue));
                }
                catch (ClassNotFoundException e) {
                    if (objectValue != null) {
                        objectValue = CmpCommonUtil.getEnumItem(enumSource, objectValue.toString());
                    }
                    break block19;
                }
            }
            if ("Boolean".equalsIgnoreCase(type)) {
                objectValue = CmpCommonUtil.toInt(objectValue) == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else if ("Integer".equalsIgnoreCase(type)) {
                objectValue = CmpCommonUtil.toInt(objectValue);
            } else if ("Date".equalsIgnoreCase(type)) {
                objectValue = CmpDateUtil.toDate(objectValue);
            } else if ("TimeStamp".equalsIgnoreCase(type)) {
                objectValue = CmpCommonUtil.toTimestamp(objectValue);
            } else if ("BigDecimal".equalsIgnoreCase(type)) {
                objectValue = CmpCommonUtil.toBigDecimal(CmpCommonUtil.toDoubleString(objectValue));
            } else if ("Float".equalsIgnoreCase(type)) {
                objectValue = CmpCommonUtil.toBigDecimal(objectValue);
            }
        }
        return objectValue;
    }

    public StructureConfigColumnsInfo getStructureConfigColumns(Context ctx, String scheme, String structConfig, String column) throws BOSException, EASBizException {
        try {
            if (CmpCommonUtil.isNullOrEmpty(scheme, structConfig, column)) {
                throw new BaseUtilsBizException(BaseUtilsBizException.SCHEME_CONFIG_COLUMN_EMPTY);
            }
            StructureConfigColumnsCollection structureConfigColumnsCollection = this.getStructureConfigColumnsCollection(ctx, scheme);
            int j = structureConfigColumnsCollection.size();
            for (int i = 0; i < j; ++i) {
                StructureConfigSchemeInfo structureConfigSchemeInfo;
                StructureConfigInfo structureConfig;
                StructureConfigColumnsInfo structureConfigColumnsInfo = structureConfigColumnsCollection.get(i);
                if (CmpCommonUtil.isNullOrEmpty(structureConfigColumnsInfo)) continue;
                String columnNumber = structureConfigColumnsInfo.getNumber();
                if (CmpCommonUtil.isNullOrEmpty(columnNumber, structureConfig = structureConfigColumnsInfo.getStructureConfig())) continue;
                String clientNumber = structureConfig.getClientNumber();
                if (CmpCommonUtil.isNullOrEmpty(clientNumber, structureConfigSchemeInfo = structureConfig.getScheme())) continue;
                String schemeNumber = structureConfigSchemeInfo.getNumber();
                if (CmpCommonUtil.isNullOrEmpty(schemeNumber) || !scheme.equalsIgnoreCase(schemeNumber) || !structConfig.equalsIgnoreCase(clientNumber) || !column.equalsIgnoreCase(columnNumber)) continue;
                return structureConfigColumnsInfo;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public StructureConfigColumnsCollection getStructureConfigColumnsCollection(Context ctx, String scheme) throws BOSException, EASBizException {
        try {
            StructureConfigColumnsCollection structureConfigColumnsCollection = null;
            String key = "initSchemeConfig_scheme_" + scheme;
            if (null == CmpCacheUtil.getCacheMap(ctx, key)) {
                String oql = "select *,structureConfig.*,structureConfig.scheme.* where structureConfig.scheme.number = '" + scheme + "'";
                structureConfigColumnsCollection = StructureConfigColumnsFactory.getLocalInstance((Context)ctx).getStructureConfigColumnsCollection(oql);
                CmpCacheUtil.setCacheMap(ctx, key, structureConfigColumnsCollection);
            } else {
                structureConfigColumnsCollection = (StructureConfigColumnsCollection)CmpCacheUtil.getCacheMap(ctx, key);
            }
            return structureConfigColumnsCollection;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

