/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public final class SqlUtil {
    private static final int MAX_DATA_ROW = 1000;

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        if (sql == null) {
            return null;
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows) throws BOSException {
        try {
            JdbcRowSet sourceRowSet = (JdbcRowSet)SqlUtil.executeQuery(ctx, sql);
            JdbcRowSet rowSet = new JdbcRowSet();
            rowSet.populate((ResultSet)sourceRowSet, start, rows, true);
            return rowSet;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        if (sql == null) {
            return null;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        paramsList.add(params);
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])((Object[])paramsList.get(0)));
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        if (sql == null) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static int executeUpdate(Context ctx, String sql) throws BOSException {
        if (sql == null) {
            return 0;
        }
        Connection conn = null;
        Statement stat = null;
        int rowNum = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stat = conn.createStatement();
            rowNum = stat.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stat, (Connection)conn);
        return rowNum;
    }

    public static int[] executeBatch(Context ctx, String sql, List<Object[]> params) throws BOSException {
        if (sql == null) {
            return null;
        }
        return DbUtil.executeBatchAndReturn((Context)ctx, (String)sql, params);
    }

    public static int[] executeBatch(Context ctx, String[] sqls) throws BOSException {
        int[] tempReturnValue3;
        if (sqls == null || sqls.length == 0) {
            return null;
        }
        int[] returnValue = new int[sqls.length];
        int realSize = 0;
        Connection conn = null;
        Statement stat = null;
        int k = 1;
        boolean flag = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stat = conn.createStatement();
            int size = sqls.length;
            for (int i = 0; i < size; ++i) {
                stat.addBatch(sqls[i]);
                flag = false;
                if (i != k * 1000 - 1) continue;
                flag = true;
                int[] tempReturnValue2 = stat.executeBatch();
                System.arraycopy(tempReturnValue2, 0, returnValue, realSize, tempReturnValue2.length);
                realSize += tempReturnValue2.length;
                ++k;
                stat.clearBatch();
            }
            if (!flag) {
                int[] tempReturnValue3 = stat.executeBatch();
                System.arraycopy(tempReturnValue3, 0, returnValue, realSize, tempReturnValue3.length);
            }
            tempReturnValue3 = returnValue;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stat, (Connection)conn);
        return tempReturnValue3;
    }

    public static IRowSet executeQuery(Context ctx, String sql, ParamData param) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException((Throwable)exc);
        }
        try {
            statement = conn.prepareStatement(sql);
            ParamData.setParamDataToStatement((ParamData)param, (PreparedStatement)statement);
            rs = statement.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }
}

