/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.card.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.card.model.CardParams;
import com.kingdee.shr.card.service.ICardService;
import com.kingdee.shr.common.util.SnowFlakeUtils;
import com.kingdee.shr.dataplatform.CardConfigCollection;
import com.kingdee.shr.dataplatform.CardConfigFactory;
import com.kingdee.shr.dataplatform.CardConfigInfo;
import com.kingdee.shr.dataplatform.DataSetConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.ICardConfig;
import com.kingdee.shr.dataplatform.IDataSetConfig;
import com.kingdee.shr.dataplatform.ISQLResult;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.SQLResultFactory;
import com.kingdee.shr.dataplatform.SQLResultInfo;
import com.kingdee.shr.dataplatform.SQLTypeEnum;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.DataSourceItem;
import com.kingdee.shr.dataset.model.JavaResult;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.DataPlatformServiceFactory;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.pageset.model.Children;
import com.kingdee.shr.pageset.util.PageSetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CardService
implements ICardService {
    private static final String RUN = "run";
    private static final String DESIGN = "design";
    private static final String SQL = "sql";
    private boolean isProductionMode = true;

    @Override
    public Object execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String type = (String)param.get("type");
        this.isProductionMode = (Boolean)param.get("isProductionMode");
        if (!StringUtils.isEmpty((CharSequence)type)) {
            String cardParamsJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)param.get("cardParams"));
            CardParams cardParams = (CardParams)JSONUtils.convertJsonToObject((Context)ctx, (String)cardParamsJson, CardParams.class);
            String cardPermItemId = cardParams.getCardPermItemId();
            if (StringUtils.isEmpty((CharSequence)cardPermItemId)) {
                cardParams.setCardPermItemId((String)param.get("permItemId"));
            }
            if (RUN.equals(type)) {
                if (PageSetUtils.checkPagePermission(ctx, PageSetUtils.getUipkByNodeId(ctx, cardParams.getCardNodeId())) && this.checkCardPermission(ctx, cardParams.getCardNodeId())) {
                    if (cardParams.isDrill()) {
                        this.getCardData(ctx, cardParams);
                    }
                    return this.getCardDataRun(ctx, cardParams);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("isPermission", false);
                map.put("nodeId", cardParams.getCardNodeId());
                return map;
            }
            if (DESIGN.equals(type)) {
                return this.getCardData(ctx, cardParams);
            }
            if (SQL.equals(type)) {
                return this.getCardSqlRuntime(ctx, cardParams);
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getCardData(Context ctx, CardParams cardParams) throws EASBizException, BOSException {
        DataResult data = this.getCardDataDesign(ctx, cardParams);
        return this.getAssembleResultData(data);
    }

    @Override
    public Map<String, Object> getCardDataRun(Context ctx, CardParams cardParams) throws EASBizException, BOSException {
        this.initCardParams(ctx, cardParams);
        if (StringUtils.isEmpty((CharSequence)cardParams.getDataSetId())) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"CardParams.dataSetId is empty "});
        }
        SQLResult sqlResult = (SQLResult)DataplatformCacheHelper.get(ctx, 3, cardParams.getCardNodeId());
        if (null == sqlResult) {
            sqlResult = this.getSQLResult(ctx, cardParams);
        } else {
            SQLResult sqlResultDataSet = (SQLResult)DataplatformCacheHelper.get(ctx, 2, cardParams.getDataSetId());
            if (sqlResultDataSet.getCurrentTimeStamp() >= sqlResult.getCurrentTimeStamp()) {
                sqlResult = this.getSQLResult(ctx, cardParams);
                ISQLResult iSQLResult = SQLResultFactory.getLocalInstance(ctx);
                String oql = "where boid = '" + cardParams.getCardNodeId() + "'";
                SQLResultInfo dbSQLResult = null;
                if (iSQLResult.exists(oql)) {
                    dbSQLResult = iSQLResult.getSQLResultInfo(oql);
                } else {
                    dbSQLResult = new SQLResultInfo();
                    dbSQLResult.setBoid(cardParams.getCardNodeId());
                    dbSQLResult.setType(SQLTypeEnum.CardSQL);
                }
                dbSQLResult.setContent(JSONUtils.convertObjectToJson((Context)ctx, (Object)sqlResult));
                iSQLResult.save((CoreBaseInfo)dbSQLResult);
                DataplatformCacheHelper.remove(ctx, 3, cardParams.getCardNodeId());
            }
        }
        DataResult data = this.getCardResultData(ctx, sqlResult, cardParams);
        return this.getAssembleResultData(data);
    }

    @Override
    public String getCardSqlRuntime(Context ctx, CardParams cardParams) throws EASBizException, BOSException {
        DataResult data = this.getCardDataDesign(ctx, cardParams);
        return data.getRuntimeSQL();
    }

    @Override
    public DataResult getCardDataDesign(Context ctx, CardParams cardParams) throws EASBizException, BOSException {
        this.initCardParams(ctx, cardParams);
        if (StringUtils.isEmpty((CharSequence)cardParams.getDataSetId())) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"CardParams.dataSetId is empty "});
        }
        SQLResult sqlResult = this.getSQLResult(ctx, cardParams);
        return this.getCardResultData(ctx, sqlResult, cardParams);
    }

    @Override
    public SQLResult getSQLResult(Context ctx, CardParams cardParams) throws EASBizException, BOSException {
        IDataPlatformService service = DataPlatformServiceFactory.getPlateformService("/dataplateform/showLevelSQL.do");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cardParams", cardParams);
        param.put("isProductionMode", this.isProductionMode);
        SQLResult sqlResult = (SQLResult)service.execute(ctx, param);
        IDataSetConfig iDataSetConfig = DataSetConfigFactory.getLocalInstance(ctx);
        DataSetConfigInfo info = iDataSetConfig.getDataSetConfigInfo((IObjectPK)new ObjectUuidPK(cardParams.getDataSetId()));
        sqlResult.setSetType(info.getSetType().getValue());
        DataSourceItem ds = new DataSourceItem();
        ds.setId(info.getDatasource().getId().toString());
        sqlResult.setDataSourceItem(ds);
        return sqlResult;
    }

    @Override
    public List<String> getReferCard(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String cardIds = (String)param.get("cardIds");
        ArrayList<String> cards = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)cardIds)) {
            String[] id = cardIds.split(",");
            if (id.length > 20) {
                throw new PageConfigException(PageConfigException.MAX_CARD_REFER);
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("content"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)cardIds, CompareType.INCLUDE));
            view.setSelector(selector);
            view.setFilter(filter);
            CardConfigCollection coll = CardConfigFactory.getLocalInstance(ctx).getCardConfigCollection(view);
            if (null != coll && !coll.isEmpty()) {
                for (int i = 0; i < coll.size(); ++i) {
                    CardConfigInfo cardConfigInfo = coll.get(i);
                    String card = cardConfigInfo.getContent();
                    String oldId = StringUtils.substringBetween((String)card, (String)"id\":\"", (String)"\"");
                    cards.add(card.replace(oldId, "refer" + SnowFlakeUtils.createID() + i));
                }
            }
        }
        return cards;
    }

    private Map<String, Object> getAssembleResultData(DataResult data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rows", data.getRows());
        map.put("records", data.getRecords());
        map.put("total", data.getTotal());
        map.put("page", data.getPage());
        return map;
    }

    private void initCardParams(Context ctx, CardParams cardParams) throws EASBizException, BOSException {
        String nodeId = cardParams.getCardNodeId();
        if (this.isValid(nodeId)) {
            ICardConfig iCardConfig = CardConfigFactory.getLocalInstance(ctx);
            if (!iCardConfig.exists((IObjectPK)new ObjectUuidPK(nodeId))) {
                throw new PageConfigException(PageConfigException.CARD_CHICK, new Object[]{nodeId});
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("dataSet.id"));
            selector.add(new SelectorItemInfo("permItem.id"));
            selector.add(new SelectorItemInfo("content"));
            CardConfigInfo cardConfigInfo = null;
            cardConfigInfo = iCardConfig.getCardConfigInfo((IObjectPK)new ObjectUuidPK(nodeId), selector);
            if (null != cardConfigInfo.getPermItem() && null != cardConfigInfo.getPermItem().getId()) {
                cardParams.setCardPermItemId(cardConfigInfo.getPermItem().getId().toString());
            }
            if (StringUtils.isEmpty((CharSequence)cardParams.getDataSetId()) && null != cardConfigInfo.getDataSet() && null != cardConfigInfo.getDataSet().getId()) {
                cardParams.setDataSetId(cardParams.getDataSetId());
            }
            if ((null == cardParams.getDimension() || cardParams.getDimension().isEmpty()) && (null == cardParams.getMeasure() || cardParams.getMeasure().isEmpty())) {
                Children children = (Children)JSONUtils.convertJsonToObject((Context)ctx, (String)cardConfigInfo.getContent(), Children.class);
                cardParams.setDimension(children.getProps().getDimension());
                cardParams.setMeasure(children.getProps().getMeasure());
            }
        } else if (this.isValid(cardParams.getDataSetId())) {
            cardParams.setCardPermItemId(cardParams.getCardPermItemId());
            cardParams.setDataSetId(cardParams.getDataSetId());
        }
    }

    private DataResult getCardResultData(Context ctx, SQLResult sqlResult, CardParams cardParams) throws EASBizException, BOSException {
        IDataPlatformService service = DataPlatformServiceFactory.getPlateformService("/dataplateform/datasetData.do");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sqlResult", sqlResult);
        param.put("isPreview", cardParams.isPreview());
        param.put("runParam", cardParams.getRunParam());
        param.put("isAll", cardParams.isAll());
        param.put("page", cardParams.getPage());
        param.put("rows", cardParams.getRows());
        param.put("drill", cardParams.isDrill());
        if (!StringUtils.isEmpty((CharSequence)cardParams.getCardPermItemId())) {
            param.put("permItemId", cardParams.getCardPermItemId());
        }
        DataResult data = (DataResult)service.execute(ctx, param);
        if (40 == sqlResult.getSetType()) {
            JavaResult jr = (JavaResult)sqlResult;
            data.setSourceSQL(jr.getClz());
            data.setRuntimeSQL(jr.getClz());
        }
        return data;
    }

    private boolean checkCardPermission(Context ctx, String id) throws EASBizException, BOSException {
        boolean isPermItem = true;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("permItem.id"));
        selector.add(new SelectorItemInfo("permItem.name"));
        selector.add(new SelectorItemInfo("permItem.number"));
        selector.add(new SelectorItemInfo("permItem.type"));
        selector.add(new SelectorItemInfo("permItem.orgRelation"));
        CardConfigInfo model = CardConfigFactory.getLocalInstance(ctx).getCardConfigInfo((IObjectPK)new ObjectUuidPK(id), selector);
        PermItemInfo permItemInfo = model.getPermItem();
        if (null != permItemInfo && null != permItemInfo.getId()) {
            isPermItem = PageSetUtils.checkPagePermissionBypermItemInfo(ctx, permItemInfo);
        }
        return isPermItem;
    }

    private boolean isValid(String id) {
        return BOSUuid.isValid((String)id, (boolean)false);
    }

    @Override
    public List<Map<String, Object>> getDesktopItem(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        return (List)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("getCommonUseFunctionItemList", param);
    }

    @Override
    public boolean addDesktopItem(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        return (Boolean)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("addCommonUseFunctionItem", param);
    }

    @Override
    public boolean removeDesktopItem(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        return (Boolean)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService("removeItem", param);
    }
}

