/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import com.kingdee.shr.common.util.CloseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class IOUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.common.util.IOUtils");
    private static final int BUFFER_SIZE = 32768;

    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File[] subs, String baseName, ZipOutputStream zos) throws IOException {
        for (int i = 0; i < subs.length; ++i) {
            File f = subs[i];
            if (f == null || !f.exists() || !f.isFile()) continue;
            FileInputStream fis = null;
            try {
                zos.putNextEntry(new ZipEntry(baseName + f.getName()));
                fis = new FileInputStream(f);
                byte[] buffer = new byte[1024];
                int r = 0;
                while ((r = fis.read(buffer)) != -1) {
                    zos.write(buffer, 0, r);
                }
            }
            catch (IOException e) {
                try {
                    logger.error((Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    CloseUtil.close(fis);
                    throw throwable;
                }
                CloseUtil.close(fis);
                continue;
            }
            CloseUtil.close(fis);
            continue;
        }
    }

    public static void copyFile(String from, String to) throws IOException {
        File fromFile = new File(from);
        File toFile = new File(to);
        File parent = toFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        IOUtils.copyFile(fromFile, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(from);
            fos = new FileOutputStream(to);
            in = fis.getChannel();
            out = fos.getChannel();
            in.transferTo(0L, in.size(), out);
        }
        catch (IOException e) {
            try {
                logger.error((Object)e.getMessage());
            }
            catch (Throwable throwable) {
                CloseUtil.close(fos, fis, in, out);
                throw throwable;
            }
            CloseUtil.close(fos, fis, in, out);
        }
        CloseUtil.close(fos, fis, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, File to) throws IOException {
        InputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = in;
            fos = new FileOutputStream(to);
            IOUtils.copy(fis, fos);
        }
        catch (IOException e) {
            try {
                logger.error((Object)e.getMessage());
            }
            catch (Throwable throwable) {
                CloseUtil.close(fos, fis);
                throw throwable;
            }
            CloseUtil.close(fos, fis);
        }
        CloseUtil.close(fos, fis);
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int size = 0;
        byte[] block = new byte[32768];
        int r = 0;
        while ((r = in.read(block)) != -1) {
            out.write(block, 0, r);
            size += r;
        }
        return size;
    }
}

