/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pageset.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.dataplatform.IWorkPFSolution;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.WorkPFSolutionFactory;
import com.kingdee.shr.dataplatform.WorkPFSolutionInfo;
import com.kingdee.shr.dataplatform.util.WorkPFSolutionUtils;
import com.kingdee.shr.pageset.model.Solution;
import com.kingdee.shr.pageset.service.IWorkPFSolutionService;
import com.kingdee.shr.pageset.util.PageSetUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WorkPFSolutionConfigService
implements IWorkPFSolutionService {
    private static final String SOLUTION_BOSTYPE = "6DBF7BDF";
    private static final String SOLUTION_ID_STR = "solutionId";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.pageset.service.WorkPFSolutionConfigService");

    @Override
    public IObjectPK doSave(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String solutionJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)param.get("solution"));
        Boolean isProductionMode = (Boolean)param.get("isProductionMode");
        Solution solution = (Solution)JSONUtils.convertJsonToObject((Context)ctx, (String)solutionJson, Solution.class);
        this.initWorkPlatformId(ctx, solution, param);
        CoreBaseInfo workPFSolutionInfo = solution.toSolutionInfo(ctx);
        workPFSolutionInfo.put("isProductionMode", (Object)isProductionMode);
        return WorkPFSolutionFactory.getLocalInstance(ctx).save(workPFSolutionInfo);
    }

    @Override
    public Solution init(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String solutionId = (String)param.get(SOLUTION_ID_STR);
        Boolean isProductionMode = (Boolean)param.get("isProductionMode");
        if (StringUtils.isEmpty((CharSequence)solutionId)) {
            return this.createNewSolution(isProductionMode);
        }
        return this.initSolution(ctx, solutionId);
    }

    @Override
    public String setIsDefault(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String solutionId = (String)param.get(SOLUTION_ID_STR);
        boolean isUserState = (Boolean)param.get("isUserState");
        if (StringUtils.isEmpty((CharSequence)solutionId)) {
            throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"params [solutionId] is empty."});
        }
        WorkPFSolutionFactory.getLocalInstance(ctx).setDefault(solutionId, isUserState);
        return solutionId;
    }

    @Override
    public String deleteSolutionById(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String solutionId = (String)param.get(SOLUTION_ID_STR);
        boolean isUserState = (Boolean)param.get("isUserState");
        if (!StringUtils.isEmpty((CharSequence)solutionId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)solutionId));
            IWorkPFSolution iWorkPFSolution = WorkPFSolutionFactory.getLocalInstance(ctx);
            if (iWorkPFSolution.exists(filter)) {
                iWorkPFSolution.deleteById(solutionId, isUserState);
                return solutionId;
            }
        }
        return null;
    }

    private Solution initSolution(Context ctx, String solutionId) throws BOSException, EASBizException {
        return new Solution().toSolution(ctx, solutionId);
    }

    private Solution createNewSolution(Boolean isProductionMode) {
        Solution solution = new Solution();
        solution.setPreSet(true);
        solution.setSolutionId(BOSUuid.create((String)SOLUTION_BOSTYPE).toString());
        solution.setSolutionName(PageSetUtils.initMutiLanField((IObjectValue)new WorkPFSolutionInfo()));
        solution.setSchema("");
        solution.setWorkPlatformId("");
        solution.setSolutionType(1);
        if (Boolean.TRUE.equals(isProductionMode)) {
            solution.setPreSet(false);
        }
        return solution;
    }

    private void initWorkPlatformId(Context ctx, Solution solution, Map<String, Object> param) throws EASBizException, BOSException {
        String uipk;
        if (null != solution && StringUtils.isEmpty((CharSequence)solution.getWorkPlatformId()) && !StringUtils.isEmpty((CharSequence)(uipk = (String)param.get("uipk")))) {
            String workPlatfromId = WorkPFSolutionUtils.getWorkPlatfromIdByUipk(ctx, uipk);
            if (!StringUtils.isEmpty((CharSequence)workPlatfromId)) {
                solution.setWorkPlatformId(workPlatfromId);
            } else {
                throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"params [workPlatfromId] is empty."});
            }
        }
    }

    @Override
    public Object execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        return null;
    }
}

