/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pageset.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.syssetting.IWorkPlatform;
import com.kingdee.shr.base.syssetting.WorkPlatformCollection;
import com.kingdee.shr.base.syssetting.WorkPlatformFactory;
import com.kingdee.shr.base.syssetting.WorkPlatformInfo;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.dataplatform.CardConfigFactory;
import com.kingdee.shr.dataplatform.CardConfigInfo;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.ICardConfig;
import com.kingdee.shr.dataplatform.IPageConfig;
import com.kingdee.shr.dataplatform.PageConfigCollection;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.PageConfigFactory;
import com.kingdee.shr.dataplatform.PageConfigInfo;
import com.kingdee.shr.dataplatform.ShrBizDomainInfo;
import com.kingdee.shr.dataplatform.WorkPFSolutionInfo;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.pageset.model.Page;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PageSetUtils {
    private static final String CARD_ID = "8CD3A671";

    private PageSetUtils() {
    }

    public static boolean isVaild(String id, ICoreBase imodel) throws EASBizException, BOSException {
        return BOSUuid.isValid((String)id, (boolean)true) && imodel.exists((IObjectPK)new ObjectUuidPK(id));
    }

    public static String getWorklatfromIdByUipk(Context ctx, String uipk) throws BOSException {
        WorkPlatformInfo workPlatformInfo;
        IWorkPlatform iWorkPlatform = WorkPlatformFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
        filter.getFilterItems().add(new FilterItemInfo("isNew", (Object)true));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("uipk"));
        view.setSelector(selector);
        WorkPlatformCollection collWorkPlatform = iWorkPlatform.getWorkPlatformCollection(view);
        if (null != collWorkPlatform && collWorkPlatform.size() > 0 && null != (workPlatformInfo = collWorkPlatform.get(0))) {
            return workPlatformInfo.getId().toString();
        }
        return null;
    }

    public static CoreBaseCollection getCards(Context ctx, WorkPFSolutionInfo solutionInfo, PageConfigInfo pageInfo, String content, CoreBaseCollection cards, boolean isExtend) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return cards;
        }
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)content);
        List list = (List)map.get("componentsTree");
        Map page = (Map)list.get(0);
        if (page.get("children") instanceof List) {
            List childList = (List)page.get("children");
            if (null == childList || childList.isEmpty()) {
                return cards;
            }
            PageSetUtils.getCard(ctx, solutionInfo, pageInfo, cards, content, isExtend, childList);
        }
        return cards;
    }

    private static CoreBaseCollection getCard(Context ctx, WorkPFSolutionInfo solutionInfo, PageConfigInfo pageConfigInfo, CoreBaseCollection coll, String content, boolean isExtend, List<Map<String, Object>> childList) throws BOSException, EASBizException {
        ICardConfig iCardConfig = CardConfigFactory.getLocalInstance(ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp createtime = PageSetUtils.getTime();
        int total = childList.size();
        for (int i = 0; i < total; ++i) {
            String id;
            Map<String, Object> each = childList.get(i);
            String cardContent = JSONUtils.convertObjectToJson((Context)ctx, each);
            CardConfigInfo info = null;
            String nodeID = id = (String)each.get("id");
            if (!(solutionInfo != null && solutionInfo.isIsPreset() || !isExtend || nodeID.contains("_copy"))) {
                nodeID = MessageFormat.format("{0}_copy", nodeID);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("nodeID", (Object)nodeID));
            filter.getFilterItems().add(new FilterItemInfo("page.id", (Object)pageConfigInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("solution.id", null != solutionInfo ? solutionInfo.getId().toString() : null));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
            if (BOSUuid.isValid((String)id, (boolean)true) && iCardConfig.exists(filter)) {
                info = iCardConfig.getCardConfigInfo((IObjectPK)new ObjectUuidPK(id));
                info.setContent(cardContent);
            } else {
                BOSUuid cardId = BOSUuid.create((String)CARD_ID);
                info = new CardConfigInfo();
                info.setId(cardId);
                content = content.replace(id, cardId.toString());
                cardContent = cardContent.replace(id, cardId.toString());
                info.setContent(cardContent);
                if (isExtend) {
                    pageConfigInfo.setExtend(content);
                    info.setNodeID(MessageFormat.format("{0}_copy", cardId));
                    info.setIsPreset(false);
                    if (solutionInfo != null && solutionInfo.isIsPreset()) {
                        info.setNodeID(cardId.toString());
                        info.setIsPreset(true);
                    }
                } else {
                    pageConfigInfo.setContent(content);
                    info.setNodeID(cardId.toString());
                    info.setIsPreset(true);
                }
                info.setPage(pageConfigInfo);
                info.setSolution(solutionInfo);
                info.setCreator(userInfo);
                info.setCreateTime(createtime);
                info.setCU(pageConfigInfo.getCU());
                SHRCodingRuleApi.setNumberFromCodingRule((Context)ctx, (IObjectValue)info, (String)ContextUtil.getCurrentOrgUnit((Context)ctx).toString());
            }
            info.setLastUpdateUser(userInfo);
            info.setLastUpdateTime(createtime);
            Map props = (Map)each.get("props");
            PageSetUtils.initCardConfigInfo(ctx, info, props);
            coll.add((CoreBaseInfo)info);
            List children = (List)each.get("children");
            if (null == children || children.isEmpty()) continue;
            PageSetUtils.getCard(ctx, solutionInfo, pageConfigInfo, coll, content, isExtend, children);
        }
        return coll;
    }

    private static void initCardConfigInfo(Context ctx, CardConfigInfo cardConfigInfo, Map<String, Object> props) throws EASBizException, BOSException {
        if (null == props) {
            return;
        }
        if (props.get("chartTitle") instanceof Map) {
            Map temp = (Map)props.get("chartTitle");
            for (Map.Entry entry : temp.entrySet()) {
                Locale l = LocaleUtils.getLocale((String)((String)entry.getKey()));
                if (l.equals(ctx.getLocale())) {
                    if (StringUtils.isEmpty((CharSequence)entry.getValue())) {
                        throw new PageConfigException(PageConfigException.NAME_CARD_NON);
                    }
                    cardConfigInfo.setName((String)entry.getValue());
                }
                cardConfigInfo.put("name", entry.getValue(), l);
            }
        } else {
            if (props.get("chartTitle") instanceof String) {
                throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{" Expected chartTitle is Map Object but was STRING."});
            }
            throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{" Please check chartTitle!"});
        }
        if (StringUtils.isEmpty((CharSequence)cardConfigInfo.getNumber())) {
            throw new PageConfigException(PageConfigException.NUMBER_CARD_NON, new Object[]{cardConfigInfo.getName()});
        }
        if (props.get("dataSetConfig") instanceof Map) {
            Map dscMap = (Map)props.get("dataSetConfig");
            DataSetConfigInfo dsc = new DataSetConfigInfo();
            String dataSetId = (String)dscMap.get("id");
            if (!StringUtils.isEmpty((CharSequence)dataSetId)) {
                dsc.setId(BOSUuid.read((String)dataSetId));
                cardConfigInfo.setDataSet(dsc);
            } else {
                cardConfigInfo.setDataSet(null);
            }
        }
        if (props.get("bizDomain") instanceof Map) {
            Map bizDomain = (Map)props.get("bizDomain");
            ShrBizDomainInfo sbd = new ShrBizDomainInfo();
            String domainId = (String)bizDomain.get("id");
            if (!StringUtils.isEmpty((CharSequence)domainId)) {
                sbd.setId(BOSUuid.read((String)domainId));
                cardConfigInfo.setDomain(sbd);
            } else {
                throw new PageConfigException(PageConfigException.BIZ_DOMAIM_CARD_NON, new Object[]{cardConfigInfo.getName()});
            }
        }
        if (props.get("permission") instanceof Map) {
            Map permission = (Map)props.get("permission");
            PermItemInfo pii = new PermItemInfo();
            String permissionId = (String)permission.get("id");
            if (!StringUtils.isEmpty((CharSequence)permissionId)) {
                pii.setId(BOSUuid.read((String)permissionId));
                cardConfigInfo.setPermItem(pii);
            } else {
                cardConfigInfo.setPermItem(null);
            }
        }
    }

    public static Map<String, String> initMutiLanField(IObjectValue model) {
        HashMap<String, String> m = new HashMap<String, String>();
        List lml = BOSConfigUtil.getLanguageMapingList();
        Map lang = null;
        int total = lml.size();
        for (int i = 0; i < total; ++i) {
            lang = (Map)lml.get(i);
            m.put((String)lang.get("lang"), ((String)lang.get("lang")).equals(model.get("name_" + (String)lang.get("lang"))) ? "" : (String)model.get("name_" + (String)lang.get("lang")));
        }
        return m;
    }

    public static void setMutiLanField(Context ctx, Map<String, String> map, IObjectValue model) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Locale l = LocaleUtils.getLocale((String)entry.getKey());
            if (l.equals(ctx.getLocale())) {
                model.put("name", (Object)entry.getValue());
            }
            model.put("name", (Object)entry.getValue(), l);
        }
    }

    public static String getPageInfoIdByUipk(Context ctx, String uipk) throws BOSException {
        PageConfigInfo pageConfigInfo;
        IPageConfig iPageConfig = PageConfigFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        view.setFilter(filter);
        PageConfigCollection coll = iPageConfig.getPageConfigCollection(view);
        if (null != coll && !coll.isEmpty() && null != (pageConfigInfo = coll.get(0))) {
            return pageConfigInfo.getId().toString();
        }
        return null;
    }

    public static String getUipkById(Context ctx, String id) throws BOSException, EASBizException {
        IPageConfig iPageConfig = PageConfigFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("uipk"));
        PageConfigInfo model = iPageConfig.getPageConfigInfo((IObjectPK)new ObjectUuidPK(id), selector);
        if (null != model) {
            return model.getUipk();
        }
        return null;
    }

    public static String getUipkByNodeId(Context ctx, String id) throws BOSException, EASBizException {
        ICardConfig iCardConfig = CardConfigFactory.getLocalInstance(ctx);
        if (!BOSUuid.isValid((String)id, (boolean)false) || !iCardConfig.exists((IObjectPK)new ObjectUuidPK(id))) {
            throw new PageConfigException(PageConfigException.CARD_CHICK, new Object[]{id});
        }
        SelectorItemCollection selector0 = new SelectorItemCollection();
        selector0.add(new SelectorItemInfo("page.id"));
        CardConfigInfo cardConfigInfo = iCardConfig.getCardConfigInfo((IObjectPK)new ObjectUuidPK(id), selector0);
        if (null == cardConfigInfo.getPage() || null == cardConfigInfo.getPage().getId()) {
            throw new PageConfigException(PageConfigException.CARD_CHICK_REFER_PAGE, new Object[]{id});
        }
        return PageSetUtils.getUipkById(ctx, cardConfigInfo.getPage().getId().toString());
    }

    public static boolean checkPagePermission(Context ctx, String uipk) throws BOSException, EASBizException {
        String permItemUrl = MessageFormat.format("/dynamic.do?method=initalize#uri={0}", uipk);
        PermItemInfo permItemInfo = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)permItemUrl);
        return PageSetUtils.checkPagePermissionBypermItemInfo(ctx, permItemInfo);
    }

    public static boolean checkPagePermissionBypermItemInfo(Context ctx, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        boolean isPermItem = true;
        if (null == permItemInfo) {
            return false;
        }
        try {
            SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItemInfo);
        }
        catch (ShrPermissionException e) {
            isPermItem = false;
        }
        catch (PermissionException e1) {
            isPermItem = false;
        }
        return isPermItem;
    }

    public static void permissionVerification(Context ctx, String content, Page model) throws EASBizException, BOSException {
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)content);
        List list = (List)map.get("componentsTree");
        Map page = (Map)list.get(0);
        Map props = (Map)page.get("props");
        if (props.get("navBarData") instanceof List) {
            List navBarData = (List)props.get("navBarData");
            ArrayList<Map> navBarDataNew = new ArrayList<Map>();
            if (null == navBarData || navBarData.isEmpty()) {
                return;
            }
            for (int i = 0; i < navBarData.size(); ++i) {
                Map navBarF7 = (Map)navBarData.get(i);
                Map navBar = (Map)navBarF7.get("navBarF7");
                if (null != navBar.get("uipk") && !PageSetUtils.checkPagePermission(ctx, (String)navBar.get("uipk"))) continue;
                navBarDataNew.add(navBarF7);
                if (!(navBarF7.get("children") instanceof List)) continue;
                List navBarChilds = (List)navBarF7.get("children");
                ArrayList<Map> navBarChildsNew = new ArrayList<Map>();
                for (int j = 0; j < navBarChilds.size(); ++j) {
                    Map navBarF7Child = (Map)navBarChilds.get(j);
                    Map navBarChild = (Map)navBarF7Child.get("navBarF7");
                    if (null != navBarChild.get("uipk") && !PageSetUtils.checkPagePermission(ctx, (String)navBarChild.get("uipk"))) continue;
                    navBarChildsNew.add(navBarF7Child);
                }
                navBarF7.put("children", navBarChildsNew);
            }
            props.put("navBarData", navBarDataNew);
            model.setSchema(JSONUtils.convertObjectToJson((Context)ctx, (Object)map));
        }
    }

    public static Map<String, String> getPageUipkMap(Context ctx, String uipk, String pageId) throws EASBizException, BOSException {
        HashMap<String, String> uipkMap = new HashMap<String, String>();
        String content = PageSetUtils.getContentByUipk(ctx, uipk);
        if (StringUtils.isEmpty((CharSequence)content)) {
            return uipkMap;
        }
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)content);
        List list = (List)map.get("componentsTree");
        Map page = (Map)list.get(0);
        Map props = (Map)page.get("props");
        if (props.get("navBarData") instanceof List) {
            List navBarData = (List)props.get("navBarData");
            if (null == navBarData || navBarData.isEmpty()) {
                return uipkMap;
            }
            for (int i = 0; i < navBarData.size(); ++i) {
                Map navBarF7 = (Map)navBarData.get(i);
                Map navBar = (Map)navBarF7.get("navBarF7");
                if (null != navBar.get("uipk") && PageSetUtils.checkPagePermission(ctx, (String)navBar.get("uipk"))) {
                    uipkMap.put((String)navBar.get("uipk"), (String)navBar.get("id"));
                }
                if (!(navBarF7.get("children") instanceof List)) continue;
                List navBarChilds = (List)navBarF7.get("children");
                for (int j = 0; j < navBarChilds.size(); ++j) {
                    Map navBarF7Child = (Map)navBarChilds.get(j);
                    Map navBarChild = (Map)navBarF7Child.get("navBarF7");
                    if (null == navBarChild.get("uipk") || !PageSetUtils.checkPagePermission(ctx, (String)navBarChild.get("uipk"))) continue;
                    uipkMap.put((String)navBarChild.get("uipk"), (String)navBarChild.get("id"));
                }
            }
        } else {
            String pageInfoId = PageSetUtils.getPageInfoIdByUipk(ctx, uipk);
            if (StringUtils.isEmpty((CharSequence)pageInfoId) || !pageInfoId.equals(pageId)) {
                throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"uipk does not match pageId!"});
            }
        }
        return uipkMap;
    }

    public static Set<String> getPageUipkSet(Context ctx, String uipk, Set<String> set) throws EASBizException, BOSException {
        String content = PageSetUtils.getContentByUipk(ctx, uipk);
        if (StringUtils.isEmpty((CharSequence)content)) {
            return set;
        }
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)content);
        List list = (List)map.get("componentsTree");
        Map page = (Map)list.get(0);
        Map props = (Map)page.get("props");
        if (props.get("navBarData") instanceof List) {
            List navBarData = (List)props.get("navBarData");
            if (null == navBarData || navBarData.isEmpty()) {
                return set;
            }
            for (int i = 0; i < navBarData.size(); ++i) {
                Map navBarF7 = (Map)navBarData.get(i);
                Map navBar = (Map)navBarF7.get("navBarF7");
                if (null != navBar.get("uipk") && PageSetUtils.checkPagePermission(ctx, (String)navBar.get("uipk"))) {
                    set.add((String)navBar.get("uipk"));
                }
                if (!(navBarF7.get("children") instanceof List)) continue;
                List navBarChilds = (List)navBarF7.get("children");
                for (int j = 0; j < navBarChilds.size(); ++j) {
                    Map navBarF7Child = (Map)navBarChilds.get(j);
                    Map navBarChild = (Map)navBarF7Child.get("navBarF7");
                    if (null == navBarChild.get("uipk") || !PageSetUtils.checkPagePermission(ctx, (String)navBarChild.get("uipk"))) continue;
                    set.add((String)navBarChild.get("uipk"));
                }
            }
        } else {
            set.add(uipk);
        }
        return set;
    }

    private static String getContentByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        String pageId = PageSetUtils.getPageInfoIdByUipk(ctx, uipk);
        if (!StringUtils.isEmpty((CharSequence)pageId)) {
            PageConfigInfo model = PageConfigFactory.getLocalInstance(ctx).getPageConfigInfo((IObjectPK)new ObjectUuidPK(pageId));
            String content = model.getContent();
            if (!StringUtils.isEmpty((CharSequence)model.getExtend())) {
                content = model.getExtend();
            }
            return content;
        }
        return null;
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

