/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.response;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.common.response.AbstractResponseWrap;
import com.kingdee.shr.common.response.StackTraceUtil;
import org.apache.log4j.Logger;

public class ResponseErrorWrap
extends AbstractResponseWrap {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.common.response.ResponseErrorWrap");
    private static final long serialVersionUID = 2453304714744782297L;
    private static int defaultErrorCode = 500;
    private int errorCode;
    private String errorMessage;
    private String errorStackMessage;

    public ResponseErrorWrap(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ResponseErrorWrap(int errorCode, String errorMessage, Throwable exception) {
        BOSException e = this.getBOSException(exception);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.errorStackMessage = StackTraceUtil.getStackTrace((Throwable)e);
        logger.error((Object)exception.getMessage(), exception);
    }

    public ResponseErrorWrap(String errorMessage, Throwable exception) {
        this.errorCode = defaultErrorCode;
        this.errorMessage = errorMessage;
        logger.error((Object)exception.getMessage(), exception);
    }

    public ResponseErrorWrap(Throwable exception) {
        BOSException e = this.getBOSException(exception);
        this.errorCode = defaultErrorCode;
        this.errorMessage = e.getMessage();
        this.errorStackMessage = StackTraceUtil.getStackTrace((Throwable)e);
        logger.error((Object)exception.getMessage(), exception);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorStackMessage() {
        return this.errorStackMessage;
    }

    public void setErrorStackMessage(String errorStackMessage) {
        this.errorStackMessage = errorStackMessage;
    }

    private BOSException getBOSException(Throwable exception) {
        BOSException e = null;
        e = !(exception instanceof BOSException) ? new BOSException(exception) : (BOSException)exception;
        return e;
    }
}

