/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.HisOperateEnum;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.dataplatform.CardConfigFactory;
import com.kingdee.shr.dataplatform.DSConfigInfo;
import com.kingdee.shr.dataplatform.DataSetConfigCollection;
import com.kingdee.shr.dataplatform.DataSetConfigExtCollection;
import com.kingdee.shr.dataplatform.DataSetConfigExtFactory;
import com.kingdee.shr.dataplatform.DataSetConfigExtInfo;
import com.kingdee.shr.dataplatform.DataSetConfigHisFactory;
import com.kingdee.shr.dataplatform.DataSetConfigHisInfo;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.IDataSetConfigExt;
import com.kingdee.shr.dataplatform.IDataSetConfigHis;
import com.kingdee.shr.dataplatform.SQLResultFactory;
import com.kingdee.shr.dataplatform.app.AbstractDataSetConfigControllerBean;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.util.DataSetUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DataSetConfigControllerBean
extends AbstractDataSetConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.DataSetConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataSetConfigInfo info = (DataSetConfigInfo)model;
        this._checkNumberDup(ctx, model);
        DataSetUtils.checkNumberRule(info.getNumber());
        if (null == info.getDatasource()) {
            DSConfigInfo dsInfo = new DSConfigInfo();
            dsInfo.setId(BOSUuid.read((String)"ILeTYP+2/kulvw58JCQfXiFEaFA="));
            info.setDatasource(dsInfo);
        }
        String extend = info.getExtend();
        String content = info.getContent();
        if (StringUtils.isEmpty((String)extend) && StringUtils.isEmpty((String)content)) {
            throw new DataSetException(DataSetException.CONTENT_OR_EXTEND_NON);
        }
        if (info.isIsPreset() && StringUtils.isEmpty((String)content)) {
            throw new DataSetException(DataSetException.CONTEND_PRESET_NON);
        }
        boolean isExtend = false;
        if (!StringUtils.isEmpty((String)extend)) {
            isExtend = true;
            info.setExtend(null);
        }
        IObjectPK pk = null;
        boolean isProductionMode = (Boolean)info.get("isProductionMode");
        if (null != info.getId() && info.isIsPreset() && isProductionMode) {
            pk = new ObjectUuidPK(info.getId());
        } else {
            pk = super._save(ctx, (IObjectValue)info);
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        if (isProductionMode || !info.isIsPreset()) {
            this.saveExtend(ctx, info, extend, isExtend);
        }
        String realContent = content;
        if (isExtend) {
            realContent = extend;
        }
        DataSetUtils.saveSQLResultInfo(ctx, pk, realContent, info.getDatasource().getId().toString(), info.getSetType());
        if (isProductionMode) {
            this.addDataSetConfigHis(ctx, info.getId().toString(), HisOperateEnum.save, null);
        }
        return pk;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DataSetConfigInfo model = (DataSetConfigInfo)super._getValue(ctx, pk);
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iDataSetConfigExt, model);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        DataSetConfigInfo model = (DataSetConfigInfo)super._getValue(ctx, pk, selector);
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iDataSetConfigExt, model);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        DataSetConfigInfo model = (DataSetConfigInfo)super._getValue(ctx, pk, selector, sorter);
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iDataSetConfigExt, model);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        DataSetConfigInfo model = (DataSetConfigInfo)super._getValue(ctx, pk, sorter);
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iDataSetConfigExt, model);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        DataSetConfigInfo model = (DataSetConfigInfo)super._getValue(ctx, oql);
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        this.mergeExtInfo(iDataSetConfigExt, model);
        return model;
    }

    @Override
    public DataSetConfigCollection getDataSetConfigCollection(Context ctx, EntityViewInfo view) throws BOSException {
        DataSetConfigCollection coll = super.getDataSetConfigCollection(ctx, view);
        return this.doGetCollection(ctx, coll);
    }

    @Override
    public DataSetConfigCollection getDataSetConfigCollection(Context ctx) throws BOSException {
        DataSetConfigCollection coll = super.getDataSetConfigCollection(ctx);
        return this.doGetCollection(ctx, coll);
    }

    @Override
    public DataSetConfigCollection getDataSetConfigCollection(Context ctx, String oql) throws BOSException {
        DataSetConfigCollection coll = super.getDataSetConfigCollection(ctx, oql);
        return this.doGetCollection(ctx, coll);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)1));
        if (this._exists(ctx, filter)) {
            throw new DataSetException(DataSetException.PRESET_VIEW_NOT_DELETE);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("dataSet.id", (Object)pk.toString()));
        if (CardConfigFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new DataSetException(DataSetException.EXIST_CARD_REFER);
        }
        DataSetConfigInfo info = this.getDataSetConfigInfo(ctx, pk);
        DataSetConfigExtInfo extInfo = this.deleteExtInfo(ctx, pk);
        super._delete(ctx, pk);
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)pk.toString()));
        SQLResultFactory.getLocalInstance(ctx).delete(filterInfo);
        DataplatformCacheHelper.remove(ctx, 2, pk.toString());
        this.addDataSetConfigHis(ctx, info, extInfo, HisOperateEnum.delete, null);
    }

    @Override
    protected void _deleteDev(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("dataSet.id", (Object)pk.toString()));
        if (CardConfigFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new DataSetException(DataSetException.EXIST_CARD_REFER);
        }
        this.deleteExtInfo(ctx, pk);
        super._delete(ctx, pk);
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)pk.toString()));
        SQLResultFactory.getLocalInstance(ctx).delete(filterInfo);
        DataplatformCacheHelper.remove(ctx, 2, pk.toString());
    }

    private DataSetConfigExtInfo deleteExtInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString()));
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        DataSetConfigExtCollection coll = iDataSetConfigExt.getDataSetConfigExtCollection(view);
        iDataSetConfigExt.delete(filterInfo);
        if (null != coll && !coll.isEmpty()) {
            return coll.get(0);
        }
        return null;
    }

    private void saveExtend(Context ctx, DataSetConfigInfo pModel, String extend, boolean isExtend) throws BOSException, EASBizException {
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pModel.getId().toString()));
        DataSetConfigExtInfo model = null;
        if (iDataSetConfigExt.exists(filter)) {
            if (!isExtend) {
                iDataSetConfigExt.delete(filter);
                return;
            }
            model = iDataSetConfigExt.getDataSetConfigExtInfo("where parent.id='" + pModel.getId().toString() + "'");
        } else {
            if (!isExtend) {
                return;
            }
            model = new DataSetConfigExtInfo();
            model.setParent(pModel);
        }
        model.setContent(extend);
        iDataSetConfigExt.save((CoreBaseInfo)model);
    }

    private DataSetConfigCollection doGetCollection(Context ctx, DataSetConfigCollection coll) throws BOSException {
        if (coll != null && coll.size() > 0) {
            IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                DataSetConfigInfo info = coll.get(i);
                this.mergeExtInfo(iDataSetConfigExt, info);
            }
        }
        return coll;
    }

    private IObjectValue mergeExtInfo(IDataSetConfigExt iDataSetConfigExt, DataSetConfigInfo dataSetConfigInfo) throws BOSException {
        if (null == dataSetConfigInfo) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)dataSetConfigInfo.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("content"));
        DataSetConfigExtCollection coll = iDataSetConfigExt.getDataSetConfigExtCollection(viewInfo);
        if (null != coll && coll.size() > 0) {
            DataSetConfigExtInfo info = coll.get(0);
            dataSetConfigInfo.setExtend(info.getContent());
        }
        return dataSetConfigInfo;
    }

    @Override
    protected void _revert(Context ctx, String dataSetId, String hisId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)dataSetId));
        IDataSetConfigExt iDataSetConfigExt = DataSetConfigExtFactory.getLocalInstance(ctx);
        IDataSetConfigHis iDataSetConfigHis = DataSetConfigHisFactory.getLocalInstance(ctx);
        DataSetConfigHisInfo hisModel = iDataSetConfigHis.getDataSetConfigHisInfo((IObjectPK)new ObjectUuidPK(hisId));
        if (HisOperateEnum.delete.equals((Object)hisModel.getOptType())) {
            throw new SyssettinException(SyssettinException.DELETE_NOT_REVERT);
        }
        HashMap contentMap = JSONUtils.convertJsonToObject((Context)ctx, (String)hisModel.getContent());
        DataSetConfigInfo dataSetConfigInfoHis = (DataSetConfigInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)contentMap.get("DataSetConfigInfo")), DataSetConfigInfo.class);
        DataSetConfigExtInfo dataSetConfigExtInfoHis = (DataSetConfigExtInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)((String)contentMap.get("DataSetConfigExtInfo")), DataSetConfigExtInfo.class);
        if (null == dataSetConfigExtInfoHis) {
            iDataSetConfigExt.delete(filterInfo);
            this.addDataSetConfigHis(ctx, dataSetId, HisOperateEnum.revert, hisModel.getId().toString());
        } else {
            DataSetConfigExtInfo model = new DataSetConfigExtInfo();
            String oql = "where id ='" + dataSetId + "'";
            DataSetConfigInfo oldInfo = null;
            if (this._exists(ctx, oql)) {
                oldInfo = this.getDataSetConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(dataSetId));
            } else {
                this._save(ctx, (IObjectPK)new ObjectUuidPK(dataSetConfigInfoHis.getId()), (IObjectValue)dataSetConfigInfoHis);
                oldInfo = dataSetConfigInfoHis;
            }
            if (iDataSetConfigExt.exists(filterInfo)) {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filterInfo);
                DataSetConfigExtCollection coll = iDataSetConfigExt.getDataSetConfigExtCollection(view);
                model.setId(coll.get(0).getId());
                model.setContent(dataSetConfigExtInfoHis.getContent());
                model.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                model.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                model.setParent(oldInfo);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("content");
                selector.add("parent");
                selector.add("lastUpdateUser");
                selector.add("lastUpdateTime");
                iDataSetConfigExt.updatePartial((CoreBaseInfo)model, selector);
            } else {
                model.setContent(dataSetConfigExtInfoHis.getContent());
                model.setParent(oldInfo);
                iDataSetConfigExt.addnew((CoreBaseInfo)model);
            }
            this.addDataSetConfigHis(ctx, dataSetId, HisOperateEnum.revert, hisModel.getId().toString());
        }
    }

    @Override
    protected void _recImport(Context ctx, String dataSetId) throws BOSException, EASBizException {
        DataSetConfigExtInfo dataSetConfigExtInfo = DataSetConfigExtFactory.getLocalInstance(ctx).getDataSetConfigExtInfo((IObjectPK)new ObjectUuidPK(dataSetId));
        DataSetConfigInfo model = this.getDataSetConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(dataSetConfigExtInfo.getParent().getId()));
        this.addDataSetConfigHis(ctx, model, dataSetConfigExtInfo, HisOperateEnum.importScript, null);
    }

    private void addDataSetConfigHis(Context ctx, String dataSetId, HisOperateEnum optType, String hisId) throws EASBizException, BOSException {
        DataSetConfigInfo dataSetConfigInfo = (DataSetConfigInfo)super._getValue(ctx, " where id = '" + dataSetId + "'");
        DataSetConfigExtCollection coll = DataSetConfigExtFactory.getLocalInstance(ctx).getDataSetConfigExtCollection(" where parent.id = '" + dataSetConfigInfo.getId().toString() + "'");
        DataSetConfigExtInfo dataSetConfigExtInfo = null;
        if (null != coll && !coll.isEmpty()) {
            dataSetConfigExtInfo = coll.get(0);
        }
        this.addDataSetConfigHis(ctx, dataSetConfigInfo, dataSetConfigExtInfo, optType, hisId);
    }

    private void addDataSetConfigHis(Context ctx, DataSetConfigInfo dataSetConfigInfo, DataSetConfigExtInfo dataSetConfigExtInfo, HisOperateEnum optType, String hisId) throws EASBizException, BOSException {
        DataSetConfigHisInfo model = new DataSetConfigHisInfo();
        model.setHisRelateID(dataSetConfigInfo.getId().toString());
        HashMap<String, String> contentMap = new HashMap<String, String>(2);
        contentMap.put("DataSetConfigInfo", JSONUtils.convertObjectToJson((Context)ctx, (Object)dataSetConfigInfo));
        if (null == dataSetConfigExtInfo) {
            contentMap.put("DataSetConfigExtInfo", null);
        } else {
            contentMap.put("DataSetConfigExtInfo", JSONUtils.convertObjectToJson((Context)ctx, (Object)dataSetConfigExtInfo));
        }
        model.setContent(JSONUtils.convertObjectToJson((Context)ctx, contentMap));
        model.setOptType(optType);
        model.setRevertID(hisId);
        DataSetConfigHisFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)model);
    }
}

