/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.OtherFollowLaborConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.econtractservice.EContractCompanyTaskInfo;
import com.kingdee.shr.econtractservice.EContractSendMessageFacadeFactory;
import com.kingdee.shr.econtractservice.EContractServiceFacadeFactory;
import com.kingdee.shr.econtractservice.IEContractServiceFacade;
import com.kingdee.shr.econtractservice.ISSCEContractTaskFacade;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.SSCEContractTaskFacadeFactory;
import com.kingdee.shr.econtractservice.SSCEContractTaskInfo;
import com.kingdee.shr.econtractservice.service.EContractService;
import com.kingdee.shr.econtractservice.service.ITaskThread;
import com.kingdee.shr.econtractservice.util.EContractConstants;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthResult;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECompanyTaskThread
implements Runnable,
ITaskThread {
    private static final long serialVersionUID = 455042313124022021L;
    private static final Logger logger = LoggerFactory.getLogger(ECompanyTaskThread.class);
    protected static final SecureRandom random = new SecureRandom();
    private String threadName;
    private CountDownLatch latch;
    private Context ctx;
    private String jobId;
    private String billId;
    private String entryId;
    private String bussAttrId;
    private Map<String, Object> dataMap;
    private Map<?, ?> otherParam;
    private String taskType = "COMPANY";
    protected static final int MAX_TRYTIMES = 15;
    private BatchMessageTipsBody messageTips;
    private String message = "";
    private boolean state = false;

    public ECompanyTaskThread(Context ctx, CountDownLatch latch, String jobId, String billId, Map dataMap, Map otherParam, BatchMessageTipsBody messageTips) {
        this.ctx = ctx;
        this.latch = latch;
        this.jobId = jobId;
        this.billId = billId;
        this.dataMap = dataMap;
        this.bussAttrId = (String)this.dataMap.get("bussAttrID");
        if (StringUtils.isEmpty((CharSequence)this.bussAttrId)) {
            this.bussAttrId = (String)this.dataMap.get("bussAttrID.id");
        }
        this.otherParam = otherParam;
        if (messageTips == null) {
            messageTips = new BatchMessageTipsBody();
        }
        messageTips.setMuitTipsState(false);
        this.messageTips = messageTips;
        this.threadName = "ECompanyTaskThread--> " + billId + " : " + jobId;
        this.initalize();
    }

    public ECompanyTaskThread(Context ctx, CountDownLatch latch, String jobId, String billId, Map dataMap, Map otherParam, BatchMessageTipsBody messageTips, String entryId) {
        this.ctx = ctx;
        this.latch = latch;
        this.jobId = jobId;
        this.billId = billId;
        this.entryId = entryId;
        this.dataMap = dataMap;
        this.bussAttrId = (String)this.dataMap.get("bussAttrID");
        if (StringUtils.isEmpty((CharSequence)this.bussAttrId)) {
            this.bussAttrId = (String)this.dataMap.get("bussAttrID.id");
        }
        this.otherParam = otherParam;
        if (messageTips == null) {
            messageTips = new BatchMessageTipsBody();
        }
        messageTips.setMuitTipsState(false);
        this.messageTips = messageTips;
        this.threadName = "ECompanyTaskThread--> " + billId + " : " + jobId;
        this.initalize();
    }

    public ECompanyTaskThread(Context ctx, CountDownLatch latch, String jobId, String billId, String bussAttrId, Map dataMap, Map otherParam, BatchMessageTipsBody messageTips) {
        this.ctx = ctx;
        this.latch = latch;
        this.jobId = jobId;
        this.billId = billId;
        this.bussAttrId = bussAttrId;
        this.dataMap = dataMap;
        this.otherParam = otherParam;
        if (messageTips == null) {
            messageTips = new BatchMessageTipsBody();
        }
        messageTips.setMuitTipsState(false);
        this.messageTips = messageTips;
        this.threadName = "ECompanyTaskThread--> " + billId + " : " + jobId;
        this.initalize();
    }

    public void initalize() {
        if (EContractConstants.COMPANY_PARTY_B_TASK_BUSSATTRID_MAP.containsKey(this.bussAttrId)) {
            this.taskType = "COMPANY_B";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String contractNoTemp = "";
        try {
            logger.error(this.threadName + " start running...... ");
            HRBillBaseInfo hrBillBaseInfo = EContractService.getHRBillBaseInfo(this.ctx, this.billId);
            HRBillBaseEntryInfo billEntryInfo = null;
            IObjectCollection entryColls = (IObjectCollection)hrBillBaseInfo.get("entrys");
            if (entryColls.size() > 0) {
                billEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
            }
            if (billEntryInfo == null) {
                return;
            }
            if (this.entryId == null || this.entryId.isEmpty()) {
                this.entryId = billEntryInfo.getId().toString();
            }
            if (hrBillBaseInfo instanceof ContractSignBizBillInfo && !this.entryId.equals(billEntryInfo.getId().toString())) {
                billEntryInfo = OtherFollowLaborConEntryFactory.getLocalInstance((Context)this.ctx).getOtherFollowLaborConEntryInfo((IObjectPK)new ObjectUuidPK(this.entryId));
                logger.error("run entryId is:" + this.entryId + ",OtherFollowLaborConEntry id is:" + billEntryInfo.getId().toString());
            }
            if (hrBillBaseInfo instanceof ContractPreSignBizBillInfo && !this.entryId.equals(billEntryInfo.getId().toString())) {
                billEntryInfo = OtherFollowPreConEntryFactory.getLocalInstance((Context)this.ctx).getOtherFollowPreConEntryInfo((IObjectPK)new ObjectUuidPK(this.entryId));
                logger.error("run entryId is:" + this.entryId + ",OtherFollowPreConEntry id is:" + billEntryInfo.getId().toString());
            }
            logger.error("run entryId is:" + this.entryId + ",billEntryInfo id is:" + billEntryInfo.getId().toString());
            Map<String, String> processInfo = EContractService.getProcessInfoNew(this.ctx, hrBillBaseInfo, billEntryInfo);
            EContractSignState currentSignState = null;
            Object signStateObj = billEntryInfo.get("signState");
            if (signStateObj instanceof EContractSignState) {
                currentSignState = (EContractSignState)signStateObj;
            } else if (signStateObj instanceof Integer) {
                currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
            } else {
                Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
                currentSignState = EContractSignState.getEnum((int)intObj);
            }
            SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecord(this.ctx, this.billId, this.entryId);
            if (recordInfo == null) {
                HashMap<String, Boolean> param = new HashMap<String, Boolean>();
                if (EContractSignState.signing.equals((Object)currentSignState)) {
                    param.put("isPersonSigned", true);
                } else if (EContractSignState.partyASigned.equals((Object)currentSignState)) {
                    param.put("isCompanyBSigned", true);
                } else if (EContractSignState.complete.equals((Object)currentSignState)) {
                    param.put("isCompanySigned", true);
                }
                logger.error(this.threadName + " repairEContractRecordData ......");
                recordInfo = (SSCEContractRecordInfo)EContractServiceFacadeFactory.getLocalInstance(this.ctx).repairEContractRecordData(hrBillBaseInfo, billEntryInfo, param);
            }
            contractNoTemp = recordInfo.getContractNO();
            SSCEContractTaskInfo taskInfo = EContractService.getEContractTaskInfo(this.ctx, this.jobId, this.billId, this.taskType);
            if (taskInfo == null) {
                logger.error(this.threadName + " saveSSCEContractTaskInfo ......");
                taskInfo = EContractService.saveSSCEContractTaskInfo(this.ctx, this.jobId, this.billId, this.dataMap, this.otherParam, false, this.taskType);
            }
            EContractCompanyTaskInfo eContractCompanyTaskInfo = EContractService.getEContractCompanyTaskInfoNew(this.ctx, this.billId, this.jobId, this.entryId, null);
            boolean isRequest = false;
            Timestamp requestTime = null;
            if (eContractCompanyTaskInfo != null) {
                isRequest = eContractCompanyTaskInfo.isIsRequest();
                requestTime = eContractCompanyTaskInfo.getRequestTime();
            }
            if (isRequest && requestTime != null) {
                String label33 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label33", (Context)this.ctx);
                logger.error(this.threadName + " 120  " + label33 + "  pollingProcess ......");
                this.pollingProcess(hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo);
            } else {
                IEContractServiceFacade serviceFacade = EContractServiceFacadeFactory.getLocalInstance(this.ctx);
                if (EContractSignState.nosign.equals((Object)currentSignState)) {
                    logger.error(this.threadName + " currentSignState ReNewBillSignState.nosign ......");
                    String personId = processInfo.get("personId");
                    Object res = serviceFacade.checkPersonHashAuth(personId, null, this.billId);
                    logger.error(this.threadName + " checkPersonHashAuth " + res);
                    Map resMap = (Map)res;
                    String userId = (String)resMap.get("userId");
                    if (!StringUtils.isEmpty((CharSequence)userId) && SSCPersonAuthResult.SUCCESS.equals(resMap.get("result"))) {
                        JSONObject data;
                        int signStatus;
                        String eContractNO = recordInfo.getEContractNO();
                        String entryId = billEntryInfo.getId().toString();
                        String recordId = recordInfo.getId().toString();
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("userId", userId);
                        param.put("eContractNo", eContractNO);
                        param.put("entryId", entryId);
                        param.put("recordId", recordId);
                        param.put("isQueryCompanySign", false);
                        param.put("taskType", this.taskType);
                        Object result = serviceFacade.getEContractSignStatus(param);
                        logger.error(this.threadName + " getEContractSignStatus " + result);
                        JSONObject resObj = null;
                        resObj = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString());
                        int code = resObj.getIntValue("code");
                        boolean isPersonSign = false;
                        if (code == 0 && (signStatus = (data = resObj.getJSONObject("data")).getIntValue("signStatus")) == 1) {
                            isPersonSign = true;
                            hrBillBaseInfo = EContractService.getHRBillBaseInfo(this.ctx, this.billId);
                            entryColls = (IObjectCollection)hrBillBaseInfo.get("entrys");
                            if (entryColls.size() > 0) {
                                billEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
                            }
                            String label34 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label34", (Context)this.ctx);
                            logger.error(this.threadName + label34);
                            recordInfo = EContractService.getSSCEContractRecord(this.ctx, this.billId, entryId);
                            taskInfo = EContractService.getEContractTaskInfo(this.ctx, this.jobId, this.billId, this.taskType);
                        }
                        if (!isPersonSign) {
                            String label6 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label6", (Context)this.ctx);
                            throw new BOSException(label6);
                        }
                    }
                }
                ISSCEContractTaskFacade issceContractTaskFacade = SSCEContractTaskFacadeFactory.getLocalInstance(this.ctx);
                if (recordInfo.isIsCompanySign() && recordInfo.isIsSigned()) {
                    String label35 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label35", (Context)this.ctx);
                    logger.error(this.threadName + label35);
                    this.messageTips.setMuitTipsState(true);
                    String label10 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label10", (Context)this.ctx);
                    this.messageTips.setMuitTipsMessage(label10);
                    this.state = true;
                    this.message = label10;
                } else {
                    String label36 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label36", (Context)this.ctx);
                    logger.error(this.threadName + " " + label36 + " ......");
                    this.dataMap.put("entryId", this.entryId);
                    logger.error("run entryId is:" + this.entryId);
                    Thread.sleep(ECompanyTaskThread.getRandomMils());
                    issceContractTaskFacade.sendCompanySign(this.jobId, this.billId, this.dataMap, this.otherParam);
                    this.pollingProcess(hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo);
                }
            }
            this.afterRun();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
            this.message = e.getMessage();
            Thread.currentThread().interrupt();
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
            this.message = e.getMessage();
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
            this.message = e.getMessage();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
            this.message = e.getMessage();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            this.messageTips.setMuitTipsMessage(e.getMessage());
        }
        finally {
            HashMap<String, Object> entryResultMap = new HashMap<String, Object>();
            entryResultMap.put("entryId", this.entryId);
            entryResultMap.put("contractNo", contractNoTemp);
            entryResultMap.put("state", this.state);
            entryResultMap.put("message", this.message);
            this.messageTips.addMessageListExt(entryResultMap);
            logger.error(this.threadName + " ending...... messageTips : " + this.messageTips.toString());
            this.latch.countDown();
        }
    }

    public void afterRun() {
        logger.error(this.threadName + "afterRun");
    }

    public void pollingProcess(HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo) throws BOSException, EASBizException, InterruptedException {
        String label37 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label37", (Context)this.ctx);
        logger.error(this.threadName + " " + label37 + " ");
        Thread.sleep(2000L);
        boolean isbreak = true;
        int times = 0;
        ISSCEContractTaskFacade issceContractTaskFacade = SSCEContractTaskFacadeFactory.getLocalInstance(this.ctx);
        while (isbreak) {
            EContractCompanyTaskInfo companyTaskInfo = EContractService.getEContractCompanyTaskInfoNew(this.ctx, this.billId, this.jobId, this.entryId, null);
            if (companyTaskInfo == null) {
                logger.error(this.threadName + " issceContractTaskFacade companyTaskInfo is null");
                continue;
            }
            boolean isCallback = companyTaskInfo.isIsCallback();
            String resultCodeStr = companyTaskInfo.getResultCode();
            int resultCode = 0;
            if (!StringUtils.isEmpty((CharSequence)resultCodeStr)) {
                resultCode = Integer.parseInt(resultCodeStr);
            }
            String label38 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label38", (Context)this.ctx);
            String realObj = MessageFormat.format(label38, ++times);
            logger.error(this.threadName + realObj + " ....... entryId : " + this.entryId);
            if (companyTaskInfo != null) {
                String label39 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label39", (Context)this.ctx);
                logger.error(this.threadName + " " + label39 + " \uff1a" + companyTaskInfo.toString());
            }
            if (isCallback && 0 == resultCode) {
                isbreak = false;
                String label9 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label9", (Context)this.ctx);
                throw new BOSException(label9);
            }
            if (isCallback && 1 == resultCode) {
                this.messageTips.setMuitTipsState(true);
                String label10 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label10", (Context)this.ctx);
                this.messageTips.setMuitTipsMessage(label10);
                this.state = true;
                this.message = label10;
                isbreak = false;
            } else if (!isCallback && times > 15) {
                String label40 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label40", (Context)this.ctx);
                String real = MessageFormat.format(label40, 15);
                logger.error(this.threadName + real);
                IEContractServiceFacade serviceFacade = EContractServiceFacadeFactory.getLocalInstance(this.ctx);
                isbreak = false;
                String eContractNO = recordInfo.getEContractNO();
                String entryId = billEntryInfo.getId().toString();
                String recordId = recordInfo.getId().toString();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("eContractNo", eContractNO);
                param.put("entryId", entryId);
                param.put("recordId", recordId);
                param.put("isQueryCompanySign", true);
                param.put("taskType", this.taskType);
                Object result = serviceFacade.getEContractSignStatus(param);
                String label41 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label41", (Context)this.ctx);
                String realvalue = MessageFormat.format(label41, result);
                JSONObject resObj = null;
                resObj = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString());
                int code = resObj.getIntValue("code");
                if (code == 0) {
                    JSONObject data = resObj.getJSONObject("data");
                    int signStatus = data.getIntValue("signStatus");
                    if (signStatus == 1) {
                        taskInfo = EContractService.getEContractTaskInfo(this.ctx, this.jobId, this.billId, this.taskType);
                        EContractService.updateEContractCompanyTaskInfo(this.ctx, companyTaskInfo, true);
                        this.updateOtherInfo(hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo, companyTaskInfo);
                        this.afterPollingProcessSuccess(hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo, companyTaskInfo);
                        this.messageTips.setMuitTipsState(true);
                        String label10 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label10", (Context)this.ctx);
                        this.messageTips.setMuitTipsMessage(label10);
                        this.state = true;
                        this.message = label10;
                    } else {
                        EContractService.updateEContractCompanyTaskInfo(this.ctx, companyTaskInfo, false);
                        this.afterPollingProcessFail(hrBillBaseInfo, billEntryInfo, recordInfo, taskInfo, companyTaskInfo);
                        String label9 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label9", (Context)this.ctx);
                        throw new BOSException(label9);
                    }
                }
            }
            if (!isbreak) continue;
            Thread.sleep(2000L);
        }
    }

    public void sendSignCompleteMessage(HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo, EContractCompanyTaskInfo companyTaskInfo) {
        if ("COMPANY".equalsIgnoreCase(this.taskType)) {
            try {
                EContractSendMessageFacadeFactory.getLocalInstance(this.ctx).sandSignCompleteMessage(hrBillBaseInfo, billEntryInfo);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateOtherInfo(HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo, EContractCompanyTaskInfo companyTaskInfo) {
        String eContractNO = recordInfo.getEContractNO();
        KDContractConfigInfo kdContractConfig = recordInfo.getKdContractConfig();
        try {
            if ("COMPANY_B".equalsIgnoreCase(this.taskType)) {
                LabContractFirstPartyInfo labContractPartyB = EContractService.getLabContractPartyB(this.ctx, hrBillBaseInfo, billEntryInfo);
                kdContractConfig = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty((Context)this.ctx, (String)labContractPartyB.getId().toString());
            }
            if (kdContractConfig.get("clientEnterpriseId") == null) {
                KDContractConfigFactory.getLocalInstance((Context)this.ctx).getKDContractConfigInfo((IObjectPK)new ObjectUuidPK(kdContractConfig.getId()));
            }
            String userId = kdContractConfig.getClientEnterpriseId();
            EContractService.updateKDContractConfigRecordState(this.ctx, hrBillBaseInfo, billEntryInfo, eContractNO, userId);
        }
        catch (ObjectNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void afterPollingProcessSuccess(HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo, EContractCompanyTaskInfo companyTaskInfo) throws BOSException, EASBizException {
    }

    public void afterPollingProcessFail(HRBillBaseInfo hrBillBaseInfo, HRBillBaseEntryInfo billEntryInfo, SSCEContractRecordInfo recordInfo, SSCEContractTaskInfo taskInfo, EContractCompanyTaskInfo companyTaskInfo) throws BOSException, EASBizException {
    }

    public static int getRandomMils() {
        return random.nextInt(2001) + 500;
    }

    public final String getThreadName() {
        return this.threadName;
    }

    public final CountDownLatch getLatch() {
        return this.latch;
    }

    public final Context getCtx() {
        return this.ctx;
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final String getBillId() {
        return this.billId;
    }

    public final String getBussAttrId() {
        return this.bussAttrId;
    }

    public final Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public final Map<?, ?> getOtherParam() {
        return this.otherParam;
    }

    public final String getTaskType() {
        return this.taskType;
    }

    public final BatchMessageTipsBody getMessageTips() {
        return this.messageTips;
    }
}

