/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.elecontract.service.CreateEContractThread;
import com.kingdee.shr.elecontract.util.CloudServiceUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadETemplateThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DownloadETemplateThread.class);
    private Context ctx;
    private String eId;
    private String boId;
    private String fullname;
    private boolean isTemplate;
    private Map<String, String> paramsMap;

    public DownloadETemplateThread(Context ctx, String eId, String boId, String fullname, boolean isTemplate, Map<String, String> paramsMap) {
        this.ctx = ctx;
        this.eId = eId;
        this.boId = boId;
        this.fullname = fullname;
        this.isTemplate = isTemplate;
        this.paramsMap = paramsMap;
    }

    @Override
    public void run() {
        byte[] byteData = null;
        try {
            String downloadUrl = CloudServiceUtil.getServiceUrl(this.ctx, "BASE") + "/kdcontract/contract/downloadTemplateOrFile?isDownloadTemplate=" + this.isTemplate + "&id=" + this.eId;
            URL httpUrl = new URL(downloadUrl);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setConnectTimeout(120000);
            InputStream inputStream = conn.getInputStream();
            byteData = DownloadETemplateThread.readInputStream(inputStream);
            logger.error("\u4e0b\u8f7d\u5b8c\u6210 :" + this.eId + "; BOID = " + this.boId);
            if (!this.isTemplate) {
                new Thread(new CreateEContractThread(this.ctx, byteData, this.fullname, this.eId, this.paramsMap)).start();
            }
            this.saveAttachment(this.ctx, this.boId, this.fullname, byteData);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("DownloadETemplateThread Exception : " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error("DownloadETemplateThread Throwable : " + e.getMessage(), e);
        }
    }

    public SHRAttachmentExtInfo saveAttachment(Context ctx, String boID, String fullname, byte[] filedata) throws BOSException, EASBizException {
        logger.error("=====saveAttachment=====");
        String label58 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label58", (Context)ctx);
        String mainname = fullname + label58;
        String extname = "pdf";
        extname = extname.toLowerCase();
        IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        SHRAttachmentExtInfo attchExt = null;
        SHRAttachmentExtCollection shrAttachmentExtCollection = SHRAttachmentExtFactory.getLocalInstance((Context)ctx).getSHRAttachmentExtCollection("where boid = '" + boID + "'");
        attchExt = shrAttachmentExtCollection.size() > 0 ? shrAttachmentExtCollection.get(0) : new SHRAttachmentExtInfo();
        IBoAttchAsso attchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        BoAttchAssoInfo boAttchAssoInfo = null;
        BoAttchAssoCollection boAttchAssoCollection = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection("where boid = '" + boID + "'");
        boAttchAssoInfo = boAttchAssoCollection.size() > 0 ? boAttchAssoCollection.get(0) : new BoAttchAssoInfo();
        AttachmentInfo aiOld = boAttchAssoInfo.getAttachment();
        if (aiOld != null && aiOld.getId() != null) {
            attachment.delete((IObjectPK)new ObjectUuidPK(aiOld.getId()));
        }
        AttachmentInfo ai = new AttachmentInfo();
        Locale locale_en_US = LocaleUtils.locale_en_US;
        Locale locale_zh_CN = LocaleUtils.locale_zh_CN;
        Locale locale_zh_TW = LocaleUtils.locale_zh_TW;
        ai.setName(mainname, locale_en_US);
        ai.setName(mainname, locale_zh_CN);
        ai.setName(mainname, locale_zh_TW);
        ai.setSimpleName(extname);
        ai.setDescription("");
        ai.setFile(filedata);
        ai.setIsShared(false);
        String label26 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label26", (Context)ctx);
        ai.setSharedDesc(label26);
        int size = filedata.length;
        if (size < 1024) {
            String label27 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label27", (Context)ctx);
            String realObj = MessageFormat.format(label27, size);
            ai.setSize(realObj);
        } else {
            ai.setSize(size / 1024 + "KB");
        }
        ai.setSizeInByte(size);
        ai.setAttachID("" + System.currentTimeMillis());
        String label28 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label28", (Context)ctx);
        ai.setType(label28);
        attchExt.setName(fullname, locale_en_US);
        attchExt.setName(fullname, locale_zh_CN);
        attchExt.setName(fullname, locale_zh_TW);
        attchExt.setPropertyName("null0");
        attchExt.setType(AttachmentTypeEnum.PROPERTY);
        attchExt.setState(AttachmentState.SAVE);
        attchExt.setBoID(boID);
        boAttchAssoInfo.setBoID(boID);
        boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boID, (boolean)true)));
        boAttchAssoInfo.setAssoType("Added Accessories");
        try {
            IObjectPK attachPk = attachment.save((CoreBaseInfo)ai);
            attchExt.setAttachment(ai);
            boAttchAssoInfo.setAttachment(ai);
            attchAsso.save((CoreBaseInfo)boAttchAssoInfo);
            shrAttchExt.save((CoreBaseInfo)attchExt);
            return attchExt;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String label29 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label29", (Context)ctx);
            String label30 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label30", (Context)ctx);
            String label31 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label31", (Context)ctx);
            String label32 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label32", (Context)ctx);
            throw new BOSException(label29 + "\uff1a\n1\u3001" + label30 + "\uff1b\n2\u3001" + label31 + "\uff1b\n3\u3001" + label32 + "\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream inputStream) throws BOSException, EASBizException {
        byte[] buffer = new byte[1024];
        byte[] bufferReturn = null;
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bufferReturn = bos.toByteArray();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return bufferReturn;
    }
}

