/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.eas.hr.contract.ISHRElectronicTemplate;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryCollection;
import com.kingdee.eas.hr.contract.OtherContractChangeBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryCollection;
import com.kingdee.eas.hr.contract.OtherContractRenewBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.OtherFollowLaborConEntryCollection;
import com.kingdee.eas.hr.contract.OtherFollowLaborConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryCollection;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryCollection;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.cloudservice.util.CloudServiceExceptionUtil;
import com.kingdee.shr.cloudservice.util.HttpClientUtil;
import com.kingdee.shr.elecontract.EContractSealTypeFactory;
import com.kingdee.shr.elecontract.EContractSealTypeInfo;
import com.kingdee.shr.elecontract.EContractSignImgFactory;
import com.kingdee.shr.elecontract.ElecontractException;
import com.kingdee.shr.elecontract.ElecontractException_880;
import com.kingdee.shr.elecontract.IEContractSignImg;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.app.KDContractServiceStatus;
import com.kingdee.shr.elecontract.util.ContactBillMiddleUtils;
import com.kingdee.shr.elecontract.util.ElectronicTemplateSqlUtils;
import com.kingdee.shr.elecontract.util.RowSetUtils;
import com.kingdee.shr.elecontract.vo.ETemplateFieldType;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.smsplatform.service.ISMSStrategy;
import com.kingdee.shr.smsplatform.service.NewSignSMSStrategy;
import com.kingdee.shr.smsplatform.service.SMSSendEntry;
import com.kingdee.shr.smsplatform.service.SignOverSMSStrategy;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicContractUtils {
    public static final String LABCONTRACTFIRSTPARTYINFO_KEY = "labContractFirstPartyInfoId";
    private static final Logger logger = LoggerFactory.getLogger(ElectronicContractUtils.class);
    public static final String E_CONTRACT_RENEW_STRUCTURECONFIG_NUMBER = "009SSC";
    public static final String E_CONTRACT_SIGN_STRUCTURECONFIG_NUMBER = "013SSC";
    public static final String E_CONTRACT_PRE_SIGN_STRUCTURECONFIG_NUMBER = "012SSC";
    public static final String E_CONTRACTNO_SEPARATION_KDAPPID = "-";

    public static Map<String, String> assembleContractInfoFromEntry(Context ctx, String billId, SHRElectronicTemplateInfo electronicTemplateInfo) throws BOSException, EASBizException {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        String querySql = "";
        JSONArray configList = new JSONArray();
        if (StringUtils.isEmpty((String)electronicTemplateInfo.getConfig())) {
            String label34 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label34", (Context)ctx);
            throw new BOSException(label34);
        }
        String config = electronicTemplateInfo.getConfig();
        configList = JSONArray.parseArray((String)config);
        logger.error("assembleContractInfoFromEntry : configList" + configList);
        if (StringUtils.isEmpty((String)electronicTemplateInfo.getContent())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("selectorFields", configList);
            querySql = ElectronicTemplateSqlUtils.generateSQL(ctx, params, electronicTemplateInfo);
        } else {
            querySql = electronicTemplateInfo.getContent();
        }
        int index = querySql.indexOf("@{CONTRACTRENEWBIZBILL.ID}");
        if (index <= -1) {
            String label20 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label20", (Context)ctx);
            throw new BOSException(label20);
        }
        querySql = querySql.replace("@{CONTRACTRENEWBIZBILL.ID}", billId);
        logger.error("assembleContractInfoFromEntry : querysql" + querySql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            if (rs.next()) {
                for (int i = 0; i < configList.size(); ++i) {
                    com.alibaba.fastjson.JSONObject config2 = configList.getJSONObject(i);
                    String key = config2.getString("key");
                    String metaField = config2.getString("metafield");
                    String metaFieldValue = rs.getString(metaField);
                    metaFieldValue = ElectronicContractUtils.decideFieldValue(ctx, key, metaField, (Object)metaFieldValue, electronicTemplateInfo.getStructureNumber());
                    infoMap.put(key, metaFieldValue);
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return infoMap;
    }

    public static void setEmployeeContractInfoIsElectronicSign(Context ctx, EmployeeContractInfo contractInfo, ContractTempletInfo templetInfo) throws EASBizException, BOSException {
        if (templetInfo.get("isElectronicSign") == null) {
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
        }
        contractInfo.setIsElectronicSign(templetInfo.isIsElectronicSign());
    }

    public static String decideFieldValue(Context ctx, String key, String fieldName, Object fieldValue, String structureNumber) throws BOSException, EASBizException {
        String returnFieldValue = "";
        if (fieldValue instanceof String) {
            returnFieldValue = (String)fieldValue;
        }
        if (StringUtils.isEmpty((String)returnFieldValue)) {
            fieldValue = "";
        } else if (fieldName.indexOf(".") > 0) {
            String structureKey = fieldName.split("\\.")[0];
            String structureField = fieldName.split("\\.")[1];
            StructureConfigInfo structureInfo = StructureConfigConvertHelper.getStructureConfigByKey((Context)ctx, (String)structureKey, (String)structureNumber);
            if (structureInfo != null) {
                EntityObjectInfo entityInfo;
                String entityName = structureInfo.getEntityName();
                try {
                    entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return returnFieldValue;
                }
                PropertyInfo property = entityInfo.getPropertyByName(structureField);
                return ElectronicContractUtils.decideFieldValue(ctx, structureKey, fieldName, returnFieldValue, property);
            }
        }
        return returnFieldValue;
    }

    public static String decideFieldValue(Context ctx, String key, String fieldName, String fieldValue, PropertyInfo property) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fieldValue)) {
            fieldValue = "";
        } else if (property != null && property instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)property;
            DataType dateType = ownPropertyInfo.getDataType();
            if (DataType.DATE.equals((Object)dateType) || DataType.TIME.equals((Object)dateType) || DataType.TIMESTAMP.equals((Object)dateType)) {
                try {
                    SimpleDateFormat YYYY_MM_DD_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
                    fieldValue = YYYY_MM_DD_FORMATTER.format(YYYY_MM_DD_FORMATTER.parse(fieldValue));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return fieldValue;
                }
            } else {
                fieldValue = DataType.ENUM.equals((Object)dateType) ? ElectronicContractUtils.decideFieldValueIfEnum(ctx, ownPropertyInfo, fieldValue) : String.valueOf(fieldValue);
            }
        }
        return fieldValue;
    }

    public static String decideFieldValueIfEnum(Context ctx, OwnPropertyInfo ownPropertyInfo, String fieldValue) {
        String enumRefName = ownPropertyInfo.getMetaDataRef();
        if (!StringUtils.isEmpty((String)enumRefName)) {
            try {
                MetaDataPK metaPk = MetaDataPK.create((String)enumRefName);
                BizEnumInfo bizEnum = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)metaPk);
                IntEnum enumValie = null;
                if (bizEnum.getDataType() == BizEnumValueType.INTEGER) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (int)Integer.parseInt(fieldValue));
                    fieldValue = enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.STRING) {
                    enumValie = EnumUtils.getEnumByValue(Class.forName(enumRefName), (String)fieldValue.toString());
                    fieldValue = enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.LONG) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (long)Long.parseLong(fieldValue));
                    fieldValue = enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.FLOAT) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (float)Float.parseFloat(fieldValue));
                    fieldValue = enumValie.getAlias();
                } else if (bizEnum.getDataType() == BizEnumValueType.DOUBLE) {
                    enumValie = EnumUtils.getEnum(Class.forName(enumRefName), (double)Double.parseDouble(fieldValue));
                    fieldValue = enumValie.getAlias();
                } else {
                    logger.error("propertyInfo " + ownPropertyInfo + "can not find enum type " + bizEnum.getDataType());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fieldValue;
    }

    public static String addContractNumber(Context ctx, LabContractFirstPartyInfo partyInfo, String number) throws EASBizException, BOSException {
        if (partyInfo == null || partyInfo.getId() == null) {
            throw new ElecontractException(ElecontractException.LBCFPNOFOUND);
        }
        KDContractConfigInfo kdConfig = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty(ctx, partyInfo.getId().toString());
        if (kdConfig == null || kdConfig.getServiceStatus() != KDContractServiceStatus.REGISTSUCC) {
            String label22;
            if (StringUtils.isEmpty((String)partyInfo.getName())) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("id"));
                partyInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(partyInfo.getId()), selector);
            }
            String errorMsg = label22 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label22", (Context)ctx);
            NumericExceptionSubItem validException = new NumericExceptionSubItem("00", errorMsg);
            throw new EASBizException(validException, new Object[]{partyInfo.getName()});
        }
        String no = "";
        if (!StringUtils.isEmpty((String)number)) {
            no = no + number + E_CONTRACTNO_SEPARATION_KDAPPID + kdConfig.getClientKDAppId();
        }
        logger.error("ElectronicContractUtils addContractNumber no : " + no);
        return no;
    }

    public static String generateContractNumber(Context ctx, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
            number = new String();
            number = number + "HT-" + dateFormat.format(new Date());
        }
        if (number.startsWith("E") || number.startsWith("EE")) {
            return number;
        }
        String no = "";
        if (!StringUtils.isEmpty((String)number)) {
            no = no + "E" + number;
        }
        return no;
    }

    public static SHRElectronicTemplateInfo getElectronicInfo(Context ctx, ContractTempletInfo templetInfo) throws EASBizException, BOSException {
        ISHRElectronicTemplate electronicTemplate = SHRElectronicTemplateFactory.getLocalInstance((Context)ctx);
        SHRElectronicTemplateCollection electronicTemplateInfoColl = electronicTemplate.getSHRElectronicTemplateCollection("where contractTemplet.id = '" + templetInfo.getId().toString() + "'");
        if (electronicTemplateInfoColl.size() < 1) {
            String label24 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label24", (Context)ctx);
            throw new BOSException(label24);
        }
        SHRElectronicTemplateInfo electronicTemplateInfo = electronicTemplateInfoColl.get(0);
        return electronicTemplateInfo;
    }

    public static Map<String, Object> packageOsfParams(List<String> templateIds, String contractNo, List<Map<String, String>> osfContractDataList) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("contractNo", contractNo);
        dataMap.put("templates", templateIds);
        dataMap.put("templateData", osfContractDataList);
        return dataMap;
    }

    public static boolean sengPhoneMessage(Context ctx, String tspServerUrl, String serviceId, String phone, String messageServiceId, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, String> queryParamsCondition = new HashMap<String, String>();
        queryParamsCondition.put("billId", String.valueOf(params.get("billId")));
        queryParamsCondition.put("entryId", String.valueOf(params.get("entryId")));
        HashMap<String, String> presetParValMap = new HashMap<String, String>();
        presetParValMap.put("presetName", String.valueOf(params.get("0")));
        presetParValMap.put("presetCompanyFullName", String.valueOf(params.get("presetCompanyFullName")));
        presetParValMap.put("presetContractNo", String.valueOf(params.get("presetContractNo")));
        HashMap<String, String> cloudParams = new HashMap<String, String>();
        cloudParams.put("shorturl", String.valueOf(params.get("shorturl")));
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("contractNum", String.valueOf(params.get("contractNum")));
        Object[] mapObjs = new Object[]{presetParValMap, queryParamsCondition, cloudParams, customParams};
        Map result = new HashMap();
        result = "HRSSC_Contract_Pre_Sign_PACKAGE".equals(messageServiceId) ? SMSSendEntry.sendSMS((ISMSStrategy)new NewSignSMSStrategy("PRE_ENTRY_SIGN", phone, String.valueOf(params.get("hrOrgUnitId")), mapObjs), (Context)ctx) : SMSSendEntry.sendSMS((ISMSStrategy)new SignOverSMSStrategy("PRE_ENTRY_SIGN_OVER", phone, String.valueOf(params.get("hrOrgUnitId")), mapObjs), (Context)ctx);
        return null != (Integer)result.get("code") && 0 == (Integer)result.get("code");
    }

    public static String getShortUrl(Context ctx, String tspServerUrl, Map<String, Object> dataMap) throws EASBizException, BOSException {
        String tspInterfaceUrl = tspServerUrl + "/econtract/preentry/getShortUrl?randomuuid=" + HttpClientUtil.generateShortUuid();
        String label25 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label25", (Context)ctx);
        logger.error(label25 + "dataMap " + dataMap);
        logger.error(label25 + "tspInterfaceUrl " + tspInterfaceUrl);
        JSONObject jsonObejct = HttpClientUtil.postForm((Context)ctx, (String)tspInterfaceUrl, dataMap);
        String label26 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label26", (Context)ctx);
        logger.error(label26 + jsonObejct.toString());
        int status = jsonObejct.getInt("status");
        String shortUrl = "";
        if (status == 200) {
            String label27 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label27", (Context)ctx);
            logger.error(label27);
            try {
                JSONObject jsData = jsonObejct.getJSONObject("result");
                if (!"0".equals(jsData.getString("errcode"))) {
                    String label35 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label35", (Context)ctx);
                    throw CloudServiceExceptionUtil.getCloudServiceException((int)Integer.parseInt(jsData.getString("errcode")), (String)jsData.getString("data"), (String)label35);
                }
                String label28 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label28", (Context)ctx);
                logger.error(label28);
                shortUrl = jsData.getString("data");
            }
            catch (Exception e) {
                String label35 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label35", (Context)ctx);
                throw CloudServiceExceptionUtil.getCloudServiceException((int)status, (String)jsonObejct.toString(), (String)label35);
            }
        } else {
            String label35 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label35", (Context)ctx);
            throw CloudServiceExceptionUtil.getCloudServiceException((int)status, (String)jsonObejct.toString(), (String)label35);
        }
        return shortUrl;
    }

    public static KDContractConfigInfo getKDContractConfigByEContractNo(Context ctx, String eContractNo) throws EASBizException, BOSException {
        LabContractFirstPartyInfo Info;
        String realContractNo;
        KDContractConfigInfo config = null;
        if (!StringUtils.isEmpty((String)eContractNo) && !StringUtils.isEmpty((String)(realContractNo = ElectronicContractUtils.getRealContractNo(eContractNo))) && (Info = ElectronicContractUtils.getLabContractFirstPartyByContractNo(ctx, realContractNo)) != null) {
            config = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty(ctx, Info.getId().toString());
        }
        return config;
    }

    public static KDContractConfigInfo getKDContractConfigByEnterpriseId(Context ctx, String enterpriseId) throws BOSException {
        IKDContractConfig instance = KDContractConfigFactory.getLocalInstance(ctx);
        KDContractConfigCollection coll = instance.getKDContractConfigCollection(MessageFormat.format(" where clientEnterpriseId = ''{0}''", enterpriseId));
        if (coll != null && coll.size() > 0) {
            logger.error("KDContractConfigInfo " + coll.get(0).getId().toString() + " : " + coll.get(0).getClientKDAppId());
            return coll.get(0);
        }
        return null;
    }

    public static KDContractConfigInfo getKDContractConfigByLabContractFirstParty(Context ctx, String labContractFirstPartyId) throws BOSException {
        IKDContractConfig instance = KDContractConfigFactory.getLocalInstance(ctx);
        KDContractConfigCollection coll = instance.getKDContractConfigCollection(MessageFormat.format(" where labContractFirstParty = ''{0}'' and serviceStatus = ''{1}''", labContractFirstPartyId, 2));
        if (coll != null && coll.size() > 0) {
            logger.error("KDContractConfigInfo " + coll.get(0).getId().toString() + " : " + coll.get(0).getClientKDAppId());
            return coll.get(0);
        }
        return null;
    }

    public static void checkLabContractFirstPartyIsOpenElec(Context ctx, LabContractFirstPartyInfo partyInfo) throws EASBizException, BOSException {
        KDContractConfigInfo kdConfig;
        if (partyInfo != null && partyInfo.getId() != null && ((kdConfig = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty(ctx, partyInfo.getId().toString())) == null || kdConfig.getServiceStatus() != KDContractServiceStatus.REGISTSUCC)) {
            String label22;
            if (StringUtils.isEmpty((String)partyInfo.getName())) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("id"));
                partyInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(partyInfo.getId()), selector);
            }
            String errorMsg = label22 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label22", (Context)ctx);
            NumericExceptionSubItem validException = new NumericExceptionSubItem("00", errorMsg);
            throw new EASBizException(validException, new Object[]{partyInfo.getName()});
        }
    }

    public static boolean checkKDContractConfigIsAuth(Context ctx, LabContractFirstPartyInfo labContractFirstParty) throws BOSException, EASBizException {
        if (labContractFirstParty == null || labContractFirstParty.getId() == null) {
            return true;
        }
        String oql = "select id, enterpriseName, clientEnterpriseId where labContractFirstParty.id = '" + labContractFirstParty.getId().toString() + "'";
        KDContractConfigInfo configInfo = KDContractConfigFactory.getLocalInstance(ctx).getKDContractConfigInfo(oql);
        return ElectronicContractUtils.checkKDContractConfigIsAuth(ctx, configInfo);
    }

    public static boolean checkKDContractConfigIsAuthByLabContratId(Context ctx, String labContractFirstPartyId) throws BOSException, EASBizException {
        String oql = "select id, enterpriseName, clientEnterpriseId where labContractFirstParty.id = '" + labContractFirstPartyId + "'";
        KDContractConfigInfo configInfo = KDContractConfigFactory.getLocalInstance(ctx).getKDContractConfigInfo(oql);
        return ElectronicContractUtils.checkKDContractConfigIsAuth(ctx, configInfo);
    }

    public static boolean checkKDContractConfigIsAuth(Context ctx, String kdContractConfigId) throws BOSException, EASBizException {
        String oql = "select id, enterpriseName, clientEnterpriseId where id = '" + kdContractConfigId + "'";
        KDContractConfigInfo configInfo = KDContractConfigFactory.getLocalInstance(ctx).getKDContractConfigInfo(oql);
        return ElectronicContractUtils.checkKDContractConfigIsAuth(ctx, configInfo);
    }

    public static boolean checkKDContractConfigIsAuth(Context ctx, KDContractConfigInfo configInfo) throws BOSException, EASBizException {
        if (configInfo == null) {
            return true;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("config.id", (Object)configInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enterpId", (Object)configInfo.getClientEnterpriseId()));
        boolean exists = KDContractConfigAuthRecordFactory.getLocalInstance(ctx).exists(filter);
        if (!exists) {
            if (StringUtils.isEmpty((String)configInfo.getString("enterpriseName"))) {
                String oql = "select id, enterpriseName, clientEnterpriseId where id = '" + configInfo.getId().toString() + "'";
                configInfo = KDContractConfigFactory.getLocalInstance(ctx).getKDContractConfigInfo(oql);
            }
            throw new ElecontractException_880(ElecontractException_880.CONFIG_NO_AUTHRECORD, new Object[]{configInfo.getEnterpriseName()});
        }
        return exists;
    }

    public static LabContractFirstPartyInfo getLBCFPFromEmpConByContractNo(Context ctx, String contractNo) throws EASBizException, BOSException {
        LabContractFirstPartyInfo partyInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        view.setSelector(selector);
        EmployeeContractCollection ecc = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(view);
        if (ecc.size() > 0) {
            partyInfo = ecc.get(0).getLabContractFirstParty();
            return partyInfo;
        }
        EmployeeOtherContractCollection eocc = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(view);
        if (eocc.size() > 0) {
            partyInfo = eocc.get(0).getLabContractFirstParty();
            return partyInfo;
        }
        return partyInfo;
    }

    public static LabContractFirstPartyInfo getLabContractFirstPartyByContractNo(Context ctx, String contractNo) throws EASBizException, BOSException {
        ContractFreeBizBillEntryInfo contract;
        ContractRenewBizBillEntryInfo contract2;
        LabContractFirstPartyInfo partyInfo = null;
        HRBillBaseInfo info = ElectronicContractUtils.getHRContractBillInfo(ctx, contractNo);
        if (info == null) {
            return null;
        }
        if (info instanceof ContractRenewBizBillInfo) {
            ContractRenewBizBillInfo renewInfo = (ContractRenewBizBillInfo)info;
            contract2 = renewInfo.getEntrys().get(0);
            if (contract2 == null) {
                contract2 = ContractRenewBizBillEntryFactory.getLocalInstance((Context)ctx).getContractRenewBizBillEntryInfo("where bill = '" + renewInfo.getId() + "'");
            }
            partyInfo = contract2.getLabContractFirstParty();
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            partyInfo = ((ContractPreSignBizBillInfo)info).getLabContractFirstParty();
        }
        if (info instanceof ContractSignBizBillInfo) {
            partyInfo = ((ContractSignBizBillInfo)info).getLabContractFirstParty();
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            partyInfo = ((OtherContractSignBizBillInfo)info).getLabContractFirstParty();
        }
        if (info instanceof ContractChangeBizBillInfo) {
            ContractChangeBizBillInfo changeInfo = (ContractChangeBizBillInfo)info;
            contract2 = changeInfo.getEntrys().get(0);
            if (contract2 == null) {
                contract2 = ContractChangeBizBillEntryFactory.getLocalInstance((Context)ctx).getContractChangeBizBillEntryInfo("where bill = '" + changeInfo.getId() + "'");
            }
            partyInfo = contract2.getLabContractFirstParty();
        }
        if (info instanceof ContractFreeBizBillInfo) {
            contract = ((ContractFreeBizBillInfo)info).getEntrys().get(0);
            partyInfo = contract.getLabContractFirstParty();
        }
        if (info instanceof ContractEndBizBillInfo) {
            contract = ((ContractEndBizBillInfo)info).getEntrys().get(0);
            partyInfo = contract.getLabContractFirstParty();
        }
        if (partyInfo != null && StringUtils.isEmpty((String)partyInfo.getName())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("id"));
            partyInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(partyInfo.getId()), selector);
        }
        return partyInfo;
    }

    public static HRBillBaseInfo getHRContractBillInfoByEContractNo(Context ctx, String contractNo) throws BOSException, EASBizException {
        logger.error("contractNo = " + contractNo);
        IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance((Context)ctx);
        ElectronicContractRelationCollection coll = electronicContractRelation.getElectronicContractRelationCollection("where contractId = '" + contractNo + "'");
        ElectronicContractRelationInfo relation = null;
        if (coll.size() > 0) {
            relation = coll.get(0);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        if (relation != null && relation.getBillID() != null) {
            BOSUuid billID = relation.getBillID();
            return ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        }
        contractNo = ElectronicContractUtils.getRealContractNo(contractNo);
        return ElectronicContractUtils.getHRContractBillInfo(ctx, contractNo);
    }

    public static HRBillBaseInfo getHRContractBillInfoByEContractNoForEmp(Context ctx, String contractNo) throws BOSException, EASBizException {
        logger.error("contractNo = " + contractNo);
        IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance((Context)ctx);
        ElectronicContractRelationCollection coll = electronicContractRelation.getElectronicContractRelationCollection("where contractId = '" + contractNo + "'");
        ElectronicContractRelationInfo relation = null;
        if (coll.size() > 0) {
            relation = coll.get(0);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        if (relation != null && relation.getBillID() != null) {
            BOSUuid billID = relation.getBillID();
            return ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billID), selector);
        }
        contractNo = EmpElectronicContractUtilsEx.getRealContractNo((Context)ctx, (String)contractNo);
        return ElectronicContractUtils.getHRContractBillInfo(ctx, contractNo);
    }

    public static HRBillBaseInfo getHRContractBillInfo(Context ctx, String contractNo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        view.setFilter(filterInfo);
        HRContractInfoInfo hrContractInfo = null;
        HRContractInfoCollection hrContractInfoColls = HRContractInfoFactory.getLocalInstance((Context)ctx).getHRContractInfoCollection(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        if (hrContractInfoColls.size() > 0) {
            BOSUuid billId = null;
            for (int dex = 0; dex < hrContractInfoColls.size() && ((billId = (hrContractInfo = hrContractInfoColls.get(0)).getBillID()) == null || billId.getType() == null); ++dex) {
            }
            if (billId != null) {
                return ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
            }
            return null;
        }
        EntityViewInfo newView = new EntityViewInfo();
        FilterInfo newFilterInfo = new FilterInfo();
        newFilterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        selector.clear();
        selector.add(new SelectorItemInfo("bill.*"));
        selector.add(new SelectorItemInfo("*"));
        newView.setFilter(newFilterInfo);
        newView.setSelector(selector);
        ContractPreNewSignBizBillEntryCollection cpnbillColl = ContractPreNewSignBizBillEntryFactory.getLocalInstance((Context)ctx).getContractPreNewSignBizBillEntryCollection(newView);
        if (cpnbillColl != null && cpnbillColl.size() > 0) {
            return cpnbillColl.get(0).getBill();
        }
        OtherFollowPreNewConEntryCollection otherPreNewConBill = OtherFollowPreNewConEntryFactory.getLocalInstance((Context)ctx).getOtherFollowPreNewConEntryCollection(newView);
        if (otherPreNewConBill != null && otherPreNewConBill.size() > 0) {
            logger.info("getHRContractBillInfo_ otherPreNewConBill size is " + otherPreNewConBill.size());
            return otherPreNewConBill.get(0).getBill();
        }
        ContractPreSignBizBillEntryCollection billsss = ContractPreSignBizBillEntryFactory.getLocalInstance((Context)ctx).getContractPreSignBizBillEntryCollection(newView);
        if (billsss != null && billsss.size() > 0) {
            return billsss.get(0).getBill();
        }
        ContractSignBizBillEntryCollection billss = ContractSignBizBillEntryFactory.getLocalInstance((Context)ctx).getContractSignBizBillEntryCollection(newView);
        if (billss != null && billss.size() > 0) {
            return billss.get(0).getBill();
        }
        ContractRenewBizBillEntryCollection bills = ContractRenewBizBillEntryFactory.getLocalInstance((Context)ctx).getContractRenewBizBillEntryCollection(newView);
        if (bills != null && bills.size() > 0) {
            return bills.get(0).getBill();
        }
        OtherContractSignBizBillEntryCollection obills = OtherContractSignBizBillEntryFactory.getLocalInstance((Context)ctx).getOtherContractSignBizBillEntryCollection(newView);
        if (obills != null && obills.size() > 0) {
            return obills.get(0).getBill();
        }
        ContractChangeBizBillEntryCollection ccbbes = ContractChangeBizBillEntryFactory.getLocalInstance((Context)ctx).getContractChangeBizBillEntryCollection(newView);
        if (ccbbes != null && ccbbes.size() > 0) {
            return ccbbes.get(0).getBill();
        }
        OtherFollowLaborConEntryCollection otherLabConBill = OtherFollowLaborConEntryFactory.getLocalInstance((Context)ctx).getOtherFollowLaborConEntryCollection(newView);
        if (otherLabConBill != null && otherLabConBill.size() > 0) {
            logger.info("getHRContractBillInfo_ otherLabConBill size is " + otherLabConBill.size());
            return otherLabConBill.get(0).getBill();
        }
        OtherFollowPreConEntryCollection otherPreConBill = OtherFollowPreConEntryFactory.getLocalInstance((Context)ctx).getOtherFollowPreConEntryCollection(newView);
        if (otherPreConBill != null && otherPreConBill.size() > 0) {
            logger.info("getHRContractBillInfo_ otherPreConBill size is " + otherPreConBill.size());
            return otherPreConBill.get(0).getBill();
        }
        OtherContractRenewBizBillEntryCollection otherRenewConBill = OtherContractRenewBizBillEntryFactory.getLocalInstance((Context)ctx).getOtherContractRenewBizBillEntryCollection(newView);
        if (otherRenewConBill != null && otherRenewConBill.size() > 0) {
            logger.info("getHRContractBillInfo_ otherRenewConBill size is " + otherRenewConBill.size());
            return otherRenewConBill.get(0).getBill();
        }
        OtherContractChangeBizBillEntryCollection otherChangeConBill = OtherContractChangeBizBillEntryFactory.getLocalInstance((Context)ctx).getOtherContractChangeBizBillEntryCollection(newView);
        if (otherChangeConBill != null && otherChangeConBill.size() > 0) {
            logger.info("getHRContractBillInfo_ otherChangeConBill size is " + otherChangeConBill.size());
            return otherChangeConBill.get(0).getBill();
        }
        return null;
    }

    public static String getRealContractNo(String contractNo) {
        int index;
        if (!StringUtils.isEmpty((String)contractNo) && (index = contractNo.lastIndexOf(E_CONTRACTNO_SEPARATION_KDAPPID)) > 0) {
            return contractNo.substring(0, index);
        }
        return contractNo;
    }

    public static LabContractFirstPartyInfo getLabContractFirstPartyByBillId(Context ctx, HRBillBaseInfo info) throws EASBizException, BOSException {
        ContractRenewBizBillEntryInfo contract;
        String labContractFirstPartyInfoId = null;
        if (info == null) {
            return null;
        }
        if (info instanceof ContractRenewBizBillInfo) {
            contract = ((ContractRenewBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            labContractFirstPartyInfoId = ((ContractPreSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractPreNewSignBizBillInfo) {
            labContractFirstPartyInfoId = ((ContractPreNewSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractSignBizBillInfo) {
            labContractFirstPartyInfoId = ((ContractSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            labContractFirstPartyInfoId = ((OtherContractSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractChangeBizBillInfo) {
            contract = ((ContractChangeBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractFreeBizBillInfo) {
            contract = ((ContractFreeBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractEndBizBillInfo) {
            contract = ((ContractEndBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        return LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstPartyInfoId));
    }

    public static LabContractFirstPartyInfo getLabContractFirstPartyByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        HRBillBaseInfo info = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        BOSUuid bosUuid = BOSUuid.read((String)billId);
        info = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosUuid.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        if (info == null) {
            logger.error("getLabContractFirstPartyByBillId : billId " + billId);
            return null;
        }
        return ElectronicContractUtils.getLabContractFirstPartyByBillId(ctx, info);
    }

    public static KDContractConfigInfo getKDContractConfigInfoByKdAppId(Context ctx, String kdAppId, SelectorItemCollection selector) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (selector != null) {
            view.setSelector(selector);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("clientKDAppId", (Object)kdAppId));
        KDContractConfigCollection coll = KDContractConfigFactory.getLocalInstance(ctx).getKDContractConfigCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> assembleContractInfoData(Context ctx, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo, SHRElectronicTemplateInfo electronicTemplateInfo, PersonInfo person) throws BOSException, EASBizException {
        Map<String, String> map;
        block8: {
            Map<String, String> infoMap = new HashMap<String, String>();
            JSONArray configList = new JSONArray();
            if (StringUtils.isEmpty((String)electronicTemplateInfo.getConfig())) {
                String label41 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label41", (Context)ctx);
                throw new BOSException(label41);
            }
            String config = electronicTemplateInfo.getConfig();
            configList = JSONArray.parseArray((String)config);
            logger.error("854 assembleContractInfoData : configList " + configList);
            Map<String, Object> fieidFormConfig = ElectronicContractUtils.sortFieidFormConfig(ctx, configList);
            JSONArray queryField = (JSONArray)fieidFormConfig.get(ETemplateFieldType.QueryField.getValue());
            JSONArray cmpItem = (JSONArray)fieidFormConfig.get(ETemplateFieldType.CmpItem.getValue());
            JSONArray other = (JSONArray)fieidFormConfig.get(ETemplateFieldType.Other.getValue());
            Map mulMap = (Map)fieidFormConfig.get(ETemplateFieldType.Mul.getValue());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("selectorFields", queryField);
            FilterInfo filterItems = new FilterInfo();
            filterItems.getFilterItems().add(new FilterItemInfo("billId", (Object)billInfo.getId().toString()));
            filterItems.getFilterItems().add(new FilterItemInfo("entryId", (Object)entryInfo.getId().toString()));
            IRowSet executeQuerySet = null;
            try {
                Map<String, Object> queryParam = ElectronicTemplateSqlUtils.getBizQueryParam(ctx, params, electronicTemplateInfo, filterItems);
                executeQuerySet = DbUtil.executeQuery((Context)ctx, (String)queryParam.get("sql").toString());
                infoMap = RowSetUtils.transformRowSetValue(ctx, infoMap, queryField, executeQuerySet, queryParam);
                ElectronicContractUtils.processMulFieldData(ctx, infoMap, mulMap, queryParam);
                ElectronicContractUtils.processCmpItemData(ctx, infoMap, cmpItem, person);
                ElectronicContractUtils.processOtherData(ctx, infoMap, other, person);
                map = infoMap;
                if (executeQuerySet == null) break block8;
            }
            catch (BOSException e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                    catch (EASBizException e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                        throw e2;
                    }
                    catch (Exception e3) {
                        logger.error(e3.getMessage(), (Throwable)e3);
                        throw new BOSException(e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (executeQuerySet != null) {
                        SQLUtils.cleanup(executeQuerySet);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)executeQuerySet);
        }
        return map;
    }

    public static void processMulFieldData(Context ctx, Map<String, String> infoMap, Map<String, JSONArray> mulMap, Map<String, Object> queryParam) throws BOSException, EASBizException, SQLException {
        if (mulMap == null || mulMap.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, JSONArray>> entrySet = mulMap.entrySet();
        Iterator<Map.Entry<String, JSONArray>> iterator = entrySet.iterator();
        String shortCode = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        String currLocaleSQL = queryParam.get("sql").toString();
        while (iterator.hasNext()) {
            IRowSet executeQuerySet = null;
            Map.Entry<String, JSONArray> next = iterator.next();
            String needLocale = next.getKey();
            if (shortCode.equals(needLocale)) continue;
            JSONArray mulArrayConfig = next.getValue();
            if (mulArrayConfig != null && mulArrayConfig.size() > 0) {
                String mulSQl = currLocaleSQL.replaceAll("_" + shortCode + "\\b", "_" + needLocale);
                logger.error("ElectronicContractUtils processMulFieldData needLocale mulSQl" + needLocale + " : " + mulSQl);
                executeQuerySet = DbUtil.executeQuery((Context)ctx, (String)mulSQl);
                infoMap = RowSetUtils.transformRowSetValue(ctx, infoMap, mulArrayConfig, executeQuerySet, queryParam);
            }
            if (executeQuerySet == null) continue;
            SQLUtils.cleanup(executeQuerySet);
        }
    }

    public static void processCmpItemData(Context ctx, Map<String, String> infoMap, JSONArray CmpItem, PersonInfo person) throws BOSException, EASBizException {
        if (CmpItem == null || CmpItem.size() <= 0) {
            return;
        }
        HashMap<String, String> info = new HashMap<String, String>();
        StringBuffer cmpItems = new StringBuffer();
        String isSensitive = "";
        for (int i = 0; i < CmpItem.size(); ++i) {
            com.alibaba.fastjson.JSONObject config = CmpItem.getJSONObject(i);
            String string = config.getString("key");
            String metaid = config.getString("metaid");
            isSensitive = config.getString("isSensitive");
            cmpItems.append(metaid).append(",");
            info.put(string, metaid);
        }
        Set entrySet = info.entrySet();
        if (person == null) {
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                infoMap.put(key, "/");
            }
            return;
        }
        try {
            HashMap<String, String> osfDataMap = new HashMap<String, String>();
            osfDataMap.put("personId", person.getId().toString());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            osfDataMap.put("endDate", simpleDateFormat.format(new Date()));
            osfDataMap.put("items", cmpItems.substring(0, cmpItems.length() - 1));
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            Map resultMap = (Map)osfServiceFacade.processService("getSalaryItemInfoService", osfDataMap);
            if (resultMap != null && resultMap.size() > 0) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                nf.setGroupingUsed(false);
                for (Map.Entry entry : entrySet) {
                    String cmpitem = (String)entry.getValue();
                    Double money = (Double)resultMap.get(cmpitem);
                    String key = (String)entry.getKey();
                    String newMoney = null;
                    if (money != null) {
                        if ("true".equals(isSensitive)) {
                            newMoney = RowSetUtils.getEncryFieldValue(ctx, null, null, nf.format(money));
                            infoMap.put(key, newMoney);
                            continue;
                        }
                        infoMap.put(key, nf.format(money));
                        continue;
                    }
                    infoMap.put(key, "/");
                }
            } else {
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    infoMap.put(key, "/");
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void processOtherData(Context ctx, Map<String, String> infoMap, JSONArray Other, PersonInfo person) {
    }

    public static Map<String, Object> sortFieidFormConfig(Context ctx, JSONArray configList) {
        String shortCode = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        JSONArray queryFieldArray = new JSONArray();
        JSONArray cmpItemArray = new JSONArray();
        JSONArray otherArray = new JSONArray();
        HashMap<String, JSONArray> mulMap = new HashMap<String, JSONArray>();
        for (int i = 0; i < configList.size(); ++i) {
            com.alibaba.fastjson.JSONObject config;
            block15: {
                BOSUuid bosUuid;
                String metaid;
                config = configList.getJSONObject(i);
                String type = config.getString("type");
                if (ETemplateFieldType.QueryField.getValue().equalsIgnoreCase(type)) {
                    queryFieldArray.add((Object)config);
                } else if (ETemplateFieldType.CmpItem.getValue().equalsIgnoreCase(type)) {
                    metaid = config.getString("metaid");
                    bosUuid = BOSUuid.read((String)metaid);
                    if ("FCB49097".equals(bosUuid.getType().toString())) {
                        cmpItemArray.add((Object)config);
                    }
                } else if (ETemplateFieldType.Other.getValue().equalsIgnoreCase(type)) {
                    otherArray.add((Object)config);
                } else {
                    metaid = config.getString("metaid");
                    if (!StringUtils.isEmpty((String)metaid)) {
                        try {
                            bosUuid = BOSUuid.read((String)metaid);
                            if ("FCB49097".equals(bosUuid.getType().toString())) {
                                cmpItemArray.add((Object)config);
                                break block15;
                            }
                            queryFieldArray.add((Object)config);
                        }
                        catch (IllegalArgumentException e) {
                            queryFieldArray.add((Object)config);
                        }
                        catch (Exception e) {
                            queryFieldArray.add((Object)config);
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        queryFieldArray.add((Object)config);
                    }
                }
            }
            Object isMul = config.get((Object)"isMul");
            String isMulStr = config.getString("isMul");
            if (isMul == null || !"true".equalsIgnoreCase(isMulStr) && !config.getBoolean("isMul").booleanValue()) continue;
            String format = config.getString("format");
            JSONArray jsonArray = (JSONArray)mulMap.get(format);
            if (jsonArray == null) {
                jsonArray = new JSONArray();
                mulMap.put(format, jsonArray);
            }
            jsonArray.add((Object)config);
        }
        mulMap.remove(shortCode);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ETemplateFieldType.QueryField.getValue(), queryFieldArray);
        result.put(ETemplateFieldType.CmpItem.getValue(), cmpItemArray);
        result.put(ETemplateFieldType.Other.getValue(), otherArray);
        result.put(ETemplateFieldType.Mul.getValue(), mulMap);
        logger.error("ElectronicContractUtils.sortFieidFormConfig queryFieldArray: " + queryFieldArray + " cmpItemArray: " + cmpItemArray + " otherArray: " + otherArray + " mulMap: " + mulMap);
        return result;
    }

    public static CoreBaseInfo copyAndSaveBizBillDataToMiddle(Context ctx, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo, CoreBaseInfo middle) throws BOSException, EASBizException {
        ContactBillMiddleUtils.copyData(ctx, (IObjectValue)billInfo, (IObjectValue)middle);
        ContactBillMiddleUtils.copyData(ctx, (IObjectValue)entryInfo, (IObjectValue)middle);
        try {
            IObjectPK savePk = MetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)middle.getBOSType()).save(middle);
            middle.setId(BOSUuid.read((String)savePk.toString()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return middle;
    }

    public static HRBillBaseInfo getEntryAndOtherEntryByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        HRBillBaseInfo info = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("otherEntrys.*"));
        BOSUuid bosUuid = BOSUuid.read((String)billId);
        info = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosUuid.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        if (info == null) {
            logger.error("getEntryAndOtherEntryByBillId : billId " + billId);
            return null;
        }
        return info;
    }

    public static SHRAttachmentExtInfo saveAttachment(Context ctx, String boID, String fullname, byte[] filedata, String propertyName) throws BOSException, EASBizException {
        fullname = ElectronicContractUtils.checkScriptAttack(fullname);
        String mainname = fullname.substring(0, fullname.lastIndexOf(46));
        String extname = fullname.substring(fullname.lastIndexOf(46) + 1, fullname.length());
        extname = extname.toLowerCase();
        SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
        AttachmentInfo ai = new AttachmentInfo();
        BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
        Locale locale_en_US = LocaleUtils.locale_en_US;
        Locale locale_zh_CN = LocaleUtils.locale_zh_CN;
        Locale locale_zh_TW = LocaleUtils.locale_zh_TW;
        ai.setName(mainname, locale_en_US);
        ai.setName(mainname, locale_zh_CN);
        ai.setName(mainname, locale_zh_TW);
        ai.setSimpleName(extname);
        ai.setDescription("");
        ai.setFile(filedata);
        ai.setIsShared(false);
        String label26 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label26", (Context)ctx);
        ai.setSharedDesc(label26);
        int size = filedata.length;
        if (size < 1024) {
            String label27 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label27", (Context)ctx);
            String realObj = MessageFormat.format(label27, size);
            ai.setSize(realObj);
        } else {
            ai.setSize(size / 1024 + "KB");
        }
        ai.setSizeInByte(size);
        ai.setAttachID("" + System.currentTimeMillis());
        ai.setType(extname);
        attchExt.setAttachment(ai);
        attchExt.setName(fullname, locale_en_US);
        attchExt.setName(fullname, locale_zh_CN);
        attchExt.setName(fullname, locale_zh_TW);
        if (StringUtils.isEmpty((String)propertyName)) {
            attchExt.setPropertyName("null0");
        } else {
            attchExt.setPropertyName(propertyName);
        }
        attchExt.setType(AttachmentTypeEnum.PROPERTY);
        attchExt.setState(AttachmentState.SAVE);
        attchExt.setBoID(boID);
        boAttchAssoInfo.setBoID(boID);
        boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boID, (boolean)true)));
        boAttchAssoInfo.setAssoType("Added Accessories");
        boAttchAssoInfo.setAttachment(ai);
        try {
            IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
            IBoAttchAsso attchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            attachment.addnew(ai);
            attchAsso.addnew(boAttchAssoInfo);
            shrAttchExt.addnew((CoreBaseInfo)attchExt);
            return attchExt;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String label29 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label29", (Context)ctx);
            String label30 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label30", (Context)ctx);
            String label31 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label31", (Context)ctx);
            String label32 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label32", (Context)ctx);
            throw new BOSException(label29 + "\uff1a\n1\u3001" + label30 + "\uff1b\n2\u3001" + label31 + "\uff1b\n3\u3001" + label32 + "\u3002");
        }
    }

    public static String getContractTempletSeal(Context ctx, String templetId) throws BOSException, EASBizException {
        return SHRElectronicTemplateFactory.getLocalInstance((Context)ctx).getSHRElectronicTemplateInfo("where contractTemplet = '" + templetId + "'").getEContractSealType().getId().toString();
    }

    public static List<String> getContractTempletSealList(Context ctx, Map<String, List<String>> contractSealMap, String kdContractConfigInfoId) throws BOSException, EASBizException {
        List<String> contractSealList = new ArrayList<String>();
        if (contractSealMap.containsKey(kdContractConfigInfoId)) {
            contractSealList = contractSealMap.get(kdContractConfigInfoId);
        }
        return contractSealList;
    }

    public static Map<String, List<String>> getNoSetContractSealTypeTemplet(Context ctx, Map<String, List<String>> contractSealMap) throws BOSException, EASBizException {
        if (contractSealMap.isEmpty()) {
            return null;
        }
        HashMap<String, List<String>> noSetContractSealMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : contractSealMap.entrySet()) {
            String kdContractConfig = entry.getKey();
            List<String> contractSealTypeList = entry.getValue();
            ArrayList<String> noSetContractSealList = new ArrayList<String>();
            IEContractSignImg localInstance = EContractSignImgFactory.getLocalInstance(ctx);
            for (int i = 0; i < contractSealTypeList.size(); ++i) {
                String contractSealType = contractSealTypeList.get(i);
                if ("00000000-0000-0000-0000-00000000000057D8E364".equals(contractSealType) || localInstance.exists("where kdContractConfig = '" + kdContractConfig + "' and eContractSealType = '" + contractSealType + "'")) continue;
                EContractSealTypeInfo eContractSealTypeInfo = EContractSealTypeFactory.getLocalInstance(ctx).getEContractSealTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)contractSealType)));
                noSetContractSealList.add(eContractSealTypeInfo.getName());
            }
            if (noSetContractSealList.size() <= 0) continue;
            KDContractConfigInfo kdContractConfigInfo = KDContractConfigFactory.getLocalInstance(ctx).getKDContractConfigInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)kdContractConfig)));
            noSetContractSealMap.put(kdContractConfigInfo.getEnterpriseName(), noSetContractSealList);
        }
        return noSetContractSealMap;
    }

    public static String checkScriptAttack(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            if (str.contains("<")) {
                str = str.replaceAll("<", "&lt;");
            }
            if (str.contains(">")) {
                str = str.replaceAll(">", "&gt;");
            }
        }
        return str;
    }
}

