/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.elecontract.util.Base64Utils;
import com.kingdee.shr.elecontract.util.EContractServiceUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractOperationLogUtils {
    private static final Logger logger = LoggerFactory.getLogger(EContractOperationLogUtils.class);
    private static final String ENTITY_BOSTYPE = "7D3936B6";
    private static final String ENTITY_META_FULL_NAME = "com.kingdee.shr.econtractservice.app.EContractOperationLog";
    private static final String ENTITY_META_TABLE_FULL_NAME = "com.kingdee.shr.econtractservice.app.T_SHR_EContractOLog";
    private static final String TABLE_NAME = "T_SHR_EContractOLog";

    public static void addLog(Context ctx, String nonce, String target, String node, String params, String result) {
        try {
            int clen;
            CoreBaseInfo newModel = EContractServiceUtils.createNewModel(ctx, ENTITY_META_FULL_NAME);
            newModel.put("boId", (Object)nonce);
            int len = target.length();
            if (len > 256) {
                clen = len - 256;
                target = target.substring(clen);
            }
            newModel.put("target", (Object)target);
            len = node.length();
            if (len > 32) {
                clen = len - 32;
                node = node.substring(clen);
            }
            newModel.put("node", (Object)node);
            newModel.put("params", (Object)Base64Utils.encode(params));
            newModel.put("result", (Object)Base64Utils.encode(result));
            IObjectPK iObjectPK = EContractServiceUtils.getBizInterface(ctx, newModel).save(newModel);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static void addLogFromResult(Context ctx, String nonce, String target, String node, String params, Map result) {
        try {
            String boId = EContractOperationLogUtils.getBoParam(ctx, result);
            if (StringUtils.isEmpty((CharSequence)boId)) {
                boId = nonce;
            }
            EContractOperationLogUtils.addLog(ctx, boId, target, node, params, JSONUtils.convertObjectToJson((Context)ctx, (Object)result));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static void addLog(Context ctx, String nonce, String target, String node, Map params, String result) {
        try {
            CoreBaseInfo newModel = EContractServiceUtils.createNewModel(ctx, ENTITY_META_FULL_NAME);
            String boId = EContractOperationLogUtils.getBoParam(ctx, params);
            if (StringUtils.isEmpty((CharSequence)boId)) {
                boId = nonce;
            }
            newModel.put("boId", (Object)boId);
            int len = target.length();
            int clen = 0;
            if (len > 256) {
                clen = len - 256;
                target = target.substring(clen);
            }
            newModel.put("target", (Object)target);
            len = node.length();
            if (len > 32) {
                clen = len - 32;
                node = node.substring(clen);
            }
            newModel.put("node", (Object)node);
            String paramsStr = JSONUtils.convertObjectToJson((Context)ctx, (Object)params);
            newModel.put("params", (Object)Base64Utils.encode(paramsStr));
            newModel.put("result", (Object)Base64Utils.encode(result));
            IObjectPK iObjectPK = EContractServiceUtils.getBizInterface(ctx, newModel).save(newModel);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static String getBoParam(Context ctx, Map params) {
        String boPram = "";
        try {
            Object dataObj = params.get("data");
            if (dataObj instanceof Map) {
                Map data = (Map)dataObj;
                if (data.get("contractNo") != null) {
                    boPram = String.valueOf(data.get("contractNo"));
                    return boPram;
                }
                if (data.get("contractNO") != null) {
                    boPram = String.valueOf(data.get("contractNO"));
                    return boPram;
                }
                if (data.get("userId") != null) {
                    boPram = String.valueOf(data.get("userId"));
                    return boPram;
                }
                if (data.get("signatureId") != null) {
                    boPram = String.valueOf(data.get("signatureId"));
                    return boPram;
                }
                if (data.get("name") != null) {
                    boPram = String.valueOf(data.get("name"));
                    String str = Base64Utils.encode(boPram);
                    return str;
                }
                if (data.get("templateID") != null) {
                    boPram = String.valueOf(data.get("templateID"));
                    return boPram;
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return boPram;
    }
}

