/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractEndBizBillInfo;
import com.kingdee.eas.hr.contract.ContractFreeBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBillInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillInfo;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.lightapp.wx.WXUtil;
import com.kingdee.shr.elecontract.util.URLUtils;
import com.kingdee.shr.elecontract.util.XTServiceConfigUtils;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicTaskAppUtils {
    public static final Logger logger = LoggerFactory.getLogger(ElectronicTaskAppUtils.class);
    public static final String KDAPP_ECONTRACT_NUMBER = "kdappEContractNumber";
    public static final String IS_SENDLIGHTMSG_TO_WEIXIN = "IS_SENDLIGHTMSG_TO_WEIXIN";

    public String getLCFPNameByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        HRBillBaseInfo info = this.getHRBillBaseInfo(ctx, billId);
        return this.getLCFPNameByBillId(ctx, info);
    }

    public String getLCFPNameByBillId(Context ctx, HRBillBaseInfo info) throws EASBizException, BOSException {
        ContractRenewBizBillEntryInfo contract;
        if (info == null) {
            return null;
        }
        String lcfpName = null;
        if (info instanceof ContractRenewBizBillInfo) {
            contract = ((ContractRenewBizBillInfo)info).getEntrys().get(0);
            lcfpName = contract.getLCFPName();
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            lcfpName = ((ContractPreSignBizBillInfo)info).getLCFPName();
        }
        if (info instanceof ContractSignBizBillInfo) {
            lcfpName = ((ContractSignBizBillInfo)info).getLCFPName();
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            lcfpName = ((OtherContractSignBizBillInfo)info).getLCFPName();
        }
        if (info instanceof ContractChangeBizBillInfo) {
            contract = ((ContractChangeBizBillInfo)info).getEntrys().get(0);
            lcfpName = contract.getLCFPName();
        }
        return lcfpName;
    }

    public HRBillBaseInfo getHRBillBaseInfo(Context ctx, String billId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        return this.getHRBillBaseInfo(ctx, billId, selector);
    }

    public HRBillBaseInfo getHRBillBaseInfo(Context ctx, String billId, SelectorItemCollection selector) throws EASBizException, BOSException {
        HRBillBaseInfo info = null;
        BOSUuid bosUuid = BOSUuid.read((String)billId);
        info = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosUuid.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        if (info == null) {
            return null;
        }
        return info;
    }

    public LabContractFirstPartyInfo getLabContractFirstPartyByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        HRBillBaseInfo info = this.getHRBillBaseInfo(ctx, billId);
        return this.getLabContractFirstPartyByBillId(ctx, info);
    }

    public LabContractFirstPartyInfo getLabContractFirstPartyByBillId(Context ctx, HRBillBaseInfo info) throws EASBizException, BOSException {
        ContractRenewBizBillEntryInfo contract;
        if (info == null) {
            return null;
        }
        String labContractFirstPartyInfoId = null;
        if (info instanceof ContractRenewBizBillInfo) {
            contract = ((ContractRenewBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            labContractFirstPartyInfoId = ((ContractPreSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractSignBizBillInfo) {
            labContractFirstPartyInfoId = ((ContractSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            labContractFirstPartyInfoId = ((OtherContractSignBizBillInfo)info).getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractChangeBizBillInfo) {
            contract = ((ContractChangeBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractFreeBizBillInfo) {
            contract = ((ContractFreeBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (info instanceof ContractEndBizBillInfo) {
            contract = ((ContractEndBizBillInfo)info).getEntrys().get(0);
            labContractFirstPartyInfoId = contract.getLabContractFirstParty().getId().toString();
        }
        if (StringUtils.isEmpty((String)labContractFirstPartyInfoId)) {
            return null;
        }
        return LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstPartyInfoId));
    }

    public PreEntryInfo getPreEntryInfo(Context ctx, String preEntryPersonId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("cellPhone"));
        selector.add(new SelectorItemInfo("talent.id"));
        selector.add(new SelectorItemInfo("talent.idCardNO"));
        selector.add(new SelectorItemInfo("adminOrg.company.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("talent.id", (Object)preEntryPersonId));
        view.setFilter(filter);
        view.setSelector(selector);
        PreEntryCollection colls = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(view);
        if (colls.size() > 0) {
            return colls.get(0);
        }
        return new PreEntryInfo();
    }

    public Map<String, String> getProcessInfo(Context ctx, HRBillBaseInfo info) throws BOSException, EASBizException {
        ContractSignBizBillInfo signBizBillInfo;
        ContractRenewBizBillEntryInfo entryInfo;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (info instanceof ContractRenewBizBillInfo) {
            ContractRenewBizBillInfo renewBizBillInfo = (ContractRenewBizBillInfo)info;
            entryInfo = renewBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractPreSignBizBillInfo) {
            ContractPreSignBizBillInfo preSignBizBillInfo = (ContractPreSignBizBillInfo)info;
            entryInfo = preSignBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractSignBizBillInfo) {
            signBizBillInfo = (ContractSignBizBillInfo)info;
            entryInfo = signBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof OtherContractSignBizBillInfo) {
            signBizBillInfo = (OtherContractSignBizBillInfo)info;
            entryInfo = signBizBillInfo.getEntrys().get(0);
            if (((OtherContractSignBizBillInfo)info).isIsPreEntry()) {
                dataMap.put("personId", entryInfo.getPreEntryPerson().getId().toString());
            } else {
                dataMap.put("personId", entryInfo.getPerson().getId().toString());
            }
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        if (info instanceof ContractChangeBizBillInfo) {
            ContractChangeBizBillInfo changeBizBillInfo = (ContractChangeBizBillInfo)info;
            entryInfo = changeBizBillInfo.getEntrys().get(0);
            dataMap.put("personId", entryInfo.getPerson().getId().toString());
            dataMap.put("contractNo", entryInfo.getContractNo());
            dataMap.put("entryId", entryInfo.getId().toString());
            dataMap.put("templateId", entryInfo.getContractTemplet().getId().toString());
        }
        return dataMap;
    }

    public boolean isSendToWeixin(Context ctx) throws BOSException, EASBizException {
        return HRParamUtil.getParamOfHR((Context)ctx, (String)IS_SENDLIGHTMSG_TO_WEIXIN, null);
    }

    public String processWeiXinMessageURL(Context ctx, String url) throws BOSException, EASBizException {
        StringBuffer stringBuffer = new StringBuffer(url);
        String contractWxAppId = XTServiceConfigUtils.getShrWxAppItemProperty("contractSign", "appId");
        String basePath = URLUtils.getBasePath(url);
        Map<String, String> queryParams = URLUtils.getQueryParams(url);
        String[] config = WXUtil.getWXConfig();
        queryParams.put("appid", contractWxAppId);
        url = URLUtils.assembleUrl(basePath, queryParams);
        stringBuffer = new StringBuffer(url);
        stringBuffer.append("&agentid=").append(contractWxAppId);
        stringBuffer.append("&eid=").append(config[0]);
        return stringBuffer.toString();
    }
}

