/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.File;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnClient {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.util.SvnClient");
    private String svnPath;
    private String user;
    private String password;
    private SVNClientManager svnClientManager = null;

    public SvnClient(String svnPath, String user, String password) {
        this.svnPath = svnPath;
        this.user = user;
        this.password = password;
    }

    public void connectSVN() throws BOSException {
        if (this.svnPath.startsWith("http")) {
            DAVRepositoryFactory.setup();
        } else if (this.svnPath.startsWith("svn")) {
            SVNRepositoryFactoryImpl.setup();
        } else if (this.svnPath.startsWith("file")) {
            FSRepositoryFactory.setup();
        } else {
            throw new BOSException("Wrong SVN address format");
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.svnClientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)this.user, (String)this.password);
    }

    public void close() {
        if (this.svnClientManager == null) {
            return;
        }
        this.svnClientManager.dispose();
        this.svnClientManager = null;
    }

    public void doUpdate(String localDirPath) throws BOSException {
        if (null == this.svnClientManager) {
            throw new BOSException("SVN is not connected");
        }
        SVNUpdateClient updateClient = this.svnClientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        File localDir = new File(SHRCheck.checkFilePath((String)localDirPath));
        try {
            updateClient.doUpdate(localDir, SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
        }
        catch (Exception e) {
            throw new BOSException("SVN update fail", (Throwable)e);
        }
    }
}

