/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.socialSecurity.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CalFunctionService
extends SalaryCalFunction {
    public String getSocEmpSocFilesCurrency(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId) {
        try {
            HashMap socTempMap = new HashMap();
            String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
            String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
            if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
                return "";
            }
            String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            socTempMap = (HashMap)tempMap.get(fixPayMapKey);
            String socRecordId = "";
            String socFilesCurrencyName = "";
            String key = personid + "_" + socItemId;
            if (socTempMap.get(key) != null) {
                Map map = (Map)socTempMap.get(key);
                socFilesCurrencyName = (String)map.get("socFilesCurrencyName");
                socRecordId = (String)map.get("socRecordId");
                paramMap.put("socRecordId", socRecordId);
            }
            if (socFilesCurrencyName == null || "".equals(socFilesCurrencyName)) {
                return "";
            }
            return socFilesCurrencyName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public double getSocBaseSocFiles(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId, double isCompanyPay) {
        BigDecimal zero;
        HashMap socTempMap = new HashMap();
        String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
            return 0.0;
        }
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
        Date endDate = calScheme.getEndDate();
        Date beginDate = calScheme.getBeginDate();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, beginDate, endDate, mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        BigDecimal companyBase = zero = new BigDecimal(0);
        BigDecimal selfBase = zero;
        BigDecimal basePay = zero;
        BigDecimal maxPay = zero;
        BigDecimal minPay = zero;
        BigDecimal companyMaxPay = zero;
        BigDecimal companyMinPay = zero;
        boolean hasSocFiles = false;
        String socRecordId = "";
        String key = personid + "_" + socItemId;
        String socFilesCurrencyID = "";
        if (socTempMap.get(key) != null) {
            Map map = (Map)socTempMap.get(key);
            maxPay = (BigDecimal)map.get("FMaxPay");
            minPay = (BigDecimal)map.get("FMinPay");
            companyMaxPay = (BigDecimal)map.get("FCompanyMaxPay");
            companyMinPay = (BigDecimal)map.get("FCompanyMinPay");
            companyBase = (BigDecimal)map.get("FCompanyBase");
            selfBase = (BigDecimal)map.get("FSelfBase");
            socRecordId = (String)map.get("socRecordId");
            socFilesCurrencyID = (String)map.get("socFilesCurrencyID");
            rate = null == currencyMap.get(socFilesCurrencyID) ? new BigDecimal(1) : currencyMap.get(socFilesCurrencyID);
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return basePay.multiply(rate).doubleValue();
        }
        if (isCompanyPay == 0.0) {
            basePay = selfBase;
        } else {
            basePay = companyBase;
            maxPay = companyMaxPay;
            minPay = companyMinPay;
        }
        if (maxPay != null && basePay.compareTo(maxPay) > 0) {
            basePay = maxPay;
        } else if (minPay != null && basePay.compareTo(minPay) < 0) {
            basePay = minPay;
        }
        return basePay.multiply(rate).doubleValue();
    }

    public double getSocEmpSocFiles(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId, double isCompanyPay) {
        HashMap socTempMap = new HashMap();
        String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
            return 0.0;
        }
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        boolean hasSocFiles = false;
        Map<String, Object> tempmap = new HashMap();
        String key = personid + "_" + socItemId;
        if (socTempMap.get(key) != null) {
            tempmap = (Map)socTempMap.get(key);
            String socRecordId = (String)tempmap.get("socRecordId");
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return 0.0;
        }
        return this.getSocPayValue(calScheme, tempmap, isCompanyPay, currencyMap);
    }

    public double getSocPayValue(CalSchemeInfo calScheme, Map<String, Object> tempmap, double isCompanyPay, Map<String, BigDecimal> currencyMap) {
        boolean isCurrency = null != calScheme.getCurrency();
        BigDecimal zero = new BigDecimal(0);
        BigDecimal companyBase = tempmap.get("FCompanyBase") == null ? zero : (BigDecimal)tempmap.get("FCompanyBase");
        BigDecimal selfBase = tempmap.get("FSelfBase") == null ? zero : (BigDecimal)tempmap.get("FSelfBase");
        BigDecimal maxPay = (BigDecimal)tempmap.get("FMaxPay");
        BigDecimal minPay = (BigDecimal)tempmap.get("FMinPay") == null ? zero : (BigDecimal)tempmap.get("FMinPay");
        BigDecimal companyMaxPay = (BigDecimal)tempmap.get("FCompanyMaxPay");
        BigDecimal companyMinPay = (BigDecimal)tempmap.get("FCompanyMinPay") == null ? zero : (BigDecimal)tempmap.get("FCompanyMinPay");
        BigDecimal selfPrec = tempmap.get("FSelfPrec") == null ? zero : (BigDecimal)tempmap.get("FSelfPrec");
        BigDecimal companyPrec = tempmap.get("FCompanyPrec") == null ? zero : (BigDecimal)tempmap.get("FCompanyPrec");
        BigDecimal selfFixedPay = (BigDecimal)tempmap.get("FSelfFixedPay") == null ? zero : (BigDecimal)tempmap.get("FSelfFixedPay");
        BigDecimal companyFixedPay = (BigDecimal)tempmap.get("FCompanyFixedPay") == null ? zero : (BigDecimal)tempmap.get("FCompanyFixedPay");
        String socFilesCurrencyID = (String)tempmap.get("socFilesCurrencyID");
        BigDecimal basePay = zero;
        BigDecimal soc = zero;
        BigDecimal rate = new BigDecimal(1);
        if (isCurrency) {
            BigDecimal bigDecimal = rate = null == currencyMap.get(socFilesCurrencyID) ? new BigDecimal(1) : currencyMap.get(socFilesCurrencyID);
        }
        if (isCompanyPay == 0.0) {
            basePay = selfBase;
        } else {
            basePay = companyBase;
            maxPay = companyMaxPay;
            minPay = companyMinPay;
        }
        if (maxPay != null && basePay.compareTo(maxPay) > 0) {
            basePay = maxPay;
        } else if (minPay != null && basePay.compareTo(minPay) < 0) {
            basePay = minPay;
        }
        if (isCompanyPay == 0.0) {
            soc = basePay.multiply(selfPrec.divide(new BigDecimal(100))).add(selfFixedPay);
        } else if (isCompanyPay == 1.0) {
            soc = basePay.multiply(companyPrec.divide(new BigDecimal(100))).add(companyFixedPay);
        } else {
            return 0.0;
        }
        return soc.multiply(rate).doubleValue();
    }

    public String getSocAreaName(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId) throws Exception {
        try {
            HashMap socTempMap = new HashMap();
            String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
            String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
            if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
                return "";
            }
            String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
            if (tempMap.get(fixPayMapKey) == null) {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            socTempMap = (HashMap)tempMap.get(fixPayMapKey);
            String socRecordId = "";
            String socAreaName = "";
            String key = personid + "_" + socItemId;
            if (socTempMap.get(key) != null) {
                Map map = (Map)socTempMap.get(key);
                socAreaName = (String)map.get("socAreaName");
                socRecordId = (String)map.get("socRecordId");
                paramMap.put("socRecordId", socRecordId);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)socAreaName)) {
                return "";
            }
            return socAreaName;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return "";
        }
    }

    public double getSocMaxPay(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId, double isCompanyPay) {
        BigDecimal zero;
        HashMap socTempMap = new HashMap();
        String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
            return 0.0;
        }
        BigDecimal rate = new BigDecimal(1);
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        BigDecimal soc = zero = new BigDecimal(0);
        BigDecimal maxPay = zero;
        BigDecimal companyMaxPay = zero;
        boolean hasSocFiles = false;
        String socRecordId = "";
        String key = personid + "_" + socItemId;
        String calCurrencyID = "";
        String socFilesCurrencyID = "";
        if (socTempMap.get(key) != null) {
            Map map = (Map)socTempMap.get(key);
            maxPay = (BigDecimal)map.get("FMaxPay");
            companyMaxPay = (BigDecimal)map.get("FCompanyMaxPay");
            socRecordId = (String)map.get("socRecordId");
            calCurrencyID = (String)map.get("calCurrencyID");
            socFilesCurrencyID = (String)map.get("socFilesCurrencyID");
            rate = null == currencyMap.get(socFilesCurrencyID) ? new BigDecimal(1) : currencyMap.get(socFilesCurrencyID);
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return soc.multiply(rate).doubleValue();
        }
        if (isCompanyPay == 0.0) {
            soc = maxPay;
        } else if (isCompanyPay == 1.0) {
            soc = companyMaxPay;
        } else {
            return 0.0;
        }
        if (null == soc) {
            return Integer.valueOf("999999999").intValue();
        }
        return soc.multiply(rate).doubleValue();
    }

    public double getSocMinPay(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId, double isCompanyPay) {
        BigDecimal zero;
        HashMap socTempMap = new HashMap();
        String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
            return 0.0;
        }
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        BigDecimal soc = zero = new BigDecimal(0);
        BigDecimal minPay = zero;
        BigDecimal companyMinPay = zero;
        boolean hasSocFiles = false;
        String socRecordId = "";
        String key = personid + "_" + socItemId;
        String socFilesCurrencyID = "";
        if (socTempMap.get(key) != null) {
            Map map = (Map)socTempMap.get(key);
            minPay = (BigDecimal)map.get("FMinPay");
            companyMinPay = (BigDecimal)map.get("FCompanyMinPay");
            socRecordId = (String)map.get("socRecordId");
            socFilesCurrencyID = (String)map.get("socFilesCurrencyID");
            rate = null == currencyMap.get(socFilesCurrencyID) ? new BigDecimal(1) : currencyMap.get(socFilesCurrencyID);
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return soc.multiply(rate).doubleValue();
        }
        if (isCompanyPay == 0.0) {
            soc = minPay;
        } else if (isCompanyPay == 1.0) {
            soc = companyMinPay;
        } else {
            return 0.0;
        }
        return soc.multiply(rate).doubleValue();
    }

    public double getSocFixedPay(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId, double isCompanyPay) {
        BigDecimal zero;
        HashMap socTempMap = new HashMap();
        String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
            return 0.0;
        }
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
        BigDecimal rate = new BigDecimal(1);
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        BigDecimal soc = zero = new BigDecimal(0);
        BigDecimal selfFixedPay = zero;
        BigDecimal companyFixedPay = zero;
        boolean hasSocFiles = false;
        String socRecordId = "";
        String key = personid + "_" + socItemId;
        String socFilesCurrencyID = "";
        if (socTempMap.get(key) != null) {
            Map map = (Map)socTempMap.get(key);
            selfFixedPay = (BigDecimal)map.get("FSelfFixedPay");
            companyFixedPay = (BigDecimal)map.get("FCompanyFixedPay");
            socRecordId = (String)map.get("socRecordId");
            socFilesCurrencyID = (String)map.get("socFilesCurrencyID");
            rate = null == currencyMap.get(socFilesCurrencyID) ? new BigDecimal(1) : currencyMap.get(socFilesCurrencyID);
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return soc.multiply(rate).doubleValue();
        }
        if (isCompanyPay == 0.0) {
            soc = selfFixedPay;
        } else if (isCompanyPay == 1.0) {
            soc = companyFixedPay;
        } else {
            return 0.0;
        }
        return soc.multiply(rate).doubleValue();
    }

    public double getSocPrec(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String mainTableRowFilter, String socItemId, double isCompanyPay) {
        BigDecimal zero;
        HashMap socTempMap = new HashMap();
        String tableid = (String)paramMap.get("T_HR_SCMPCALTABLE_FID");
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        if (StringUtils.isEmpty((String)socItemId) || StringUtils.isEmpty((String)personid) || StringUtils.isEmpty((String)tableid)) {
            return 0.0;
        }
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + calScheme.getEndDate();
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemId, calScheme.getBeginDate(), calScheme.getEndDate(), mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        BigDecimal soc = zero = new BigDecimal(0);
        BigDecimal selfPrec = zero;
        BigDecimal companyPrec = zero;
        boolean hasSocFiles = false;
        String socRecordId = "";
        String key = personid + "_" + socItemId;
        if (socTempMap.get(key) != null) {
            Map map = (Map)socTempMap.get(key);
            selfPrec = (BigDecimal)map.get("FSelfPrec");
            companyPrec = (BigDecimal)map.get("FCompanyPrec");
            socRecordId = (String)map.get("socRecordId");
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return soc.doubleValue();
        }
        if (isCompanyPay == 0.0) {
            soc = selfPrec;
        } else if (isCompanyPay == 1.0) {
            soc = companyPrec;
        } else {
            return 0.0;
        }
        return soc.doubleValue();
    }

    public Map<String, Map<String, Object>> initSocEmpSocFilesMap(CalSchemeInfo calScheme, String socItemId, Date beginDate, Date endDate, String mainTableRowFilter) throws Exception {
        BigDecimal zero;
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        int calTime = calScheme.getCalTime();
        String calSchemeId = calScheme.getId().toString();
        String ksqlEndDate = CmpDateUtil.toKSqlDate((Date)endDate);
        Context ctx = Tools.getInstance().getCtx();
        String langIndex = calScheme.getLanType().getValue();
        String FENDDATE = ksqlEndDate;
        String FBEGINDATE = CmpDateUtil.toKSqlDate((Date)beginDate);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/*dialect*/SELECT t1.* from ( ");
        sqlBuilder.append("SELECT t.*, row_number() over(partition by t.FPersonID,t.fnumber order by t.entryEffdt desc) rn FROM ( ");
        sqlBuilder.append("SELECT (select FHRORGUNITID from T_HR_SCalScheme where fid = '" + calSchemeId + "') as org, cmpOrg, socRecordId, FPersonID,fnumber,adminOrgName,FSocAccount,FHouseFundAccount,FMedInsuranceAccount,FEffectDay,entryEffdt,socTypeName");
        sqlBuilder.append(",FCompanyBase,FSelfBase,FMaxPay,FMinPay,FCompanyMaxPay,FCompanyMinPay,FSelfPrec,FCompanyPrec");
        sqlBuilder.append(",FSelfFixedPay,FCompanyFixedPay,socAreaName,socFilesCurrencyID,socFilesCurrencyName,calCurrencyID,calCurrencyName ");
        sqlBuilder.append(" FROM (");
        sqlBuilder.append("(SELECT T_HR_SSocEmpSocFiles.FCMPORGUNIT cmpOrg,socRecord.fid socRecordId, T_BD_Person.Fid as FPersonID,T_HR_SSocItem.fnumber,T_ORG_Admin.FName_" + langIndex + " as adminOrgName");
        sqlBuilder.append(",T_HR_SSocEmpSocFiles.FSocAccount,T_HR_SSocEmpSocFiles.FHouseFundAccount,T_HR_SSocEmpSocFiles.FEffectDay, T_HR_SSocEmpSocFiles.FMedInsuranceAccount");
        sqlBuilder.append(",entry.FEffectDay AS entryEffdt,T_HR_SSocType.FName_" + langIndex + " as socTypeName");
        sqlBuilder.append(",entry.FCompanyBase,entry.FSelfBase");
        sqlBuilder.append(",T_HR_SSocTypeItem.FMaxPay,T_HR_SSocTypeItem.FMinPay");
        sqlBuilder.append(",T_HR_SSocTypeItem.FCompanyMaxPay,T_HR_SSocTypeItem.FCompanyMinPay");
        sqlBuilder.append(",T_HR_SSocTypeItem.FSelfPrec,T_HR_SSocTypeItem.FCompanyPrec");
        sqlBuilder.append(",T_HR_SSocTypeItem.FSelfFixedPay,T_HR_SSocTypeItem.FCompanyFixedPay");
        sqlBuilder.append(",T_HR_SSocArea.FNAME_" + langIndex + " AS socAreaName");
        sqlBuilder.append(",socFilesCurrency.FID AS socFilesCurrencyID");
        sqlBuilder.append(",socFilesCurrency.FNAME_" + langIndex + " AS socFilesCurrencyName");
        sqlBuilder.append(",calCurrency.FID AS calCurrencyID");
        sqlBuilder.append(",calCurrency.FNAME_" + langIndex + " AS calCurrencyName");
        sqlBuilder.append(" from T_HR_SSocPersonRecord socRecord ");
        sqlBuilder.append(" left join T_HR_SSocEmpSocFiles on socRecord.fid=T_HR_SSocEmpSocFiles.FBillID ");
        sqlBuilder.append(" left join T_ORG_Admin on T_HR_SSocEmpSocFiles.FJoinSocOrgID = T_ORG_Admin.fid ");
        sqlBuilder.append(" left join  T_HR_SSocEmpSocFilesEntry entry");
        sqlBuilder.append(" on T_HR_SSocEmpSocFiles.Fid = entry.FBillID");
        sqlBuilder.append(" left join T_HR_SSocType on T_HR_SSocType.Fid = T_HR_SSocEmpSocFiles.FSocTypeID");
        sqlBuilder.append(" left join T_HR_SSocArea on T_HR_SSocType.FSocAreaID = T_HR_SSocArea.Fid");
        sqlBuilder.append(" left join T_HR_SSocTypeItemHis T_HR_SSocTypeItem on T_HR_SSocTypeItem.Fid = entry.FSocTypeItemID");
        sqlBuilder.append(" left join T_HR_SSocItem on T_HR_SSocItem.Fid = T_HR_SSocTypeItem.FSocItemID");
        sqlBuilder.append(" left join T_HR_SSocEmpPayStatus on T_HR_SSocEmpPayStatus.FSocPersonRecordID = socRecord.fid and T_HR_SSocEmpPayStatus.FSocCategoryID = T_HR_SSocItem.FSocCategoryID");
        sqlBuilder.append(" inner join T_BD_Person on T_BD_Person.Fid = T_HR_SSocEmpSocFiles.FPersonId");
        sqlBuilder.append(" inner join T_HR_SCmpCalTable on T_BD_Person.Fid = T_HR_SCmpCalTable.FPersonId");
        sqlBuilder.append(" and T_HR_SCmpCalTable.FCalSchemeId = '" + calSchemeId + "' ");
        sqlBuilder.append(" and T_HR_SCmpCalTable.FPeriodYear = " + periodYear);
        sqlBuilder.append(" and T_HR_SCmpCalTable.FPeriodMonth = " + periodMonth);
        sqlBuilder.append(" and T_HR_SCmpCalTable.FCalTime = " + calTime);
        sqlBuilder.append(" left join T_BD_Currency socFilesCurrency on socFilesCurrency.fid = T_HR_SSocEmpSocFiles.FCurrencyID");
        sqlBuilder.append(" left join T_BD_Currency calCurrency on calCurrency.FID =  T_HR_SCmpCalTable.fcurrencyID");
        sqlBuilder.append(" where entry.FEffectDay <=" + ksqlEndDate);
        sqlBuilder.append(" and ((T_HR_SSocEmpPayStatus.FSocPayStatus=1 and T_HR_SSocEmpPayStatus.FEffectDate<=" + FENDDATE + ") ");
        sqlBuilder.append(" or (T_HR_SSocEmpPayStatus.FSocPayStatus=0 and T_HR_SSocEmpPayStatus.FEffectDate>" + FBEGINDATE + ")) ");
        sqlBuilder.append(" and socRecord.FEMPORGRELATIONID is not null ");
        sqlBuilder.append(" and socRecord.FEffectDate<= " + ksqlEndDate + " and socRecord.FLeffectDate>=" + ksqlEndDate);
        sqlBuilder.append(" and T_BD_Person.Fid in(select FPERSONID from T_HR_SCmpCalTable where FCalSchemeId = '" + calSchemeId + "' ");
        sqlBuilder.append(" and FPeriodYear = " + periodYear + " and FPeriodMonth = " + periodMonth + " and FCalTime = " + calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            sqlBuilder.append(" and " + mainTableRowFilter);
        }
        sqlBuilder.append(" ) ");
        sqlBuilder.append(" ) ");
        sqlBuilder.append(" union all ");
        sqlBuilder.append("(SELECT T_HR_SSocEmpSocFiles.FCMPORGUNIT cmpOrg,socRecord.fid socRecordId, T_BD_Person.Fid as FPersonID,T_HR_SSocItem.fnumber,T_ORG_Admin.FName_" + langIndex + " as adminOrgName");
        sqlBuilder.append(",T_HR_SSocEmpSocFiles.FSocAccount,T_HR_SSocEmpSocFiles.FHouseFundAccount,T_HR_SSocEmpSocFiles.FEffectDay, T_HR_SSocEmpSocFiles.FMedInsuranceAccount");
        sqlBuilder.append(",entry.FEffectDay AS entryEffdt,T_HR_SSocType.FName_" + langIndex + " as socTypeName");
        sqlBuilder.append(",entry.FCompanyBase,entry.FSelfBase");
        sqlBuilder.append(",T_HR_SSocTypeItem.FMaxPay,T_HR_SSocTypeItem.FMinPay");
        sqlBuilder.append(",T_HR_SSocTypeItem.FCompanyMaxPay,T_HR_SSocTypeItem.FCompanyMinPay");
        sqlBuilder.append(",T_HR_SSocTypeItem.FSelfPrec,T_HR_SSocTypeItem.FCompanyPrec");
        sqlBuilder.append(",T_HR_SSocTypeItem.FSelfFixedPay,T_HR_SSocTypeItem.FCompanyFixedPay");
        sqlBuilder.append(",T_HR_SSocArea.FNAME_" + langIndex + " AS socAreaName");
        sqlBuilder.append(",socFilesCurrency.FID AS socFilesCurrencyID");
        sqlBuilder.append(",socFilesCurrency.FNAME_" + langIndex + " AS socFilesCurrencyName");
        sqlBuilder.append(",calCurrency.FID AS calCurrencyID");
        sqlBuilder.append(",calCurrency.FNAME_" + langIndex + " AS calCurrencyName");
        sqlBuilder.append(" from T_HR_SSocPersonRecord socRecord ");
        sqlBuilder.append(" left join T_HR_SSocEmpSocFiles on socRecord.fid=T_HR_SSocEmpSocFiles.FBillID ");
        sqlBuilder.append(" left join T_ORG_Admin on T_HR_SSocEmpSocFiles.FJoinSocOrgID = T_ORG_Admin.fid ");
        sqlBuilder.append(" left join T_HR_SSocEmpSocFilesEntryHis entry");
        sqlBuilder.append(" on T_HR_SSocEmpSocFiles.Fid = entry.FBillID");
        sqlBuilder.append(" left join T_HR_SSocType on T_HR_SSocType.Fid = T_HR_SSocEmpSocFiles.FSocTypeID");
        sqlBuilder.append(" left join T_HR_SSocArea on T_HR_SSocType.FSocAreaID = T_HR_SSocArea.Fid");
        sqlBuilder.append(" left join T_HR_SSocTypeItemHis T_HR_SSocTypeItem on T_HR_SSocTypeItem.Fid = entry.FSocTypeItemID");
        sqlBuilder.append(" left join T_HR_SSocItem on T_HR_SSocItem.Fid = T_HR_SSocTypeItem.FSocItemID");
        sqlBuilder.append(" left join T_HR_SSocEmpPayStatus on T_HR_SSocEmpPayStatus.FSocPersonRecordID = socRecord.fid and T_HR_SSocEmpPayStatus.FSocCategoryID = T_HR_SSocItem.FSocCategoryID");
        sqlBuilder.append(" inner join T_BD_Person on T_BD_Person.Fid = T_HR_SSocEmpSocFiles.FPersonId");
        sqlBuilder.append(" inner join T_HR_SCmpCalTable on T_BD_Person.Fid = T_HR_SCmpCalTable.FPersonId");
        sqlBuilder.append(" and T_HR_SCmpCalTable.FCalSchemeId = '" + calSchemeId + "' ");
        sqlBuilder.append(" and T_HR_SCmpCalTable.FPeriodYear = " + periodYear);
        sqlBuilder.append(" and T_HR_SCmpCalTable.FPeriodMonth = " + periodMonth);
        sqlBuilder.append(" and T_HR_SCmpCalTable.FCalTime = " + calTime);
        sqlBuilder.append(" left join T_BD_Currency socFilesCurrency on socFilesCurrency.fid = T_HR_SSocEmpSocFiles.FCurrencyID");
        sqlBuilder.append(" left join T_BD_Currency calCurrency on calCurrency.FID =  T_HR_SCmpCalTable.fcurrencyID");
        sqlBuilder.append(" where entry.FEffectDay <=" + ksqlEndDate);
        sqlBuilder.append(" and ((T_HR_SSocEmpPayStatus.FSocPayStatus=1 and T_HR_SSocEmpPayStatus.FEffectDate<=" + FENDDATE + ") ");
        sqlBuilder.append(" or (T_HR_SSocEmpPayStatus.FSocPayStatus=0 and T_HR_SSocEmpPayStatus.FEffectDate>" + FBEGINDATE + ")) ");
        sqlBuilder.append(" and socRecord.FEMPORGRELATIONID is not null ");
        sqlBuilder.append(" and socRecord.FEffectDate<= " + ksqlEndDate + " and socRecord.FLeffectDate>=" + ksqlEndDate);
        sqlBuilder.append(" and T_BD_Person.Fid in(select FPERSONID from T_HR_SCmpCalTable where FCalSchemeId = '" + calSchemeId + "' ");
        sqlBuilder.append(" and FPeriodYear = " + periodYear + " and FPeriodMonth = " + periodMonth + " and FCalTime = " + calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            sqlBuilder.append(" and " + mainTableRowFilter);
        }
        sqlBuilder.append(" ) ");
        sqlBuilder.append(" ) ");
        sqlBuilder.append(") temp1 )t)t1 where t1.rn = 1 ");
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        if (executeQuery == null || executeQuery.size() < 1) {
            return result;
        }
        BigDecimal companyBase = zero = new BigDecimal(0);
        BigDecimal selfBase = zero;
        BigDecimal maxPay = zero;
        BigDecimal minPay = zero;
        BigDecimal companyMaxPay = zero;
        BigDecimal companyMinPay = zero;
        BigDecimal selfPrec = zero;
        BigDecimal companyPrec = zero;
        BigDecimal selfFixedPay = zero;
        BigDecimal companyFixedPay = zero;
        String socItemAreaName = "";
        String socFilesCurrencyID = "";
        String socFilesCurrencyName = "";
        String calCurrencyID = "";
        String calCurrencyName = "";
        HashMap<String, Object> socEmpSocFilesMap = null;
        while (executeQuery.next()) {
            String socRecordId = executeQuery.getString("socRecordId");
            String FSocAccount = executeQuery.getString("FSocAccount");
            String FHouseFundAccount = executeQuery.getString("FHouseFundAccount");
            String FMedInsuranceAccount = executeQuery.getString("FMedInsuranceAccount");
            String FEffectDay = null == executeQuery.getDate("FEffectDay") ? "" : executeQuery.getDate("FEffectDay").toString();
            String entryEffdt = null == executeQuery.getDate("entryEffdt") ? "" : executeQuery.getDate("entryEffdt").toString();
            String socTypeName = executeQuery.getString("socTypeName");
            String adminOrgName = executeQuery.getString("adminOrgName");
            companyBase = executeQuery.getBigDecimal("FCompanyBase");
            selfBase = this.getBigDecimalValue(executeQuery.getBigDecimal("FSelfBase"));
            String fnumber = executeQuery.getString("fnumber");
            String personid = executeQuery.getString("FPersonID");
            maxPay = executeQuery.getBigDecimal("FMaxPay");
            minPay = this.getBigDecimalValue(executeQuery.getBigDecimal("FMinPay"));
            companyMaxPay = executeQuery.getBigDecimal("FCompanyMaxPay");
            companyMinPay = this.getBigDecimalValue(executeQuery.getBigDecimal("FCompanyMinPay"));
            selfPrec = this.getBigDecimalValue(executeQuery.getBigDecimal("FSelfPrec"));
            companyPrec = this.getBigDecimalValue(executeQuery.getBigDecimal("FCompanyPrec"));
            selfFixedPay = this.getBigDecimalValue(executeQuery.getBigDecimal("FSelfFixedPay"));
            companyFixedPay = this.getBigDecimalValue(executeQuery.getBigDecimal("FCompanyFixedPay"));
            selfFixedPay = this.getBigDecimalValue(executeQuery.getBigDecimal("FSelfFixedPay"));
            companyFixedPay = this.getBigDecimalValue(executeQuery.getBigDecimal("FCompanyFixedPay"));
            socItemAreaName = executeQuery.getString("socAreaName");
            socFilesCurrencyID = executeQuery.getString("socFilesCurrencyID");
            socFilesCurrencyName = executeQuery.getString("socFilesCurrencyName");
            calCurrencyID = executeQuery.getString("calCurrencyID");
            calCurrencyName = executeQuery.getString("calCurrencyName");
            String cmpOrg = executeQuery.getString("cmpOrg");
            String org = executeQuery.getString("org");
            socEmpSocFilesMap = new HashMap<String, Object>();
            socEmpSocFilesMap.put("socRecordId", socRecordId);
            socEmpSocFilesMap.put("FSocAccount", FSocAccount);
            socEmpSocFilesMap.put("FHouseFundAccount", FHouseFundAccount);
            socEmpSocFilesMap.put("FMedInsuranceAccount", FMedInsuranceAccount);
            socEmpSocFilesMap.put("FEffectDay", FEffectDay);
            socEmpSocFilesMap.put("entryEffdt", entryEffdt);
            socEmpSocFilesMap.put("socTypeName", socTypeName);
            socEmpSocFilesMap.put("adminOrgName", adminOrgName);
            socEmpSocFilesMap.put("FPersonId", personid);
            socEmpSocFilesMap.put("fnumber", fnumber);
            socEmpSocFilesMap.put("FCompanyBase", companyBase);
            socEmpSocFilesMap.put("FSelfBase", selfBase);
            socEmpSocFilesMap.put("FMaxPay", maxPay);
            socEmpSocFilesMap.put("FMinPay", minPay);
            socEmpSocFilesMap.put("FCompanyMaxPay", companyMaxPay);
            socEmpSocFilesMap.put("FCompanyMinPay", companyMinPay);
            socEmpSocFilesMap.put("FSelfPrec", selfPrec);
            socEmpSocFilesMap.put("FCompanyPrec", companyPrec);
            socEmpSocFilesMap.put("FSelfFixedPay", selfFixedPay);
            socEmpSocFilesMap.put("FCompanyFixedPay", companyFixedPay);
            socEmpSocFilesMap.put("socAreaName", socItemAreaName);
            socEmpSocFilesMap.put("socFilesCurrencyID", socFilesCurrencyID);
            socEmpSocFilesMap.put("socFilesCurrencyName", socFilesCurrencyName);
            socEmpSocFilesMap.put("calCurrencyID", calCurrencyID);
            socEmpSocFilesMap.put("calCurrencyName", calCurrencyName);
            String key = personid + "_" + fnumber;
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cmpOrg) && !org.equals(cmpOrg) || result.containsKey(key)) continue;
            result.put(key, socEmpSocFilesMap);
        }
        return result;
    }

    private BigDecimal getBigDecimalValue(BigDecimal value) {
        BigDecimal zero = new BigDecimal(0);
        return null == value ? zero : value;
    }

    public Map<String, String> getSocInfoMap(CalSchemeInfo calScheme) {
        HashMap<String, String> map = new HashMap<String, String>();
        String localeString = calScheme.getLanType().getValue();
        Locale locale = LocaleUtils.getLocale((String)localeString);
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"SocAccount", (Locale)locale), "FSocAccount");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"MedInsuranceAccount", (Locale)locale), "FMedInsuranceAccount");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"HouseFundAccount", (Locale)locale), "FHouseFundAccount");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"adminOrgName", (Locale)locale), "adminOrgName");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"socTypeName", (Locale)locale), "socTypeName");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"FEffectDay", (Locale)locale), "FEffectDay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"SelfBase", (Locale)locale), "FSelfBase");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"CompanyBase", (Locale)locale), "FCompanyBase");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"entryEffdt", (Locale)locale), "entryEffdt");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"SelfPrec", (Locale)locale), "FSelfPrec");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"CompanyPrec", (Locale)locale), "FCompanyPrec");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"SelfFixedPay", (Locale)locale), "FSelfFixedPay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"CompanyFixedPay", (Locale)locale), "FCompanyFixedPay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"PERMAX", (Locale)locale), "FMaxPay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"PERMIN", (Locale)locale), "FMinPay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"ORGMAX", (Locale)locale), "FCompanyMaxPay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"ORGMIN", (Locale)locale), "FCompanyMinPay");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"CURRENCY", (Locale)locale), "socFilesCurrencyName");
        map.put(EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"socSubjects", (Locale)locale), "adminOrgName");
        return map;
    }

    public double getSocSelfOrCompRelativePay(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String socItemNum, double type, double month) {
        HashMap socTempMap = new HashMap();
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        Calendar calendar = Calendar.getInstance();
        Date calSchemeEndDate = calScheme.getEndDate();
        calendar.setTime(calSchemeEndDate);
        calendar.add(2, (int)month);
        if (CmpDateUtil.isLastDayOfMonth((Date)calSchemeEndDate)) {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        Date endDate = calendar.getTime();
        calendar.setTime(calScheme.getBeginDate());
        calendar.add(2, (int)month);
        Date beginDate = calendar.getTime();
        String mainTableRowFilter = null;
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + endDate;
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemNum, beginDate, endDate, mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                tempMap.put(fixPayMapKey, new HashMap());
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        boolean hasSocFiles = false;
        String socRecordId = "";
        String key = personid + "_" + socItemNum;
        Map<String, Object> tempmap = new HashMap();
        if (socTempMap.get(key) != null) {
            tempmap = (Map)socTempMap.get(key);
            socRecordId = (String)tempmap.get("socRecordId");
            paramMap.put("socRecordId", socRecordId);
            hasSocFiles = true;
        }
        if (!hasSocFiles) {
            return 0.0;
        }
        return this.getSocPayValue(calScheme, tempmap, type, currencyMap);
    }

    public String getSocFileRelativePay(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, String socName, String socItemNum, double month) {
        HashMap socTempMap = new HashMap();
        String personid = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        Calendar calendar = Calendar.getInstance();
        Date calSchemeEndDate = calScheme.getEndDate();
        calendar.setTime(calSchemeEndDate);
        calendar.add(2, (int)month);
        if (CmpDateUtil.isLastDayOfMonth((Date)calSchemeEndDate)) {
            calendar.set(5, calendar.getActualMaximum(5));
        }
        Date endDate = calendar.getTime();
        calendar.setTime(calScheme.getBeginDate());
        calendar.add(2, (int)month);
        Date beginDate = calendar.getTime();
        String mainTableRowFilter = null;
        String fixPayMapKey = "initSocEmpSocFilesMap_" + calScheme.getId() + "_" + endDate;
        if (tempMap.get(fixPayMapKey) == null) {
            try {
                tempMap.put(fixPayMapKey, this.initSocEmpSocFilesMap(calScheme, socItemNum, beginDate, endDate, mainTableRowFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        socTempMap = (HashMap)tempMap.get(fixPayMapKey);
        String socValue = "";
        Map<String, String> map = this.getSocInfoMap(calScheme);
        if (!map.containsKey(socName)) {
            return "";
        }
        String socNumber = map.get(socName);
        String socRecordId = "";
        String key = personid + "_" + socItemNum;
        if (socTempMap.get(key) != null) {
            Map tempmap = (Map)socTempMap.get(key);
            socValue = null == tempmap.get(socNumber) ? "" : tempmap.get(socNumber).toString();
            socRecordId = (String)tempmap.get("socRecordId");
            paramMap.put("socRecordId", socRecordId);
        }
        return socValue;
    }

    public double getSocImportDetail(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, Map<String, BigDecimal> currencyMap, String mainTableRowFilter, String item, double offset, double isSameHr, double type) throws Exception {
        int integerType = (int)type;
        String key = "getSocImportDetail_" + calScheme.getId() + "_" + offset + "_" + isSameHr + "_" + type;
        if (tempMap.get(key) == null) {
            Calendar calendar = Calendar.getInstance();
            int month = calScheme.getPeriodMonth() - 1 + (int)offset;
            calendar.set(calScheme.getPeriodYear(), month, 1, 0, 0, 0);
            int year = calendar.get(1);
            month = calendar.get(2) + 1;
            StringBuilder str = new StringBuilder();
            str.append(" SELECT FPERSONID,FSOCBASE,FUNDBASE,FRECEIVABLETOTAL, FPERSONALTOTAL,FUNITTOTAL,FPENSIONBASE,FPERSONALPENSION,FUNITPENSION,FMEDICALBASE,");
            str.append(" FPERSONALMEDICAL,FUNITMEDICAL,FINDUSTRIALINJURYBASE,FUNITINDUSTRIALINJURY, FUNEMPLOYMENTBASE,FPERSONALUNEMPLOYMENT,FUNITUNEMPLOYMENT,FBEARBASE,");
            str.append(" FUNITBEAR,FUNITFUND,FPERSONALFUND,FCURRENCYID, ");
            str.append(" FSOCPERSONAL1,FSOCPERSONAL2,FSOCPERSONAL3,FSOCPERSONAL4,FSOCPERSONAL5,FSOCPERSONAL6,FSOCPERSONAL7,FSOCPERSONAL8,FSOCUNIT1,FSOCUNIT2,FSOCUNIT3,FSOCUNIT4,FSOCUNIT5,");
            str.append(" FSOCUNIT6,FSOCUNIT7,FSOCUNIT8,FITEMPERSONAL1,FITEMPERSONAL2,FITEMPERSONAL3,FITEMPERSONAL4,FITEMPERSONAL5,FITEMUNIT1,FITEMUNIT2,FITEMUNIT3,FITEMUNIT4,FITEMUNIT5 , ");
            str.append(" FSOCPERSONTOTAL ,FSOCUNITTOTAL,FSOCPERSONRECORDID ");
            str.append(" FROM T_HR_SSOCPAY ");
            str.append(" WHERE FPERIODYEAR = ").append(year);
            str.append(" AND FPERIODMONTH = ").append(month);
            if (isSameHr <= 0.0) {
                str.append(" AND FHrOrgUnitID = '").append(calScheme.getHrOrgUnit().getId().toString()).append("' ");
            }
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String calSchemeId = calScheme.getId().toString();
                int calTime = calScheme.getCalTime();
                int periodYear = calScheme.getPeriodYear();
                int periodMonth = calScheme.getPeriodMonth();
                String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calSchemeId + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth + " and " + mainTableRowFilter;
                str.append(" AND FPERSONID IN (").append(personSql).append(") ");
            }
            switch (integerType) {
                case 1: {
                    str.append(" AND FSOCPAYTYPE = 1");
                    break;
                }
                case 2: {
                    str.append(" AND FSOCPAYTYPE = 2");
                    break;
                }
                case 3: {
                    str.append(" AND FSOCPAYTYPE = 3");
                    break;
                }
            }
            this.initScoImportData(tempMap, key, str.toString());
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        return this.getSocImportValue(paramMap, tempMap, currencyMap, key, personId, item);
    }

    private void initSocImportDetailMap(HashMap tempMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("01", "FRECEIVABLETOTAL");
        map.put("02", "FPERSONALTOTAL");
        map.put("03", "FUNITTOTAL");
        map.put("04", "FSOCPERSONTOTAL");
        map.put("05", "FSOCUNITTOTAL");
        map.put("06", "FPENSIONBASE");
        map.put("07", "FPERSONALPENSION");
        map.put("08", "FUNITPENSION");
        map.put("09", "FMEDICALBASE");
        map.put("10", "FPERSONALMEDICAL");
        map.put("11", "FUNITMEDICAL");
        map.put("12", "FINDUSTRIALINJURYBASE");
        map.put("13", "FUNITINDUSTRIALINJURY");
        map.put("14", "FUNEMPLOYMENTBASE");
        map.put("15", "FPERSONALUNEMPLOYMENT");
        map.put("16", "FUNITUNEMPLOYMENT");
        map.put("17", "FBEARBASE");
        map.put("18", "FUNITBEAR");
        map.put("19", "FUNDBASE");
        map.put("20", "FPERSONALFUND");
        map.put("21", "FUNITFUND");
        map.put("22", "FSOCPERSONAL1");
        map.put("23", "FSOCPERSONAL2");
        map.put("24", "FSOCPERSONAL3");
        map.put("25", "FSOCPERSONAL4");
        map.put("26", "FSOCPERSONAL5");
        map.put("27", "FSOCPERSONAL6");
        map.put("28", "FSOCPERSONAL7");
        map.put("29", "FSOCPERSONAL8");
        map.put("30", "FSOCUNIT1");
        map.put("31", "FSOCUNIT2");
        map.put("32", "FSOCUNIT3");
        map.put("33", "FSOCUNIT4");
        map.put("34", "FSOCUNIT5");
        map.put("35", "FSOCUNIT6");
        map.put("36", "FSOCUNIT7");
        map.put("37", "FSOCUNIT8");
        map.put("38", "FITEMPERSONAL1");
        map.put("39", "FITEMPERSONAL2");
        map.put("40", "FITEMPERSONAL3");
        map.put("41", "FITEMPERSONAL4");
        map.put("42", "FITEMPERSONAL5");
        map.put("43", "FITEMUNIT1");
        map.put("44", "FITEMUNIT2");
        map.put("45", "FITEMUNIT3");
        map.put("46", "FITEMUNIT4");
        map.put("47", "FITEMUNIT5");
        tempMap.put("GETSOCIMPORTDETAIL_ITEMMAP", map);
    }

    private void initScoImportData(HashMap tempMap, String key, String sql) throws Exception {
        Context ctx = Tools.getInstance().getCtx();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Object> detaiMap = new HashMap<String, Object>();
        HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>();
        int columnCount = rowSet.getMetaData().getColumnCount();
        ResultSetMetaData metaData = rowSet.getMetaData();
        while (rowSet.next()) {
            detaiMap = new HashMap();
            String personId = rowSet.getString("FPERSONID");
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnName(i);
                detaiMap.put(columnName.toUpperCase(Locale.ENGLISH), rowSet.getObject(columnName));
            }
            map.put(personId, detaiMap);
        }
        tempMap.put(key, map);
        this.initSocImportDetailMap(tempMap);
    }

    private double getSocImportValue(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, String key, String personId, String item) {
        Map itemMap = (Map)tempMap.get("GETSOCIMPORTDETAIL_ITEMMAP");
        String columnName = (String)itemMap.get(item);
        Map dataMap = (Map)tempMap.get(key);
        if (!dataMap.containsKey(personId)) {
            return 0.0;
        }
        Map detailMap = (Map)dataMap.get(personId);
        String currencyId = detailMap.get("FCURRENCYID").toString();
        BigDecimal val = null == detailMap.get(columnName) ? new BigDecimal(0) : (BigDecimal)detailMap.get(columnName);
        BigDecimal rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
        paramMap.put("socRecordId", null == detailMap.get("FSOCPERSONRECORDID") ? null : detailMap.get("FSOCPERSONRECORDID").toString());
        return val.multiply(rate).doubleValue();
    }

    public double getSocImportSum(Map paramMap, HashMap tempMap, CalSchemeInfo calScheme, Map<String, BigDecimal> currencyMap, String mainTableRowFilter, String item, double offset, double isSameHr, double type) throws Exception {
        int integerType = (int)type;
        String key = "getSocImportSum_" + calScheme.getId() + "_" + offset + "_" + isSameHr + "_" + type;
        if (tempMap.get(key) == null) {
            Calendar calendar = Calendar.getInstance();
            int month = calScheme.getPeriodMonth() - 1 + (int)offset;
            calendar.set(calScheme.getPeriodYear(), month, 1, 0, 0, 0);
            int year = calendar.get(1);
            month = calendar.get(2) + 1;
            StringBuilder str = new StringBuilder();
            str.append(" SELECT FPERSONID,FCURRENCYID,SUM(FSOCBASE) FSOCBASE,SUM(FUNDBASE) FUNDBASE,SUM(FRECEIVABLETOTAL) FRECEIVABLETOTAL,SUM(FPERSONALTOTAL) FPERSONALTOTAL,");
            str.append(" SUM(FUNITTOTAL) FUNITTOTAL,SUM(FPENSIONBASE) FPENSIONBASE,SUM(FPERSONALPENSION) FPERSONALPENSION,SUM(FUNITPENSION) FUNITPENSION,SUM(FMEDICALBASE) FMEDICALBASE,");
            str.append(" SUM(FPERSONALMEDICAL) FPERSONALMEDICAL,SUM(FUNITMEDICAL) FUNITMEDICAL,SUM(FINDUSTRIALINJURYBASE) FINDUSTRIALINJURYBASE,SUM(FUNITINDUSTRIALINJURY) FUNITINDUSTRIALINJURY,");
            str.append(" SUM(FUNEMPLOYMENTBASE) FUNEMPLOYMENTBASE,SUM(FPERSONALUNEMPLOYMENT) FPERSONALUNEMPLOYMENT,SUM(FUNITUNEMPLOYMENT) FUNITUNEMPLOYMENT,SUM(FBEARBASE) FBEARBASE,SUM(FUNITBEAR) FUNITBEAR,");
            str.append(" SUM(FUNITFUND) FUNITFUND,SUM(FPERSONALFUND) FPERSONALFUND, ");
            str.append(" SUM(FSOCPERSONAL1) FSOCPERSONAL1,SUM(FSOCPERSONAL2) FSOCPERSONAL2,SUM(FSOCPERSONAL3) FSOCPERSONAL3,SUM(FSOCPERSONAL4) FSOCPERSONAL4,SUM(FSOCPERSONAL5) FSOCPERSONAL5,");
            str.append(" SUM(FSOCPERSONAL6) FSOCPERSONAL6,SUM(FSOCPERSONAL7) FSOCPERSONAL7,SUM(FSOCPERSONAL8) FSOCPERSONAL8,SUM(FSOCUNIT1) FSOCUNIT1,SUM(FSOCUNIT2) FSOCUNIT2,SUM(FSOCUNIT3) FSOCUNIT3,");
            str.append(" SUM(FSOCUNIT4) FSOCUNIT4,SUM(FSOCUNIT5) FSOCUNIT5,SUM(FSOCUNIT6) FSOCUNIT6,SUM(FSOCUNIT7) FSOCUNIT7,SUM(FSOCUNIT8) FSOCUNIT8,SUM(FITEMPERSONAL1) FITEMPERSONAL1,SUM(FITEMPERSONAL2) FITEMPERSONAL2,");
            str.append(" SUM(FITEMPERSONAL3) FITEMPERSONAL3,SUM(FITEMPERSONAL4) FITEMPERSONAL4,SUM(FITEMPERSONAL5) FITEMPERSONAL5,SUM(FITEMUNIT1) FITEMUNIT1,SUM(FITEMUNIT2) FITEMUNIT2,SUM(FITEMUNIT3) FITEMUNIT3,");
            str.append(" SUM(FITEMUNIT4) FITEMUNIT4,SUM(FITEMUNIT5) FITEMUNIT5 , SUM(FSOCPERSONTOTAL) FSOCPERSONTOTAL ,SUM(FSOCUNITTOTAL) FSOCUNITTOTAL ");
            str.append(" FROM T_HR_SSOCPAY ");
            str.append(" WHERE FPERIODYEAR = ").append(year);
            str.append(" AND FPERIODMONTH = ").append(month);
            if (isSameHr <= 0.0) {
                str.append(" AND FHrOrgUnitID = '").append(calScheme.getHrOrgUnit().getId().toString()).append("' ");
            }
            if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
                String calSchemeId = calScheme.getId().toString();
                int calTime = calScheme.getCalTime();
                int periodYear = calScheme.getPeriodYear();
                int periodMonth = calScheme.getPeriodMonth();
                String personSql = "select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '" + calSchemeId + "' and FcalTime = " + calTime + " and FperiodYear = " + periodYear + " and FperiodMonth = " + periodMonth + " and " + mainTableRowFilter;
                str.append(" AND FPERSONID IN (").append(personSql).append(") ");
            }
            switch (integerType) {
                case 1: {
                    str.append(" AND FSOCPAYTYPE = 1");
                    break;
                }
                case 2: {
                    str.append(" AND FSOCPAYTYPE = 2");
                    break;
                }
                case 3: {
                    str.append(" AND FSOCPAYTYPE = 3");
                    break;
                }
            }
            str.append(" GROUP BY FPERSONID,FCURRENCYID ");
            this.initScoImportData(tempMap, key, str.toString());
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        return this.getSocImportValue(paramMap, tempMap, currencyMap, key, personId, item);
    }
}

