/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFactory;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.CmpItemDataType;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.vo.CalExecutorParam;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.base.vo.VRCell;
import com.kingdee.shr.validaterule.formula.base.vo.VRRow;
import com.kingdee.shr.validaterule.formula.result.ExtendDataInterface;
import com.kingdee.shr.validaterule.formula.result.analysis.GetClassFromInterface;
import com.kingdee.shr.validaterule.util.FunUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SalaryCalExecutor2
extends Thread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.formula.SalaryCalExecutor2");
    private final String mainTableItemKey = "fid";
    private String calMessage = "";
    private Sheet result = new Sheet();
    private boolean isExecuteFinished = false;
    private static final FunUtils util = new FunUtils();
    private double ext_finishedPer = 0.0;
    private final String maxDotString = "0.0000000000";
    private CalExecutorParam executorParam;
    List<ExtendDataInterface> instanceList;

    public Sheet getChangeData() {
        return this.result;
    }

    public SalaryCalExecutor2() {
    }

    public SalaryCalExecutor2(CalExecutorParam executorParam) {
        String init;
        this.calMessage = init = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"init", (Locale)executorParam.getCtx().getLocale());
        this.executorParam = executorParam;
        try {
            this.initResultHandleService(executorParam);
        }
        catch (Exception e) {
            logger.error((Object)"init initResultHandleService error, ", (Throwable)e);
        }
    }

    private void initResultHandleService(CalExecutorParam executorParam) throws Exception {
        List<Class<?>> classList = GetClassFromInterface.getAllClass(executorParam.getCtx(), ExtendDataInterface.class, executorParam.getCalCategoryNum());
        this.instanceList = new ArrayList<ExtendDataInterface>();
        for (Class<?> c : classList) {
            this.instanceList.add((ExtendDataInterface)c.newInstance());
        }
    }

    public boolean isExecuteFinished() {
        return this.isExecuteFinished;
    }

    @Override
    public void run() {
        try {
            this.result = this.doExecute();
            this.isExecuteFinished = true;
        }
        catch (Exception e) {
            this.result.setErrMsg(e.getMessage());
            e.printStackTrace();
            this.isExecuteFinished = true;
        }
    }

    public Map<String, BizEnumValueCollection> getEnumProperty() {
        HashMap<String, BizEnumValueCollection> map = new HashMap<String, BizEnumValueCollection>();
        StructureConfigCollection structureConfigCollection = null;
        Context ctx = this.executorParam.getCtx();
        String calCategoryNum = this.executorParam.getCalCategoryNum();
        try {
            structureConfigCollection = StructureConfigFactory.getLocalInstance((Context)ctx).getStructureConfigCollection("where scheme.number = '" + calCategoryNum + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < structureConfigCollection.size(); ++i) {
            String entityName;
            if (null == structureConfigCollection.get(i) || StringUtils.isEmpty((String)(entityName = structureConfigCollection.get(i).getEntityName()))) continue;
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            if (entityInfo == null || entityInfo.getProperties() == null) {
                System.out.println("----enumEntity not found----" + entityName);
                continue;
            }
            PropertyCollection properties = entityInfo.getProperties();
            for (int k = 0; k < properties.size(); ++k) {
                String dataType;
                PropertyInfo propertyInfo = properties.get(k);
                IStateManager stateManager = propertyInfo.getStateManager();
                if (null == stateManager.getStateValue("dataType") || !"Enum".equalsIgnoreCase(dataType = stateManager.getStateValue("dataType").toString())) continue;
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)dataRef));
                BizEnumValueCollection enumValueColl = enumInfo.getEnumValue();
                map.put(entityInfo.getTable().getName().toUpperCase(Locale.ENGLISH) + "_" + propertyInfo.getMappingField().getName().toUpperCase(Locale.ENGLISH), enumValueColl);
            }
        }
        return map;
    }

    protected SalaryCalFunction2 calFromulaImp() {
        SalaryCalFunction2 formulaImp = null;
        SalaryCalFunction2 calObj = this.executorParam.getCalObj();
        try {
            formulaImp = (SalaryCalFunction2)calObj.getClass().getDeclaredMethod("getFormulaImp", new Class[0]).invoke((Object)calObj, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        formulaImp.setTempMap(calObj.getTempMap());
        formulaImp.setCalScheme(calObj.getCalScheme());
        formulaImp.setCurrencyMap(calObj.getCurrencyMap());
        formulaImp.setCurrency(calObj.isCurrency());
        formulaImp.setCtx(calObj.getCtx());
        formulaImp.setType(calObj.getType());
        formulaImp.setSchemeID(calObj.getSchemeID());
        formulaImp.setMainTableName(calObj.getMainTableName());
        formulaImp.setMainTableRowFilter(calObj.getMainTableRowFilter());
        return formulaImp;
    }

    protected SalaryCalFunction2 calFunctionImp(SalaryCalFunction2 formulaImp) {
        SalaryCalFunction2 funcImp = null;
        try {
            funcImp = (SalaryCalFunction2)formulaImp.getClass().getDeclaredMethod("getFuncImp", new Class[0]).invoke((Object)formulaImp, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SalaryCalFunction2 calObj = this.executorParam.getCalObj();
        funcImp.setTempMap(calObj.getTempMap());
        funcImp.setCalScheme(calObj.getCalScheme());
        funcImp.setCtx(calObj.getCtx());
        funcImp.setType(calObj.getType());
        funcImp.setCurrencyMap(calObj.getCurrencyMap());
        funcImp.setCurrency(calObj.isCurrency());
        funcImp.setSchemeID(calObj.getSchemeID());
        funcImp.setMainTableName(calObj.getMainTableName());
        funcImp.setMainTableRowFilter(calObj.getMainTableRowFilter());
        funcImp.setUid(calObj.getUid());
        return funcImp;
    }

    private Sheet doExecute() throws Exception {
        List<DataRow> datas;
        Map<String, BizEnumValueCollection> enumMap;
        int rowCount;
        String columnName;
        String attName;
        String errMsg;
        String caltableid = null;
        DataSet dataSet = this.executorParam.getDataSet();
        String mainTableName = this.executorParam.getMainTableName();
        String mainTableNameAlias = this.executorParam.getMainTableAlias();
        Map<String, Object> allCnSnMap = this.executorParam.getAllCnSnMap();
        SalaryCalFunction2 calObj = this.executorParam.getCalObj();
        Context ctx = this.executorParam.getCtx();
        Set secColSet = this.executorParam.getSecColSet();
        DataTable mainTable = dataSet.getTables(mainTableName);
        HashMap<String, Object> paras = new HashMap<String, Object>();
        Sheet result = new Sheet();
        ArrayList changeDataList = new ArrayList();
        ArrayList errList = new ArrayList();
        try {
            errMsg = "";
            attName = "";
            columnName = "";
            rowCount = mainTable.rowCount();
            enumMap = this.getEnumProperty();
            datas = mainTable.datas;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setErrMsg(e.getMessage());
            return result;
        }
        long l1 = System.currentTimeMillis();
        System.out.println("-----------calAppend-----begin---");
        long rwSum = 0L;
        long dsSum = 0L;
        long calSum = 0L;
        if (datas != null) {
            SalaryCalFunction2 formulaImp = this.calFromulaImp();
            SalaryCalFunction2 funcImp = this.calFunctionImp(formulaImp);
            int size = datas.size();
            for (int index = 0; index < size; ++index) {
                VRRow vrRow;
                ErrRow errRow;
                long ds1;
                DataRow mtDataRow;
                try {
                    ColumnAttributes att;
                    paras.clear();
                    mtDataRow = mainTable.getRows(index);
                    if (mtDataRow == null) continue;
                    long rw1 = System.currentTimeMillis();
                    for (int loop = 0; loop < mtDataRow.columnCount(); ++loop) {
                        att = mtDataRow.getColumns(loop);
                        if (att.getName().equalsIgnoreCase("fid")) {
                            caltableid = (String)mtDataRow.getValue(loop);
                        }
                        if (att.isVar()) {
                            paras.put(att.getName().toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                            continue;
                        }
                        if (!att.getName().contains(".")) {
                            paras.put((mainTableName + "_" + att.getName()).toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                        }
                        if (!att.getName().toUpperCase(Locale.ENGLISH).contains(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".S") && !att.getName().toUpperCase(Locale.ENGLISH).contains(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".T") && !att.getName().toUpperCase(Locale.ENGLISH).contains(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".M")) continue;
                        if (att.getName().toUpperCase(Locale.ENGLISH).contains(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".S") && allCnSnMap.get("f7TypeMap") != null) {
                            Map f7TypeMap = (Map)allCnSnMap.get("f7TypeMap");
                            String fieldSn = att.getName().substring(att.getName().indexOf(".") + 1).toLowerCase();
                            if (mtDataRow.getValue(loop) != null && f7TypeMap.get(fieldSn) != null) {
                                String actualValue = (String)((Map)f7TypeMap.get(fieldSn)).get(mtDataRow.getValue(loop).toString());
                                if (StringUtils.isEmpty((String)actualValue)) {
                                    actualValue = mtDataRow.getValue(loop).toString();
                                }
                                paras.put((mainTableName + "_" + att.getName().toUpperCase(Locale.ENGLISH).replace(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".", "")).toUpperCase(Locale.ENGLISH), actualValue);
                                continue;
                            }
                        }
                        paras.put((mainTableName + "_" + att.getName().toUpperCase(Locale.ENGLISH).replace(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".", "")).toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                    }
                    long rw2 = System.currentTimeMillis();
                    rwSum += rw2 - rw1;
                    ds1 = System.currentTimeMillis();
                    for (int loop = 0; loop < dataSet.tableCount(); ++loop) {
                        DataRow dataRow;
                        DataTable tb = dataSet.getTables(loop);
                        String tableName = tb.tablename.split("~")[0].toUpperCase(Locale.ENGLISH);
                        String tbAndNum = tb.tablename.indexOf("~") != -1 ? tb.tablename.replace("~", "_") : tb.tablename;
                        if (mainTableName.equals(tbAndNum) || null == (dataRow = tb.getDataRow(caltableid))) continue;
                        for (int i = 0; i < dataRow.columnCount(); ++i) {
                            att = dataRow.getColumns(i);
                            Object value = dataRow.getValue(i);
                            columnName = (att.getName().contains(".") ? att.getName().split("\\.")[att.getName().split("\\.").length - 1] : att.getName()).toUpperCase(Locale.ENGLISH);
                            if (enumMap.containsKey(tableName + "_" + columnName) && null != value) {
                                BizEnumValueCollection enumValueColl = enumMap.get(tableName + "_" + columnName);
                                boolean findEnum = false;
                                for (int k = 0; k < enumValueColl.size(); ++k) {
                                    if (enumValueColl.get(k) == null || !value.toString().equals(enumValueColl.get(k).getValue())) continue;
                                    value = enumValueColl.get(k).getAlias();
                                    findEnum = true;
                                }
                                if (!findEnum) {
                                    value = null;
                                }
                            }
                            if (calObj.getType().equals("test")) {
                                paras.put((tbAndNum + "_" + columnName).toUpperCase(Locale.ENGLISH), value);
                                continue;
                            }
                            if (tb.tablename.contains("~")) {
                                String structNum = tb.tablename.split("~")[1];
                                columnName = att.getName();
                                if (!structNum.toLowerCase(Locale.ENGLISH).equals(columnName.split("\\.")[0].toLowerCase(Locale.ENGLISH))) continue;
                            }
                            columnName = attName = att.getName();
                            if (attName.split("\\.").length > 1) {
                                columnName = attName.split("\\.")[1];
                            }
                            paras.put((tbAndNum + "_" + columnName).toUpperCase(Locale.ENGLISH), value);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    errRow = new ErrRow(caltableid, e.getMessage());
                    result.addErrorData(errRow);
                    continue;
                }
                long ds2 = System.currentTimeMillis();
                dsSum += ds2 - ds1;
                long cal1 = System.currentTimeMillis();
                try {
                    calObj.setParamMap(paras);
                    formulaImp.setParamMap(calObj.getParamMap());
                    funcImp.setParamMap(calObj.getParamMap());
                    paras.put("ThisParamUsedForAnalasysTimePrint", null == ctx.get((Object)"shr_cmp_compensation_cal_spend_time_print") ? Boolean.valueOf(false) : ctx.get((Object)"shr_cmp_compensation_cal_spend_time_print"));
                    paras.put("ThisParamUsedForAnalasysTimeIsLastPerson", index == size - 1);
                    calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)calObj, paras);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("======" + e.getMessage());
                    System.out.println("======" + e);
                    this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            e.printStackTrace();
                        }
                    });
                    String calFormulaName = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                    calFormulaName = calFormulaName.substring(calFormulaName.indexOf("{") + 1, calFormulaName.indexOf("}"));
                    errMsg = null != calFormulaName ? MessageFormat.format("{0}\uff1a{1}{2}<br>", EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"label29", (Locale)ctx.getLocale()), calFormulaName, EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"label30", (Locale)ctx.getLocale())) : EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"label28", (Locale)ctx.getLocale()) + "<br>" + e;
                    errRow = new ErrRow(caltableid, errMsg);
                    result.addErrorData(errRow);
                    VRRow vrResult = this.getVRResult(paras, errMsg);
                    if (null == vrResult) continue;
                    result.addVRData(vrResult);
                    continue;
                }
                Row changeData = this.getChangeDataMap(mtDataRow, paras, secColSet, allCnSnMap);
                if (null != changeData) {
                    result.addChangeData(changeData);
                }
                if (null != (vrRow = this.getVRResult(paras, null))) {
                    result.addVRData(vrRow);
                }
                for (ExtendDataInterface ins : this.instanceList) {
                    try {
                        ins.handle(this.executorParam, paras);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                double curFinishedPer = 50.0 / (double)rowCount * (double)(index + 1);
                BigDecimal bCurFinishedPer = BigDecimal.valueOf(curFinishedPer).setScale(2, RoundingMode.UP);
                this.ext_finishedPer = bCurFinishedPer.doubleValue();
                long cal2 = System.currentTimeMillis();
                calSum += cal2 - cal1;
            }
        }
        for (ExtendDataInterface ins : this.instanceList) {
            try {
                ins.save(this.executorParam);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("-----------Calculation and assembly-----end---" + (l2 - l1));
        System.out.println("-----------Assembly data parameters-------" + rwSum);
        System.out.println("-----------Fill in other tables------" + dsSum);
        System.out.println("-----------Calculation-------" + calSum);
        return result;
    }

    public Row getChangeDataMap(DataRow rw, Map paras, Set secColSet, Map<String, Object> cnSn) throws BOSException, EASBizException {
        Row row = new Row();
        int size = rw.columnCount();
        String caltableid = (String)rw.getValue("fid");
        row.setFID(caltableid);
        Map dataTypeMap = (Map)cnSn.get("dataTypeMap");
        Map dataDotMap = (Map)cnSn.get("dataDotMap");
        String mainTableName = this.executorParam.getMainTableName();
        String mainTableNameAlias = this.executorParam.getMainTableAlias();
        for (int index = 0; index < size; ++index) {
            String calValueStr;
            String orgValueStr;
            Map f7TypeMap;
            Cell cell;
            Object orgValue;
            ColumnAttributes rwColumn = rw.getColumns(index);
            String key = rwColumn.getName().toUpperCase(Locale.ENGLISH);
            if (rwColumn.isReturn()) {
                orgValue = rw.getValue(index);
                orgValue = null == orgValue ? paras.get(key) : orgValue;
                cell = new Cell(key, FunUtils.toString(orgValue));
                row.addCell(cell);
                continue;
            }
            String string = key = key.contains(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".") ? key.replace(mainTableNameAlias.toUpperCase(Locale.ENGLISH) + ".", "") : key;
            if (!dataTypeMap.containsKey(key.toLowerCase(Locale.ENGLISH))) continue;
            String paraName = (mainTableName + "_" + key).toUpperCase(Locale.ENGLISH);
            orgValue = rw.getValue(index);
            Object calValue = paras.get(paraName);
            if (cnSn.containsKey("f7TypeMap") && (f7TypeMap = (Map)cnSn.get("f7TypeMap")).get(key.toLowerCase()) != null && ((Map)f7TypeMap.get(key.toLowerCase())).get(orgValue) != null && ((String)((Map)f7TypeMap.get(key.toLowerCase())).get(orgValue)).equals(calValue)) continue;
            Integer cmpItemDataType = (int)((Integer)dataTypeMap.get(key.toLowerCase(Locale.ENGLISH)));
            if (cmpItemDataType.intValue() == CmpItemDataType.NUMBER.getValue()) {
                CmpItemDataDot cmpItemDataDot = (CmpItemDataDot)((Object)dataDotMap.get(key.toLowerCase(Locale.ENGLISH)));
                orgValueStr = this.getDoubleByScienNotation(orgValue, "0.0000000000");
                calValueStr = this.getDoubleByScienNotation(calValue, "0.0000000000");
            } else {
                orgValueStr = FunUtils.toString(orgValue);
                calValueStr = FunUtils.toString(calValue);
            }
            if (this.isEqual(orgValueStr, calValueStr) && !rw.isModify()) continue;
            cell = new Cell(key, calValueStr);
            row.addCell(cell);
        }
        if (row.getCells().size() > 0) {
            return row;
        }
        return null;
    }

    private String getDoubleByScienNotation(Object obj, String cmpItemDataDot) {
        if (null == obj) {
            return null;
        }
        Double res = FunUtils.toBigDecimal(obj).doubleValue();
        DecimalFormat df = new DecimalFormat(cmpItemDataDot);
        return df.format(res);
    }

    public VRRow getVRResult(Map paras, String errMsg) {
        if (!paras.containsKey("USED_VALIDATERULE_MAP")) {
            return null;
        }
        VRRow vrRow = new VRRow();
        String mainTableName = this.executorParam.getMainTableName();
        String id = (String)paras.get((mainTableName + "_" + "fid").toUpperCase(Locale.ENGLISH));
        vrRow.setId(id);
        Map vrMap = (Map)paras.get("USED_VALIDATERULE_MAP");
        for (Map.Entry vr : vrMap.entrySet()) {
            String warnType;
            String vrId = (String)vr.getKey();
            String vrName = (String)vr.getValue();
            if (vrName.indexOf("####") < 0) continue;
            VRCell vrCell = new VRCell();
            vrCell.setVrId(vrId);
            String[] split = vrName.split("####");
            String result = "";
            if (paras.containsKey(split[0].toUpperCase(Locale.ENGLISH))) {
                result = (String)paras.get(split[0].toUpperCase(Locale.ENGLISH));
                warnType = split[1];
            } else {
                result = StringUtils.isEmpty((String)errMsg) ? errMsg : errMsg.replace("<br>", "");
                warnType = "40";
            }
            vrCell.setWarnType(warnType);
            vrCell.setResult(result);
            vrRow.addVrCell(vrCell);
        }
        if (vrRow.getVrCells().size() > 0) {
            return vrRow;
        }
        return null;
    }

    public boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if ((a == null || StringUtils.isEmpty((String)a.toString())) && (b == null || StringUtils.isEmpty((String)b.toString()))) {
            return true;
        }
        if (a instanceof String) {
            return ((String)a).equals(b);
        }
        if (b instanceof String) {
            return ((String)b).equals(a);
        }
        if (a instanceof Double) {
            return ((Double)a).equals(b);
        }
        if (b instanceof Double) {
            return ((Double)b).equals(a);
        }
        if (a instanceof Number && a != null && b != null && ((Number)a).doubleValue() == ((Number)b).doubleValue()) {
            return true;
        }
        return a == b;
    }

    public double getExt_finishedPer() {
        return this.ext_finishedPer;
    }
}

