/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.CalCategoryCollection;
import com.kingdee.shr.validaterule.CalCategoryFactory;
import com.kingdee.shr.validaterule.CalCategoryInfo;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.GuidUtil;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import com.kingdee.shr.validaterule.formula.SalaryCalExecutor2;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.formula.base.ICalculatorBusinessData;
import com.kingdee.shr.validaterule.formula.base.ICheckBeforeCalculate;
import com.kingdee.shr.validaterule.formula.base.IInitFormula;
import com.kingdee.shr.validaterule.formula.base.ISaveCalResult;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.impl.CheckBeforeCalculateImplCommon;
import com.kingdee.shr.validaterule.formula.base.impl.InitCalFormulaImplCommon;
import com.kingdee.shr.validaterule.formula.base.impl.SaveCalResultImplCommon;
import com.kingdee.shr.validaterule.formula.base.vo.CalExecutorParam;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.process.CalculatorProcessCache;
import com.kingdee.shr.validaterule.util.CalFormulaUpToBigUtil;
import com.kingdee.shr.validaterule.util.FunUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SalaryCalculator2
implements ISalaryCalculator {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.formula.SalaryCalculator2");
    private String calCategoryNum = "";
    private int precision = 2;
    private String mainTableName;
    private String mainTableAlias;
    private final String uid;
    private Context ctx;
    private String schemeID;
    private String tempTable;
    private String condition;
    private String calFormulas;
    private BaseFormulaCollection calFormulaColl;
    private Date endDate;
    private int status = 0;
    private double finishedPer = 0.0;
    private String calMessage = "";
    private boolean isDataSecret = false;
    private FunUtils util = null;
    private String filterSql;
    private ICalculatorBusinessData operateData;
    private ICheckBeforeCalculate checkBeforeCalculate;
    private IInitFormula initFormula;
    private ISaveCalResult saveCalResult;
    private String configNum;
    private boolean isSimilation = false;
    private SalaryCalExecutor2 salaryCalExecutor2 = null;
    private Sheet result;
    private Object outerData;
    private InitCalData initCalData = new InitCalData();

    public SalaryCalculator2() {
        if (this.util == null) {
            this.util = new FunUtils();
        }
        this.uid = GuidUtil.getRandomGUID();
    }

    public SalaryCalculator2(String uid) {
        if (this.util == null) {
            this.util = new FunUtils();
        }
        this.uid = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String info = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"label0", (Locale)this.ctx.getLocale());
        try {
            this.upgradeFormulaBigExpress();
            this.initCalData.setCtx(this.ctx);
            this.initCalData.setSchemeID(this.schemeID);
            this.initCalData.setUid(this.uid);
            this.initCalData.setOuterData(this.outerData);
            this.initBusinessOperate();
            String msg = this.checkBeforeCalculate.checkSchemeValid(this.ctx, this.schemeID);
            if (!StringUtils.isEmpty((String)msg)) {
                throw new RuntimeException(msg);
            }
            this.setStatus(1);
            this.initCalData.setCalFormulas(this.calFormulas);
            this.initCalData.setCalFormulaColl(this.calFormulaColl);
            this.initCalData.setSimulation(this.isSimilation);
            this.initCalData.setLanType(this.ctx.getLocale().getLanguage());
            this.initCalData.setMainTable(this.mainTableName);
            BaseFormulaCollection searchCalFormula = this.initFormula.searchCalFormula(this.initCalData);
            this.initCalData.setCalFormulaColl(searchCalFormula);
            Map<String, String> assTable = this.operateData.combineTableItems(this.ctx, searchCalFormula);
            this.initCalData.setAssTable(assTable);
            Map<String, Object> allCnSnMap = this.operateData.getAllCnSnMap(this.ctx, this.schemeID);
            this.initCalData.setAllCnSnMap(allCnSnMap);
            SalaryCalFunction2 calObj = this.initCalInstance(allCnSnMap, searchCalFormula);
            DataSet dataSet = this.initCalData(assTable);
            Set secColSet = this.initSecureCol();
            Map<String, Object> editedItems = this.initEditedItems();
            this.result = this.execCalculate(calObj, dataSet, secColSet, editedItems, allCnSnMap);
            this.handleCalResult(allCnSnMap, this.result, calObj.getParamMap());
            this.finishedPer = 99.0;
            this.setStatus(2);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException || e instanceof RuntimeException) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (e instanceof NullPointerException) {
                info = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"label31", (Locale)this.ctx.getLocale());
            } else {
                logger.error((Object)e.getMessage(), (Throwable)e);
                info = e.getMessage();
            }
            this.setStatus(4);
        }
        finally {
            this.calMessage = info;
            this.finishedPer = 100.0;
            this.destroyed();
        }
    }

    protected void upgradeFormulaBigExpress() {
        CalFormulaUpToBigUtil upToBigUtil = new CalFormulaUpToBigUtil(this.ctx);
        upToBigUtil.upgradeFormula("T_HR_SBaseFormula");
    }

    protected void initBusinessOperate() throws BOSException {
        CalCategoryCollection calCategoryCollection = CalCategoryFactory.getLocalInstance(this.ctx).getCalCategoryCollection("select * where number = '" + this.calCategoryNum + "'");
        if (null == calCategoryCollection || calCategoryCollection.size() == 0) {
            this.checkBeforeCalculate = new CheckBeforeCalculateImplCommon();
            this.initFormula = new InitCalFormulaImplCommon();
            this.operateData = new CalculatorBusinessDataCommon();
            this.saveCalResult = new SaveCalResultImplCommon();
            return;
        }
        CalCategoryInfo categoryInfo = calCategoryCollection.get(0);
        this.configNum = categoryInfo.getConfigSchemeNum();
        String beforeCalImplStr = categoryInfo.getBeforeCalImpl();
        this.checkBeforeCalculate = this.classForName(new CheckBeforeCalculateImplCommon(), beforeCalImplStr);
        String initFormulaImplClassStr = categoryInfo.getInitFormulaImplClass();
        this.initFormula = this.classForName(new InitCalFormulaImplCommon(), initFormulaImplClassStr);
        String initDataImplClassStr = categoryInfo.getInitDataImplClass();
        this.operateData = this.classForName(new CalculatorBusinessDataCommon(), initDataImplClassStr);
        String saveCalResultImplClassStr = categoryInfo.getSaveCalResultImplClass();
        this.saveCalResult = this.classForName(new SaveCalResultImplCommon(), saveCalResultImplClassStr);
    }

    private <T> T classForName(T t, String beforeCalImplStr) {
        try {
            Class<?> beforeCalImpl = Class.forName(beforeCalImplStr);
            Object obj = beforeCalImpl.newInstance();
            if (!t.getClass().isInstance(obj)) {
                return t;
            }
            return (T)obj;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return t;
    }

    protected SalaryCalFunction2 initCalInstance(Map<String, Object> allCnSnMap, BaseFormulaCollection searchCalFormula) throws SalaryException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"---initCalInstance");
        }
        SalaryCalFunction2 calObj = this.operateData.initCalInstance(this.initCalData);
        calObj.setCtx(this.ctx);
        calObj.setMainTableName(this.mainTableName);
        calObj.setType("cal");
        return calObj;
    }

    protected DataSet initCalData(Map<String, String> assTable) throws EASBizException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"---initCalData");
        }
        this.initCalData.setConfigNum(this.configNum);
        this.initCalData.setCondition(this.condition);
        this.initCalData.setMainTableName(this.mainTableName);
        this.initCalData.setMainTableAlias(this.mainTableAlias);
        this.initCalData.setEndDate(this.endDate);
        return this.operateData.initCalData(this.initCalData);
    }

    protected void handleCalResult(Map<String, Object> allCnSnMap, Sheet result, Map<String, Object> paras) throws SalaryException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("---handleCalResult  :   " + result));
        }
        this.saveCalResult.saveCalResult(this.initCalData, result);
    }

    public void destroyed() {
        this.util = null;
        if (this.getTempTable() != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.getTempTable());
        }
    }

    public Sheet execCalculate(SalaryCalFunction2 calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems, Map<String, Object> allCnSnMap) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"---execCalculate");
        }
        if (this.finishedPer < 40.0) {
            this.finishedPer = 40.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"label3", (Locale)this.ctx.getLocale());
        }
        Sheet result = new Sheet();
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setMainTableRowFilter(this.condition);
        calObj.setUid(this.uid);
        result = this.calSalaryBySubThread(calObj, dataSet, secColSet, editedItems, allCnSnMap);
        return result;
    }

    public Sheet calSalaryBySubThread(SalaryCalFunction2 calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems, Map<String, Object> allCnSnMap) throws EASBizException {
        Sheet changeSqlMap = new Sheet();
        Runnable getFinishPer = () -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            do {
                this.finishedPer = 40.0 + this.salaryCalExecutor2.getExt_finishedPer();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!this.salaryCalExecutor2.isExecuteFinished());
            System.out.println("Thread name : " + this.salaryCalExecutor2.getName() + ", UID : " + this.uid + " isExecuteFinished");
        };
        new Thread(getFinishPer).start();
        this.doExecute(calObj, dataSet, secColSet, editedItems, allCnSnMap);
        if (this.salaryCalExecutor2.getChangeData() != null) {
            System.out.println("---------------" + this.salaryCalExecutor2.getName() + ":" + this.salaryCalExecutor2.getChangeData().getErrMsg());
            changeSqlMap = this.salaryCalExecutor2.getChangeData();
        }
        return changeSqlMap;
    }

    private SalaryCalExecutor2 doExecute(SalaryCalFunction2 calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems, Map<String, Object> allCnSnMap) {
        CalExecutorParam executorParam = new CalExecutorParam();
        executorParam.setCalCategoryNum(this.configNum);
        executorParam.setPrecision(this.precision);
        executorParam.setMainTableName(this.mainTableName);
        executorParam.setMainTableAlias(this.mainTableAlias);
        executorParam.setCtx(this.ctx);
        executorParam.setCalMessage("");
        executorParam.setDataSecret(this.isDataSecret);
        executorParam.setSchemeID(this.schemeID);
        executorParam.setCalObj(calObj);
        executorParam.setDataSet(dataSet);
        executorParam.setSecColSet(secColSet);
        executorParam.setEditedItems(editedItems);
        executorParam.setAllCnSnMap(allCnSnMap);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" SalaryCalExecutor2 run executorParam :  " + executorParam));
        }
        this.salaryCalExecutor2 = new SalaryCalExecutor2(executorParam);
        this.salaryCalExecutor2.setName("ValidateCalculatorThread");
        this.salaryCalExecutor2.run();
        return this.salaryCalExecutor2;
    }

    public String getCalMessage() {
        return this.calMessage;
    }

    public double getFinishedPer() {
        if (this.finishedPer >= 99.0) {
            this.finishedPer = 99.0;
        }
        return this.finishedPer;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    public Sheet getCalResult() {
        return this.result;
    }

    public Set initSecureCol() {
        HashSet set = new HashSet();
        return set;
    }

    protected Map<String, Object> initEditedItems() {
        HashMap<String, Object> EditedItems = new HashMap<String, Object>();
        return EditedItems;
    }

    @Override
    public void setCalFormulas(String calFormulas) {
        this.calFormulas = calFormulas;
    }

    public void setCalFormulaColl(BaseFormulaCollection calFormulaColl) {
        this.calFormulaColl = calFormulaColl;
    }

    public void setCalMessage(String calMessage) {
        this.calMessage = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.SalaryCalculatResource", (String)"init", (Locale)this.ctx.getLocale());
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    @Override
    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getMainTableName() {
        return this.mainTableName;
    }

    public String getMainTableAlias() {
        return this.mainTableAlias;
    }

    public String getCalFormulas() {
        return this.calFormulas;
    }

    @Override
    public void setPrecision(int v) {
        this.precision = v;
    }

    @Override
    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public String getSchemeID() {
        return this.schemeID;
    }

    public void setStatus(int status) {
        this.status = status;
        CalculatorProcessCache.updateProcess(this.uid, status, this.finishedPer);
    }

    public void setTempTable(String tempTable) {
        this.tempTable = tempTable;
    }

    public String getFilterSql() {
        return this.filterSql;
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }

    public String getCalCategoryNum() {
        return this.calCategoryNum;
    }

    public void setCalCategoryNum(String calCategoryNum) {
        this.calCategoryNum = calCategoryNum;
    }

    public void setMainTableAlias(String mainTableAlias) {
        this.mainTableAlias = mainTableAlias;
    }

    @Override
    public void setCalFromDate(String calFromDate) {
    }

    @Override
    public void setCalToDate(String calToDate) {
    }

    @Override
    public void setMonth(String month) {
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    protected boolean isDataSecret() {
        return this.isDataSecret;
    }

    protected void setDataSecret(boolean isDataSecret) {
        this.isDataSecret = isDataSecret;
    }

    protected ICalculatorBusinessData getOperateData() {
        return this.operateData;
    }

    protected void setOperateData(ICalculatorBusinessData operateData) {
        this.operateData = operateData;
    }

    protected ICheckBeforeCalculate getCheckBeforeCalculate() {
        return this.checkBeforeCalculate;
    }

    protected void setCheckBeforeCalculate(ICheckBeforeCalculate checkBeforeCalculate) {
        this.checkBeforeCalculate = checkBeforeCalculate;
    }

    protected IInitFormula getInitFormula() {
        return this.initFormula;
    }

    protected void setInitFormula(IInitFormula initFormula) {
        this.initFormula = initFormula;
    }

    protected ISaveCalResult getSaveCalResult() {
        return this.saveCalResult;
    }

    protected void setSaveCalResult(ISaveCalResult saveCalResult) {
        this.saveCalResult = saveCalResult;
    }

    protected String getConfigNum() {
        return this.configNum;
    }

    protected void setConfigNum(String configNum) {
        this.configNum = configNum;
    }

    protected int getPrecision() {
        return this.precision;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    protected BaseFormulaCollection getCalFormulaColl() {
        return this.calFormulaColl;
    }

    protected Date getEndDate() {
        return this.endDate;
    }

    protected void setFinishedPer(double finishedPer) {
        this.finishedPer = finishedPer;
    }

    protected boolean isSimilation() {
        return this.isSimilation;
    }

    protected void setSimilation(boolean isSimilation) {
        this.isSimilation = isSimilation;
    }

    protected SalaryCalExecutor2 getSalaryCalExecutor2() {
        return this.salaryCalExecutor2;
    }

    protected Object getOuterData() {
        return this.outerData;
    }

    protected void setOuterData(Object outerData) {
        this.outerData = outerData;
    }

    public void setContainsVerification(boolean isContainsVerification) {
        this.initCalData.setContainsVerification(isContainsVerification);
    }
}

