/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula.base.data;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataSetGenerator;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.util.SqlUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DataAccess {
    private static Logger logger = Logger.getLogger(DataAccess.class);

    public static final void logException(Exception e) {
        logger.error((Object)e.getMessage());
        e.printStackTrace();
    }

    public DataTable getDataForDataTable(Context ctx, String sql) {
        DataTable dt = new DataTable();
        IRowSet rs = null;
        try {
            ArrayList<ColumnAttributes> columns;
            int columnSize;
            int exceptionNumber;
            int mod;
            String tempSql = "";
            if (sql.contains(" ")) {
                int orderIndex = 0;
                if (sql.contains("order by")) {
                    orderIndex = sql.indexOf("order by");
                } else if (sql.contains("ORDER BY")) {
                    orderIndex = sql.indexOf("ORDER BY");
                }
                tempSql = orderIndex > 0 ? sql.substring(0, orderIndex) : sql;
            }
            int pageSize = 0 == (mod = (exceptionNumber = JdbcRowSet.UPPER_CELLNUMBER_FOR_EXCEPTION) % (columnSize = (columns = DataSetGenerator.generateColumns((rs = DbUtil.executeQuery((Context)ctx, (String)("select TEMPTABLE.* from (" + tempSql + ") TEMPTABLE where 1<>1"))).getMetaData())).size())) ? exceptionNumber / columnSize + 1 : (exceptionNumber - mod) / columnSize;
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) counts from (" + tempSql + ")TEMPTABLE"));
            int rowTotalSize = 0;
            while (rs.next()) {
                rowTotalSize = rs.getInt("counts");
            }
            int totalPage = 1;
            if (rowTotalSize > pageSize) {
                totalPage = rowTotalSize / pageSize + 1;
            }
            int length = pageSize;
            PagingHelper pageHelper = new PagingHelper();
            String pagingSQL = "";
            for (int curPage = 1; curPage < totalPage + 1; ++curPage) {
                if (curPage * pageSize > rowTotalSize) {
                    length = rowTotalSize - (curPage - 1) * pageSize;
                }
                pagingSQL = pageHelper.getPagingSqlNoOptmize(ctx, sql, (curPage - 1) * pageSize, length);
                logger.info((Object)("getDataForDataTable pagingSQL : " + pagingSQL));
                rs = SqlUtil.executeQuery(ctx, pagingSQL, pageHelper.getParamData());
                dt = DataSetGenerator.generateDatas(dt, (ResultSet)rs, columns);
            }
            dt.columns = columns;
            dt.emptyrow = DataSetGenerator.generateEmptyRow(columns);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("errorSQL\uff1a" + sql));
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                DataAccess.logException(e);
            }
        }
        return dt;
    }
}

