/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OUPartCoreBaseInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.OrgHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.org.helper.OrgTypeSelfInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AutoSealUpNoBizOrgUnitHelper {
    private static Logger logger = Logger.getLogger((String)AutoSealUpNoBizOrgUnitHelper.class.getName());

    public static boolean tryAutoSealNoBizOrg(Context ctx, String orgId) {
        if (!OrgHelper.isSupportAutoSealup(ctx)) {
            return false;
        }
        try {
            FullOrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            AutoSealUpNoBizOrgUnitHelper.autoSealNoBizOrg(ctx, unitInfo);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static void autoSealNoBizOrg(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        INewOUInnerFacade iNewOUInnerFacade = NewOUInnerFacadeFactory.getLocalInstance(ctx);
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance(ctx);
        AutoSealUpNoBizOrgUnitHelper.checkBizPropertiesSealedUp(ctx, unitInfo);
        String longNumberOfSubUnits = unitInfo.getLongNumber() + "!%";
        String oqlToFindUnSealedUpSubUnits = "where isOUSealUp = 0 and isUnion = 0 and longNumber like '" + longNumberOfSubUnits + "' order by longnumber desc";
        OrgUnitCollection orgUnitCollection = iFull.getOrgUnitCollection(oqlToFindUnSealedUpSubUnits);
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            OrgUnitInfo subOrgUnitInfo = orgUnitCollection.get(i);
            iNewOUInnerFacade.ouSealUp(subOrgUnitInfo.getId().toString());
        }
        iNewOUInnerFacade.ouSealUp(unitInfo.getId().toString());
    }

    private static void checkBizPropertiesSealedUp(Context ctx, FullOrgUnitInfo unitInfo) throws BOSException, EASBizException {
        String unitID = unitInfo.getId().toString();
        Iterator it = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo().iterator();
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
        IDynamicObject iDO = DynamicObjectFactory.getLocalInstance((Context)ctx);
        String oql = "Select isSealUp Where unit.id = '" + unitID + "'";
        while (it.hasNext()) {
            OUPartCoreBaseInfo ouPartBaseInfo;
            OrgTypeInfo orgTypeInfo = (OrgTypeInfo)it.next();
            if (OrgType.NONE == orgTypeInfo.getOrgType()) continue;
            OrgTypeSelfInfo orgTypeSelfInfo = OrgTypeAppCenter.getInstance().getHelper(orgTypeInfo.getOrgType()).getOrgTypeSelfInfo();
            if (!orgTypeHelper.isOrgType(orgTypeInfo.getOrgType()) || (ouPartBaseInfo = (OUPartCoreBaseInfo)iDO.getValue(orgTypeSelfInfo.getOrgTableBosType(), oql)).getBoolean("isSealUp")) continue;
            Object[] params = new String[]{orgTypeInfo.getOrgType().getAlias()};
            throw new OUException(OUException.CANT_OUSEALUP_NOTSEALUP, params);
        }
    }
}

