/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OUPartHRInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.OrgVersionMgrFacadeFactory;
import com.kingdee.eas.basedata.org.app.AbstractOrgUnitDefaultRelationControllerBean;
import com.kingdee.eas.basedata.org.app.helper.IOrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgAppHelper;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.basedata.org.helper.BizOrgQueryParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class OrgUnitDefaultRelationControllerBean
extends AbstractOrgUnitDefaultRelationControllerBean {
    private static Logger logger = Logger.getLogger((String)OrgUnitDefaultRelationControllerBean.class.getName());
    private static final String ADMIN_TO_HR_ID = "00000000-0000-0000-0000-0000000000100FE9F8B5";
    private static final String ADMIN_TO_FI_ID = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    private static final String PURCHASE_TO_FI_ID = "00000000-0000-0000-0000-0000000000030FE9F8B5";
    private static final String SALE_TO_FI_ID = "00000000-0000-0000-0000-0000000000050FE9F8B5";
    private static final String STORAGE_TO_FI_ID = "00000000-0000-0000-0000-0000000000070FE9F8B5";

    @Override
    protected void _rebuildOrgDefaultRelation(Context ctx) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance(ctx).getCurrentVersionNumber();
            BizOrgQueryParam queryParam = new BizOrgQueryParam("BIZOBJ_VIEW", "TRUE", "ALL", false);
            this.insertRecordsOfAdminToHR(ctx, cn, versionNumber, queryParam);
            this.insertRecordsOfAdminToFI(ctx, cn, versionNumber, queryParam);
            this.insertRecordsOfPurchaseToFI(ctx, cn, versionNumber, queryParam);
            this.insertRecordsOfSaleToFI(ctx, cn, versionNumber, queryParam);
            this.insertRecordsOfStorageToFI(ctx, cn, versionNumber, queryParam);
            this.deleteDuplicateRelation(ctx, cn);
        }
        catch (Exception e) {
            logger.debug((Object)"Exceptioin:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void deleteDuplicateRelation(Context ctx, Connection conn) throws Exception {
        StringBuffer select = new StringBuffer("SELECT FFromUnitID, FToUnitID, FTypeRelationID ").append("FROM T_ORG_UnitRelation ").append("GROUP BY FFromUnitID, FToUnitID, FTypeRelationID ").append("HAVING COUNT(1) > 1");
        RowSet rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)select.toString());
        ArrayList<UnitAndTypeInfo> infoList = new ArrayList<UnitAndTypeInfo>();
        while (rs.next()) {
            UnitAndTypeInfo info = new UnitAndTypeInfo(rs.getString(1), rs.getString(2), rs.getString(3));
            infoList.add(info);
        }
        Statement stmt = conn.createStatement();
        for (UnitAndTypeInfo info : infoList) {
            StringBuffer buffer = new StringBuffer("SELECT FID FROM T_ORG_UnitRelation WHERE ").append("FFromUnitID = '").append(info.fromUnitId).append("' AND ").append("FToUnitID = '").append(info.toUnitId).append("' AND ").append("FTypeRelationID = '").append(info.typeRelationId).append("'");
            RowSet result = SQLUtils.getJdbcRowSet((Connection)conn, (String)buffer.toString());
            if (!result.next()) continue;
            while (result.next()) {
                String fid = result.getString(1);
                stmt.addBatch("DELETE FROM T_ORG_UnitRelation WHERE FID = '" + fid + "'");
            }
        }
        stmt.executeBatch();
    }

    @Override
    protected void _buildAdminToHRDefaultRelation(Context ctx, IObjectValue unitInfo) throws BOSException {
        FullOrgUnitInfo info = (FullOrgUnitInfo)unitInfo;
        Connection conn = null;
        Statement stmt = null;
        ResultSet result = null;
        try {
            Statement selectStmt;
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            String fID = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
            String fFromUnitid = info.getId().toString();
            String fToUnitid = this.getClosestUpperHROrg(ctx, info);
            if (fToUnitid != null && !(result = (selectStmt = conn.createStatement()).executeQuery(new StringBuffer("select 1 from T_ORG_UnitRelation where FFromUnitID = '").append(fFromUnitid).append("' and FToUnitID = '").append(fToUnitid).append("' and FTypeRelationID = '").append(ADMIN_TO_HR_ID).append("'").toString())).next()) {
                stmt.executeUpdate(new StringBuffer("insert into T_ORG_UnitRelation values ('").append(fID).append("', '").append(fFromUnitid).append("', '").append(fToUnitid).append("', '").append(ADMIN_TO_HR_ID).append("')").toString());
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(result, (Statement)stmt, (Connection)conn);
    }

    private String getClosestUpperHROrg(Context ctx, FullOrgUnitInfo info) throws BOSException, EASBizException {
        for (FullOrgUnitInfo anInfo = info; anInfo != null; anInfo = anInfo.getParent()) {
            OUPartHRInfo hrInfo = anInfo.getPartHR();
            if (hrInfo == null || !hrInfo.isIsBizUnit()) continue;
            return anInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected void _rebuildAdminToHRDefaultRelation(Context ctx) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance(ctx).getCurrentVersionNumber();
            BizOrgQueryParam queryParam = new BizOrgQueryParam("BIZOBJ_VIEW", "TRUE", "ALL", false);
            this.insertRecordsOfAdminToHR(ctx, cn, versionNumber, queryParam);
            this.deleteDuplicateRelation(ctx, cn);
        }
        catch (Exception e) {
            logger.debug((Object)"Exceptioin:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected void _rebuildAdminToFIDefaultRelation(Context ctx) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String versionNumber = OrgVersionMgrFacadeFactory.getLocalInstance(ctx).getCurrentVersionNumber();
            BizOrgQueryParam queryParam = new BizOrgQueryParam("BIZOBJ_VIEW", "TRUE", "ALL", false);
            this.insertRecordsOfAdminToFI(ctx, cn, versionNumber, queryParam);
            this.deleteDuplicateRelation(ctx, cn);
        }
        catch (Exception e) {
            logger.debug((Object)"Exceptioin:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void insertRecordsOfAdminToHR(Context ctx, Connection cn, String versionNumber, BizOrgQueryParam queryParam) throws Exception {
        StringBuffer select = new StringBuffer(100);
        select.append("select FID, FLongNumber from T_ORG_BaseUnit a ").append("where FIsAdminOrgUnit = 1 ").append(" and not exists(").append("select 1 from  T_ORG_UnitRelation b where FTypeRelationID = '").append(ADMIN_TO_HR_ID).append("' and a.fid = b.FFromUnitID").append(")");
        RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)select.toString());
        StringBuffer insert = new StringBuffer(100);
        insert.append("insert into T_ORG_UnitRelation ").append("values (''{0}'', ''{1}'', ''{2}'', ''{3}''");
        String fID = null;
        String fFromUnitid = null;
        String fToUnitid = null;
        String fTypeRelationID = ADMIN_TO_HR_ID;
        String insertBatch = null;
        Statement st = cn.createStatement();
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(OrgType.HRO.getValue()));
        while (rs.next()) {
            fID = BOSUuid.create((BOSObjectType)new OrgUnitRelationInfo().getBOSType()).toString();
            fFromUnitid = rs.getString(1);
            rs.getString(2);
            fToUnitid = this.getClosestUpperBizOrg(ctx, queryParam, orgAppHelper, fFromUnitid);
            if (fToUnitid == null) continue;
            insertBatch = MessageFormat.format(insert.toString(), fID, fFromUnitid, fToUnitid, fTypeRelationID);
            insertBatch = insertBatch + ", 0, '" + versionNumber + "')";
            st.addBatch(insertBatch);
        }
        st.executeBatch();
    }

    private void insertRecordsOfAdminToFI(Context ctx, Connection cn, String versionNumber, BizOrgQueryParam queryParam) throws Exception {
        StringBuffer select = new StringBuffer(100);
        select.append("select FID, FLongNumber from T_ORG_BaseUnit a ").append(" where FIsAdminOrgUnit = 1 ").append(" and not exists(").append("select 1 from  T_ORG_UnitRelation b where FTypeRelationID = '").append(ADMIN_TO_FI_ID).append("' and a.fid = b.FFromUnitID").append(")");
        RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)select.toString());
        StringBuffer insert = new StringBuffer(100);
        insert.append("insert into T_ORG_UnitRelation ").append("values (''{0}'', ''{1}'', ''{2}'', ''{3}''");
        String fID = null;
        String fFromUnitid = null;
        String fToUnitid = null;
        String fTypeRelationID = ADMIN_TO_FI_ID;
        String insertBatch = null;
        Statement st = cn.createStatement();
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(OrgType.Company.getValue()));
        while (rs.next()) {
            fID = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
            fFromUnitid = rs.getString(1);
            fToUnitid = this.getClosestUpperBizOrg(ctx, queryParam, orgAppHelper, fFromUnitid);
            if (fToUnitid == null) continue;
            insertBatch = MessageFormat.format(insert.toString(), fID, fFromUnitid, fToUnitid, fTypeRelationID);
            insertBatch = insertBatch + ", 0, '" + versionNumber + "')";
            st.addBatch(insertBatch);
        }
        st.executeBatch();
    }

    private void insertRecordsOfPurchaseToFI(Context ctx, Connection cn, String versionNumber, BizOrgQueryParam queryParam) throws Exception {
        StringBuffer select = new StringBuffer(100);
        select.append("select FID, FLongNumber from T_ORG_BaseUnit a").append(" where FIsPurchaseOrgUnit = 1 ").append(" and not exists(").append("select 1 from  T_ORG_UnitRelation b where FTypeRelationID = '").append(PURCHASE_TO_FI_ID).append("' and a.fid = b.FFromUnitID").append(")");
        RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)select.toString());
        StringBuffer insert = new StringBuffer(100);
        insert.append("insert into T_ORG_UnitRelation ").append("values (''{0}'', ''{1}'', ''{2}'', ''{3}''");
        String fID = null;
        String fFromUnitid = null;
        String fToUnitid = null;
        String fTypeRelationID = PURCHASE_TO_FI_ID;
        String insertBatch = null;
        Statement st = cn.createStatement();
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(OrgType.Company.getValue()));
        while (rs.next()) {
            fID = BOSUuid.create((BOSObjectType)new OrgUnitRelationInfo().getBOSType()).toString();
            fFromUnitid = rs.getString(1);
            fToUnitid = this.getClosestUpperBizOrg(ctx, queryParam, orgAppHelper, fFromUnitid);
            if (fToUnitid == null) continue;
            insertBatch = MessageFormat.format(insert.toString(), fID, fFromUnitid, fToUnitid, fTypeRelationID);
            insertBatch = insertBatch + ", 0, '" + versionNumber + "')";
            st.addBatch(insertBatch);
        }
        st.executeBatch();
    }

    private void insertRecordsOfSaleToFI(Context ctx, Connection cn, String versionNumber, BizOrgQueryParam queryParam) throws Exception {
        StringBuffer select = new StringBuffer(100);
        select.append("select FID, FLongNumber from T_ORG_BaseUnit a").append(" where FIsSaleOrgUnit = 1 ").append(" and not exists(").append("select 1 from  T_ORG_UnitRelation b where FTypeRelationID = '").append(SALE_TO_FI_ID).append("' and a.fid = b.FFromUnitID").append(")");
        RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)select.toString());
        StringBuffer insert = new StringBuffer(100);
        insert.append("insert into T_ORG_UnitRelation ").append("values (''{0}'', ''{1}'', ''{2}'', ''{3}''");
        String fID = null;
        String fFromUnitid = null;
        String fToUnitid = null;
        String fTypeRelationID = SALE_TO_FI_ID;
        String insertBatch = null;
        Statement st = cn.createStatement();
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(OrgType.Company.getValue()));
        while (rs.next()) {
            fID = BOSUuid.create((BOSObjectType)new OrgUnitRelationInfo().getBOSType()).toString();
            fFromUnitid = rs.getString(1);
            fToUnitid = this.getClosestUpperBizOrg(ctx, queryParam, orgAppHelper, fFromUnitid);
            if (fToUnitid == null) continue;
            insertBatch = MessageFormat.format(insert.toString(), fID, fFromUnitid, fToUnitid, fTypeRelationID);
            insertBatch = insertBatch + ", 0, '" + versionNumber + "')";
            st.addBatch(insertBatch);
        }
        st.executeBatch();
    }

    private void insertRecordsOfStorageToFI(Context ctx, Connection cn, String versionNumber, BizOrgQueryParam queryParam) throws Exception {
        StringBuffer select = new StringBuffer(100);
        select.append("select FID, FLongNumber from T_ORG_BaseUnit a").append(" where FIsStorageOrgUnit = 1 ").append(" and not exists(").append("select 1 from  T_ORG_UnitRelation b where FTypeRelationID = '").append(STORAGE_TO_FI_ID).append("' and a.fid = b.FFromUnitID").append(")");
        RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)select.toString());
        StringBuffer insert = new StringBuffer(100);
        insert.append("insert into T_ORG_UnitRelation ").append("values (''{0}'', ''{1}'', ''{2}'', ''{3}''");
        String fID = null;
        String fFromUnitid = null;
        String fToUnitid = null;
        String insertBatch = null;
        Statement st = cn.createStatement();
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(OrgType.Company.getValue()));
        while (rs.next()) {
            fID = BOSUuid.create((BOSObjectType)new OrgUnitRelationInfo().getBOSType()).toString();
            fFromUnitid = rs.getString(1);
            fToUnitid = this.getClosestUpperBizOrg(ctx, queryParam, orgAppHelper, fFromUnitid);
            if (fToUnitid == null) continue;
            insertBatch = MessageFormat.format(insert.toString(), fID, fFromUnitid, fToUnitid, STORAGE_TO_FI_ID);
            insertBatch = insertBatch + ", 0, '" + versionNumber + "')";
            st.addBatch(insertBatch);
        }
        st.executeBatch();
    }

    private String getClosestUpperBizOrg(Context ctx, BizOrgQueryParam queryParam, IOrgAppHelper orgAppHelper, String orgID) throws EASBizException, BOSException {
        OrgUnitInfo orgInfo = OrgAppHelper.findBizSuperiorOrg(ctx, orgAppHelper.getOrgTypeSelfInfo().getOrgViewBosType(), orgID, queryParam);
        if (orgInfo != null) {
            return orgInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected IObjectValue _getUpperOrgID(Context ctx, String orgID, int upperOrgType) throws BOSException, EASBizException {
        BizOrgQueryParam queryParam = new BizOrgQueryParam("BIZOBJ_VIEW", "TRUE", "ALL", false);
        IOrgAppHelper orgAppHelper = OrgTypeAppCenter.getInstance().getHelper(OrgType.getEnum(upperOrgType));
        OrgUnitInfo orgInfo = OrgAppHelper.findBizSuperiorOrg(ctx, orgAppHelper.getOrgTypeSelfInfo().getOrgViewBosType(), orgID, queryParam);
        if (orgInfo != null) {
            return orgInfo.castToFullOrgUnitInfo();
        }
        return null;
    }

    @Override
    protected void _buildAdminToFIDefaultRelation(Context ctx, IObjectValue unitInfo) throws BOSException {
    }

    class UnitAndTypeInfo {
        String fromUnitId = null;
        String toUnitId = null;
        String typeRelationId = null;

        UnitAndTypeInfo(String fromUnitId, String toUnitId, String typeRelationId) {
            this.fromUnitId = fromUnitId;
            this.toUnitId = toUnitId;
            this.typeRelationId = typeRelationId;
        }
    }
}

