/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgTypeRelation;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationCollection;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.app.cache.OrgCacheInfo;
import com.kingdee.eas.basedata.org.app.cache.OrgTypeRelationCacheInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeInitHelper;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class OrgCacheImpl
implements Serializable {
    private static CustomCacheService orgCache = new CustomCacheService("permission.OrgCacheImpl");
    private static CustomCacheService orgUnitRelationCache = new CustomCacheService("org.orgUnitRelationCache");
    private static Map dcs = new Hashtable(5);
    private static CustomCacheService orgTypeRelationCache = new CustomCacheService("permission.OrgCacheImpl");

    private OrgCacheImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOrgCache() {
        CustomCacheService customCacheService = orgCache;
        synchronized (customCacheService) {
            orgCache.removeAll();
        }
        orgUnitRelationCache.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localClearCache() {
        CustomCacheService customCacheService = orgCache;
        synchronized (customCacheService) {
            orgCache.removeAll();
        }
        orgUnitRelationCache.removeAll();
    }

    public static boolean existsInOrgCache(Context ctx, String id, OrgType orgType) {
        String key = ctx.getAIS().trim() + id + orgType.getValue();
        return orgCache.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOrgUnitInfo(Context ctx, String id) {
        OrgType orgType = null;
        String key = null;
        Iterator orgTypeIter = OrgType.iterator();
        while (orgTypeIter.hasNext()) {
            orgType = (OrgType)((Object)orgTypeIter.next());
            key = ctx.getAIS().trim() + id + orgType.getValue();
            CustomCacheService customCacheService = orgCache;
            synchronized (customCacheService) {
                orgCache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putOrgUnitInfo(Context ctx, String id, OrgType orgType, OrgUnitInfo unitInfo) {
        String key = ctx.getAIS().trim() + id + orgType.getValue();
        OrgCacheInfo cacheInfo = new OrgCacheInfo(unitInfo);
        CustomCacheService customCacheService = orgCache;
        synchronized (customCacheService) {
            orgCache.put(key, (Object)cacheInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrgUnitInfo getOrgUnitInfo(Context ctx, String id, OrgType orgType) throws EASBizException, BOSException {
        String key = ctx.getAIS().trim() + id + orgType.getValue();
        OrgCacheInfo cacheInfo = (OrgCacheInfo)orgCache.get(key);
        OrgTypeInitHelper helper = new OrgTypeInitHelper();
        helper.checkOrgInit(ctx);
        if (cacheInfo == null) {
            OrgUnitInfo unitInfo = OrgCacheImpl.getTypedInfo(ctx, id, orgType);
            if (unitInfo != null) {
                cacheInfo = new OrgCacheInfo(unitInfo);
                CustomCacheService customCacheService = orgCache;
                synchronized (customCacheService) {
                    orgCache.put(key, (Object)cacheInfo);
                }
            }
        } else {
            cacheInfo.setLastAccessTime(System.currentTimeMillis());
        }
        return cacheInfo == null ? null : cacheInfo.getUnitInfo();
    }

    private static OrgUnitInfo getTypedInfo(Context ctx, String id, OrgType orgType) throws BOSException, EASBizException {
        return NewOrgUnitHelper.getTypedOrgUnit(ctx, id, orgType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOrgTypeRelationCache() {
        CustomCacheService customCacheService = orgTypeRelationCache;
        synchronized (customCacheService) {
            orgTypeRelationCache.removeAll();
        }
    }

    public static boolean existsInOrgTypeRelationCache(Context ctx, int fromTypeValue, int toTypeValue) {
        String key = ctx.getAIS().trim() + fromTypeValue + toTypeValue;
        return orgTypeRelationCache.contains(key);
    }

    public static OrgTypeRelationInfo getOrgTypeRelationInfo(Context ctx, int fromTypeValue, int toTypeValue) throws EASBizException, BOSException {
        OrgTypeRelationCacheInfo cacheInfo;
        String dc = ctx.getAIS().trim();
        if (dcs.get(dc) == null) {
            dcs.put(dc, dc);
            OrgCacheImpl.localAllOrgTypeRelationCache(ctx);
        }
        return (cacheInfo = (OrgTypeRelationCacheInfo)orgTypeRelationCache.get(dc + fromTypeValue + toTypeValue)) == null ? null : cacheInfo.getTypeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void localAllOrgTypeRelationCache(Context ctx) throws EASBizException, BOSException {
        String pk = null;
        OrgTypeRelationCacheInfo cacheInfo = null;
        IOrgTypeRelation iTypeRel = OrgTypeRelationFactory.getLocalInstance(ctx);
        OrgTypeRelationCollection typeCol = iTypeRel.getOrgTypeRelationCollection();
        for (int i = 0; i < typeCol.size(); ++i) {
            OrgTypeRelationInfo typeInfo = typeCol.get(i);
            pk = ctx.getAIS().trim() + typeInfo.getFromType().getValue() + typeInfo.getToType().getValue();
            cacheInfo = new OrgTypeRelationCacheInfo(typeInfo);
            CustomCacheService customCacheService = orgTypeRelationCache;
            synchronized (customCacheService) {
                orgTypeRelationCache.put(pk, (Object)cacheInfo);
                continue;
            }
        }
    }

    public static OrgUnitRelationCollection getOrgUnitRelationCollectionCache(Context ctx, String fromUnitID, int fromType, int toType) throws BOSException {
        String key = fromUnitID + "_" + fromType + "_" + toType;
        OrgUnitRelationCollection relCol = null;
        Object obj = orgUnitRelationCache.get(key);
        if (obj != null && obj instanceof OrgUnitRelationCollection) {
            relCol = (OrgUnitRelationCollection)((Object)obj);
        }
        if (relCol == null) {
            relCol = OrgCacheImpl.getOrgUnitRelationCollection(ctx, fromUnitID, fromType, toType);
            orgUnitRelationCache.put(key, (Object)relCol);
        }
        return relCol;
    }

    public static void setOrgUnitRelationCollectionCache(Context ctx, String fromUnitID, int fromType, int toType) throws BOSException {
        String key = fromUnitID + "_" + fromType + "_" + toType;
        orgUnitRelationCache.remove(key);
        OrgUnitRelationCollection relCol = OrgCacheImpl.getOrgUnitRelationCollection(ctx, fromUnitID, fromType, toType);
        orgUnitRelationCache.put(key, (Object)relCol);
    }

    public static void removeOrgUnitRelationCollectionCache(String fromUnitID, int fromType, int toType) {
        String key = fromUnitID + "_" + fromType + "_" + toType;
        orgUnitRelationCache.remove(key);
    }

    public static void removeAllOrgUnitRelationCollectionCache() {
        orgUnitRelationCache.removeAll();
    }

    private static OrgUnitRelationCollection getOrgUnitRelationCollection(Context ctx, String fromUnitID, int fromType, int toType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)fromUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toType), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        OrgUnitRelationCollection relCol = OrgUnitRelationFactory.getLocalInstance(ctx).getOrgUnitRelationCollection(view);
        return relCol;
    }
}

