/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.di;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CUBDControlCollection;
import com.kingdee.eas.basedata.org.CUBDControlDefaultObjectCollection;
import com.kingdee.eas.basedata.org.CUBDControlDefaultObjectFactory;
import com.kingdee.eas.basedata.org.CUBDControlDefaultObjectInfo;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControlDefaultObject;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.app.di.OrgDIBase;
import com.kingdee.eas.basedata.org.helper.OrgTypeHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class CUDI
extends OrgDIBase {
    @Override
    protected CoreBaseInfo createNewData(Hashtable hsData, Context ctx) throws Exception {
        String number = this.getFieldValue(hsData, "FNumber");
        String code = this.getFieldValue(hsData, "FCode");
        String parent = this.getFieldValue(hsData, "FParentID");
        String name_l1 = this.getFieldValue(hsData, "FName_L1");
        String name_l2 = this.getFieldValue(hsData, "FName_L2");
        String name_l3 = this.getFieldValue(hsData, "FName_L3");
        String englishName = this.getFieldValue(hsData, "FEnglishName");
        String simple = this.getFieldValue(hsData, "FSimpleName");
        String desc_l1 = this.getFieldValue(hsData, "FDescription_L1");
        String desc_l2 = this.getFieldValue(hsData, "FDescription_L2");
        String desc_l3 = this.getFieldValue(hsData, "FDescription_L3");
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        this.checkRequeiredField(ctx, "FNumber", number);
        this.checkRequeiredField(ctx, "FParentID", parent);
        unitInfo.setParent(this.getFullOrgUnitInfo4Common(ctx, parent));
        this.checkParentExisted(ctx, parent);
        if (new Locale("L1").equals(ctx.getLocale())) {
            this.checkRequeiredField(ctx, "FName_L1", name_l1);
        } else if (new Locale("L2").equals(ctx.getLocale())) {
            this.checkRequeiredField(ctx, "FName_L2", name_l2);
        } else {
            this.checkRequeiredField(ctx, "FName_L3", name_l3);
        }
        super.checkAllInvalidChar(hsData, ctx);
        unitInfo.setIsCU(true);
        unitInfo.put("isCus", new Boolean(true));
        this.setCUBDControl(unitInfo, ctx);
        if (number != null && number.length() != 0) {
            unitInfo.setNumber(number);
        }
        if (code != null && code.length() != 0) {
            unitInfo.setCode(code);
        }
        if (name_l1 != null && name_l1.length() != 0) {
            unitInfo.setName(name_l1, new Locale("L1"));
        }
        if (name_l2 != null && name_l2.length() != 0) {
            unitInfo.setName(name_l2, new Locale("L2"));
        }
        if (name_l3 != null && name_l3.length() != 0) {
            unitInfo.setName(name_l3, new Locale("L3"));
        }
        if (simple != null && simple.length() != 0) {
            unitInfo.setSimpleName(simple);
        }
        if (desc_l1 != null && desc_l1.length() != 0) {
            unitInfo.setDescription(desc_l1, new Locale("L1"));
        }
        if (desc_l2 != null && desc_l2.length() != 0) {
            unitInfo.setDescription(desc_l2, new Locale("L2"));
        }
        if (desc_l3 != null && desc_l3.length() != 0) {
            unitInfo.setDescription(desc_l3, new Locale("L3"));
        }
        if (englishName != null && englishName.length() != 0) {
            unitInfo.setEnglishName(englishName);
        }
        unitInfo.put("isImportCU", Boolean.TRUE);
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(unitInfo);
        orgTypeHelper.addOrgType(OrgType.ControlUnit);
        unitInfo.setOrgTypeStr(orgTypeHelper.createOrgTypeStrBySet());
        if (this.isImpModeUpdate() && this.isHaveSetOrgTypes(ctx, unitInfo)) {
            throw new OUException(OUException.CANNOT_IMPORT_CU_OR_OU);
        }
        return unitInfo;
    }

    private boolean isImpModeUpdate() {
        return (Integer)this.getContextParameter().get("DATATASKMODE") == 16;
    }

    private boolean isHaveSetOrgTypes(Context ctx, FullOrgUnitInfo unitInfo) throws Exception {
        String oql = "select id,orgTypeStr,isAdminOrgUnit,isCompanyOrgUnit,isCU,isCostOrgUnit,isHROrgUnit,isProfitOrgUnit,isPurchaseOrgUnit,isQualityOrgUnit,isSaleOrgUnit,isStorageOrgUnit,isTransportOrgUnit,isUnion where number='" + unitInfo.getNumber() + "' and isCU = '" + 1 + "'";
        FullOrgUnitInfo info = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance(ctx).getDataBaseInfo(oql);
        OrgTypeHelper orgTypeHelper = new OrgTypeHelper(info);
        Set orgTypes = orgTypeHelper.getAllSelectOrgTypeSet();
        HashSet<OrgType> notBizOrgTypes = new HashSet<OrgType>();
        notBizOrgTypes.add(OrgType.ControlUnit);
        notBizOrgTypes.add(OrgType.NONE);
        orgTypes.removeAll(notBizOrgTypes);
        return orgTypes.size() > 0;
    }

    private void setCUBDControl(FullOrgUnitInfo unitInfo, Context ctx) throws Exception {
        ICUBDControlDefaultObject iCUBDDefault = CUBDControlDefaultObjectFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSorter().add(new SorterItemInfo("defaultIndex"));
        CUBDControlCollection cubdCol = this.convertDefault(iCUBDDefault.getCUBDControlDefaultObjectCollection(viewInfo));
        unitInfo.put("CUBDControl", (Object)cubdCol);
    }

    private CUBDControlCollection convertDefault(CUBDControlDefaultObjectCollection col) {
        CUBDControlCollection ret = new CUBDControlCollection();
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            CUBDControlDefaultObjectInfo oldInfo = col.get(i);
            CUBDControlInfo newInfo = new CUBDControlInfo();
            newInfo.setBDBOSType(oldInfo.getBDBOSType());
            newInfo.setBDName(oldInfo.getBDName(new Locale("L2")), new Locale("L2"));
            newInfo.setBDName(oldInfo.getBDName(new Locale("L3")), new Locale("L3"));
            newInfo.setIsSuperiorViewable(oldInfo.isDefaultSuperiorViewable());
            newInfo.setIsSubordinateAddnewable(oldInfo.isDefaultSubordinateAddnewable());
            newInfo.setIsSubordinateEditable(oldInfo.isDefaultSubordinateEditable());
            newInfo.setIsSubordinateDeletable(oldInfo.isDefaultSubordinateDeletable());
            newInfo.setIsSubordinateUpgradable(oldInfo.isDefaultSubordinateUpgradable());
            newInfo.setIsDispatchChangable(oldInfo.isDefaultDispatchChangable());
            newInfo.setDispatchPattern(oldInfo.getDefaultDispatchPattern());
            newInfo.setIndex(oldInfo.getDefaultIndex());
            ret.add(newInfo);
        }
        return ret;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            Timestamp createTime;
            String creatorNumber;
            String englishName;
            String desciption;
            String simpleName;
            String parentNumber;
            result.put("FNumber", rs.getString("number"));
            String code = rs.getString("code");
            if (code != null) {
                result.put("FCode", code);
            }
            if ((parentNumber = rs.getString("parent.number")) != null) {
                result.put("FParentID", parentNumber);
            }
            Locale currentLocale = ctx.getLocale();
            String name = rs.getString("name");
            if (name != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FName_L1", name);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FName_L2", name);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FName_L3", name);
                }
            }
            if ((simpleName = rs.getString("simpleName")) != null) {
                result.put("FSimpleName", simpleName);
            }
            if ((desciption = rs.getString("description")) != null) {
                if (new Locale("L1").equals(currentLocale)) {
                    result.put("FDescription_L1", desciption);
                } else if (new Locale("L2").equals(currentLocale)) {
                    result.put("FDescription_L2", desciption);
                } else if (new Locale("L3").equals(currentLocale)) {
                    result.put("FDescription_L3", desciption);
                }
            }
            if ((englishName = rs.getString("englishName")) != null) {
                result.put("FEnglishName", englishName);
            }
            if ((creatorNumber = rs.getString("creator.number")) != null) {
                result.put("FCreatorNumber", creatorNumber);
            }
            if ((createTime = rs.getTimestamp("createTime")) != null) {
                result.put("FCreateTime", createTime.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Locale currentLocale = ctx.getLocale();
            String message = ResourceBase.getString((String)this.RESOURCE_FILE_NAME, (String)"DB_ACCESS_ERROR", (Locale)currentLocale);
            throw new TaskExternalException(message, (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isCU", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.NOTEQUALS));
        String currentLongNum = ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)currentLongNum, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(currentLongNum + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.org.app.OUExportQuery";
    }
}

