/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.app.log;

import com.kingdee.eas.basedata.org.OrgLogInfo;

public class OrgLogQueue {
    public static final int MAXIMUM_CAPACITY = 1024;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static OrgLogQueue instance;
    private OrgLogInfo[] logInfos = new OrgLogInfo[16];
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    private OrgLogQueue() {
    }

    public static OrgLogQueue getInstance() {
        if (instance == null) {
            instance = new OrgLogQueue();
        }
        return instance;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized void enqueue(OrgLogInfo logInfo) {
        if (this.size == this.logInfos.length) {
            this.reSize();
        }
        this.logInfos[this.tail] = logInfo;
        this.tail = (this.tail + 1) % this.logInfos.length;
        if (this.size == 0) {
            this.notifyAll();
        }
        ++this.size;
    }

    public synchronized OrgLogInfo dequeue() throws InterruptedException {
        while (this.size == 0) {
            this.wait();
        }
        OrgLogInfo logInfo = this.logInfos[this.head];
        this.head = (this.head + 1) % this.logInfos.length;
        --this.size;
        return logInfo;
    }

    private void reSize() {
        int oldCapacity = this.logInfos.length;
        OrgLogInfo[] oldArray = this.logInfos;
        int newCapacity = oldCapacity << 1;
        OrgLogInfo[] newArray = new OrgLogInfo[newCapacity];
        int i = this.head;
        for (int j = 0; j < this.size; ++j) {
            newArray[j] = oldArray[i];
            i = (i + 1) % oldCapacity;
        }
        this.logInfos = newArray;
        this.head = 0;
        this.tail = this.size;
    }
}

