/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.basedata.org.OrgXMLElement;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public class OrgBizConfigUtil {
    private static Logger logger = Logger.getLogger((String)OrgBizConfigUtil.class.getName());
    private static OrgBizConfigUtil instance = null;
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.deploy";
    public static final String CLIENTROOT_DIR_ENV_NAME = "easclient.root";
    public static final String fileName = "OrgConfig.xml";

    private static boolean runtimeIsClient() {
        return System.getProperty(CLIENTROOT_DIR_ENV_NAME) != null;
    }

    public static OrgBizConfigUtil getInstance() {
        if (instance == null) {
            instance = new OrgBizConfigUtil();
        }
        return instance;
    }

    private static String getPath() {
        String configPath = OrgBizConfigUtil.runtimeIsClient() ? System.getProperty(CLIENTROOT_DIR_ENV_NAME) : System.getProperty(PROPERTIES_DIR_ENV_NAME);
        String fullPath = configPath + File.separator + fileName;
        return fullPath;
    }

    public static List getBizClassesforOrg(String configitemName, String attributeKey) {
        ArrayList<String> dealClassNamesList = new ArrayList<String>();
        try {
            String path = OrgBizConfigUtil.getPath();
            File orgConfigFile = new File(path);
            XMLConfiguration xmlReader = XMLConfiguration.getInstance((File)orgConfigFile);
            ConfigurationItem item = xmlReader.getConfigItem(configitemName);
            Map pro = item.getProperties();
            String dealClassName2 = null;
            if (StringUtils.isEmpty((String)attributeKey)) {
                for (String dealClassName2 : pro.values()) {
                    if (StringUtils.isEmpty((String)dealClassName2)) continue;
                    dealClassNamesList.add(dealClassName2);
                }
            } else {
                dealClassNamesList.add((String)pro.get(attributeKey));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dealClassNamesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getXMLBizClasses(String configitemName, String attributeKey) throws JDOMException, IOException {
        ArrayList<OrgXMLElement> dealClassNamesList = new ArrayList<OrgXMLElement>();
        try (InputStream inputStream = null;){
            String path = OrgBizConfigUtil.getPath();
            inputStream = new FileInputStream(new File(path));
            Element document = XMLParser.parseXML((InputStream)inputStream).getRootElement();
            Element currentElement = (Element)XPath.selectSingleNode((Object)document, (String)("configitem[lower-case(attribute::name)='" + configitemName.toLowerCase() + "']"));
            if (currentElement != null) {
                List entities = currentElement.getChildren();
                int size = entities.size();
                for (int i = 0; i < size; ++i) {
                    Element entity = (Element)entities.get(i);
                    String key = entity.getAttribute("key").getValue();
                    String value = entity.getAttribute("value").getValue();
                    boolean isThrowException = Boolean.valueOf(entity.getAttribute("isThrowException").getValue());
                    String description = entity.getAttribute("description").getValue();
                    OrgXMLElement item = new OrgXMLElement(key, value, isThrowException, description);
                    if (!StringUtils.isEmpty((String)attributeKey) && attributeKey.equalsIgnoreCase(key)) {
                        dealClassNamesList.clear();
                        dealClassNamesList.add(item);
                        ArrayList<OrgXMLElement> arrayList = dealClassNamesList;
                        return arrayList;
                    }
                    dealClassNamesList.add(item);
                }
            }
        }
        return dealClassNamesList;
    }
}

