/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class OrgF7FilterUtil {
    private static Logger logger = Logger.getLogger((String)OrgF7FilterUtil.class.getName());

    public static String buildParamSQL(Context ctx, IObjectPK userPK, String cuID, OrgViewType viewType, boolean isCUFilter, boolean isIncludeSubCU) throws BOSException, EASBizException {
        StringBuffer paramSQL = new StringBuffer();
        paramSQL.append("SELECT BaseUnit.FID ").append("FROM T_PM_OrgRange OrgRange INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID ");
        if (isCUFilter && isIncludeSubCU) {
            paramSQL.append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = BaseUnit.FControlUnitID ");
        }
        paramSQL.append("WHERE OrgRange.FUserID = '").append(userPK).append("'").append(" AND OrgRange.FType = ").append(viewType == OrgViewType.ADMIN ? 20 : 10);
        if (isCUFilter) {
            if (isIncludeSubCU) {
                String cuLongNumber = OrgF7FilterUtil.getCULongNumber(ctx, cuID);
                paramSQL.append(" AND (CtrlUnit.FID = '").append(cuID).append("' OR CtrlUnit.FLongNumber like '").append(cuLongNumber).append("!%')");
            } else {
                paramSQL.append(" AND BaseUnit.FControlUnitID = '").append(cuID).append("'");
            }
        }
        return paramSQL.toString();
    }

    public static String buildParamSQL(IObjectPK userPK, String cuID, OrgViewType viewType, boolean isCUFilter, boolean isIncludeSubCU) throws BOSException, EASBizException {
        return OrgF7FilterUtil.buildParamSQL(null, userPK, cuID, viewType, isCUFilter, isIncludeSubCU);
    }

    public static String getCULongNumber(Context ctx, String cuID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)cuID)) {
            logger.debug((Object)"cuID is null.");
            return "no_data";
        }
        ICtrlUnit iCtrlUnit = null;
        iCtrlUnit = ctx == null ? CtrlUnitFactory.getRemoteInstance() : CtrlUnitFactory.getLocalInstance(ctx);
        return iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cuID)).getLongNumber();
    }

    public static String buildAuthorizedOrgSQL(Context ctx, IObjectPK userPK, String cuID, String permItemID, boolean isCUFilter, boolean isIncludeSubCU) throws BOSException, EASBizException {
        StringBuffer paramSQL = new StringBuffer();
        paramSQL.append(" SELECT BaseUnit.FID").append(" FROM T_ORG_BaseUnit BaseUnit ");
        if (isCUFilter && isIncludeSubCU) {
            paramSQL.append(" INNER JOIN T_ORG_CtrlUnit CtrlUnit ON CtrlUnit.FID = BaseUnit.FControlUnitID ");
        }
        paramSQL.append(" WHERE ");
        if (isCUFilter) {
            if (isIncludeSubCU) {
                String cuLongNumber = OrgF7FilterUtil.getCULongNumber(ctx, cuID);
                paramSQL.append(" CtrlUnit.FLongNumber || N'!' LIKE N'").append(cuLongNumber).append("' AND ");
            } else {
                paramSQL.append(" BaseUnit.FControlUnitID = '").append(cuID).append("' AND ");
            }
        }
        paramSQL.append(" BaseUnit.FID IN ( ").append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = '").append(userPK).append("' ").append(" AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' ").append(" AND UserOrgPerm.FPermType = ").append(10).append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userPK).append("' ").append(" AND RolePerm.FPermItemID = '").append(permItemID).append("' ").append(" AND RolePerm.FPermType =  ").append(10).append(" ) AND BaseUnit.FID NOT IN ( ").append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = '").append(userPK).append("' ").append(" AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' ").append(" AND UserOrgPerm.FPermType =  ").append(20).append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userPK).append("' ").append(" AND RolePerm.FPermItemID = '").append(permItemID).append("' ").append(" AND RolePerm.FPermType =  ").append(20).append(" ) ");
        return paramSQL.toString();
    }
}

