/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.bos.tool.utils.StringZipper;
import com.kingdee.eas.base.uict.ICloudMainMenuFacade;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;

public class RetrieveDynamicMetadataCommand
extends AbstractCommand {
    private static final String SQL_QUERY_MENU = "SELECT fMD5 FROM T_BIM_MDVIEW WHERE fProjectName=? AND fPath='FnMenuTree.xml'";
    private static final String SQL_INSERT = "INSERT T_BIM_MDVIEW (fProjectName, fPath, fMD5, fAlias, fCreator, fCreateTime, fLastModifyTime) VALUES(?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE = "UPDATE T_BIM_MDVIEW SET fMD5 = ?, fLastModifyTime=? WHERE fProjectName=? AND fPath=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String pk = this.request.getParameter("metadatapk");
        String projectName = this.getProjectName();
        AppInfo info = AppManager.getAppInfo(projectName);
        if (pk.equals("FnMenuTree.xml")) {
            ICloudMainMenuFacade facade = this.getCloudFacade();
            Connection conn = null;
            try {
                conn = this.getConnection();
                conn.setAutoCommit(true);
                PreparedStatement pstmt = conn.prepareStatement(SQL_QUERY_MENU);
                pstmt.setString(1, projectName);
                ResultSet rs = pstmt.executeQuery();
                String oldMd5 = null;
                boolean exists = false;
                if (rs.next()) {
                    exists = true;
                    oldMd5 = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                String xml = facade.loadMainMenuInfo();
                MD5 md5 = new MD5();
                md5.update(xml.getBytes("UTF-8"));
                String newMd5 = md5.asHex();
                if (!exists) {
                    pstmt = conn.prepareStatement(SQL_INSERT);
                    pstmt.setString(1, projectName);
                    pstmt.setString(2, "FnMenuTree.xml");
                    pstmt.setString(3, newMd5);
                    pstmt.setString(4, "mainMenu");
                    pstmt.setString(5, "sys_default");
                    pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                    pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                    pstmt.executeUpdate();
                } else if (!newMd5.equals(oldMd5)) {
                    pstmt = conn.prepareStatement(SQL_UPDATE);
                    pstmt.setString(1, newMd5);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, projectName);
                    pstmt.setString(4, "FnMenuTree.xml");
                    pstmt.executeUpdate();
                }
                File file = info.getProject().getRoot().getChildFile("FnMenuTree.xml").toFile();
                PFileUtils.write2File((String)xml, (File)file);
                ServletOutputStream out = this.response.getOutputStream();
                out.write(xml.getBytes("UTF-8"));
                out.flush();
            }
            catch (Exception e) {
                this.response.sendError(402, "fail to retrieve medata:" + this.getTrace(e));
                return;
            }
        }
        File md = new File(info.getProject().getSrcMetadataDir(), pk);
        if (!md.exists()) {
            this.response.sendError(-100001);
            return;
        }
        RandomAccessFile randomFile = null;
        ServletOutputStream out = null;
        try {
            randomFile = new RandomAccessFile(md, "r");
            out = this.response.getOutputStream();
            int fileLength = (int)randomFile.length();
            byte[] bscontent = new byte[fileLength];
            randomFile.read(bscontent);
            byte[] contentbytes = StringZipper.gzipToBytes((byte[])bscontent);
            this.response.addHeader("zipped", "1");
            out.write(contentbytes);
            out.flush();
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (Exception e) {
                    this.response.sendError(402, "fail to close RandomAccessFile:" + this.getTrace(e));
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.response.sendError(402, "fail to close ServletOutputStream:" + this.getTrace(e));
                }
            }
        }
    }
}

