/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.servlet;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.bean.DynamicMDBean;
import com.kingdee.bos.cloud.bean.UserManager;
import com.kingdee.bos.cloud.utils.LogUtil;
import com.kingdee.bos.cloud.utils.ResourceUtil;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.md.cache.MDSimpleObject;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDProject;
import com.kingdee.bos.md.tools.BizMetadataUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.bos.tool.utils.StringZipper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.uict.CloudMainMenuFacadeFactory;
import com.kingdee.eas.base.uict.ICloudMainMenuFacade;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class CloudAppServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(CloudAppServlet.class);
    public static final String SESSION_KEY_RPC_SESS_ID = "rpc_session_id";
    public static final String SESSION_KEY_MD_LOADER = "metadata_loader";
    public static final String SESSION_KEY_PROJECTNAME = "projectname";
    public static final String SESSION_KEY_USERNAME = "username";
    public static final String SESSION_KEY_P = "password";
    public static final String SESSION_KEY_APP_USERNAME = "appusername";
    public static final String SESSION_KEY_APP_P = "apppassword";
    public static final String SESSION_KEY_ENGINE_INITED = "mdengineinited";
    public static final String SESSION_KEY_MD_STORER = "metadata_storer";
    public static final String SESSION_KEY_MD_STORER_SERVER = "metadata_store_server";
    public static final String SESSION_KEY_MM_FACADE = "mainmenufacade";
    public static final String SESSION_KEY_BIZ_CTRL = "bizUnitCtrl";
    public static final String COMMAND_KEY_LOGIN = "login";
    public static final String COMMAND_KEY_LIST_BASE_MD = "list_base_metadata";
    public static final String COMMAND_KEY_RETRIEVE_BASE_MD = "retrieve_base_metadata";
    public static final String COMMAND_KEY_LIST_DY_MD = "list_dy_metadata";
    public static final String COMMAND_KEY_RETRIEVE_DY_MD = "retrieve_dy_metadata";
    public static final String COMMAND_KEY_RETRIEVE_APP_INFO = "retrieve_app_info";
    public static final String COMMAND_KEY_QUERY_RELATE_MD = "query_relate_metadata";
    public static final String COMMAND_KEY_QUERY_UPDATEED_MD = "query_updated_metadatas";
    public static final String COMMAND_KEY_QUERY_DY_STSTUS = "query_metadata_status";
    public static final String COMMAND_KEY_STOER_DY = "store_metadata";
    public static final String COMMAND_KEY_CHECKOUT_MD = "checkout_metadatas";
    public static final String COMMAND_KEY_CHECKIN_MD = "checkin_metadatas";
    public static final String COMMAND_KEY_DELETE_MD = "delete_metadata";
    public static final String COMMAND_KEY_DEPLOY_MD = "deploy_metadata";
    public static final String COMMAND_KEY_RETRIEVE_CLT_FILES = "retrieve_client_file";
    public static final String COMMAND_KEY_LIST_CLT_FILES = "list_client_files";
    public static final String COMMAND_KEY_QUERY_TEST_URL = "query_test_url";
    public static final String COMMAND_KEY_RESET_MD5 = "reset_md5";
    public static final String COMMAND_KEY_ADD_APP = "add_application";
    public static final String COMMAND_KEY_DEL_APP = "del_application";
    public static final String COMMAND_KEY_CHECK_LOGIN = "check_login";
    public static final String REQUEST_KEY_COMMAND = "command";
    private static final long serialVersionUID = 1L;
    private String bosComIP = null;
    private String clientRoot = null;
    private static Project DEFAULT_PROJECT = new Project("always_on");
    private static final String MainMenuConfigFile = "FnMenuTree.xml";
    private static Map MD5_MAP = new Hashtable();
    private static Map TS_MAP = new Hashtable();

    public void init(ServletConfig config) throws ServletException {
        String path = config.getServletContext().getRealPath("/");
        System.setProperty("%cloud_app_root%", path);
        this.clientRoot = config.getInitParameter("clientRoot");
        if (StringUtils.isEmpty((String)this.clientRoot)) {
            this.clientRoot = path;
        }
        this.bosComIP = config.getInitParameter("ip.bos.com");
        super.init(config);
    }

    private Connection getConnection(HttpServletRequest request) throws ClassNotFoundException, SQLException {
        return EJBFactory.getConnection((Context)AppManager.getContext(this.getProjectName(request)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueryDyStatus(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] mainPKs = request.getParameter("metadatapks").trim().split(";");
        String sql = "SELECT fMD5, fCheckOutUser, fLastModifyUser, fLastModifyTime, fDeployTime, fCreateTime, fCreator FROM T_BIM_MDVIEW WHERE fPath=?";
        Connection conn = null;
        HashMap<String, Properties> status = new HashMap<String, Properties>();
        try {
            conn = this.getConnection(request);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            for (int i = 0; i < mainPKs.length; ++i) {
                String path = mainPKs[i].trim();
                pstmt.setString(1, path);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    Timestamp time;
                    Properties prop = new Properties();
                    prop.setProperty("md5", rs.getString(1));
                    if (!StringUtils.isEmpty((String)rs.getString(2))) {
                        prop.setProperty("checkoutuser", rs.getString(2));
                    }
                    if (!StringUtils.isEmpty((String)rs.getString(3))) {
                        prop.setProperty("lastmodifyuser", rs.getString(3));
                    }
                    if ((time = rs.getTimestamp(4)) != null) {
                        prop.setProperty("lastmodifytime", String.valueOf(time.getTime()));
                    }
                    if ((time = rs.getTimestamp(5)) != null) {
                        prop.setProperty("deploytime", String.valueOf(time.getTime()));
                    }
                    if ((time = rs.getTimestamp(6)) != null) {
                        prop.setProperty("createtime", String.valueOf(time.getTime()));
                    }
                    if (!StringUtils.isEmpty((String)rs.getString(7))) {
                        prop.setProperty("creator", rs.getString(7));
                    }
                    status.put(path, prop);
                } else {
                    status.put(path, null);
                }
                rs.close();
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(status);
            out.flush();
            ServletOutputStream rOut = response.getOutputStream();
            rOut.write(bout.toByteArray());
            rOut.flush();
            rOut.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendError(response, 601, "get connection error, the track is:" + this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
    }

    private void sendError(HttpServletResponse resp, int code, String msg) throws IOException {
        msg = "<MSG>" + msg + "</MSG>";
        resp.sendError(code, msg);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long ts = System.currentTimeMillis();
        request.setCharacterEncoding("UTF-8");
        try {
            Method method = response.getClass().getMethod("setCharacterEncoding", String.class);
            if (method != null) {
                method.invoke((Object)response, "UTF-8");
            }
        }
        catch (Throwable method) {
            // empty catch block
        }
        String command = request.getParameter(REQUEST_KEY_COMMAND);
        boolean executed = false;
        if (StringUtils.isEmpty((String)command)) {
            this.sendError(response, 401, "command can't be null!");
            executed = true;
        } else if (COMMAND_KEY_CHECK_LOGIN.equals(command)) {
            this.doCheckLogin(request, response);
            executed = true;
        } else if (COMMAND_KEY_ADD_APP.equals(command)) {
            this.doAddApplication(request, response);
            executed = true;
        } else if (COMMAND_KEY_DEL_APP.equals(command)) {
            this.doDelApplication(request, response);
            executed = true;
        } else if (COMMAND_KEY_LOGIN.equals(command)) {
            this.doLogin(request, response);
            executed = true;
        }
        if (executed) {
            logger.info((Object)LogUtil.filterLogForging("execute command [" + command + "] cost [" + (System.currentTimeMillis() - ts) + "]"));
            return;
        }
        if (!this.checkLogin(request, response)) {
            return;
        }
        if (COMMAND_KEY_RETRIEVE_APP_INFO.equals(command)) {
            this.doRetrieveAppInfo(request, response);
            executed = true;
        } else if (COMMAND_KEY_LIST_BASE_MD.equals(command)) {
            this.doListBaseMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_RETRIEVE_BASE_MD.equals(command)) {
            this.doRetrieveBaseMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_LIST_DY_MD.equals(command)) {
            this.doListDynamicMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_RETRIEVE_DY_MD.equals(command)) {
            this.doRetrieveDyMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_QUERY_RELATE_MD.equals(command)) {
            this.doQueryRelationMetas(request, response);
            executed = true;
        } else if (COMMAND_KEY_QUERY_UPDATEED_MD.equals(command)) {
            this.doQueryUpdated(request, response);
            executed = true;
        } else if (COMMAND_KEY_QUERY_DY_STSTUS.equals(command)) {
            this.doQueryDyStatus(request, response);
            executed = true;
        } else if (COMMAND_KEY_STOER_DY.equals(command)) {
            this.doStoreDynamicMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_CHECKOUT_MD.equals(command)) {
            this.doCheckOutDynamicMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_CHECKIN_MD.equals(command)) {
            this.doCheckInDynamicMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_DELETE_MD.equals(command)) {
            this.doDeleteDynamicMD(request, response);
            executed = true;
        } else if (COMMAND_KEY_DEPLOY_MD.equals(command)) {
            this.doDeployMetadata(request, response);
            executed = true;
        } else if (COMMAND_KEY_RETRIEVE_CLT_FILES.equals(command)) {
            this.doRetriveClentFile(request, response);
            executed = true;
        } else if (COMMAND_KEY_LIST_CLT_FILES.equals(command)) {
            this.doListClentFile(request, response);
            executed = true;
        } else if (COMMAND_KEY_QUERY_TEST_URL.equals(command)) {
            this.doQueryTestUrl(request, response);
            executed = true;
        } else if (COMMAND_KEY_RESET_MD5.equals(command)) {
            this.doResetMD5(request, response);
            executed = true;
        }
        if (executed) {
            logger.info((Object)LogUtil.filterLogForging("execute command [" + command + "] cost [" + (System.currentTimeMillis() - ts) + "]"));
            return;
        }
        this.sendError(response, 401, "\u672a\u77e5\u7684\u8bf7\u6c42\u547d\u4ee4:" + command);
    }

    private void doCheckLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean flag = StringUtils.isEmpty((String)this.getUserName(request));
        if (flag) {
            String ip = (String)request.getSession().getAttribute("kick_out");
            if (!StringUtils.isEmpty((String)ip)) {
                this.sendError(response, -10005, ip);
            } else {
                this.sendError(response, -10004, "user hasn't login! please login first");
            }
        } else {
            this.sendError(response, -10004, "user hasn't login! please login first");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStoreDynamicMD(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMDFile file;
        String pk = request.getParameter("metadatapk");
        if (StringUtils.isEmpty((String)pk)) {
            this.sendError(response, 401, "metadatapk can't be empty");
            return;
        }
        AppInfo info = this.getAppInfo(request);
        String md5 = request.getParameter("md5");
        String content = request.getParameter("content");
        String iszipped = request.getParameter("zipped");
        if ("1".equalsIgnoreCase(iszipped)) {
            byte[] contentbytes = Base64.decode((String)content);
            content = StringZipper.unzipStringFromBytes((byte[])contentbytes);
        }
        if (pk.endsWith("Resource.resource") && (file = info.getProject().getRoot().getChildFile(pk)).toFile().exists()) {
            try {
                content = ResourceUtil.getMergedResource(content, file.toFile());
                MD5 md = new MD5();
                md.update(content.getBytes("UTF-8"));
                md5 = md.asHex();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pk.equals(MainMenuConfigFile)) {
            ICloudMainMenuFacade facade = this.getCloudFacade(request);
            Connection conn = null;
            try {
                facade.storeMainMenuInfo(content);
                String updateSql = "UPDATE T_BIM_MDVIEW SET fLastModifyUser=?, fLastModifyTime=? WHERE fPath=? ";
                String userName = this.getUserName(request);
                conn = this.getConnection(request);
                conn.setAutoCommit(true);
                PreparedStatement pstmt = conn.prepareStatement(updateSql);
                pstmt.setString(1, userName);
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, MainMenuConfigFile);
                pstmt.executeUpdate();
                pstmt.close();
                this.close(conn);
            }
            catch (Exception e) {
                try {
                    this.sendError(response, 401, "fail to store metadata:" + this.getTrace(e));
                    this.close(conn);
                    return;
                }
                catch (Throwable throwable) {
                    this.close(conn);
                    throw throwable;
                }
            }
            return;
        }
        String alias = request.getParameter("alias");
        IMDFile file2 = info.getProject().getRoot().getChildFile(pk);
        if (!file2.toFile().exists()) {
            file2.toFile().getParentFile().mkdirs();
            file2.toFile().createNewFile();
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file2.toFile());
            out.write(content.getBytes("UTF-8"));
            out.flush();
        }
        if (pk.endsWith(".log") || pk.endsWith(".permission")) {
            IServerMetadataStore store = this.getServerMetadataStore(request);
            MetaDataPK2 mpk = this.getMetadataPK2(file2);
            try {
                store.saveXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, BOSObjectType.create((String)mpk.getType()), content);
            }
            catch (Exception e) {
                this.sendError(response, 401, "fail to store metadata:" + this.getTrace(e));
                return;
            }
        }
        try {
            this.storeMetadata(request, pk, md5, alias);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendError(response, 601, "get connection error, pk: " + pk + ", alias: " + alias + ", md5:" + md5 + ", the track is:" + this.getTrace(ex));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResetMD5(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String querySql = "SELECT fPath from T_BIM_MDVIEW";
        String updateSql = "Update T_BIM_MDVIEW SET fMD5=? WHERE fPath=?";
        AppInfo info = this.getAppInfo(request);
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            conn.setAutoCommit(true);
            PreparedStatement pstmt = conn.prepareStatement(querySql);
            ArrayList<String> list = new ArrayList<String>();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            rs.close();
            pstmt.close();
            IMDFolder folder = info.getProject().getRoot();
            HashMap<String, String> map = new HashMap<String, String>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String path = (String)list.get(i);
                IMDFile file = folder.getChildFile(path);
                if (!file.toFile().exists()) {
                    map.put(path, "");
                    continue;
                }
                MD5 md5 = new MD5();
                md5.update(PFileUtils.getFileContent((File)file.toFile()).getBytes("UTF-8"));
                map.put(path, md5.asHex());
            }
            pstmt = conn.prepareStatement(updateSql);
            for (String path : map.keySet()) {
                String md5Value = (String)map.get(path);
                pstmt.setString(1, md5Value);
                pstmt.setString(2, path);
                pstmt.executeUpdate();
            }
            pstmt.close();
        }
        catch (Exception ex) {
            this.sendError(response, 401, this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMetadata(HttpServletRequest request, String path, String md5, String alias) throws Exception {
        Connection conn = null;
        String querySql = "SELECT fCheckOutUser FROM T_BIM_MDVIEW WHERE fPath=?";
        String updateSql = "UPDATE T_BIM_MDVIEW SET fMD5=?, fAlias=?, fLastModifyUser=?, fLastModifyTime=? WHERE fPath=? ";
        String insertSql = "INSERT T_BIM_MDVIEW (fProjectName, fPath, fMD5, fAlias, fCreator, fCreateTime) VALUES(?,?,?,?,?,?)";
        String projectName = this.getProjectName(request);
        String userName = this.getUserName(request);
        try {
            conn = this.getConnection(request);
            conn.setAutoCommit(true);
            PreparedStatement pstmt = conn.prepareStatement(querySql);
            pstmt.setString(1, path);
            ResultSet rs = pstmt.executeQuery();
            boolean isInsert = true;
            if (rs.next()) {
                isInsert = false;
                String user = rs.getString(1);
                if (!(StringUtils.isEmpty((String)user) || userName.equals(user) || MainMenuConfigFile.equals(path))) {
                    throw new Exception("metadata [" + path + "] is check out by [" + user + "]");
                }
            }
            if (isInsert) {
                pstmt = conn.prepareStatement(insertSql);
                pstmt.setString(1, projectName);
                pstmt.setString(2, path);
                pstmt.setString(3, md5);
                if (alias != null && alias.length() > 30) {
                    alias = alias.substring(0, 30);
                }
                pstmt.setString(4, alias);
                pstmt.setString(5, userName);
                pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                pstmt.executeUpdate();
                pstmt.close();
            } else {
                pstmt = conn.prepareStatement(updateSql);
                pstmt.setString(1, md5);
                if (alias != null && alias.length() > 30) {
                    alias = alias.substring(0, 30);
                }
                pstmt.setString(2, alias);
                pstmt.setString(3, userName);
                pstmt.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(5, path);
                pstmt.executeUpdate();
                pstmt.close();
            }
        }
        finally {
            this.close(conn);
        }
    }

    private MetaDataPK2 getMetadataPK2(IMDFile file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        return new MetaDataPK2(file.getParent().getPackageName(), name, file.getBOSType().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doListDynamicMD(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DynamicMDBean bean;
        Connection conn = null;
        String sql = "SELECT fPath, fAlias, fMD5, fCheckOutUser, fLastModifyUser, fLastModifyTime, fDeployTime, fCreator, fCreateTime FROM T_BIM_MDVIEW";
        ArrayList<DynamicMDBean> mds = new ArrayList<DynamicMDBean>();
        try {
            conn = this.getConnection(request);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                bean = new DynamicMDBean();
                bean.setPath(rs.getString(1));
                bean.setAlias(rs.getString(2));
                bean.setMd5(rs.getString(3));
                bean.setCheckoutUser(rs.getString(4));
                bean.setLastModifyUser(rs.getString(5));
                Timestamp time = rs.getTimestamp(6);
                if (time != null) {
                    bean.setLastModifyTime(time.getTime());
                }
                if ((time = rs.getTimestamp(7)) != null) {
                    bean.setDeployTime(time.getTime());
                }
                bean.setCreator(rs.getString(8));
                time = rs.getTimestamp(9);
                if (time != null) {
                    bean.setCreateTime(time.getTime());
                }
                mds.add(bean);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendError(response, 601, "get connection error, the track is:" + this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (int i = 0; i < mds.size(); ++i) {
            bean = (DynamicMDBean)mds.get(i);
            Properties prop = new Properties();
            prop.setProperty("md5", bean.getMd5());
            if (!StringUtils.isEmpty((String)bean.getAlias())) {
                prop.setProperty("alias", bean.getAlias());
            }
            if (!StringUtils.isEmpty((String)bean.getCheckoutUser())) {
                prop.setProperty("checkoutuser", bean.getCheckoutUser());
            }
            if (!StringUtils.isEmpty((String)bean.getLastModifyUser())) {
                prop.setProperty("lastmodifyuser", bean.getLastModifyUser());
            }
            prop.setProperty("lastmodifytime", String.valueOf(bean.getLastModifyTime()));
            prop.setProperty("deploytime", String.valueOf(bean.getDeployTime()));
            prop.setProperty("createtime", String.valueOf(bean.getCreateTime()));
            if (!StringUtils.isEmpty((String)bean.getCreator())) {
                prop.setProperty("creator", bean.getCreator());
            }
            map.put(bean.getPath(), prop);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        out.flush();
        ServletOutputStream rOut = response.getOutputStream();
        rOut.write(bout.toByteArray());
        rOut.flush();
        rOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckOutDynamicMD(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] pks = request.getParameter("metadatapks").split(";");
        String sql = "UPDATE T_BIM_MDVIEW SET fCheckOutUser = ?, fCheckOutTime=? WHERE fPath=? AND (fCheckOutUser is null OR fCheckOutUser = ?)";
        String username = this.getUserName(request);
        Connection conn = null;
        boolean flag = true;
        ArrayList<String> faildList = new ArrayList<String>();
        try {
            conn = this.getConnection(request);
            conn.setAutoCommit(false);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, username);
            pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(4, username);
            for (int i = 0; i < pks.length; ++i) {
                String pk = pks[i].trim();
                if (StringUtils.isEmpty((String)pk)) continue;
                pstmt.setString(3, pk);
                int count = pstmt.executeUpdate();
                if (count >= 1) continue;
                flag = false;
                faildList.add(pk);
            }
            pstmt.close();
            if (flag) {
                conn.commit();
            } else {
                StringBuffer querySql = new StringBuffer();
                querySql.append("SELECT fPath, fCheckOutUser FROM T_BIM_MDVIEW WHERE (");
                int n = faildList.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        querySql.append(" OR");
                    }
                    querySql.append(" fPath=?");
                }
                querySql.append(")");
                PreparedStatement stmt = conn.prepareStatement(querySql.toString());
                int n2 = faildList.size();
                for (int i = 0; i < n2; ++i) {
                    stmt.setString(i + 1, faildList.get(i).toString());
                }
                ResultSet rs = stmt.executeQuery();
                StringBuffer sb = new StringBuffer();
                while (rs.next()) {
                    sb.append(rs.getString(1) + ":" + rs.getString(2) + ";");
                }
                if (sb.length() != 0) {
                    conn.rollback();
                    PrintWriter out = response.getWriter();
                    out.println(sb.toString());
                    out.flush();
                } else {
                    conn.commit();
                }
                rs.close();
                stmt.close();
            }
        }
        catch (Exception ex) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            ex.printStackTrace();
            this.sendError(response, 401, "check out metadata fail:" + this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteDynamicMD(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] paths;
        String p = request.getParameter("metadatapks");
        logger.info((Object)LogUtil.filterLogForging(this.getUserName(request) + " request delete metdata :" + p));
        String[] pks = p.split(";");
        if (pks.length > 1) {
            for (int i = 0; i < pks.length; ++i) {
                if (pks[i].endsWith("package") || pks[i].endsWith("resource")) continue;
                this.sendError(response, -10006, "\u65e0\u6cd5\u5220\u9664\u975e\u8d44\u6e90\u548c\u5305\u5143\u6570\u636e");
                return;
            }
        } else if (pks.length == 0 && !pks[0].endsWith("bizunit") && !pks[0].endsWith("biztemplate")) {
            this.sendError(response, -10006, "\u65e0\u6cd5\u5220\u9664\u975e\u8d44\u6e90\u548c\u5305\u5143\u6570\u636e");
            return;
        }
        try {
            paths = this.getRelationMetas(pks, request, 7);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        String sql = "SELECT count(1) FROM T_BIM_MDVIEW WHERE fCreator=? AND (fcheckOutUser is null OR fCheckOutUser=?) AND (";
        String deleteSql = "DELETE FROM T_BIM_MDVIEW WHERE (";
        int count = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (StringUtils.isEmpty((String)paths[i])) continue;
            ++count;
            if (i > 0) {
                sql = sql + " OR";
                deleteSql = deleteSql + " OR";
            }
            sql = sql + " fPath=?";
            deleteSql = deleteSql + " fPath=?";
        }
        sql = sql + ")";
        deleteSql = deleteSql + ")";
        if (count == 0) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            conn.setAutoCommit(true);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, this.getUserName(request));
            stmt.setString(2, this.getUserName(request));
            for (int i = 0; i < paths.length; ++i) {
                stmt.setString(i + 3, paths[i]);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next() && count != rs.getInt(1)) {
                this.sendError(response, -10003, "fail to delete metadata, metadata must not be checken out by others and create by current user!");
                return;
            }
            PreparedStatement stmt1 = conn.prepareStatement(deleteSql);
            for (int i = 0; i < paths.length; ++i) {
                stmt1.setString(i + 1, paths[i]);
            }
            stmt1.executeUpdate();
        }
        catch (Exception ex) {
            this.sendError(response, 401, this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
        AppInfo info = this.getAppInfo(request);
        File deletedMetas = new File(info.getProject().getSrcMetadataDir().getParentFile(), "deleted");
        if (!deletedMetas.exists()) {
            deletedMetas.mkdirs();
        }
        MetaDataPK2[] pks2 = new MetaDataPK2[paths.length];
        IMDFolder root = info.getProject().getRoot();
        FileUtils fu = FileUtils.getFileUtils();
        for (int i = 0; i < paths.length; ++i) {
            IMDFile mdFile = root.getChildFile(paths[i]);
            pks2[i] = this.getMetadataPK2(mdFile);
            File file = mdFile.toFile();
            if (file.exists()) {
                logger.info((Object)LogUtil.filterLogForging("Metadata deleted:" + file.getAbsolutePath() + " by " + this.getUserName(request)));
                fu.copyFile(file, new File(deletedMetas, paths[i]));
                file.delete();
                continue;
            }
            logger.info((Object)LogUtil.filterLogForging("Metadata deleted:" + file.getAbsolutePath() + " but not exists " + this.getUserName(request)));
        }
        try {
            this.getServerMetadataStore(request).deleteMetadata(pks2, DEFAULT_PROJECT.getId());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeployMetadata(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String[] paths;
        String sql = "update T_BIM_MDVIEW SET fDeployUser=?, fDeployTime=? WHERE fPath=?";
        String[] pks = request.getParameter("metadatapks").split(";");
        IServerMetadataStore store = this.getServerMetadataStore(request);
        logger.info((Object)LogUtil.filterLogForging("User:" + this.getUserName(request) + " deploy metadata :" + request.getParameter("metadatapks")));
        try {
            paths = this.getRelationMetas(pks, request, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        IMDFolder root = this.getAppInfo(request).getProject().getRoot();
        ArrayList<MetaDataPK> tables = new ArrayList<MetaDataPK>();
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            conn.setAutoCommit(true);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, this.getUserName(request));
            pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            HashSet<IMDFile> set = new HashSet<IMDFile>();
            int n = paths.length;
            for (int i = 0; i < n; ++i) {
                IMDFile file = root.getChildFile(paths[i]);
                if (file.getExtension().equals("table")) {
                    tables.add(file.getMetaDataPK());
                }
                if (!file.toFile().exists()) continue;
                String xml = PFileUtils.getFileContent((File)file.toFile());
                logger.info((Object)("sotre to db:" + file.getPath()));
                store.saveXml(DEFAULT_PROJECT, (IMetaDataPK)file.getMetaDataPK(), file.getBOSType(), xml);
                pstmt.setString(3, file.getPath());
                pstmt.executeUpdate();
                IMDFolder folder = file.getParent();
                while (!folder.isRoot()) {
                    IMDFile pkFile = folder.getChildFile(folder.getName() + ".package");
                    if (!set.contains(pkFile) && pkFile.toFile().exists()) {
                        set.add(pkFile);
                    }
                    folder = folder.getParent();
                }
            }
            for (IMDFile file : set) {
                logger.info((Object)("sotre to db:" + file.getPath()));
                String xml = PFileUtils.getFileContent((File)file.toFile());
                store.saveXml(DEFAULT_PROJECT, (IMetaDataPK)file.getMetaDataPK(), file.getBOSType(), xml);
                pstmt.setString(3, file.getPath());
                pstmt.executeUpdate();
            }
            pstmt.close();
        }
        catch (Exception ex) {
            this.sendError(response, 401, "store to db error:" + this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
        IMetaDataPK[] tablePKs = tables.toArray(new IMetaDataPK[tables.size()]);
        ICloudMainMenuFacade facade = this.getCloudFacade(request);
        try {
            facade.synchronizeTables(tablePKs);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendError(response, 401, "synchronize db error:" + this.getTrace(e));
            return;
        }
    }

    protected void doListClentFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File root = new File(this.clientRoot);
        String str = CloudAppServlet.listMDFiles(root, new String[]{"bosmodular", "botprules", "download", "meta-inf", "web-inf", "setup.exe"});
        this.write2Client(response, str);
    }

    protected void doQueryTestUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getParameter("path");
        AppInfo info = this.getAppInfo(request);
        String url = null;
        Context ctx = info.getContext();
        String testUrl = info.getTestUrl();
        if (!StringUtils.isEmpty((String)testUrl) && !testUrl.trim().endsWith("/")) {
            testUrl = testUrl.trim() + "/";
        }
        if (StringUtils.isEmpty((String)path)) {
            url = testUrl + "easportal?dcNumber_cloud=" + ctx.getAIS() + "&dcName_cloud=" + ctx.getAIS();
        } else {
            IMDProject proj = info.getProject();
            IMDFile file = proj.getRoot().getChildFile(path);
            if (file.toFile().exists()) {
                MDSimpleObject so = MDORMUtil.getSimpleObject((IMDFile)file);
                String pk = so.getPK("webListUIPK");
                if (!StringUtils.isEmpty((String)pk)) {
                    url = testUrl + "easweb/winlet/list/listUIProxy.jsf?uipk=" + pk;
                } else {
                    pk = so.getPK("webEditUIPK");
                    if (!StringUtils.isEmpty((String)pk)) {
                        url = testUrl + "easweb/winlet/list/editUIProxy.jsf?uipk=" + pk;
                    }
                }
            } else {
                BizUnitInfo md;
                IMetaDataLoader loader = this.getMetaDataLoader(request);
                try {
                    MetaDataPK2 pk2 = this.getMetadataPK2(file);
                    md = (BizUnitInfo)loader.get(MetaDataTypeList.BIZUNIT, (IMetaDataPK)pk2);
                }
                catch (Exception e) {
                    this.sendError(response, 401, this.getTrace(e));
                    return;
                }
                if (md != null) {
                    String pk = md.getWebListUIPK();
                    if (!StringUtils.isEmpty((String)pk)) {
                        url = testUrl + "easweb/winlet/list/listUIProxy.jsf?uipk=" + pk;
                    } else {
                        pk = md.getWebEditUIPK();
                        if (!StringUtils.isEmpty((String)pk)) {
                            url = testUrl + "easweb/winlet/list/editUIProxy.jsf?uipk=" + pk;
                        }
                    }
                }
            }
            url = url + "&dcNumber_cloud=" + ctx.getAIS() + "&dcName_cloud=" + ctx.getAIS();
        }
        if (!StringUtils.isEmpty((String)url)) {
            PrintWriter out = response.getWriter();
            out.print(url);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetriveClentFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File root = new File(this.clientRoot);
        String path = request.getParameter("path");
        if (StringUtils.isEmpty((String)path)) {
            this.sendError(response, 401, "invalid file path: [" + path + "]");
            return;
        }
        File file = new File(root, path.trim());
        ServletOutputStream out = null;
        FileInputStream in = null;
        try {
            out = response.getOutputStream();
            in = new FileInputStream(file);
            byte[] bs = new byte[5120];
            int len = in.read(bs);
            while (len != -1) {
                out.write(bs, 0, len);
                len = in.read(bs);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.sendError(response, 402, "fail to close FileInputStream:" + this.getTrace(e));
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.sendError(response, 402, "fail to close FileInputStream:" + this.getTrace(e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckInDynamicMD(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ArrayList<String> faildList;
        Connection conn;
        block10: {
            String[] pks = StringUtils.split((String)request.getParameter("metadatapks"), (String)";");
            String sql = "UPDATE T_BIM_MDVIEW SET fCheckOutUser = null WHERE fPath=? AND (fCheckOutUser = ?  OR fCheckOutUser is null)";
            String username = this.getUserName(request);
            conn = null;
            if (pks.length != 1 || !MainMenuConfigFile.equals(pks[0])) {
                pks = this.getRelationMetas(pks, request, 0);
            }
            faildList = new ArrayList<String>();
            conn = this.getConnection(request);
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(2, username);
            for (int i = 0; i < pks.length; ++i) {
                String pk = pks[i].trim();
                if (StringUtils.isEmpty((String)pk)) continue;
                pstmt.setString(1, pk);
                int count = pstmt.executeUpdate();
                if (count >= 1) continue;
                faildList.add(pk);
            }
            pstmt.close();
            if (!faildList.isEmpty()) break block10;
            this.close(conn);
            return;
        }
        try {
            String selectSql = "SELECT fPath, fCheckOutUser FROM T_BIM_MDVIEW WHERE (";
            for (int i = 0; i < faildList.size(); ++i) {
                if (i > 0) {
                    selectSql = selectSql + " OR ";
                }
                selectSql = selectSql + "fPath ='" + faildList.get(i) + "'";
            }
            selectSql = selectSql + ")";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectSql);
            PrintWriter out = response.getWriter();
            while (rs.next()) {
                out.println(rs.getString(1) + ":" + rs.getString(2));
            }
            out.flush();
            out.close();
            rs.close();
            this.close(conn);
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                this.sendError(response, 401, "check out metadata fail:" + this.getTrace(ex));
                this.close(conn);
                return;
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    private void doQueryRelationMetas(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] pks;
        String mainPK = request.getParameter("metadatapk");
        try {
            pks = this.getRelationMetas(new String[]{mainPK}, request, 0);
        }
        catch (Exception e) {
            this.sendError(response, 401, this.getTrace(e));
            return;
        }
        PrintWriter out = response.getWriter();
        for (int i = 0; i < pks.length; ++i) {
            out.println(pks[i]);
        }
        out.flush();
    }

    private AppInfo getAppInfo(HttpServletRequest request) {
        return AppManager.getAppInfo(this.getProjectName(request));
    }

    private String[] getRelationMetas(String[] paths, HttpServletRequest request, int flag) throws Exception {
        IMDFolder root = this.getAppInfo(request).getProject().getRoot();
        ArrayList list = new ArrayList();
        ArrayList<IMDFile> noExistsList = new ArrayList<IMDFile>();
        for (int i = 0; i < paths.length; ++i) {
            IMDFile file = root.getChildFile(paths[i]);
            if (!file.toFile().exists()) {
                noExistsList.add(file);
                continue;
            }
            BizMetadataUtil.getBizRelateMetas((IMDFile)file, list, (int)flag);
        }
        ArrayList<String> result = new ArrayList<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            result.add(((IMDFile)list.get(i)).getPath());
        }
        if (!noExistsList.isEmpty()) {
            IServerMetadataStore store = this.getServerMetadataStore(request);
            String projectname = this.getProjectName(request);
            int n2 = noExistsList.size();
            for (int i = 0; i < n2; ++i) {
                IMDFile file = (IMDFile)noExistsList.get(i);
                logger.debug((Object)("File not exists in disk:" + file + " project:" + projectname));
                List temp = store.getAssociatedMDPKs(this.getMetadataPK2(file));
                for (MetaDataPK2 pk : temp) {
                    String path = pk.getPath2();
                    if (result.contains(path)) continue;
                    result.add(path);
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueryUpdated(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pks = request.getParameter("metadatapks");
        if (StringUtils.isEmpty((String)pks)) {
            this.sendError(response, 401, "must set metadatapks parameter");
            return;
        }
        String[] pkList = pks.split(";");
        boolean hasMenu = false;
        for (int i = 0; i < pkList.length; ++i) {
            if (!MainMenuConfigFile.equals(pkList[i])) continue;
            hasMenu = true;
            break;
        }
        try {
            pkList = this.getRelationMetas(pkList, request, 12);
        }
        catch (Exception e) {
            this.sendError(response, 401, this.getTrace(e));
            return;
        }
        if (pkList.length == 0) {
            if (hasMenu) {
                pkList = new String[]{MainMenuConfigFile};
            } else {
                return;
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fPath, fMD5 FROM T_BIM_MDVIEW WHERE (");
        for (int i = 0; i < pkList.length; ++i) {
            if (i > 0) {
                sql.append(" OR ");
            }
            sql.append("fPath = '" + pkList[i] + "'");
        }
        sql.append(")");
        Connection conn = null;
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> md5s = new ArrayList<String>();
        try {
            conn = this.getConnection(request);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                paths.add(rs.getString(1));
                md5s.add(rs.getString(2));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sendError(response, 401, this.getTrace(ex));
            return;
        }
        finally {
            this.close(conn);
        }
        PrintWriter writer = response.getWriter();
        int n = paths.size();
        for (int i = 0; i < n; ++i) {
            String path = (String)paths.get(i);
            writer.println(path + ":" + md5s.get(i));
        }
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetrieveDyMD(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String pk = request.getParameter("metadatapk");
        AppInfo info = this.getAppInfo(request);
        if (pk.equals(MainMenuConfigFile)) {
            ICloudMainMenuFacade facade = this.getCloudFacade(request);
            Connection conn = null;
            String querySql = "SELECT fMD5 FROM T_BIM_MDVIEW WHERE fPath='FnMenuTree.xml'";
            try {
                String insertSql;
                conn = this.getConnection(request);
                conn.setAutoCommit(true);
                PreparedStatement pstmt = conn.prepareStatement(querySql);
                ResultSet rs = pstmt.executeQuery();
                String oldMd5 = null;
                boolean exists = false;
                if (rs.next()) {
                    exists = true;
                    oldMd5 = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                String xml = facade.loadMainMenuInfo();
                MD5 md5 = new MD5();
                md5.update(xml.getBytes("UTF-8"));
                String newMd5 = md5.asHex();
                if (!exists) {
                    insertSql = "INSERT T_BIM_MDVIEW (fProjectName, fPath, fMD5, fAlias, fCreator, fCreateTime, fLastModifyTime) VALUES(?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(insertSql);
                    pstmt.setString(1, this.getProjectName(request));
                    pstmt.setString(2, MainMenuConfigFile);
                    pstmt.setString(3, newMd5);
                    pstmt.setString(4, "mainMenu");
                    pstmt.setString(5, "sys_default");
                    pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                    pstmt.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                    pstmt.executeUpdate();
                } else if (!newMd5.equals(oldMd5)) {
                    insertSql = "UPDATE T_BIM_MDVIEW SET fMD5 = ?, fLastModifyTime=? WHERE fPath=?";
                    pstmt = conn.prepareStatement(insertSql);
                    pstmt.setString(1, newMd5);
                    pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(3, MainMenuConfigFile);
                    pstmt.executeUpdate();
                }
                File file = info.getProject().getRoot().getChildFile(MainMenuConfigFile).toFile();
                PFileUtils.write2File((String)xml, (File)file);
                ServletOutputStream out = response.getOutputStream();
                out.write(xml.getBytes("UTF-8"));
                out.flush();
            }
            catch (Exception e) {
                this.sendError(response, 402, "fail to retrieve medata:" + this.getTrace(e));
                return;
            }
            finally {
                this.close(conn);
            }
        }
        byte[] bscontent = null;
        IMDFile file = info.getProject().getRoot().getChildFile(pk);
        if (file.toFile().exists()) {
            bscontent = file.toBytes();
        } else {
            String xml;
            IMetadataStore store = this.getMetadataStore(request);
            MetaDataPK2 mpk = this.getMetadataPK2(file);
            try {
                BOSObjectType type = BOSObjectType.create((String)mpk.getType());
                xml = store.getXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, type);
                if (StringUtils.isEmpty((String)xml) && MetaDataTypeList.ABSTRACTTABLE.equals((Object)type)) {
                    xml = store.getXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, MetaDataTypeList.DATATABLE);
                    if (StringUtils.isEmpty((String)xml)) {
                        xml = store.getXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, MetaDataTypeList.CROSSTABLE);
                    }
                    if (StringUtils.isEmpty((String)xml)) {
                        xml = store.getXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, MetaDataTypeList.EXTENDEDTABLE);
                    }
                } else if (StringUtils.isEmpty((String)xml) && MetaDataTypeList.BASEQUERY.equals((Object)type) && StringUtils.isEmpty((String)(xml = store.getXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, MetaDataTypeList.JOINQUERY)))) {
                    xml = store.getXml(DEFAULT_PROJECT, (IMetaDataPK)mpk, MetaDataTypeList.UNIONQUERY);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException((Throwable)ex);
            }
            if (!StringUtils.isEmpty((String)xml)) {
                bscontent = xml.getBytes("UTF-8");
            }
        }
        if (bscontent == null) {
            this.sendError(response, -10007, pk);
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        byte[] contentbytes = StringZipper.gzipToBytes((byte[])bscontent);
        response.addHeader("zipped", "1");
        out.write(contentbytes);
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetrieveBaseMD(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AppInfo info = this.getAppInfo(request);
        File metadatadir = info.getProject().getBaseMetadataDir();
        String path = request.getParameter("path");
        if (StringUtils.isEmpty((String)path)) {
            this.sendError(response, 401, "invalid file path: [" + path + "]");
            return;
        }
        File file = new File(metadatadir, path.trim());
        ServletOutputStream out = null;
        FileInputStream in = null;
        try {
            out = response.getOutputStream();
            in = new FileInputStream(file);
            byte[] bs = new byte[5120];
            int len = in.read(bs);
            while (len != -1) {
                out.write(bs, 0, len);
                len = in.read(bs);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.sendError(response, 402, "fail to close FileInputStream:" + this.getTrace(e));
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.sendError(response, 402, "fail to close FileInputStream:" + this.getTrace(e));
                }
            }
        }
    }

    protected void doListBaseMD(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File root = this.getAppInfo(request).getProject().getBaseMetadataDir();
        String str = CloudAppServlet.listMDFiles(root, null);
        this.write2Client(response, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String listMDFiles(File root, String[] excludeSubs) throws IOException {
        int len = root.getAbsolutePath().length();
        File[] files = PFileUtils.listFile((File)root, (boolean)true, (boolean)true, (boolean)false);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getAbsolutePath().substring(len);
            path = StringUtils.replace((String)path, (String)"\\", (String)"/");
            boolean isExclude = false;
            if (excludeSubs != null) {
                String p = path.toLowerCase(Locale.ENGLISH);
                if (p.startsWith("/")) {
                    p = p.substring(1);
                }
                for (int j = 0; j < excludeSubs.length; ++j) {
                    if (!p.startsWith(excludeSubs[j])) continue;
                    isExclude = true;
                    break;
                }
            }
            if (isExclude) continue;
            Map map = MD5_MAP;
            synchronized (map) {
                Long ts;
                String md5 = (String)MD5_MAP.get(path);
                if (md5 != null && ((ts = (Long)TS_MAP.get(path)) == null || ts.longValue() != files[i].lastModified())) {
                    md5 = null;
                }
                if (md5 == null) {
                    md5 = MD5.asHex((byte[])MD5.getHash((File)files[i]));
                    MD5_MAP.put(path, md5);
                    TS_MAP.put(path, new Long(files[i].lastModified()));
                }
                sb.append(path + "=" + md5 + "\n");
                continue;
            }
        }
        return sb.toString();
    }

    private void write2Client(HttpServletResponse response, String str) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        out.print(str);
        out.flush();
        out.close();
    }

    private void doAddApplication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!StringUtils.isEmpty((String)this.bosComIP) && this.bosComIP.equals(request.getRemoteAddr())) {
            this.sendError(response, 401, "Must request from bos.com!");
            return;
        }
        AppManager.init();
        String ip = AppManager.getLocleAddress().getHostAddress();
        String projectName = request.getParameter("name");
        String rpcPort = request.getParameter("rpcPort");
        String httpPort = request.getParameter("httpPort");
        String ais = request.getParameter("ais");
        AppInfo info = new AppInfo();
        Context ctx = new Context();
        ctx.setAIS(ais);
        ctx.setSolution("eas");
        ctx.setLocale(new Locale("zh_CN"));
        info.setContext(ctx);
        String appPath = System.getProperty("%cloud_app_root%");
        File baseRoot = new File(StringUtils.replace((String)AppManager.defaultBaseMetaRoot, (String)"%cloud_app_root%", (String)appPath));
        File projectRoot = new File(StringUtils.replace((String)AppManager.defaultProjectRoot, (String)"%cloud_app_root%", (String)appPath));
        projectRoot = new File(projectRoot, projectName);
        MDProject project = new MDProject(projectRoot, projectName, baseRoot, new File(projectRoot, "metadata"));
        info.setProject((IMDProject)project);
        info.setOrmrpcUrl("tcp://" + ip + ":" + rpcPort);
        info.setTestUrl("http://" + ip + ":" + httpPort);
        info.setSave2Disk(true);
        AppManager.add(projectName, info);
    }

    private void doDelApplication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!StringUtils.isEmpty((String)this.bosComIP) && this.bosComIP.equals(request.getRemoteAddr())) {
            this.sendError(response, 401, "Must request from bos.com!");
            return;
        }
        String projectName = request.getParameter("name");
        AppManager.remove(projectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String key;
        String password;
        String projectName = request.getParameter(SESSION_KEY_PROJECTNAME);
        String username = request.getParameter(SESSION_KEY_USERNAME);
        if (!UserManager.checkUser(username, password = request.getParameter(SESSION_KEY_P))) {
            this.sendError(response, -10001, "wrong username & password");
            return;
        }
        HttpSession session = request.getSession();
        ServletContext context = request.getSession().getServletContext();
        HttpSession otherSession = (HttpSession)context.getAttribute(key = projectName + ":" + username);
        if (otherSession != null) {
            try {
                this.clearSession(otherSession);
                otherSession.setAttribute("kick_out", (Object)(request.getRemoteHost() + ":" + request.getRemoteAddr()));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.clearSession(session);
        if (!AppManager.checkValid(projectName, username)) {
            this.sendError(response, -10002, "current user [" + username + "] hasn't right for project [" + projectName + "]");
            return;
        }
        session.setAttribute(SESSION_KEY_PROJECTNAME, (Object)projectName);
        session.setAttribute(SESSION_KEY_USERNAME, (Object)username);
        session.setAttribute(SESSION_KEY_P, (Object)password);
        session.setMaxInactiveInterval(-1);
        context.setAttribute(key, (Object)session);
        Connection conn = null;
        String querySql = "SELECT COUNT(1) FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_BIM_MDVIEW'";
        String createTable = "CREATE TABLE T_BIM_MDVIEW (fProjectName varchar(255), fPath varchar(255), fMD5 varchar(40), fAlias varchar(255), fCheckOutUser varchar(255), fCheckOutTime DateTime,fCreator varchar(255), fCreateTime DateTime,fLastModifyUser varchar(255),fLastModifyTime DateTime,fDeployUser VARCHAR(255),fDeployTime DateTime,CONSTRAINT PK_BIM_MDVIEW primary key (fProjectName, fPath)); ";
        try {
            conn = this.getConnection(request);
            PreparedStatement pstmt = conn.prepareStatement(querySql);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            if (rs.getInt(1) < 1) {
                rs.close();
                pstmt.close();
                pstmt = conn.prepareStatement(createTable);
                pstmt.execute();
                pstmt.close();
            } else {
                rs.close();
                pstmt.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.close(conn);
        }
    }

    private void clearSession(HttpSession session) {
        try {
            session.removeAttribute(SESSION_KEY_PROJECTNAME);
            session.removeAttribute(SESSION_KEY_USERNAME);
            session.removeAttribute(SESSION_KEY_P);
            session.removeAttribute(SESSION_KEY_APP_USERNAME);
            session.removeAttribute(SESSION_KEY_APP_P);
            session.removeAttribute(SESSION_KEY_RPC_SESS_ID);
            session.removeAttribute(SESSION_KEY_MD_LOADER);
            session.removeAttribute(SESSION_KEY_ENGINE_INITED);
            session.removeAttribute(SESSION_KEY_MD_STORER);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private IMetadataStore getMetadataStore(HttpServletRequest request) throws IOException {
        Context ctx = this.getAppInfo(request).getContext();
        ConfigMDUtil.setContextToThread((Context)ctx);
        return MetadataStoreFactory.getMetadataStore((Context)ctx);
    }

    private IServerMetadataStore getServerMetadataStore(HttpServletRequest request) throws IOException {
        Context ctx = this.getAppInfo(request).getContext();
        ConfigMDUtil.setContextToThread((Context)ctx);
        return MetadataStoreFactory.getServerMetadataStore((Context)ctx);
    }

    private IMetaDataLoader getMetaDataLoader(HttpServletRequest request) throws IOException {
        Context ctx = this.getAppInfo(request).getContext();
        ConfigMDUtil.setContextToThread((Context)ctx);
        return MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
    }

    private ICloudMainMenuFacade getCloudFacade(HttpServletRequest request) throws IOException, ServletException {
        Context ctx = this.getAppInfo(request).getContext();
        if ("zh_CN".equalsIgnoreCase(ctx.getLocale().getLanguage())) {
            ctx.setLocale(new Locale("l2"));
        }
        try {
            ConfigMDUtil.setContextToThread((Context)ctx);
            return CloudMainMenuFacadeFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    private String getTrace(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        PrintStream print = new PrintStream(out);
        ex.printStackTrace(print);
        return new String(out.toByteArray());
    }

    private void doRetrieveAppInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AppInfo info = this.getAppInfo(request);
        Context context = info.getContext();
        PrintWriter writer = response.getWriter();
        writer.println("ormrpcUrl=" + info.getOrmrpcUrl());
        writer.println("testUrl=" + info.getTestUrl());
        writer.println("solution=" + context.getSolution());
        writer.println("ais=" + context.getAIS());
        writer.println("locale=" + context.getLocale().getLanguage());
        writer.flush();
    }

    private String getUserName(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(SESSION_KEY_USERNAME);
    }

    private String getProjectName(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(SESSION_KEY_PROJECTNAME);
    }

    private boolean checkLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean flag = StringUtils.isEmpty((String)this.getUserName(request));
        if (flag) {
            String ip = (String)request.getSession().getAttribute("kick_out");
            if (!StringUtils.isEmpty((String)ip)) {
                this.sendError(response, -10005, "<IP>" + ip + "</IP>");
            } else {
                this.sendError(response, -10004, "user hasn't login! please login first");
            }
            return false;
        }
        return true;
    }
}

