/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cdo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.cdo.AbstractBOSDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommonDataObject
extends AbstractBOSDataObject
implements ICommonDataObject {
    private Map properties = new HashMap();

    @Override
    public Object get(Object property) {
        return this.properties.get(property);
    }

    @Override
    public void put(Object property, Object value) {
        this.properties.put(property, value);
    }

    public String getString(Object property) throws BOSException {
        return (String)this.get(property);
    }

    public int getInt(Object property) throws BOSException {
        Object o = this.get(property);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(property);
    }

    public double getDouble(Object property) throws BOSException {
        Object o = this.get(property);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new BOSException("CDO[" + property + "] is not a number.");
        }
    }

    public boolean getBoolean(Object property) throws BOSException {
        Object o = this.get(property);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new BOSException("CDO[" + property + "] is not a Boolean.");
    }

    public List getList(Object property) throws BOSException {
        return (List)this.get(property);
    }

    @Override
    public Set keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean containKey(Object key) {
        return this.properties.containsKey(key);
    }

    public void remove(Object key) {
        this.properties.remove(key);
    }

    public Object clone() {
        CommonDataObject newObj = new CommonDataObject();
        newObj.setBosType(this.getBosType());
        newObj.properties = (Map)((HashMap)this.properties).clone();
        return newObj;
    }
}

