/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cdo.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.CommonEnumObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.ICommonEnumObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class CDOUtils {
    public static final IBizCtrl getBizInterface(Context ctx, String bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(bosType));
        if (entityObjectInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(entityObjectInfo.getFullName()));
        }
        String clzFactoryName = entityObjectInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = CDOUtils.getBizInterface(ctx, clzFactory, ctx);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static final IBizCtrl getBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        if (entityObjectInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(entityObjectInfo.getFullName()));
        }
        String clzFactoryName = entityObjectInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = CDOUtils.getBizInterface(ctx, clzFactory, ctx);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static final Class getBizObjectValueClass(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        String clzObjectValueName = entityObjectInfo.getObjectValueClass();
        Class<?> clzObjectValue = null;
        try {
            clzObjectValue = Class.forName(clzObjectValueName);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("can't find " + clzObjectValueName);
        }
        return clzObjectValue;
    }

    public static final IBizCtrl getBizInterface(Context ctx, Class clzFactory, Context mainOrgCtx) throws BOSException {
        boolean isLocal = ctx != null;
        IBizCtrl iBiz = null;
        try {
            if (isLocal) {
                Class[] parameterTypes = new Class[]{Context.class};
                Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            } else {
                iBiz = CDOUtils.getRemoteBizInterface(clzFactory, mainOrgCtx);
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return iBiz;
    }

    public static final IBizCtrl getRemoteBizInterface(Class clzFactory, Context mainOrgCtx) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        IBizCtrl iBiz;
        if (mainOrgCtx != null) {
            Method mGetInstance = clzFactory.getMethod("getRemoteInstanceWithObjectContext", Context.class);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, mainOrgCtx);
        } else {
            Method mGetInstance = clzFactory.getMethod("getRemoteInstance", null);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, null);
        }
        return iBiz;
    }

    public static final ICommonDataObject convertObjectInfoToCDO(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        if (objectValue == null) {
            return null;
        }
        CommonDataObject dataObject = new CommonDataObject();
        dataObject.setBosType(objectValue.getBOSType().toString());
        Enumeration keys = objectValue.keys();
        while (keys.hasMoreElements()) {
            CommonEnumObject enumObject;
            String propertyKey = (String)keys.nextElement();
            Object value = null;
            if (propertyKey == null || propertyKey.endsWith("_l1") || propertyKey.endsWith("_l2") || propertyKey.endsWith("_l3")) {
                // empty if block
            }
            if (objectValue.get(propertyKey) instanceof IObjectValue) {
                value = CDOUtils.convertObjectInfoToCDO(ctx, objectValue.getObjectValue(propertyKey));
            } else if (objectValue.get(propertyKey) instanceof IObjectCollection) {
                IObjectCollection valueCollection = (IObjectCollection)objectValue.get(propertyKey);
                ArrayList<ICommonDataObject> valueList = new ArrayList<ICommonDataObject>();
                for (int nIndex = 0; nIndex < valueCollection.size(); ++nIndex) {
                    valueList.add(CDOUtils.convertObjectInfoToCDO(ctx, valueCollection.getObject(nIndex)));
                }
                value = valueList;
            } else if (objectValue.get(propertyKey) instanceof BOSUuid) {
                value = objectValue.get(propertyKey).toString();
            } else if (objectValue.get(propertyKey) instanceof StringEnum) {
                StringEnum stringEnum = (StringEnum)objectValue.get(propertyKey);
                enumObject = new CommonEnumObject();
                enumObject.setEnumType(stringEnum.getClass().getName());
                value = stringEnum.getValue();
            } else if (objectValue.get(propertyKey) instanceof IntEnum) {
                IntEnum intEnum = (IntEnum)objectValue.get(propertyKey);
                enumObject = new CommonEnumObject();
                enumObject.setEnumType(intEnum.getClass().getName());
                enumObject.setKey(intEnum.getName());
                enumObject.setValue(intEnum.getValue());
                value = enumObject;
            } else if (objectValue.get(propertyKey) instanceof FloatEnum) {
                FloatEnum floatEnum = (FloatEnum)objectValue.get(propertyKey);
                enumObject = new CommonEnumObject();
                enumObject.setEnumType(floatEnum.getClass().getName());
                enumObject.setKey(floatEnum.getName());
                enumObject.setValue(Float.valueOf(floatEnum.getValue()));
                value = Float.valueOf(floatEnum.getValue());
            } else if (objectValue.get(propertyKey) instanceof DoubleEnum) {
                DoubleEnum doubleEnum = (DoubleEnum)objectValue.get(propertyKey);
                enumObject = new CommonEnumObject();
                enumObject.setEnumType(doubleEnum.getClass().getName());
                enumObject.setKey(doubleEnum.getName());
                enumObject.setValue(doubleEnum.getValue());
                value = doubleEnum.getValue();
            } else {
                value = objectValue.get(propertyKey);
            }
            String realKey = CDOUtils.getRealByEntity(ctx, objectValue, propertyKey);
            if (realKey != null) {
                propertyKey = realKey;
            }
            dataObject.put(propertyKey, value);
        }
        return dataObject;
    }

    public static final IObjectValue convertCDOToObjectInfo(Context ctx, ICommonDataObject dataObject) throws BOSException, EASBizException {
        String bosType = dataObject.getBosType();
        Class clzObjectValue = CDOUtils.getBizObjectValueClass(ctx, BOSObjectType.create((String)bosType));
        IObjectValue objectValue = null;
        try {
            objectValue = (IObjectValue)clzObjectValue.newInstance();
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        Object[] keys = dataObject.keySet().toArray();
        for (int nIndex = 0; nIndex < keys.length; ++nIndex) {
            String key = (String)keys[nIndex];
            IObjectValue value = null;
            if (dataObject.get(key) instanceof ICommonDataObject) {
                value = CDOUtils.convertCDOToObjectInfo(ctx, (ICommonDataObject)dataObject.get(key));
                objectValue.put(key, (Object)value);
                continue;
            }
            if (dataObject.get(key) instanceof List) {
                IObjectCollection valueCollection = (IObjectCollection)objectValue.get(key);
                List valueList = (List)dataObject.get(key);
                for (int vIndex = 0; vIndex < valueList.size(); ++vIndex) {
                    valueCollection.addObject(CDOUtils.convertCDOToObjectInfo(ctx, (CommonDataObject)valueList.get(vIndex)));
                }
                continue;
            }
            if (dataObject.get(key) instanceof ICommonEnumObject) {
                ICommonEnumObject enumObject = (ICommonEnumObject)dataObject.get(key);
                objectValue.put(key, ((ICommonEnumObject)dataObject.get(key)).getValue());
                continue;
            }
            objectValue.put(key, dataObject.get(key));
        }
        return objectValue;
    }

    public static ICommonEnumObject getEnum(String strEnumType, String name) throws BOSException {
        try {
            Class<?> enumClass = Class.forName(strEnumType);
            Enum enumObject = EnumUtils.getEnum(enumClass, (String)name);
            CommonEnumObject commonEnumObject = new CommonEnumObject();
            commonEnumObject.setEnumType(strEnumType);
            commonEnumObject.setKey(enumObject.getName());
            if (enumObject instanceof IntEnum) {
                commonEnumObject.setValue(((IntEnum)enumObject).getValue());
            } else if (enumObject instanceof StringEnum) {
                commonEnumObject.setValue(((StringEnum)enumObject).getValue());
            } else if (enumObject instanceof FloatEnum) {
                commonEnumObject.setValue(Float.valueOf(((FloatEnum)enumObject).getValue()));
            } else if (enumObject instanceof DoubleEnum) {
                commonEnumObject.setValue(((DoubleEnum)enumObject).getValue());
            }
            return commonEnumObject;
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
    }

    public static Enum getRealEnumValue(String strEnumType, ICommonEnumObject value) throws BOSException {
        try {
            Class<?> enumType = Class.forName(strEnumType);
            Method method = null;
            if (StringEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", String.class);
            } else if (IntEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Integer.TYPE);
            } else if (FloatEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Float.TYPE);
            } else if (DoubleEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Double.TYPE);
            }
            if (method != null) {
                return (Enum)method.invoke(enumType, value.getValue());
            }
            return null;
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
    }

    public static Enum getEnumValue(String strEnumType, Object value) throws BOSException {
        try {
            Class<?> enumType = Class.forName(strEnumType);
            Method method = null;
            if (StringEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", String.class);
            } else if (IntEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Integer.TYPE);
            } else if (FloatEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Float.TYPE);
            } else if (DoubleEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Double.TYPE);
            }
            if (method != null) {
                return (Enum)method.invoke(enumType, value);
            }
            return null;
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
    }

    public static Enum getEnumValue(String strEnumType, int value) throws BOSException {
        try {
            Class<?> enumType = Class.forName(strEnumType);
            Method method = null;
            if (StringEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", String.class);
            } else if (IntEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Integer.TYPE);
            } else if (FloatEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Float.TYPE);
            } else if (DoubleEnum.class.isAssignableFrom(enumType)) {
                method = enumType.getMethod("getEnum", Double.TYPE);
            }
            if (method != null) {
                return (Enum)method.invoke(enumType, value);
            }
            return null;
        }
        catch (Exception exception) {
            throw new BOSException((Throwable)exception);
        }
    }

    public static CommonDataObject createDataObject(Context context, String entityName) throws BOSException, EASBizException {
        EntityObjectInfo entityObjectInfo = CDOUtils.getEntity(context, entityName);
        if (entityObjectInfo == null) {
            throw new BOSException("Can't find [" + entityName + "]!");
        }
        String objectValueClassName = entityObjectInfo.getObjectValueClass();
        Class<?> objectValueClass = null;
        IObjectValue objectValue = null;
        try {
            objectValueClass = Class.forName(objectValueClassName);
            objectValue = (IObjectValue)objectValueClass.newInstance();
            objectValue.put("id", (Object)BOSUuid.create((BOSObjectType)objectValue.getBOSType()));
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        CommonDataObject dataObject = (CommonDataObject)CDOUtils.convertObjectInfoToCDO(context, objectValue);
        return dataObject;
    }

    private static EntityObjectInfo getEntity(Context ctx, String entityName) {
        Project depend = null;
        if (SysContext.getSysContext().getProperty((Object)"DTKF_DEPEND") != null) {
            depend = (Project)SysContext.getSysContext().getProperty((Object)"DTKF_DEPEND");
        }
        MetaDataPK entityPK = MetaDataPK.create((String)entityName);
        IMetaDataLoader loader = CDOUtils.getMDloader(ctx);
        if (depend == null) {
            return (EntityObjectInfo)loader.get(MetaDataTypeList.ENTITY, (IMetaDataPK)entityPK, Project.Projects.getProjects((Project[])new Project[0]));
        }
        return (EntityObjectInfo)loader.get(MetaDataTypeList.ENTITY, (IMetaDataPK)entityPK, Project.Projects.getProjects((Project[])new Project[]{depend}));
    }

    private static IMetaDataLoader getMDloader(Context context) {
        IMetaDataLoader loader = null;
        loader = context == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)context);
        return loader;
    }

    private static String getRealByEntity(Context context, IObjectValue objectValue, String property) {
        try {
            EntitySelect select = new EntitySelect(objectValue.getBOSType());
            select.propertySelect().select(new String[]{"*"}, new String[]{"dataType"});
            SimpleEntity entity = context != null ? MetaDataAccessFactory.getLocalInstance((Context)context).select(select) : MetaDataAccessFactory.getRemoteInstance().select(select);
            SimplePropertyCollection propertyCollection = entity.properties();
            for (int nIndex = 0; nIndex < propertyCollection.size(); ++nIndex) {
                SimpleProperty propertyObject = propertyCollection.get(nIndex);
                if (!propertyObject.getName().equalsIgnoreCase(property)) continue;
                return propertyObject.getName();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

