/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.cdo.CommonEnumObject;
import java.lang.reflect.Type;

public class CommonEnumObjectTypeAdapter
implements JsonSerializer<CommonEnumObject>,
JsonDeserializer<CommonEnumObject> {
    public static final String WAF_ENUM_VALUE_KEY = "isenum";

    public JsonElement serialize(CommonEnumObject object, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(WAF_ENUM_VALUE_KEY, Boolean.valueOf(true));
        String strAlias = null;
        jsonObject.addProperty("type", object.getEnumType());
        strAlias = object.getKey().toString();
        jsonObject.addProperty("alias", strAlias);
        String value = object.getValue().toString();
        if (this.isNumberValue(value.toString())) {
            jsonObject.addProperty("value", (Number)Double.parseDouble(value.toString()));
        } else {
            jsonObject.addProperty("value", value.toString());
        }
        return jsonObject;
    }

    private boolean isNumberValue(String value) {
        boolean blnResult = true;
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return blnResult;
    }

    public CommonEnumObject deserialize(JsonElement paramJsonElement, Type paramType, JsonDeserializationContext paramJsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = paramJsonElement.getAsJsonObject();
        CommonEnumObject commonEnumObject = new CommonEnumObject();
        if (jsonObject.get("type") != null) {
            commonEnumObject.setEnumType(jsonObject.get("type").toString());
        }
        if (jsonObject.get("alias") != null) {
            commonEnumObject.setKey(jsonObject.get("alias").toString());
        }
        if (jsonObject.get("value") != null) {
            try {
                commonEnumObject.setKey(jsonObject.get("value").getAsString());
            }
            catch (Exception e) {
                try {
                    commonEnumObject.setKey(jsonObject.get("value").getAsInt());
                }
                catch (Exception e2) {
                    try {
                        commonEnumObject.setKey(jsonObject.get("value").getAsDouble());
                    }
                    catch (Exception e3) {
                        commonEnumObject.setKey(Float.valueOf(jsonObject.get("value").getAsFloat()));
                    }
                }
            }
        }
        return null;
    }
}

