/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp;

public class Address {
    private final String _host;
    private final int _port;

    public Address(String host, int port) {
        this._host = host;
        this._port = port;
    }

    public Address(String host) {
        this._host = host;
        this._port = -1;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public static Address parseAddress(String addressString) {
        int idx = addressString.indexOf(58);
        return idx == -1 ? new Address(addressString) : new Address(addressString.substring(0, idx), Integer.parseInt(addressString.substring(idx + 1)));
    }

    public static Address[] parseAddresses(String addresses) {
        String[] addrs = addresses.split(" *, *");
        Address[] res = new Address[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            res[i] = Address.parseAddress(addrs[i]);
        }
        return res;
    }

    public int hashCode() {
        return 31 * this._host.hashCode() + this._port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address addr = (Address)obj;
        return this._host.equals(addr._host) && this._port == addr._port;
    }

    public String toString() {
        return this._port == -1 ? this._host : this._host + ":" + this._port;
    }
}

