/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl;

import com.kingdee.bos.rabbitmq.amqp.Address;
import com.kingdee.bos.rabbitmq.amqp.ConnectionFactory;
import com.kingdee.bos.rabbitmq.amqp.SocketConfigurator;
import com.kingdee.bos.rabbitmq.amqp.impl.AbstractFrameHandlerFactory;
import com.kingdee.bos.rabbitmq.amqp.impl.FrameHandler;
import com.kingdee.bos.rabbitmq.amqp.impl.SocketFrameHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;

public class SocketFrameHandlerFactory
extends AbstractFrameHandlerFactory {
    private final SocketFactory factory;
    private final ExecutorService shutdownExecutor;

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory factory, SocketConfigurator configurator, boolean ssl) {
        this(connectionTimeout, factory, configurator, ssl, null);
    }

    public SocketFrameHandlerFactory(int connectionTimeout, SocketFactory factory, SocketConfigurator configurator, boolean ssl, ExecutorService shutdownExecutor) {
        super(connectionTimeout, configurator, ssl);
        this.factory = factory;
        this.shutdownExecutor = shutdownExecutor;
    }

    @Override
    public FrameHandler create(Address addr) throws IOException {
        String hostName = addr.getHost();
        int portNumber = ConnectionFactory.portOrDefault(addr.getPort(), this.ssl);
        Socket socket = null;
        try {
            socket = this.factory.createSocket();
            this.configurator.configure(socket);
            socket.connect(new InetSocketAddress(hostName, portNumber), this.connectionTimeout);
            return this.create(socket);
        }
        catch (IOException ioe) {
            SocketFrameHandlerFactory.quietTrySocketClose(socket);
            throw ioe;
        }
    }

    public FrameHandler create(Socket sock) throws IOException {
        return new SocketFrameHandler(sock, this.shutdownExecutor);
    }

    private static void quietTrySocketClose(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

