/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.initialize;

import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ConsumerEntity;
import com.kingdee.bos.rabbitmq.entity.ConsumersEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerParamEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.QueueDef;
import com.kingdee.bos.rabbitmq.entity.RegionDef;
import com.kingdee.bos.rabbitmq.initialize.ConfigManager;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import org.apache.log4j.Logger;

public class InitConsumer {
    private static Logger log = Logger.getLogger((String)InitConsumer.class.getName());

    protected static void initConsumer(ConsumersEntity consumers) {
        for (ConsumerEntity consumer : consumers.getConsumers()) {
            InitConsumer.dealPerConsumer(consumer);
        }
    }

    protected static void ierpDealPerConsumerServer(IERPConsumerParamEntity consumerParam) {
        ConnectionEntity mqConn = consumerParam.getConnectionEntity();
        ProductorEntity autoCallBackProductor = consumerParam.getAutoCallBackProductor();
        for (IERPConsumerQueue consumerQueue : consumerParam.getConsumerQueues()) {
            QueueManager.initIerpPerConsumerQueue(consumerQueue, mqConn, autoCallBackProductor, consumerQueue.isComeAutoSubscribe());
        }
    }

    protected static void ierpDealPerAutoSubscribeConsumer(IERPConsumerParamEntity consumerParam) {
        ConnectionEntity mqConn = consumerParam.getConnectionEntity();
        for (IERPConsumerQueue consumerQueue : consumerParam.getConsumerQueues()) {
            QueueManager.initIerpPerConsumerQueue(consumerQueue, mqConn, null, true);
        }
    }

    private static void dealPerConsumer(ConsumerEntity consumer) {
        String mqType = consumer.getType();
        if (StringUtils.isEmpty(mqType)) {
            mqType = MQConstantEnum.RABBITMQ_TYPE.getDesc();
        }
        String connectionName = consumer.getConnection();
        ConnectionEntity conn = ConfigManager.getConnection(connectionName);
        if (!StringUtils.isEmpty(mqType) && MQConstantEnum.RABBITMQ_TYPE.getDesc().equalsIgnoreCase(mqType)) {
            for (RegionDef region : consumer.getRegionDefs()) {
                try {
                    InitConsumer.initRegion(region, conn);
                }
                catch (Exception e) {
                    log.error((Object)("init mq for region " + region + "error"), (Throwable)e);
                }
            }
        }
    }

    private static void initRegion(RegionDef region, ConnectionEntity conn) {
        if (null == region) {
            log.warn((Object)"the other systme get region information failed.");
            return;
        }
        String name = region.getName();
        if (region.getQueues() == null) {
            return;
        }
        for (QueueDef queue : region.getQueues()) {
            InitConsumer.initQueue(name, queue, conn);
        }
    }

    private static void initQueue(String region, QueueDef queueDef, ConnectionEntity conn) {
        QueueManager.add(region, queueDef, conn);
    }
}

