/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.productor.publish;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.MessageProperties;
import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.initialize.ConfigManager;
import com.kingdee.bos.rabbitmq.productor.mqfactory.MQFactory;
import com.kingdee.bos.rabbitmq.productor.mqfactory.RabbitMQFactory;
import com.kingdee.bos.rabbitmq.productor.publish.MessagePublisher;
import com.kingdee.bos.rabbitmq.support.MessageSerde;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RabbitMQPublisher
implements MessagePublisher {
    private static Logger logger = Logger.getLogger((String)RabbitMQPublisher.class.getName());
    private String queueName;
    private Channel channel;
    private JSONObject contextInfo;

    public RabbitMQPublisher(String queueName, Channel channel, JSONObject contextInfo) {
        this.queueName = queueName;
        this.channel = channel;
        if (contextInfo == null) {
            contextInfo = new JSONObject();
        }
        this.contextInfo = contextInfo;
    }

    @Override
    public MQFactory getConnection(String name) {
        if (StringUtils.isEmpty(name)) {
            return new RabbitMQFactory();
        }
        ProductorEntity productor = ConfigManager.getProductor(name);
        if (StringUtils.isNullObj(productor)) {
            return null;
        }
        if (MQConstantEnum.RABBITMQ_TYPE.getDesc().equalsIgnoreCase(productor.getType())) {
            return new RabbitMQFactory();
        }
        return null;
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void close() {
        try {
            if (!StringUtils.isNullObj(this.channel)) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"RabbitMQ channel close failed.");
            throw new RuntimeException("\u5173\u95edRabbit MQ channel\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    private String generateMQSendInfo(Object body) {
        HashMap extendMap = new HashMap();
        JSONObject json = new JSONObject();
        if (null != this.contextInfo) {
            for (Map.Entry entry : this.contextInfo.entrySet()) {
                extendMap.put(entry.getKey(), (String)entry.getValue());
            }
        }
        json.put(MQConstantEnum.ATTR_EXTEND.getDesc(), extendMap);
        if (body instanceof String) {
            body = JSONObject.parseObject((String)body.toString());
        }
        json.put(MQConstantEnum.JSONOBJ_DATA_ATTR.getDesc(), body);
        logger.info((Object)("RabbitMQPublisher class, send MQ out data: " + json.toJSONString()));
        return json.toJSONString();
    }

    private void publish0(Object body) {
        try {
            byte[] bytes = MessageSerde.get().encode(this.generateMQSendInfo(body));
            this.channel.basicPublish("", this.queueName, MessageProperties.PERSISTENT_TEXT_PLAIN, bytes);
        }
        catch (IOException e) {
            logger.error((Object)"can't publish message.");
            throw new RuntimeException("Rabbit MQ\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }
}

