/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.support;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ExtendEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerParamEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorParamEntity;
import com.kingdee.bos.rabbitmq.util.CollectionUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EASModelConvert {
    private static Map<String, RabbitTreeInfo> serverAddrMap = new HashMap<String, RabbitTreeInfo>();
    private static Map<String, WSServiceInfo> remoteServerMap = new HashMap<String, WSServiceInfo>();

    public static ProductorParamEntity convertProductorParam(Context ctx, String publishId) throws BOSException {
        if (StringUtils.isEmpty(publishId)) {
            throw new BOSException("\u83b7\u53d6\u751f\u4ea7\u8005\u961f\u5217\u4fe1\u606f\uff0c\u5165\u53c2\u4e3b\u952e\u503c\u4e3a\u7a7a");
        }
        ProductorParamEntity productor = null;
        try {
            RabbitPublishInfo publishInfo = RabbitPublishFactory.getLocalInstance(ctx).getRabbitPublishInfo("where id='" + publishId + "'");
            RabbitInfo rabbit = RabbitFactory.getLocalInstance(ctx).getRabbitInfo("where id='" + publishInfo.getRabbit().getId() + "'");
            RabbitTreeInfo tree = RabbitTreeFactory.getLocalInstance(ctx).getRabbitTreeInfo("where id='" + rabbit.getTreeid().getId() + "'");
            WSServiceInfo server = WSServiceFactory.getLocalInstance((Context)ctx).getWSServiceInfo("where id='" + rabbit.getRemoteServer().getId() + "'");
            ConnectionEntity mqConnnection = EASModelConvert.getConnection(rabbit, tree);
            JSONObject ext = EASModelConvert.getExtendInfo(server);
            productor = new ProductorParamEntity(mqConnnection, publishInfo.getRegion(), publishInfo.getQueue(), publishInfo.getAutoSubscribeClass(), ext, rabbit.getTag());
        }
        catch (EASBizException e) {
            throw new BOSException("\u83b7\u53d6\u751f\u4ea7\u8005\u961f\u5217\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException("\u83b7\u53d6\u751f\u4ea7\u8005\u961f\u5217\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return productor;
    }

    public static List<ProductorParamEntity> convertProductorParam(Context ctx, List<String> fids) throws BOSException {
        if (CollectionUtils.isEmpty(fids)) {
            throw new BOSException("\u83b7\u53d6\u751f\u4ea7\u8005\u961f\u5217\u4fe1\u606f\uff0c\u5165\u53c2\u4e3b\u952e\u96c6\u5408\u4e3a\u7a7a");
        }
        ArrayList<ProductorParamEntity> paramList = new ArrayList<ProductorParamEntity>();
        for (String id : fids) {
            paramList.add(EASModelConvert.convertProductorParam(ctx, id));
        }
        return paramList;
    }

    public static List<IERPConsumerParamEntity> converConsumerParam(Context ctx) throws BOSException {
        ArrayList<IERPConsumerParamEntity> list = new ArrayList<IERPConsumerParamEntity>();
        try {
            RabbitInfo rabbit = null;
            RabbitTreeInfo tree = null;
            WSServiceInfo server = null;
            RabbitConsumerCollection consumers = null;
            RabbitPublishCollection publishs = null;
            IERPConsumerParamEntity conParam = null;
            IERPConsumerParamEntity autoConParam = null;
            RabbitCollection coll = RabbitFactory.getLocalInstance(ctx).getRabbitCollection();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                rabbit = (RabbitInfo)it.next();
                if (null != rabbit.getTreeid().getId() && serverAddrMap.containsKey(rabbit.getTreeid().getId().toString())) {
                    tree = serverAddrMap.get(rabbit.getTreeid().getId().toString());
                } else {
                    tree = RabbitTreeFactory.getLocalInstance(ctx).getRabbitTreeInfo("where id='" + rabbit.getTreeid().getId() + "'");
                    serverAddrMap.put(rabbit.getTreeid().getId().toString(), tree);
                }
                if (null != rabbit.getRemoteServer().getId() && remoteServerMap.containsKey(rabbit.getRemoteServer().getId().toString())) {
                    server = remoteServerMap.get(rabbit.getRemoteServer().getId().toString());
                } else {
                    server = WSServiceFactory.getLocalInstance((Context)ctx).getWSServiceInfo("where id='" + rabbit.getRemoteServer().getId() + "'");
                    remoteServerMap.put(rabbit.getRemoteServer().getId().toString(), server);
                }
                consumers = RabbitConsumerFactory.getLocalInstance(ctx).getRabbitConsumerCollection("where rabbit='" + rabbit.getId() + "'");
                publishs = RabbitPublishFactory.getLocalInstance(ctx).getRabbitPublishCollection("where rabbit='" + rabbit.getId() + "'");
                conParam = EASModelConvert.db2ConsumerParam(rabbit, tree, server, consumers);
                autoConParam = EASModelConvert.db2AutoSubscribeConsumer(rabbit, tree, publishs);
                list.add(conParam);
                list.add(autoConParam);
            }
        }
        catch (BOSException e) {
            throw new BOSException("\u83b7\u53d6\u6d88\u8d39\u8005\u961f\u5217\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException("\u83b7\u53d6\u6d88\u8d39\u8005\u961f\u5217\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return list;
    }

    public static List<IERPConsumerParamEntity> converAutoSubribeConsumerParam(Context ctx) throws BOSException {
        ArrayList<IERPConsumerParamEntity> list = new ArrayList<IERPConsumerParamEntity>();
        try {
            RabbitInfo rabbit = null;
            RabbitTreeInfo tree = null;
            RabbitPublishCollection publishs = null;
            IERPConsumerParamEntity conParam = null;
            RabbitCollection coll = RabbitFactory.getLocalInstance(ctx).getRabbitCollection();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                rabbit = (RabbitInfo)it.next();
                if (null != rabbit.getTreeid().getId() && serverAddrMap.containsKey(rabbit.getTreeid().getId().toString())) {
                    tree = serverAddrMap.get(rabbit.getTreeid().getId().toString());
                } else {
                    tree = RabbitTreeFactory.getLocalInstance(ctx).getRabbitTreeInfo("where id='" + rabbit.getTreeid().getId() + "'");
                    serverAddrMap.put(rabbit.getTreeid().getId().toString(), tree);
                }
                publishs = RabbitPublishFactory.getLocalInstance(ctx).getRabbitPublishCollection("where rabbit='" + rabbit.getId() + "'");
                conParam = EASModelConvert.db2AutoSubscribeConsumer(rabbit, tree, publishs);
                list.add(conParam);
            }
        }
        catch (BOSException rabbit) {
        }
        catch (EASBizException e) {
            throw new BOSException("\u83b7\u53d6\u81ea\u52a8\u8ba2\u9605\u961f\u5217\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return list;
    }

    private static JSONObject getExtendInfo(WSServiceInfo server) {
        JSONObject ext = new JSONObject();
        ext.put("tenantid", (Object)server.getTenantId());
        ext.put("user", (Object)server.getServiceUser());
        ext.put("password", (Object)server.getPassword());
        ext.put("accountid", (Object)server.getDataCenter());
        return ext;
    }

    private static ConnectionEntity getConnection(RabbitInfo rabbit, RabbitTreeInfo tree) {
        ConnectionEntity mqConnnection = new ConnectionEntity();
        mqConnnection.setHost(tree.getIp());
        mqConnnection.setPort(tree.getPort());
        mqConnnection.setUserName(rabbit.getUserName());
        mqConnnection.setPassword(rabbit.getPassword());
        mqConnnection.setVhost(rabbit.getVhost());
        return mqConnnection;
    }

    public static IERPConsumerParamEntity db2ConsumerParam(RabbitInfo rabbit, RabbitTreeInfo tree, WSServiceInfo server, RabbitConsumerCollection consumers) throws BOSException, EASBizException {
        ConnectionEntity conn = EASModelConvert.getConnection(rabbit, tree);
        JSONObject extJson = EASModelConvert.getExtendInfo(server);
        ProductorEntity autoCallBackProductor = new ProductorEntity();
        ExtendEntity extend = new ExtendEntity();
        extend.setExtendData(extJson);
        autoCallBackProductor.setExtend(extend);
        List<IERPConsumerQueue> consumerQueues = EASModelConvert.convertConsumerList(rabbit.getTag(), consumers);
        IERPConsumerParamEntity conParam = new IERPConsumerParamEntity();
        conParam.setConnectionEntity(conn);
        conParam.setAutoCallBackProductor(autoCallBackProductor);
        conParam.setConsumerQueues(consumerQueues);
        return conParam;
    }

    public static List<IERPConsumerQueue> convertConsumerList(String tag, RabbitConsumerCollection consumers) {
        RabbitConsumerInfo c = null;
        IERPConsumerQueue cQueue = null;
        ArrayList<IERPConsumerQueue> consumerQueues = new ArrayList<IERPConsumerQueue>();
        Iterator cIt = consumers.iterator();
        while (cIt.hasNext()) {
            c = (RabbitConsumerInfo)cIt.next();
            cQueue = new IERPConsumerQueue();
            cQueue.setAutoCallBack(c.isIsCallBack());
            cQueue.setConsumerClass(c.getConsumerClass());
            cQueue.setQueueName(c.getQueue());
            cQueue.setRegion(c.getRegion());
            cQueue.setThreadCount(c.getThreadCount());
            cQueue.setTag(tag);
            cQueue.setComeAutoSubscribe(false);
            consumerQueues.add(cQueue);
        }
        return consumerQueues;
    }

    public static IERPConsumerParamEntity db2AutoSubscribeConsumer(RabbitInfo rabbit, RabbitTreeInfo tree, RabbitPublishCollection publishs) {
        ConnectionEntity conn = EASModelConvert.getConnection(rabbit, tree);
        List<IERPConsumerQueue> consumerQueues = EASModelConvert.convertAutoConsumerList(rabbit.getTag(), publishs);
        IERPConsumerParamEntity conParam = new IERPConsumerParamEntity();
        conParam.setConnectionEntity(conn);
        conParam.setConsumerQueues(consumerQueues);
        return conParam;
    }

    public static List<IERPConsumerQueue> convertAutoConsumerList(String tag, RabbitPublishCollection publishs) {
        ArrayList<IERPConsumerQueue> consumerQueues = new ArrayList<IERPConsumerQueue>();
        RabbitPublishInfo p = null;
        IERPConsumerQueue cQueue = null;
        Iterator cIt = publishs.iterator();
        while (cIt.hasNext()) {
            p = (RabbitPublishInfo)cIt.next();
            if (!p.isIsAutoSubscribe()) continue;
            cQueue = new IERPConsumerQueue();
            cQueue.setAutoCallBack(false);
            cQueue.setConsumerClass(p.getAutoSubscribeClass());
            cQueue.setQueueName(p.getQueue());
            cQueue.setRegion(p.getRegion());
            cQueue.setTag(tag);
            cQueue.setComeAutoSubscribe(true);
            consumerQueues.add(cQueue);
        }
        return consumerQueues;
    }

    public static List<ProductorParamEntity> convertProductorList(String tag, JSONObject extInfo, ConnectionEntity conn, RabbitPublishCollection publishs) {
        ArrayList<ProductorParamEntity> productors = new ArrayList<ProductorParamEntity>();
        RabbitPublishInfo p = null;
        ProductorParamEntity productor = null;
        Iterator cIt = publishs.iterator();
        while (cIt.hasNext()) {
            p = (RabbitPublishInfo)cIt.next();
            productor = new ProductorParamEntity(conn, p.getRegion(), p.getQueue(), p.getAutoSubscribeClass(), extInfo, tag);
            productors.add(productor);
        }
        return productors;
    }
}

