/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.support;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.rabbitmq.hessian.io.Hessian2Input;
import com.kingdee.bos.rabbitmq.hessian.io.Hessian2Output;
import com.kingdee.bos.rabbitmq.support.MessageSerde;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class HessianMessageSerde
extends MessageSerde {
    private static Logger logger = Logger.getLogger((String)HessianMessageSerde.class.getName());
    public static final HessianMessageSerde instance = new HessianMessageSerde();

    @Override
    public byte[] encode(String message) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output h2o = new Hessian2Output(os);
        byte[] buffer = null;
        try {
            h2o.startMessage();
            h2o.writeObject(message);
            h2o.completeMessage();
            h2o.close();
            buffer = os.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)"can't encode message.");
            throw new RuntimeException("can't encode message.", e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error((Object)"ByteArrayOutputStream stream close failed.");
            }
        }
        return buffer;
    }

    @Override
    public JSONObject decode(byte[] bytes) {
        Hessian2Input h2i = new Hessian2Input(new ByteArrayInputStream(bytes));
        String msg = null;
        try {
            h2i.startMessage();
            msg = (String)h2i.readObject();
        }
        catch (Exception e) {
            logger.error((Object)"can't decode message.");
            throw new RuntimeException("can't decode message.", e);
        }
        return JSONObject.parseObject((String)msg);
    }
}

