/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.thread;

import com.kingdee.bos.rabbitmq.guava.ForwardingExecutorService;
import com.kingdee.bos.rabbitmq.guava.Ordering;
import com.kingdee.bos.rabbitmq.thread.ManagedThreadFeature;
import com.kingdee.bos.rabbitmq.thread.ThreadLifeCycleListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadLifeCycleManager {
    private static final int MAX = 100;
    private static ConcurrentHashMap<ThreadLifeCycleListener, OrderedListener> listenerMap = new ConcurrentHashMap();

    public static void addListener(ThreadLifeCycleListener l) {
        ThreadLifeCycleManager.addListener(l, 0);
    }

    public static void addListener(ThreadLifeCycleListener l, int order) {
        if (!listenerMap.contains(l)) {
            if (listenerMap.size() < 100) {
                listenerMap.put(l, new OrderedListener(order, l));
            } else {
                RuntimeException ex = new RuntimeException("Leak!!!");
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static void removeListener(ThreadLifeCycleListener l) {
        listenerMap.remove(l);
    }

    public static void start() {
        List<OrderedListener> list = Ordering.natural().sortedCopy(listenerMap.values());
        for (OrderedListener l : list) {
            try {
                l.listener.start();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void end() {
        List<OrderedListener> list = Ordering.natural().sortedCopy(listenerMap.values());
        for (OrderedListener l : list) {
            try {
                l.listener.end();
            }
            catch (Throwable throwable) {}
        }
    }

    public static <T> Callable<T> wrapCallable(Callable<T> callable) {
        if (callable instanceof CallableWrap) {
            return callable;
        }
        return new CallableWrap<T>(callable);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        if (runnable instanceof RunnableWrap) {
            return runnable;
        }
        return new RunnableWrap(runnable);
    }

    public static ExecutorService wrapExecutorService(ExecutorService pool) {
        return new ExecutorServiceWrap(pool);
    }

    static {
        ThreadLifeCycleManager.addListener(new ManagedThreadFeature(), 900);
    }

    private static class RunnableWrap
    implements Runnable {
        private Runnable runnable;

        public RunnableWrap(Runnable runnable) {
            if (runnable instanceof RunnableWrap) {
                throw new IllegalArgumentException("RunnableWrap shouldn't be wrap again.");
            }
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                ThreadLifeCycleManager.start();
                this.runnable.run();
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        }
    }

    private static class CallableWrap<T>
    implements Callable<T> {
        private Callable<T> callable;

        public CallableWrap(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            try {
                ThreadLifeCycleManager.start();
                T t = this.callable.call();
                return t;
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        }
    }

    private static class ExecutorServiceWrap
    extends ForwardingExecutorService {
        private ExecutorService delegate;

        public ExecutorServiceWrap(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        protected ExecutorService delegate() {
            return this.delegate;
        }

        private static <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
            ArrayList<CallableWrap<T>> result = new ArrayList<CallableWrap<T>>();
            for (Callable<T> task : tasks) {
                result.add(new CallableWrap<T>(task));
            }
            return result;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return super.invokeAll(ExecutorServiceWrap.wrapCallableCollection(tasks));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return super.invokeAll(ExecutorServiceWrap.wrapCallableCollection(tasks), timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return super.invokeAny(ExecutorServiceWrap.wrapCallableCollection(tasks));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.invokeAny(ExecutorServiceWrap.wrapCallableCollection(tasks), timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            super.execute(ThreadLifeCycleManager.wrapRunnable(command));
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return super.submit(ThreadLifeCycleManager.wrapCallable(task));
        }

        @Override
        public Future<?> submit(Runnable task) {
            return super.submit(ThreadLifeCycleManager.wrapRunnable(task));
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return super.submit(ThreadLifeCycleManager.wrapRunnable(task), result);
        }
    }

    private static class OrderedListener
    implements Comparable<OrderedListener> {
        private ThreadLifeCycleListener listener;
        private int order;

        public OrderedListener(int order, ThreadLifeCycleListener listener) {
            this.order = order;
            this.listener = listener;
        }

        @Override
        public int compareTo(OrderedListener o) {
            return this.order - o.order;
        }
    }
}

