/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.util;

import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.util.CollectionUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class RabbitMQCacheUtils {
    private static Logger log = Logger.getLogger((String)RabbitMQCacheUtils.class.getName());
    private static Map<String, Boolean> disablQueueMap = new ConcurrentHashMap<String, Boolean>();
    private static Map<String, List<Channel>> channelsCache = new ConcurrentHashMap<String, List<Channel>>();

    public static List<Channel> getCacheChannel(String realQueue) {
        if (StringUtils.isEmpty(realQueue)) {
            log.error((Object)"the redis cache query channel operation,parameter key is null.");
            return null;
        }
        List channels = null;
        try {
            Class<?> clazz = Class.forName(MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc());
            Method method = clazz.getMethod("takeDealQueue", String.class);
            channels = (List)method.invoke(clazz, realQueue);
        }
        catch (Exception e) {
            log.error((Object)("invoke MQ cache query operation, class is not find.class:" + MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc()), (Throwable)e);
        }
        return channels;
    }

    public static synchronized void putChannel2Cache(String realQueue, List<Channel> channels) {
        if (StringUtils.isEmpty(realQueue) || CollectionUtils.isEmpty(channels)) {
            log.error((Object)"the cache MQ channel operation, parameter is null.");
            return;
        }
        try {
            Class<?> clazz = Class.forName(MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc());
            Method method = clazz.getMethod("putDealQueue", String.class, List.class);
            method.invoke(clazz, realQueue, channels);
        }
        catch (Exception e) {
            log.error((Object)("invoke MQ cache save operation, class is not find.class:" + MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc()), (Throwable)e);
        }
    }

    public static synchronized void removeCacheChannel(String realQueue) {
        if (StringUtils.isEmpty(realQueue)) {
            log.error((Object)"the remove cache channel operation,paramemter is null.");
            return;
        }
        try {
            Class<?> clazz = Class.forName(MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc());
            Method method = clazz.getMethod("removeDealQueue", String.class);
            method.invoke(clazz, realQueue);
        }
        catch (Exception e) {
            log.error((Object)("invoke MQ cache remove operation, class is not find.class:" + MQConstantEnum.IERP_CACHE_REFLECT_CLASS.getDesc()), (Throwable)e);
        }
    }

    public static void put(String key, boolean value) {
        disablQueueMap.put(key, value);
    }

    public static void clear(String key) {
        if (disablQueueMap.containsKey(key)) {
            disablQueueMap.remove(key);
        }
    }

    public static boolean containKey(String key) {
        return disablQueueMap.containsKey(key);
    }

    public static List<Channel> takeChanel(String realQueue) {
        List<Channel> channels = null;
        if (channelsCache.containsKey(realQueue)) {
            channels = channelsCache.get(realQueue);
        }
        return channels;
    }

    public static void putChannel(String realQueue, Channel channel) {
        List<Object> channels = null;
        if (channelsCache.containsKey(realQueue)) {
            channels = channelsCache.get(realQueue);
            channels.add(channel);
        } else {
            channels = new ArrayList();
            channels.add(channel);
            channelsCache.put(realQueue, channels);
        }
    }

    public static void putChannel(String realQueue, List<Channel> channelList) {
        List<Object> channels = null;
        if (channelsCache.containsKey(realQueue)) {
            channels = channelsCache.get(realQueue);
            channels.addAll(channelList);
        } else {
            channels = new ArrayList();
            channels.addAll(channelList);
            channelsCache.put(realQueue, channels);
        }
    }

    public static void removeChannel(String realQueue) {
        if (channelsCache.containsKey(realQueue)) {
            channelsCache.remove(realQueue);
        }
    }
}

