/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ExtendEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerParamEntity;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.ProductorParamEntity;
import com.kingdee.bos.rabbitmq.entity.RabbitAPIInvokeEntity;
import com.kingdee.bos.rabbitmq.productor.mqfactory.RabbitMQFactory;
import com.kingdee.bos.rabbitmq.support.EASModelConvert;
import com.kingdee.bos.rabbitmq.util.RabbitMQCacheUtils;
import com.kingdee.bos.rabbitmq.util.RabbitMQHttpAPIUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.eipserviceplugin.EipServicePluginAdaptorFactory;
import com.kingdee.eas.csinterface.openapi.FeedBackServiceFactory;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeInfo;
import com.kingdee.eas.rabbitmq.rabbit.app.AbstractRabbitControllerBean;
import com.kingdee.eas.rabbitmq.rabbit.app.api.QueueDetailAPI;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RabbitControllerBean
extends AbstractRabbitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.rabbitmq.rabbit.app.RabbitControllerBean");
    private static Map<String, IERPConsumerQueue> consumerTHCountMap = new HashMap<String, IERPConsumerQueue>();
    private ConnectionEntity mqConnection;

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        try {
            RabbitInfo rabbit = this.getRabbitInfo(ctx, pk);
            if (null != rabbit) {
                if (rabbit.isIspreset()) {
                    throw new BOSException("\u7528\u6237\u540d\uff1a " + rabbit.getUserName() + " ,\u865a\u62df\u4e3b\u673a\u4e3a\uff1a" + rabbit.getVhost() + ",\u4e3a\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
                }
                RabbitPublishCollection pubColl = rabbit.getPublishers();
                Iterator pubIt = pubColl.iterator();
                while (pubIt.hasNext()) {
                    RabbitPublishInfo pInfo = (RabbitPublishInfo)pubIt.next();
                    String realQ = QueueManager.getRealQueueName(rabbit.getUserName(), rabbit.getPassword(), pInfo.getRegion(), pInfo.getQueue(), false, rabbit.getTag());
                    if (pInfo.isIspreset()) {
                        throw new BOSException("\u751f\u4ea7\u8005\u961f\u5217\uff1a \r\n[" + realQ + "]\u4e3a\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
                    }
                    boolean isExists = EipServicePluginAdaptorFactory.getLocalInstance((Context)ctx).exists("where queue='" + pInfo.getId().toString() + "'");
                    if (isExists) {
                        throw new BOSException("\u62e6\u622a\u670d\u52a1\u6570\u636e\u5f15\u7528\u4e86\u5f53\u524d\u751f\u4ea7\u8005\u961f\u5217\uff1a\r\n[" + realQ + "]\r\n\u4e0d\u80fd\u5220\u9664\uff01");
                    }
                    boolean isExistFeed = FeedBackServiceFactory.getLocalInstance((Context)ctx).exists("where queue='" + pInfo.getId().toString() + "'");
                    if (!isExistFeed) continue;
                    throw new BOSException("\u6570\u636e\u53cd\u5199\u670d\u52a1\u5f15\u7528\u4e86\u5f53\u524d\u751f\u4ea7\u8005\u961f\u5217\uff1a\r\n[" + realQ + "]\r\n\u4e0d\u80fd\u5220\u9664\uff01");
                }
                RabbitConsumerCollection conColl = rabbit.getConsumers();
                Iterator cIt = conColl.iterator();
                while (cIt.hasNext()) {
                    RabbitConsumerInfo cInfo = (RabbitConsumerInfo)cIt.next();
                    if (!cInfo.isIspreset()) continue;
                    String realQ = QueueManager.getRealQueueName(rabbit.getUserName(), rabbit.getPassword(), cInfo.getRegion(), cInfo.getQueue(), false, rabbit.getTag());
                    throw new BOSException("\u6d88\u8d39\u8005\u961f\u5217\uff1a \r\n[" + realQ + "]\r\n\u4e3a\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
                }
            }
        }
        catch (Exception e) {
            throw new CanNotDeleteException(e.getMessage(), e.getCause());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RabbitInfo rabbit = (RabbitInfo)model;
        String vhost = rabbit.getVhost();
        if (StringUtils.isEmpty((String)vhost)) {
            vhost = MQConstantEnum.DEFAULT_VHOST.getDesc();
        }
        RabbitTreeInfo server = rabbit.getTreeid();
        WSServiceInfo remoteService = rabbit.getRemoteServer();
        this.mqConnection = this.generateConnetion(rabbit, server, vhost);
        this.addDelConsumerByThreadCount(rabbit, remoteService, this.mqConnection, vhost);
        this.startConsumerQueues(rabbit, server, this.mqConnection, vhost);
        this.startPublishQueues(rabbit, remoteService, this.mqConnection);
        if (null != rabbit.getPublishers()) {
            rabbit.setPublishCount(rabbit.getPublishers().size());
        }
        if (null != rabbit.getConsumers()) {
            rabbit.setConsumerCount(rabbit.getConsumers().size());
        }
        IObjectPK objPK = super._submit(ctx, model);
        if (consumerTHCountMap.isEmpty()) {
            consumerTHCountMap.clear();
        }
        return objPK;
    }

    private void addDelConsumerByThreadCount(RabbitInfo rabbit, WSServiceInfo remoteService, ConnectionEntity conn, String vhost) {
        this.setConsumerThreadCountAndCallback(rabbit);
        if (!consumerTHCountMap.isEmpty()) {
            List<IERPConsumerQueue> consumerQueues = EASModelConvert.convertConsumerList(rabbit.getTag(), rabbit.getConsumers());
            int newThreadCount = 0;
            int oldThreadCount = 0;
            int tmpCount = 0;
            String realQueue = null;
            ProductorEntity autoProduct = null;
            for (IERPConsumerQueue c : consumerQueues) {
                newThreadCount = c.getThreadCount();
                realQueue = QueueManager.getRealQueueName(rabbit.getUserName(), rabbit.getPassword(), c.getRegion(), c.getQueueName(), false, rabbit.getTag());
                if (!consumerTHCountMap.containsKey(realQueue) || newThreadCount == (oldThreadCount = consumerTHCountMap.get(realQueue).getThreadCount())) continue;
                if (newThreadCount > oldThreadCount) {
                    tmpCount = newThreadCount - oldThreadCount;
                    c.setThreadCount(tmpCount);
                    if (c.isAutoCallBack()) {
                        autoProduct = this.getCallBackProductorExtendInfo(remoteService);
                    }
                    QueueManager.initIerpPerConsumerQueue(c, conn, autoProduct, false);
                }
                if (newThreadCount >= oldThreadCount) continue;
                tmpCount = oldThreadCount - newThreadCount;
                if (!StringUtils.isEmpty((String)vhost)) {
                    realQueue = vhost + "_" + realQueue;
                }
                List<Channel> channels = RabbitMQCacheUtils.takeChanel(realQueue);
                ArrayList<Channel> tempChannels = new ArrayList<Channel>();
                try {
                    for (int i = 0; i < tmpCount; ++i) {
                        channels.get(i).close();
                        tempChannels.add(channels.get(i));
                    }
                    channels.removeAll(tempChannels);
                    RabbitMQCacheUtils.putChannel(realQueue, channels);
                }
                catch (Throwable t) {
                    consumerTHCountMap.clear();
                    MsgBox.showError((String)("\u6d88\u8d39\u8005\u961f\u5217\u5206\u5f55\uff0c\u961f\u5217\u540d\u4e3a\uff1a\u3010" + c.getQueueName() + "\u3011\uff0c\u7528\u6237\u51cf\u5c11\u5e76\u53d1\u6570\uff0c\u7981\u7528\u6d88\u8d39\u8005\u5f02\u5e38"), (String)ThrowableHelper.toString((Throwable)t));
                }
            }
        }
    }

    private void startConsumerQueues(RabbitInfo rabbit, RabbitTreeInfo server, ConnectionEntity conn, String vhost) throws BOSException {
        ProductorEntity autoProduct = null;
        String realQueue = null;
        String tempQueue = null;
        int consumerCount = 0;
        ArrayList<IERPConsumerQueue> tempConsumers = new ArrayList<IERPConsumerQueue>();
        List<IERPConsumerQueue> consumerQueues = EASModelConvert.convertConsumerList(rabbit.getTag(), rabbit.getConsumers());
        IERPConsumerParamEntity autoSubscribeConsmersParam = EASModelConvert.db2AutoSubscribeConsumer(rabbit, server, rabbit.getPublishers());
        List<IERPConsumerQueue> autoSubConsumerQueues = autoSubscribeConsmersParam.getConsumerQueues();
        tempConsumers.addAll(consumerQueues);
        tempConsumers.addAll(autoSubConsumerQueues);
        for (IERPConsumerQueue consumerQueue : tempConsumers) {
            realQueue = QueueManager.getRealQueueName(rabbit.getUserName(), rabbit.getPassword(), consumerQueue.getRegion(), consumerQueue.getQueueName(), consumerQueue.isComeAutoSubscribe(), rabbit.getTag());
            tempQueue = !StringUtils.isEmpty((String)vhost) ? vhost + "_" + realQueue : realQueue;
            if (RabbitMQCacheUtils.containKey(tempQueue)) {
                try {
                    RabbitAPIInvokeEntity param = this.generateHttpAPIParam(rabbit, server, vhost);
                    param.setHttpApi(QueueDetailAPI.getURL(param, realQueue));
                    consumerCount = RabbitMQHttpAPIUtils.getSingleQueueConsumerCount(param);
                }
                catch (BOSException e) {
                    logger.error((Object)("\u6821\u9a8c\u6d88\u8d39\u8005\u662f\u5426\u5b58\u5728\u5f02\u5e38(" + realQueue + ")" + ThrowableHelper.toString((Exception)((Object)e))));
                }
                if (consumerCount != 0) continue;
            }
            if (consumerQueue.isAutoCallBack()) {
                autoProduct = this.getCallBackProductorExtendInfo(rabbit.getRemoteServer());
            }
            QueueManager.initIerpPerConsumerQueue(consumerQueue, conn, autoProduct, consumerQueue.isComeAutoSubscribe());
            RabbitMQCacheUtils.put(tempQueue, true);
        }
    }

    private void startPublishQueues(RabbitInfo rabbit, WSServiceInfo remoteService, ConnectionEntity conn) {
        ExtendEntity extend = this.generateExtend(remoteService);
        List<ProductorParamEntity> publishList = EASModelConvert.convertProductorList(rabbit.getTag(), extend.getExtendData(), conn, rabbit.getPublishers());
        RabbitMQFactory mqFactory = new RabbitMQFactory();
        for (ProductorParamEntity p : publishList) {
            mqFactory.startPublishQueues(p.getRegion(), p.getQueueName(), conn, rabbit.getTag());
        }
    }

    private void setConsumerThreadCountAndCallback(RabbitInfo rabbit) {
        if (null != rabbit) {
            RabbitConsumerCollection consumerQueues = rabbit.getConsumers();
            RabbitConsumerInfo c = null;
            String realQueue = null;
            Iterator it = consumerQueues.iterator();
            IERPConsumerQueue tempConsumer = null;
            while (it.hasNext()) {
                c = (RabbitConsumerInfo)it.next();
                realQueue = QueueManager.getRealQueueName(rabbit.getUserName(), rabbit.getPassword(), c.getRegion(), c.getQueue(), false, rabbit.getTag());
                tempConsumer = new IERPConsumerQueue();
                tempConsumer.setThreadCount(c.getThreadCount());
                tempConsumer.setAutoCallBack(c.isIsCallBack());
                consumerTHCountMap.put(realQueue, tempConsumer);
            }
        }
    }

    private ConnectionEntity generateConnetion(RabbitInfo rabbit, RabbitTreeInfo server, String vhost) {
        this.mqConnection = new ConnectionEntity();
        this.mqConnection.setHost(server.getIp());
        this.mqConnection.setPort(server.getPort());
        this.mqConnection.setUserName(rabbit.getUserName());
        this.mqConnection.setPassword(rabbit.getPassword());
        this.mqConnection.setVhost(vhost);
        return this.mqConnection;
    }

    private ProductorEntity getCallBackProductorExtendInfo(WSServiceInfo remoteService) {
        ProductorEntity autoCallBackProductor = null;
        if (null != remoteService) {
            ExtendEntity extend = this.generateExtend(remoteService);
            autoCallBackProductor = new ProductorEntity();
            autoCallBackProductor.setExtend(extend);
        }
        return autoCallBackProductor;
    }

    private ExtendEntity generateExtend(WSServiceInfo remoteService) {
        String tenantId = remoteService.getTenantId();
        String user = remoteService.getServiceUser();
        String password = remoteService.getPassword();
        String accountId = remoteService.getDataCenter();
        ExtendEntity extend = new ExtendEntity();
        JSONObject extJson = new JSONObject();
        extJson.put("tenantid", (Object)tenantId);
        extJson.put("user", (Object)user);
        extJson.put("password", (Object)password);
        extJson.put("accountid", (Object)accountId);
        extend.setExtendData(extJson);
        return extend;
    }

    private RabbitAPIInvokeEntity generateHttpAPIParam(RabbitInfo rabbit, RabbitTreeInfo server, String vhost) {
        String userName = rabbit.getUserName();
        String pwd = rabbit.getPassword();
        String ip = server.getIp();
        String apiPort = server.getApiport();
        String protocol = server.getProtocol().getName();
        return new RabbitAPIInvokeEntity(ip, apiPort, userName, pwd, protocol, vhost);
    }
}

