/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.consumer.subscribe.MessageConsumer;
import com.kingdee.bos.rabbitmq.entity.RabbitAPIInvokeEntity;
import com.kingdee.bos.rabbitmq.model.APIResultModel;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitConsumerInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitFactory;
import com.kingdee.eas.rabbitmq.rabbit.RabbitInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishCollection;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.eas.rabbitmq.rabbit.RabbitTreeInfo;
import com.kingdee.eas.rabbitmq.rabbit.app.AbstractRabbitFacadeControllerBean;
import com.kingdee.eas.rabbitmq.rabbit.app.api.CurrentUserVhostAPI;
import com.kingdee.eas.rabbitmq.rabbit.app.api.QueueDetailAPI;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueBasicInfo;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RabbitFacadeControllerBean
extends AbstractRabbitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.rabbitmq.rabbit.app.RabbitFacadeControllerBean");

    @Override
    protected String _getRabbitSystemTag(Context ctx) throws BOSException {
        if (StringUtils.isEmpty(System.getProperty("mq.debug.queue.tag"))) {
            return null;
        }
        return System.getProperty("mq.debug.queue.tag");
    }

    @Override
    protected List _getDetailByRabbit(Context ctx, String rabbitId) throws BOSException {
        List<Object> detailList = new ArrayList();
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("treeid.*"));
            selectors.add(new SelectorItemInfo("consumers.*"));
            selectors.add(new SelectorItemInfo("publishers.*"));
            RabbitInfo rabbit = RabbitFactory.getLocalInstance(ctx).getRabbitInfo(CommonUtil.convert2PK((String)rabbitId), selectors);
            String userName = rabbit.getUserName();
            String password = rabbit.getPassword();
            String tag = rabbit.getTag();
            String vhost = rabbit.getVhost();
            RabbitTreeInfo treeInfo = rabbit.getTreeid();
            String ip = treeInfo.getIp();
            String port = treeInfo.getApiport();
            String protocol = treeInfo.getProtocol().getName();
            RabbitPublishCollection publishes = rabbit.getPublishers();
            Iterator pubList = publishes.iterator();
            RabbitPublishInfo publish = null;
            ArrayList<String> queueList = new ArrayList<String>();
            while (pubList.hasNext()) {
                publish = (RabbitPublishInfo)pubList.next();
                queueList.add(QueueManager.getRealQueueName(userName, password, publish.getRegion(), publish.getQueue(), false, tag));
                if (!publish.isIsAutoSubscribe()) continue;
                queueList.add(QueueManager.getRealQueueName(userName, password, publish.getRegion(), publish.getQueue(), true, tag));
            }
            RabbitConsumerCollection consumers = rabbit.getConsumers();
            Iterator consuList = consumers.iterator();
            RabbitConsumerInfo consumer = null;
            while (consuList.hasNext()) {
                consumer = (RabbitConsumerInfo)consuList.next();
                queueList.add(QueueManager.getRealQueueName(userName, password, consumer.getRegion(), consumer.getQueue(), false, tag));
            }
            RabbitAPIInvokeEntity entity = new RabbitAPIInvokeEntity(ip, port, userName, password, protocol, vhost);
            detailList = QueueDetailAPI.getDetails(entity, queueList);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return detailList;
    }

    @Override
    protected List _getDetailByQueues(Context ctx, List queues) throws BOSException {
        return null;
    }

    @Override
    protected Map _getAllQueues(Context ctx, String rabbitId) throws BOSException {
        HashMap queueMap = new HashMap();
        try {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("treeid.*"));
            selectors.add(new SelectorItemInfo("consumers.*"));
            selectors.add(new SelectorItemInfo("publishers.*"));
            RabbitInfo rabbit = RabbitFactory.getLocalInstance(ctx).getRabbitInfo(CommonUtil.convert2PK((String)rabbitId), selectors);
            String userName = rabbit.getUserName();
            String password = rabbit.getPassword();
            String tag = rabbit.getTag();
            String vhost = rabbit.getVhost();
            RabbitTreeInfo treeInfo = rabbit.getTreeid();
            String ip = treeInfo.getIp();
            String port = treeInfo.getApiport();
            String protocol = treeInfo.getProtocol().getName();
            RabbitPublishCollection publishes = rabbit.getPublishers();
            Iterator pubList = publishes.iterator();
            RabbitPublishInfo publish = null;
            ArrayList<QueueBasicInfo> publishList = new ArrayList<QueueBasicInfo>();
            while (pubList.hasNext()) {
                publish = (RabbitPublishInfo)pubList.next();
                QueueBasicInfo basicInfo = new QueueBasicInfo();
                basicInfo.setQueue(QueueManager.getRealQueueName(userName, password, publish.getRegion(), publish.getQueue(), false, tag));
                basicInfo.setCallBack(publish.isIsAutoSubscribe());
                basicInfo.setPreset(publish.isIspreset());
                publishList.add(basicInfo);
            }
            queueMap.put(QueueTypeEnum.Publish, publishList);
            RabbitConsumerCollection consumers = rabbit.getConsumers();
            ArrayList<QueueBasicInfo> consumerList = new ArrayList<QueueBasicInfo>();
            Iterator consuList = consumers.iterator();
            RabbitConsumerInfo consumer = null;
            while (consuList.hasNext()) {
                consumer = (RabbitConsumerInfo)consuList.next();
                QueueBasicInfo basicInfo = new QueueBasicInfo();
                basicInfo.setQueue(QueueManager.getRealQueueName(userName, password, consumer.getRegion(), consumer.getQueue(), false, tag));
                basicInfo.setCallBack(consumer.isIsCallBack());
                basicInfo.setThreadCount(consumer.getThreadCount());
                basicInfo.setPreset(consumer.isIspreset());
                consumerList.add(basicInfo);
            }
            queueMap.put(QueueTypeEnum.Consumer, consumerList);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return queueMap;
    }

    @Override
    protected APIResultModel _validateCurrUserVhost(Context ctx, RabbitAPIInvokeEntity param) throws BOSException {
        return CurrentUserVhostAPI.validateCurrUserVhost(param);
    }

    @Override
    protected boolean _validateClassLegal(Context ctx, String clazz) throws BOSException {
        if (StringUtils.isEmpty(clazz)) {
            throw new BOSException("\u6821\u9a8cMQ\u6570\u636e\u5904\u7406\u7c7b\u7684\u5408\u6cd5\u6027\uff0c\u65b9\u6cd5\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        Class<?> c = null;
        try {
            c = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("\u5904\u7406\u7c7b\uff1a\u3010" + clazz + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u670d\u52a1\u5668\u4e2d\u90e8\u7f72\u5bf9\u5e94\u7684\u5305\u3002");
        }
        try {
            if (!(c.newInstance() instanceof MessageConsumer)) {
                throw new BOSException("\u5904\u7406\u7c7b\uff1a\u3010" + clazz + "\u3011\uff0c\u5fc5\u987b\u7ee7\u627f\u81ea:com.kingdee.bos.rabbitmq.consumer.subscribe.MessageConsumer\u3002");
            }
        }
        catch (InstantiationException e) {
            throw new BOSException("\u5904\u7406\u7c7b\uff1a\u3010" + clazz + "\u3011\uff0c\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u7a7a\u7684\u516c\u5171\u6784\u9020\u65b9\u6cd5\u3002");
        }
        catch (IllegalAccessException e) {
            throw new BOSException("\u5904\u7406\u7c7b\uff1a\u3010" + clazz + "\u3011\uff0c\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u7a7a\u7684\u516c\u5171\u6784\u9020\u65b9\u6cd5\u3002");
        }
        return true;
    }
}

