/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.rabbitmq.rabbit.app.util.Constants;
import com.kingdee.eas.rabbitmq.rabbit.app.util.DbUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SQLUtil {
    public static final String COMMA = ", ";
    private static final String RIGHT_BRACKET = "}";
    private static final String LEFT_BRACKET = "{";
    private static final String SINGLE_QUOTES = "'";
    public static final String QUEST_MARK = "?";
    private StringBuffer sqlSb = new StringBuffer();
    private List paramaters = new ArrayList();
    static final char oldChar = '?';

    public SQLUtil() {
    }

    public SQLUtil(String sql) {
        this();
        this.sqlSb.append(sql);
    }

    public SQLUtil appendSql(String sql) {
        this.sqlSb.append(sql);
        return this;
    }

    public void appendQuestMark() {
        this.sqlSb.append(QUEST_MARK);
    }

    public void appendParam(Object param) {
        this.paramaters.add(param);
        this.sqlSb.append(QUEST_MARK);
    }

    public void appendParam(Object[] param) {
        if (param.length == 0) {
            throw new IllegalArgumentException("param's length is 0!");
        }
        int len = param.length;
        this.appendParam(param[0]);
        for (int i = 1; i < len; ++i) {
            this.sqlSb.append(COMMA);
            this.appendParam(param[i]);
        }
    }

    public void appendParam(String key, Object[] param) {
        if (param.length == 0) {
            throw new IllegalArgumentException("param's length is 0!");
        }
        this.appendSql(" " + key + " in (");
        this.appendParam(param);
        this.appendSql(")");
    }

    public void addParam(Object param) {
        if (param instanceof java.util.Date) {
            param = new Date(((java.util.Date)param).getTime());
        }
        this.paramaters.add(param);
    }

    public void addParams(Object[] params) {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            this.addParam(params[i]);
        }
    }

    public String getSql() {
        if (this.sqlSb != null) {
            return this.sqlSb.toString();
        }
        return null;
    }

    public String getTestSql(int dbType) throws SqlTranslateException {
        return TransUtil.Translate((String)this.getTestSql(), (int)dbType);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getTestSql() {
        StringBuffer rst = new StringBuffer();
        String sql = this.getSql();
        int len = sql.length();
        int i = -1;
        char[] val = sql.toCharArray();
        int off = 0;
        while (++i < len && val[off + i] != '?') {
        }
        rst.append(sql.substring(0, i));
        if (i >= len) return rst.toString();
        Iterator iter = this.paramaters.iterator();
        while (i < len) {
            char c = val[off + i];
            if (c == '?') {
                if (!iter.hasNext()) {
                    rst.append(sql.substring(i));
                    return rst.toString();
                }
                Object p = iter.next();
                rst.append(this.getParamString(p));
            } else {
                rst.append(c);
            }
            ++i;
        }
        return rst.toString();
    }

    private String getParamString(Object p) {
        if (p == null) {
            return null;
        }
        if (p instanceof Boolean) {
            Boolean p_new = (Boolean)p;
            if (p_new.equals(Boolean.TRUE)) {
                return "1";
            }
            return "0";
        }
        if (p instanceof String) {
            return SINGLE_QUOTES + p + SINGLE_QUOTES;
        }
        if (p instanceof Timestamp) {
            return LEFT_BRACKET + Constants.FORMAT_TIME.format(p) + RIGHT_BRACKET;
        }
        if (p instanceof java.util.Date) {
            return LEFT_BRACKET + Constants.FORMAT_DAY.format(p) + RIGHT_BRACKET;
        }
        return p.toString();
    }

    public PreparedStatement createState(Connection conn) throws SQLException {
        return DbUtil.createState(conn, this.getSql(), this.paramaters.toArray());
    }

    public ResultSet exeQuery(Context ctx) throws BOSException {
        return com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)this.getSql(), (Object[])this.paramaters.toArray());
    }

    public void execute(Context ctx) throws BOSException {
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)this.getSql(), (Object[])this.paramaters.toArray());
    }

    public List getParamaters() {
        return this.paramaters;
    }

    public SqlParams getSqlParams() {
        if (this.paramaters == null || this.paramaters.size() == 0) {
            return null;
        }
        SqlParams sqlParams = new SqlParams();
        sqlParams.setParams(this.paramaters.toArray());
        return sqlParams;
    }

    public static void main(String[] args) {
        Object[] a = new String[]{"a", "b", "c", "d"};
        SQLUtil builder = new SQLUtil();
        builder.appendSql("select * from t where fid in(");
        builder.appendParam(a);
        builder.appendSql(")");
        System.out.print(builder.getSql());
        System.out.println(builder.getTestSql());
    }

    public void appendFilter(String colName, Set ids, CompareType include) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.appendSql(" and ");
        this.appendParam(colName, ids.toArray());
    }
}

