/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.app.util;

import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class SQLUtils {
    private static final Logger logger = Logger.getLogger((String)SQLUtils.class.getName());

    public static final void cleanup(Connection cn) {
        SQLUtils.cleanup(null, null, cn);
    }

    public static final void cleanup(Statement stmt) {
        SQLUtils.cleanup(null, stmt, null);
    }

    public static final void cleanup(Statement stmt, Connection cn) {
        SQLUtils.cleanup(null, stmt, cn);
    }

    public static final void cleanup(ResultSet rs) {
        SQLUtils.cleanup(rs, null, null);
    }

    public static final void cleanup(ResultSet rs, Statement stmt) {
        SQLUtils.cleanup(rs, stmt, null);
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            cn = null;
        }
    }

    public static void execute(Connection conn, String sql) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            SQLUtils.cleanup(stmt);
        }
    }

    public static RowSet getJdbcRowSet(Connection conn, String strsql) throws SQLException {
        JdbcRowSet jdbcRowSet;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(strsql);
            JdbcRowSet rset = new JdbcRowSet();
            rset.populate(rs);
            jdbcRowSet = rset;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, stmt);
        return jdbcRowSet;
    }

    public static void main(String[] args) {
    }
}

