/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment;

import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.enterprisedt.net.ftp.FTPException;
import com.kingdee.enterprisedt.net.ftp.FTPTransferType;
import com.kingdee.enterprisedt.net.ftp.KDFileTransferClient;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ConnectionObject {
    private static final Logger logger = Logger.getLogger((String)ConnectionObject.class.getName());
    private KDFileTransferClient ftpConn;
    private FtpConfigInfo config;
    private boolean inUse;
    private long lastAccess;
    private int useCount;
    private boolean inPool = true;

    public ConnectionObject(FtpConfigInfo config) throws FTPException, CryptException, IOException {
        this.config = config;
        if (config != null && config.getSftpStatus() != 32) {
            this.ftpConn = this.getFtp();
        }
        this.inUse = false;
    }

    public KDFileTransferClient getFtpConn() {
        if (this.ftpConn != null && !this.ftpConn.isConnected()) {
            try {
                this.ftpConn.connect();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return this.ftpConn;
    }

    public void setFtpConn(KDFileTransferClient ftpConn) {
        this.ftpConn = ftpConn;
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void setUseCount(int useCount) {
        this.useCount = useCount;
    }

    public void setInPool(boolean inPool) {
        this.inPool = inPool;
    }

    public boolean getInPool() {
        return this.inPool;
    }

    public FtpConfigInfo getConfig() {
        return this.config;
    }

    public void setConfig(FtpConfigInfo config) {
        this.config = config;
    }

    private KDFileTransferClient getFtp() throws FTPException, CryptException, IOException {
        KDFileTransferClient ftp = new KDFileTransferClient();
        ftp.setRemoteHost(this.config.getHost());
        ftp.setUserName(this.config.getUserName());
        ftp.setPassword(CryptoTean.decrypt((String)this.config.getUserName(), (String)this.config.getPassword()));
        ftp.setRemotePort(this.config.getPort());
        ftp.setContentType(FTPTransferType.BINARY);
        ftp.connect();
        return ftp;
    }
}

