/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentFtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentObsHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.ServerConfigHelper;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentFtpFacadeControllerBean;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadServer;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentRandom;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadServer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class AttachmentFtpFacadeControllerBean
extends AbstractAttachmentFtpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.AttachmentFtpFacadeControllerBean");
    protected static Map<Object, Object> downloadMap = new ConcurrentHashMap<Object, Object>();

    @Override
    protected AttachmentFtpInfo _uploadFile(Context ctx, String fileId, byte[] content) throws BOSException {
        AttachmentUploadServer uploadServer = new AttachmentUploadServer();
        return uploadServer.addServerContent(fileId, content);
    }

    @Override
    protected void _fileToDb4Server(Context ctx, String fileId, String attachmentId) throws BOSException, EASBizException {
        if (StringUtils.equalsIgnoreCase((String)"1", (String)AttachmentHelper.getParam(ctx))) {
            this.file2FTP(ctx, fileId, attachmentId);
        } else if (StringUtils.equalsIgnoreCase((String)"0", (String)AttachmentHelper.getParam(ctx))) {
            this.file2DB(ctx, fileId, attachmentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void file2FTP(Context ctx, String fileId, String attachmentId) throws BOSException, EASBizException {
        try {
            AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).upload(attachmentId, fileId);
        }
        finally {
            AttachmentUploadServer uploadServer = new AttachmentUploadServer();
            File tempFile = uploadServer.getServerFile(fileId);
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void file2DB(Context ctx, String fileId, String attachmentId) throws BOSException, EASBizException {
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            AttachmentUploadServer uploadServer = new AttachmentUploadServer();
            uploadServer.fileToDb4Server(fileId, attachmentId, con);
            File tempFile = uploadServer.getServerFile(fileId);
            tempFile.delete();
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.info((Object)"error:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update4FTP(Context ctx, String fileId, String attachmentId) throws BOSException, EASBizException {
        try {
            AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).updateContent(attachmentId, fileId);
        }
        finally {
            AttachmentUploadServer uploadServer = new AttachmentUploadServer();
            File tempFile = uploadServer.getServerFile(fileId);
            tempFile.delete();
        }
    }

    @Override
    protected byte[] _downloadFile(Context ctx, String attachmentId, long startPos) throws BOSException, EASBizException {
        return this._downloadFile(ctx, attachmentId);
    }

    private InputStream getInputFromSession(Context ctx, String attachmentId) {
        String uuid = AttachmentRandom.getUUIDtFromThread();
        return (InputStream)downloadMap.get("attch" + attachmentId + uuid);
    }

    private void insert2Session(Context ctx, InputStream input, String attachmentId) {
        String uuid = AttachmentRandom.getUUIDtFromThread();
        downloadMap.put("attch" + attachmentId + uuid, input);
    }

    private void removeFromSession(Context ctx, InputStream input, String attachmentId) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        String uuid = AttachmentRandom.getUUIDtFromThread();
        downloadMap.remove("attch" + attachmentId + uuid);
    }

    private InputStream getInputFromSession(Context ctx) {
        return (InputStream)ctx.get((Object)"attch");
    }

    private void insert2Session(Context ctx, InputStream input) {
        ctx.put((Object)"attch", (Object)input);
    }

    private void removeFromSession(Context ctx, InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        ctx.remove((Object)"attch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getFile(Context ctx, String attachmentId, Map attachmentFTpTmpFilePath) throws BOSException, EASBizException {
        InputStream input = null;
        AttachmentDownloadServer downServer = new AttachmentDownloadServer();
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType(ctx, attachmentId);
        if (AttachmentStorageTypeEnum.DATABASE.equals((Object)type)) {
            Connection con = null;
            try {
                con = this.getConnection(ctx);
                InputStream inputStream = input = downServer.getContent4Server(attachmentId, con);
                return inputStream;
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String filePathOnServer = this.getFilePathOnServer(ctx, attachmentId);
        attachmentFTpTmpFilePath.put("attachmentFTpTmpFilePath", filePathOnServer);
        return this.getBufferedInputStream(filePathOnServer);
    }

    @Override
    protected byte[] _downloadFile(Context ctx, String attachmentId) throws BOSException, EASBizException {
        InputStream input = this.getInputFromSession(ctx, attachmentId);
        boolean flag = false;
        HashMap attachmentFTpTmpFilePath = new HashMap();
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType(ctx, attachmentId);
        try {
            if (input == null) {
                logger.error((Object)"***AttachmentFtpFacadeControllerBean**********first download***********");
                input = this.getFile(ctx, attachmentId, attachmentFTpTmpFilePath);
                this.insert2Session(ctx, input, attachmentId);
                if (attachmentFTpTmpFilePath.size() != 0 || !attachmentFTpTmpFilePath.isEmpty()) {
                    ctx.put((Object)"attachmentFTpTmpFilePath", attachmentFTpTmpFilePath.get("attachmentFTpTmpFilePath"));
                }
            }
            AttachmentDownloadServer downServer = new AttachmentDownloadServer();
            byte[] content = downServer.getContent(input);
            AttachmentFtpInfo.init();
            if (content == null || content.length == 0) {
                logger.error((Object)"***AttachmentFtpFacadeControllerBean****file download over***(content is null)=****");
                this.removeFromSession(ctx, input, attachmentId);
                flag = true;
            }
            byte[] byArray = content;
            return byArray;
        }
        catch (EASBizException e) {
            flag = true;
            this.removeFromSession(ctx, input, attachmentId);
            throw e;
        }
        catch (Exception e) {
            flag = true;
            this.removeFromSession(ctx, input, attachmentId);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (flag && (AttachmentStorageTypeEnum.FTP.equals((Object)type) || AttachmentStorageTypeEnum.OBS.equals((Object)type))) {
                File file;
                String attachmentFTpTmpFilePath2 = (String)ctx.get((Object)"attachmentFTpTmpFilePath");
                if (attachmentFTpTmpFilePath2 != null && attachmentFTpTmpFilePath2.length() != 0 && (file = new File(attachmentFTpTmpFilePath2)).exists()) {
                    file.getAbsoluteFile().delete();
                }
                ctx.remove((Object)"attachmentFTpTmpFilePath");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFilePathOnServer(Context ctx, String attachmentId) throws EASBizException, BOSException {
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType(ctx, attachmentId);
        if (AttachmentStorageTypeEnum.FTP.equals((Object)type)) {
            File tempFile;
            try {
                tempFile = File.createTempFile("attachment", "tmp");
            }
            catch (IOException e) {
                logger.error((Object)e);
                return null;
            }
            AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).download(attachmentId, tempFile.getAbsolutePath());
            logger.error((Object)("*******AttachmentFtpFacadeControllerBean***tempFile=" + tempFile.getAbsolutePath()));
            return tempFile.getAbsolutePath();
        }
        if (AttachmentStorageTypeEnum.EASSERVER.equals((Object)type)) {
            AttachmentInfo attachment = AttachmentHelper.getAttachmentInfo(ctx, attachmentId);
            return attachment.getRemotePath();
        }
        if (AttachmentStorageTypeEnum.OBS.equals((Object)type)) {
            FileOutputStream fileOutputStream = null;
            try {
                File tempFile = File.createTempFile("attachment", "tmp");
                byte[] file = AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).download(attachmentId);
                fileOutputStream = new FileOutputStream(tempFile.getAbsolutePath());
                fileOutputStream.write(file);
                logger.error((Object)("*******AttachmentFtpFacadeControllerBean***OBS***tempFile=" + tempFile.getAbsolutePath()));
                String string = tempFile.getAbsolutePath();
                return string;
            }
            catch (IOException e) {
                logger.error((Object)e);
                String string = null;
                return string;
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private InputStream getBufferedInputStream(String localPath) {
        BufferedInputStream inputstream = null;
        FileInputStream is = null;
        try {
            logger.error((Object)("***AttachmentFtpFacadeControllerBean*****localPath=*" + localPath));
            is = new FileInputStream(localPath);
            inputstream = new BufferedInputStream(is);
            logger.error((Object)("***AttachmentFtpFacadeControllerBean**inputstream=" + inputstream.available()));
            return inputstream;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    protected boolean _updateContent(Context ctx, String attachmentId, String fileId) throws BOSException, EASBizException {
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType(ctx, attachmentId);
        if (AttachmentStorageTypeEnum.DATABASE.equals((Object)type)) {
            this.file2DB(ctx, fileId, attachmentId);
        } else if (AttachmentStorageTypeEnum.FTP.equals((Object)type)) {
            this.update4FTP(ctx, fileId, attachmentId);
        } else if (AttachmentStorageTypeEnum.EASSERVER.equals((Object)type)) {
            ServerConfigHelper.updateContent(ctx, attachmentId, fileId);
        } else if (AttachmentStorageTypeEnum.OBS.equals((Object)type)) {
            AttachmentInfo info2 = AttachmentHelper.getAttachmentInfoByObs(ctx, attachmentId);
            AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).delete(info2.getId().toString());
            AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).updateFileUrl(info2, fileId);
        }
        return true;
    }

    public InputStream downloadFileForMultiThread(Context ctx, String attachmentId) throws EASBizException, BOSException {
        boolean flag = false;
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType(ctx, attachmentId);
        HashMap attachmentFTpTmpFilePath = new HashMap();
        try {
            logger.error((Object)"***AttachmentFtpFacadeControllerBean**********first download***********");
            InputStream input = this.getFile(ctx, attachmentId, attachmentFTpTmpFilePath);
            if (attachmentFTpTmpFilePath.size() != 0 || !attachmentFTpTmpFilePath.isEmpty()) {
                ctx.put((Object)"attachmentFTpTmpFilePath", attachmentFTpTmpFilePath.get("attachmentFTpTmpFilePath"));
            }
            InputStream inputStream = input;
            return inputStream;
        }
        catch (EASBizException e) {
            flag = true;
            throw e;
        }
        catch (Exception e) {
            flag = true;
            throw new BOSException((Throwable)e);
        }
        finally {
            if (flag && AttachmentStorageTypeEnum.FTP.equals((Object)type)) {
                File file;
                String attachmentFTpTmpFilePath2 = (String)ctx.get((Object)"attachmentFTpTmpFilePath");
                if (attachmentFTpTmpFilePath2 != null && attachmentFTpTmpFilePath2.length() != 0 && (file = new File(attachmentFTpTmpFilePath2)).exists()) {
                    file.getAbsoluteFile().delete();
                }
                ctx.remove((Object)"attachmentFTpTmpFilePath");
            }
        }
    }
}

